<?php
/**
 * Template: faq-ai.txt (ADF-008) — FAQs formatted for AI.
 *
 * @package AIDF
 * @since   1.0.0
 *
 * @var array<string, mixed> $data Collected site data.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$identity = $data['identity'];
$content  = $data['content'];
$settings = $data['settings'];
$faqs     = $content['faqs'];

// Attribution header.
// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Pre-built internal string.
echo AIDF_Generator::get_attribution( '#', 'faq-ai-txt' );

echo '# Frequently Asked Questions — ' . esc_html( $identity['name'] ) . "\n\n";

echo 'Website: [' . esc_html( $identity['url'] ) . '](' . esc_url( $identity['url'] ) . ')' . "\n";
echo 'Last Updated: ' . esc_html( wp_date( 'Y-m-d' ) ) . "\n\n";

if ( empty( $faqs ) ) {
	echo "No FAQs have been configured yet.\n";
	return;
}

foreach ( $faqs as $index => $faq ) {
	if ( empty( $faq['q'] ) || empty( $faq['a'] ) ) {
		continue;
	}

	echo 'Q: ' . esc_html( $faq['q'] ) . "\n";
	echo 'A: ' . esc_html( $faq['a'] ) . "\n\n";
}

// Cross-references.
$active = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();

echo "---\n\n";

if ( in_array( 'llms-txt', $active, true ) ) {
	echo 'Learn more: [llms.txt](' . esc_url( home_url( '/llms.txt' ) ) . ')' . "\n";
}
