<?php
/**
 * Template: developer-ai.txt (ADF-009) — Technical context for developers.
 *
 * @package AIDF
 * @since   1.0.0
 *
 * @var array<string, mixed> $data Collected site data.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$identity  = $data['identity'];
$technical = $data['technical'];
$settings  = $data['settings'];

// Attribution header.
// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Pre-built internal string.
echo AIDF_Generator::get_attribution( '#', 'developer-ai-txt' );

echo '# Technical Context — ' . esc_html( $identity['name'] ) . "\n\n";

echo 'Website: [' . esc_html( $identity['url'] ) . '](' . esc_url( $identity['url'] ) . ')' . "\n";
echo 'Last Updated: ' . esc_html( wp_date( 'Y-m-d' ) ) . "\n\n";

// Platform information.
echo "## Platform\n\n";
echo '- CMS: WordPress ' . esc_html( $technical['wp_version'] ) . "\n";
echo '- PHP: ' . esc_html( $technical['php_version'] ) . "\n";
echo '- Theme: ' . esc_html( $technical['theme'] ) . "\n";
echo '- Character Set: ' . esc_html( $technical['charset'] ) . "\n";
echo '- Language: ' . esc_html( $technical['language'] ) . "\n";

// Tech stack.
if ( ! empty( $technical['tech_stack'] ) ) {
	echo "\n## Technology Stack\n\n";
	echo esc_html( $technical['tech_stack'] ) . "\n";
}

// Developer notes.
if ( ! empty( $technical['developer_notes'] ) ) {
	echo "\n## Developer Notes\n\n";
	echo esc_html( $technical['developer_notes'] ) . "\n";
}

// API information.
if ( ! empty( $technical['api_info'] ) ) {
	echo "\n## API Information\n\n";
	echo esc_html( $technical['api_info'] ) . "\n";
}

// Feeds.
$site = $data['site'];

echo "\n## Data Feeds\n\n";

if ( ! empty( $site['rss_url'] ) ) {
	echo '- [RSS](' . esc_url( $site['rss_url'] ) . ')' . "\n";
}

if ( ! empty( $site['atom_url'] ) ) {
	echo '- [Atom](' . esc_url( $site['atom_url'] ) . ')' . "\n";
}

// AI Discovery Files listing.
$active     = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();
$file_types = AIDF_Plugin::get_file_types();

echo "\n## AI Discovery Files\n\n";

foreach ( $active as $slug ) {
	if ( isset( $file_types[ $slug ] ) ) {
		$meta = $file_types[ $slug ];
		echo '- [' . esc_html( $meta['filename'] ) . '](' . esc_url( home_url( '/' . $meta['filename'] ) ) . ')' . "\n";
	}
}
