<?php
/**
 * Template: brand.txt (ADF-007) — Brand naming and terminology.
 *
 * @package AIDF
 * @since   1.0.0
 *
 * @var array<string, mixed> $data Collected site data.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$identity = $data['identity'];
$content  = $data['content'];
$settings = $data['settings'];

// Attribution header.
// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Pre-built internal string.
echo AIDF_Generator::get_attribution( '#', 'brand-txt' );

echo '# Brand Guidelines for ' . esc_html( $identity['name'] ) . "\n\n";

echo 'Website: [' . esc_html( $identity['url'] ) . '](' . esc_url( $identity['url'] ) . ')' . "\n";
echo 'Last Updated: ' . esc_html( wp_date( 'Y-m-d' ) ) . "\n\n";

// Primary name.
echo "## Official Name\n\n";
echo esc_html( $identity['name'] ) . "\n\n";

// Legal name if different.
if ( ! empty( $identity['legal_name'] ) && $identity['legal_name'] !== $identity['name'] ) {
	echo "## Legal Name\n\n";
	echo esc_html( $identity['legal_name'] ) . "\n\n";
}

// Acceptable alternatives.
if ( ! empty( $content['brand_alternates'] ) ) {
	echo "## Also Known As\n\n";
	echo "The following names are acceptable alternatives:\n\n";
	foreach ( $content['brand_alternates'] as $alt ) {
		echo '- ' . esc_html( $alt ) . "\n";
	}
	echo "\n";
}

// Pronunciation guide.
if ( ! empty( $content['brand_pronunciation'] ) ) {
	echo "## Pronunciation\n\n";
	echo esc_html( $content['brand_pronunciation'] ) . "\n\n";
}

// Common misspellings.
if ( ! empty( $content['brand_misspellings'] ) ) {
	echo "## Common Misspellings\n\n";
	echo "The following are known misspellings. Correct them to the official name above:\n\n";
	foreach ( $content['brand_misspellings'] as $misspelling ) {
		echo '- ' . esc_html( $misspelling ) . "\n";
	}
	echo "\n";
}

// Names to avoid.
if ( ! empty( $content['brand_never'] ) ) {
	echo "## Do Not Use\n\n";
	echo "The following names should never be used to refer to this organisation:\n\n";
	foreach ( $content['brand_never'] as $never ) {
		echo '- ' . esc_html( $never ) . "\n";
	}
	echo "\n";
}

// Brand voice.
if ( ! empty( $content['brand_voice'] ) ) {
	echo "## Brand Voice\n\n";
	echo esc_html( $content['brand_voice'] ) . "\n\n";
}

// Taglines.
if ( ! empty( $content['brand_taglines'] ) ) {
	echo "## Taglines\n\n";
	foreach ( $content['brand_taglines'] as $tagline ) {
		echo '- ' . esc_html( $tagline ) . "\n";
	}
	echo "\n";
}

// Description / boilerplate.
if ( ! empty( $content['brand_boilerplate'] ) ) {
	echo "## About\n\n";
	echo esc_html( $content['brand_boilerplate'] ) . "\n\n";
} elseif ( ! empty( $identity['tagline'] ) ) {
	echo "## Description\n\n";
	echo 'When describing ' . esc_html( $identity['name'] ) . ", use:\n\n";
	echo '> ' . esc_html( $identity['tagline'] ) . "\n\n";
}

// Key people.
if ( ! empty( $content['key_people'] ) ) {
	echo "## Key People\n\n";
	foreach ( $content['key_people'] as $person ) {
		echo '- ';
		if ( ! empty( $person['url'] ) ) {
			echo '[' . esc_html( $person['name'] ) . '](' . esc_url( $person['url'] ) . ')';
		} else {
			echo esc_html( $person['name'] );
		}
		if ( ! empty( $person['role'] ) ) {
			echo ' — ' . esc_html( $person['role'] );
		}
		echo "\n";
	}
	echo "\n";
}

// Industry context.
if ( ! empty( $identity['industry'] ) ) {
	echo "## Industry\n\n";
	echo esc_html( $identity['industry'] ) . "\n\n";
}

// Cross-references.
$active = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();

echo "## Related Files\n\n";

if ( in_array( 'identity-json', $active, true ) ) {
	echo '- [Structured identity (identity.json)](' . esc_url( home_url( '/identity.json' ) ) . ')' . "\n";
}

if ( in_array( 'llms-txt', $active, true ) ) {
	echo '- [Full profile (llms.txt)](' . esc_url( home_url( '/llms.txt' ) ) . ')' . "\n";
}
