<?php
/**
 * Template: ai.txt (ADF-004) — AI usage permissions.
 *
 * @package AIDF
 * @since   1.0.0
 *
 * @var array<string, mixed> $data Collected site data.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$identity    = $data['identity'];
$permissions = $data['permissions'];
$settings    = $data['settings'];

// Attribution header.
// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Pre-built internal string.
echo AIDF_Generator::get_attribution( '#', 'ai-txt' );

echo '# AI Usage Policy for ' . esc_html( $identity['name'] ) . "\n\n";

echo 'Website: [' . esc_html( $identity['url'] ) . '](' . esc_url( $identity['url'] ) . ')' . "\n";
echo 'Last Updated: ' . esc_html( wp_date( 'Y-m-d' ) ) . "\n\n";

// Usage policy.
echo "## Usage Policy\n\n";
echo 'AI Content Usage: ' . esc_html( AIDF_Generator::format_permission( $permissions['ai_usage'] ) ) . "\n";
echo 'AI Training: ' . esc_html( AIDF_Generator::format_permission( $permissions['ai_training'] ) ) . "\n\n";

// Usage details.
switch ( $permissions['ai_usage'] ) {
	case 'allow':
		echo "AI systems may use content from this website without restriction.\n\n";
		break;
	case 'allow_with_attribution':
		echo "AI systems may use content from this website provided they attribute the source.\n";
		echo 'Attribution should reference ' . esc_html( $identity['name'] ) . ' and link to [' . esc_html( $identity['url'] ) . '](' . esc_url( $identity['url'] ) . ')' . "\n\n";
		break;
	case 'restrict':
		echo "AI systems may reference this website's publicly available information but should not reproduce substantial portions of content.\n\n";
		break;
	case 'prohibit':
		echo "AI systems should not use, reproduce, or train on content from this website.\n\n";
		break;
}

// Training policy.
switch ( $permissions['ai_training'] ) {
	case 'allow':
		echo "This website's content may be used for AI model training.\n\n";
		break;
	case 'restrict':
		echo "This website's content should not be used for AI model training without explicit permission.\n\n";
		break;
	case 'prohibit':
		echo "This website's content must not be used for AI model training under any circumstances.\n\n";
		break;
}

// Content licence.
$licence_label = AIDF_Generator::format_licence( $permissions['content_licence'] );

if ( ! empty( $licence_label ) ) {
	echo "## Content Licence\n\n";
	echo 'Licence: ' . esc_html( $licence_label ) . "\n\n";
}

// Citation format.
if ( ! empty( $permissions['citation_format'] ) ) {
	echo "## Citation Format\n\n";
	echo "When citing content from this website, use:\n\n";
	echo esc_html( $permissions['citation_format'] ) . "\n\n";
}

// Crawler access.
echo "## Crawler Access\n\n";

switch ( $permissions['crawler_policy'] ) {
	case 'allow_all':
		echo "All AI crawlers are permitted to access this website.\n";
		break;
	case 'allow_known':
		echo "Known AI crawlers (GPTBot, ClaudeBot, Google-Extended, etc.) are permitted to access this website.\n";
		echo "See robots.txt and robots-ai.txt for specific directives.\n";
		break;
	case 'restrict':
		echo "AI crawlers should respect robots.txt directives. Not all AI crawlers are permitted.\n";
		echo "See robots.txt and robots-ai.txt for specific directives.\n";
		break;
}

echo "\n## Contact\n\n";

if ( ! empty( $identity['email'] ) ) {
	echo 'Email: ' . esc_html( $identity['email'] ) . "\n";
}

if ( ! empty( $identity['contact_url'] ) ) {
	echo '[Contact Page](' . esc_url( $identity['contact_url'] ) . ')' . "\n";
}

if ( ! empty( $identity['privacy_policy_url'] ) ) {
	echo '[Privacy Policy](' . esc_url( $identity['privacy_policy_url'] ) . ')' . "\n";
}

if ( ! empty( $identity['terms_url'] ) ) {
	echo '[Terms of Service](' . esc_url( $identity['terms_url'] ) . ')' . "\n";
}

// Cross-reference.
echo "\n## Related Files\n\n";

$active = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();

if ( in_array( 'ai-json', $active, true ) ) {
	echo '- [Machine-parseable version (ai.json)](' . esc_url( home_url( '/ai.json' ) ) . ')' . "\n";
}

if ( in_array( 'robots-ai-txt', $active, true ) ) {
	echo '- [AI crawler directives (robots-ai.txt)](' . esc_url( home_url( '/robots-ai.txt' ) ) . ')' . "\n";
}

echo '- [robots.txt](' . esc_url( home_url( '/robots.txt' ) ) . ')' . "\n";
