<?php
/**
 * Template: ai.json (ADF-005) — Machine-parseable AI permissions.
 *
 * @package AIDF
 * @since   1.0.0
 *
 * @var array<string, mixed> $data Collected site data.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$identity    = $data['identity'];
$permissions = $data['permissions'];
$settings    = $data['settings'];

$output = array(
	'name'        => $identity['name'],
	'url'         => $identity['url'],
	'updated'     => wp_date( 'Y-m-d' ),
	'permissions' => array(
		'ai_usage'    => $permissions['ai_usage'],
		'ai_training' => $permissions['ai_training'],
	),
	'crawlers'    => array(
		'policy' => $permissions['crawler_policy'],
	),
	'contact'     => array(
		'email' => $identity['email'],
	),
);

// Add optional contact fields.
if ( ! empty( $identity['contact_url'] ) ) {
	$output['contact']['url'] = $identity['contact_url'];
}

if ( ! empty( $identity['privacy_policy_url'] ) ) {
	$output['contact']['privacy_policy'] = $identity['privacy_policy_url'];
}

if ( ! empty( $identity['terms_url'] ) ) {
	$output['contact']['terms_of_service'] = $identity['terms_url'];
}

// Content licence.
$licence_label = AIDF_Generator::format_licence( $permissions['content_licence'] );

if ( ! empty( $licence_label ) ) {
	$output['permissions']['content_licence'] = $licence_label;
}

// Add attribution details if usage requires it.
$attribution_data = array(
	'required' => ( 'allow_with_attribution' === $permissions['ai_usage'] ),
	'name'     => $identity['name'],
	'url'      => $identity['url'],
);

if ( ! empty( $permissions['citation_format'] ) ) {
	$attribution_data['format'] = $permissions['citation_format'];
}

if ( $attribution_data['required'] || ! empty( $permissions['citation_format'] ) ) {
	$output['attribution'] = $attribution_data;
}

// Cross-references.
$active    = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();
$see_also = array();

if ( in_array( 'ai-txt', $active, true ) ) {
	$see_also[] = home_url( '/ai.txt' );
}

if ( in_array( 'identity-json', $active, true ) ) {
	$see_also[] = home_url( '/identity.json' );
}

if ( ! empty( $see_also ) ) {
	$output['see_also'] = $see_also;
}

// Spec attribution.
$attribution = AIDF_Generator::get_json_attribution( 'ai-json' );

if ( ! empty( $attribution ) ) {
	$output = array_merge( $output, $attribution );
}

echo wp_json_encode( $output, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE );
