<?php
/**
 * Plugin Name:       AI Discovery Files
 * Plugin URI:        https://www.ai-visibility.org.uk/wordpress-plugin/ai-discovery-files/
 * Description:       Improve your AI Visibility by generating AI Discovery Files so AI systems like ChatGPT, Claude, and Gemini can correctly discover, interpret, and cite your website.
 * Version:           1.1.0
 * Requires at least: 6.2
 * Requires PHP:      8.0
 * Author:            Mark McNeece, 365i
 * Author URI:        https://www.365iwebdesign.co.uk/news/author/mark-mcneece/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       ai-discovery-files
 * Domain Path:       /languages
 *
 * @package AIDF
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Plugin constants.
 */
define( 'AIDF_VERSION', '1.1.0' );
define( 'AIDF_PLUGIN_FILE', __FILE__ );
define( 'AIDF_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'AIDF_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'AIDF_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * Autoload core classes.
 */
require_once AIDF_PLUGIN_DIR . 'includes/class-plugin.php';
require_once AIDF_PLUGIN_DIR . 'includes/class-data-collector.php';
require_once AIDF_PLUGIN_DIR . 'includes/class-generator.php';
require_once AIDF_PLUGIN_DIR . 'includes/class-server.php';
require_once AIDF_PLUGIN_DIR . 'includes/class-validator.php';

/**
 * Activation hook.
 */
function aidf_activate() {
	AIDF_Server::register_rewrite_rules();
	flush_rewrite_rules();

	if ( false === get_option( 'aidf_settings' ) ) {
		update_option( 'aidf_settings', AIDF_Plugin::get_defaults() );
	}

	set_transient( 'aidf_activation_redirect', true, 30 );
}
register_activation_hook( __FILE__, 'aidf_activate' );

/**
 * Deactivation hook.
 */
function aidf_deactivate() {
	flush_rewrite_rules();
}
register_deactivation_hook( __FILE__, 'aidf_deactivate' );

/**
 * Boot the plugin.
 */
function aidf_init() {
	AIDF_Plugin::get_instance();
}
add_action( 'plugins_loaded', 'aidf_init' );
