<?php
/**
 * Status tab — file status, active toggles, validation.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$settings     = AIDF_Plugin::get_settings();
$active_files = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();
$file_types   = AIDF_Plugin::get_file_types();
$tiers        = AIDF_Plugin::get_tiers();
?>

<!-- Tier Progress -->
<?php include AIDF_PLUGIN_DIR . 'admin/views/partials/tier-progress.php'; ?>

<!-- Active Files -->
<form method="post" action="options.php" id="aidf-status-form">
	<?php settings_fields( 'aidf_settings_group' ); ?>

	<!-- Persist all non-active_files settings (scalar values only) -->
	<?php
	$persist_fields = array(
		'business_name', 'legal_name', 'tagline', 'contact_email', 'contact_phone',
		'contact_url', 'address', 'postcode', 'location_city', 'location_region', 'location_country',
		'not_services', 'industry', 'founded_year', 'employee_count',
		'business_type', 'service_areas', 'not_service_areas', 'operating_hours', 'social_links', 'logo_url', 'products_url',
		'privacy_policy_url', 'terms_url',
		'company_number', 'company_jurisdiction', 'vat_number',
		'customer_type', 'offering_type', 'operating_hours_preset',
		'ai_usage', 'ai_training', 'crawler_policy', 'content_licence', 'citation_format',
		'brand_alternates', 'brand_never', 'brand_pronunciation', 'brand_misspellings',
		'brand_voice', 'brand_taglines', 'brand_boilerplate',
		'developer_notes', 'api_info', 'tech_stack',
	);
	foreach ( $persist_fields as $field ) :
		?>
		<input type="hidden" name="aidf_settings[<?php echo esc_attr( $field ); ?>]" value="<?php echo esc_attr( $settings[ $field ] ); ?>">
	<?php endforeach; ?>

	<!-- Persist boolean fields -->
	<input type="hidden" name="aidf_settings[vat_registered]" value="<?php echo esc_attr( $settings['vat_registered'] ? '1' : '0' ); ?>">
	<input type="hidden" name="aidf_settings[is_ecommerce]" value="<?php echo esc_attr( $settings['is_ecommerce'] ? '1' : '0' ); ?>">

	<!-- Persist Services (structured array) -->
	<?php
	$services = is_array( $settings['services'] ) ? $settings['services'] : array();
	foreach ( $services as $i => $service ) :
		?>
		<input type="hidden" name="aidf_settings[services][<?php echo esc_attr( $i ); ?>][name]" value="<?php echo esc_attr( $service['name'] ); ?>">
		<?php if ( ! empty( $service['url'] ) ) : ?>
			<input type="hidden" name="aidf_settings[services][<?php echo esc_attr( $i ); ?>][url]" value="<?php echo esc_attr( $service['url'] ); ?>">
		<?php endif; ?>
	<?php endforeach; ?>

	<!-- Persist Key People (structured array) -->
	<?php
	$key_people = is_array( $settings['key_people'] ) ? $settings['key_people'] : array();
	foreach ( $key_people as $i => $person ) :
		?>
		<input type="hidden" name="aidf_settings[key_people][<?php echo esc_attr( $i ); ?>][name]" value="<?php echo esc_attr( $person['name'] ); ?>">
		<input type="hidden" name="aidf_settings[key_people][<?php echo esc_attr( $i ); ?>][role]" value="<?php echo esc_attr( isset( $person['role'] ) ? $person['role'] : '' ); ?>">
		<input type="hidden" name="aidf_settings[key_people][<?php echo esc_attr( $i ); ?>][url]" value="<?php echo esc_attr( isset( $person['url'] ) ? $person['url'] : '' ); ?>">
	<?php endforeach; ?>

	<!-- Persist FAQs (structured array) -->
	<?php
	$faqs = is_array( $settings['faqs'] ) ? $settings['faqs'] : array();
	foreach ( $faqs as $i => $faq ) :
		?>
		<input type="hidden" name="aidf_settings[faqs][<?php echo esc_attr( $i ); ?>][q]" value="<?php echo esc_attr( $faq['q'] ); ?>">
		<input type="hidden" name="aidf_settings[faqs][<?php echo esc_attr( $i ); ?>][a]" value="<?php echo esc_attr( $faq['a'] ); ?>">
	<?php endforeach; ?>

	<input type="hidden" name="aidf_settings[spec_attribution]" value="<?php echo esc_attr( $settings['spec_attribution'] ? '1' : '0' ); ?>">
	<input type="hidden" name="aidf_settings[verify_code]" value="<?php echo esc_attr( isset( $settings['verify_code'] ) ? $settings['verify_code'] : '' ); ?>">

	<?php foreach ( $tiers as $tier_slug => $tier ) : ?>
		<div class="aidf-panel">
			<div class="aidf-panel-header">
				<div>
					<h2 class="aidf-panel-title">
						<?php echo esc_html( $tier['label'] ); ?>
						<span class="aidf-badge aidf-badge--<?php echo esc_attr( $tier_slug ); ?>"><?php echo esc_html( $tier_slug ); ?></span>
					</h2>
					<p class="aidf-panel-subtitle"><?php echo esc_html( $tier['description'] ); ?></p>
				</div>
			</div>
			<div class="aidf-panel-body" style="padding: 0;">
				<ul class="aidf-checklist">
					<?php
					foreach ( $file_types as $slug => $meta ) :
						if ( $meta['tier'] !== $tier_slug ) {
							continue;
						}

						$is_active = in_array( $slug, $active_files, true );
						$status    = AIDF_Validator::get_status( $slug );
						$has_conflict = AIDF_Server::physical_file_exists( $slug );

						$icon_class = 'inactive';
						$icon       = 'dashicons-marker';

						if ( $is_active && ! $has_conflict ) {
							$icon_class = 'active';
							$icon       = 'dashicons-yes';
						} elseif ( $has_conflict ) {
							$icon_class = 'conflict';
							$icon       = 'dashicons-warning';
						}
						?>
						<li class="aidf-checklist-item">
							<span class="aidf-checklist-icon aidf-checklist-icon--<?php echo esc_attr( $icon_class ); ?>">
								<span class="dashicons <?php echo esc_attr( $icon ); ?>"></span>
							</span>
							<span class="aidf-checklist-name">
								<?php echo esc_html( $meta['filename'] ); ?>
								<span class="aidf-file-card-code"><?php echo esc_html( $meta['code'] ); ?></span>
							</span>
							<span class="aidf-checklist-meta">
								<?php if ( $has_conflict ) : ?>
									<span class="aidf-badge aidf-badge--conflict"><?php esc_html_e( 'File exists', 'ai-discovery-files' ); ?></span>
								<?php elseif ( $is_active ) : ?>
									<a href="<?php echo esc_url( AIDF_Server::get_file_url( $slug ) ); ?>" class="aidf-checklist-url" target="_blank" rel="noopener">
										/<?php echo esc_html( $meta['filename'] ); ?> &#8599;
									</a>
								<?php endif; ?>

								<label class="aidf-switch">
									<input type="checkbox"
									       name="aidf_settings[active_files][]"
									       value="<?php echo esc_attr( $slug ); ?>"
									       <?php checked( $is_active ); ?>>
									<span class="aidf-slider"></span>
								</label>
							</span>
						</li>
					<?php endforeach; ?>
				</ul>
			</div>
		</div>
	<?php endforeach; ?>

	<div class="aidf-panel">
		<div class="aidf-actions">
			<div class="aidf-actions-left">
				<?php submit_button( __( 'Save Active Files', 'ai-discovery-files' ), 'aidf-btn aidf-btn--primary', 'submit', false ); ?>
			</div>
			<div class="aidf-actions-right">
				<button type="button" id="aidf-validate-btn" class="aidf-btn aidf-btn--secondary">
					<span class="dashicons dashicons-yes-alt"></span>
					<?php esc_html_e( 'Validate All', 'ai-discovery-files' ); ?>
				</button>
			</div>
		</div>
	</div>
</form>

<!-- Validation Results (populated via AJAX) -->
<div id="aidf-validation-results" style="display: none;">
	<div class="aidf-panel">
		<div class="aidf-panel-header">
			<h2 class="aidf-panel-title">
				<span class="dashicons dashicons-yes-alt"></span>
				<?php esc_html_e( 'Validation Results', 'ai-discovery-files' ); ?>
			</h2>
		</div>
		<div class="aidf-panel-body" id="aidf-validation-output"></div>
	</div>
</div>

<!-- Domain Verification -->
<?php
$verify_code   = isset( $settings['verify_code'] ) ? $settings['verify_code'] : '';
$verify_active = ! empty( $verify_code );
?>
<div class="aidf-panel aidf-verify-panel">
	<div class="aidf-panel-header">
		<div>
			<h2 class="aidf-panel-title">
				<span class="dashicons dashicons-shield-alt"></span>
				<?php esc_html_e( 'Directory Verification', 'ai-discovery-files' ); ?>
				<?php if ( $verify_active ) : ?>
					<span class="aidf-badge aidf-badge--essential"><?php esc_html_e( 'active', 'ai-discovery-files' ); ?></span>
				<?php endif; ?>
			</h2>
			<p class="aidf-panel-subtitle"><?php esc_html_e( 'Prove domain ownership to manage your listing in the AI Visibility Directory.', 'ai-discovery-files' ); ?></p>
		</div>
	</div>
	<div class="aidf-panel-body">
		<div class="aidf-verify-inline">
			<?php if ( $verify_active ) : ?>
				<div class="aidf-verify-inline__status aidf-verify-inline__status--active">
					<span class="dashicons dashicons-yes-alt"></span>
					<span>
						<?php esc_html_e( 'Verification file is live at', 'ai-discovery-files' ); ?>
						<a href="<?php echo esc_url( home_url( '/ai-visibility-verify.txt' ) ); ?>" target="_blank" rel="noopener">
							/ai-visibility-verify.txt &#8599;
						</a>
					</span>
				</div>
			<?php else : ?>
				<p class="aidf-verify-inline__description">
					<?php esc_html_e( 'After submitting your site to the directory, enter your verification code here so the plugin can serve the ownership file automatically.', 'ai-discovery-files' ); ?>
				</p>
			<?php endif; ?>
			<button type="button" class="aidf-btn aidf-btn--secondary" id="aidf-open-verify-panel">
				<span class="dashicons dashicons-shield-alt"></span>
				<?php
				echo $verify_active
					? esc_html__( 'Update Verification Code', 'ai-discovery-files' )
					: esc_html__( 'Enter Verification Code', 'ai-discovery-files' );
				?>
			</button>
		</div>
	</div>
</div>
