<?php
/**
 * Preview tab — live preview of generated files.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$settings     = AIDF_Plugin::get_settings();
$active_files = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();
$file_types   = AIDF_Plugin::get_file_types();

// Default to first active file for preview.
$preview_slug = ! empty( $active_files ) ? $active_files[0] : 'llms-txt';
?>

<?php if ( empty( $active_files ) ) : ?>
	<div class="aidf-notice aidf-notice--warning">
		<span class="dashicons dashicons-warning"></span>
		<div>
			<?php esc_html_e( 'No files are currently enabled. Enable files in the Status tab to preview them.', 'ai-discovery-files' ); ?>
		</div>
	</div>
<?php else : ?>

	<div class="aidf-panel">
		<div class="aidf-panel-header">
			<h2 class="aidf-panel-title">
				<span class="dashicons dashicons-media-code"></span>
				<?php esc_html_e( 'File Preview', 'ai-discovery-files' ); ?>
			</h2>
		</div>
		<div class="aidf-panel-body" style="padding: 0;">

			<div class="aidf-preview-wrap">
				<div class="aidf-preview-toolbar">
					<select id="aidf-preview-picker" class="aidf-preview-select">
						<?php foreach ( $active_files as $slug ) : ?>
							<?php if ( isset( $file_types[ $slug ] ) && 'llm-txt' !== $slug ) : ?>
								<option value="<?php echo esc_attr( $slug ); ?>" <?php selected( $slug, $preview_slug ); ?>>
									<?php echo esc_html( $file_types[ $slug ]['filename'] ); ?>
								</option>
							<?php endif; ?>
						<?php endforeach; ?>
					</select>

					<div class="aidf-preview-actions">
						<button type="button" id="aidf-copy-preview" class="aidf-btn aidf-btn--sm aidf-btn--ghost" style="color: rgba(255,255,255,0.6);">
							<span class="dashicons dashicons-admin-page"></span>
							<?php esc_html_e( 'Copy', 'ai-discovery-files' ); ?>
						</button>
						<a href="#" id="aidf-view-live" class="aidf-btn aidf-btn--sm aidf-btn--ghost" style="color: rgba(255,255,255,0.6);" target="_blank" rel="noopener">
							<span class="dashicons dashicons-external"></span>
							<?php esc_html_e( 'View Live', 'ai-discovery-files' ); ?>
						</a>
					</div>
				</div>

				<textarea id="aidf-preview-output" class="aidf-preview-code" readonly><?php
					$content = AIDF_Generator::generate( $preview_slug );
					if ( false !== $content ) {
						echo esc_textarea( $content );
					}
				?></textarea>
			</div>

		</div>
	</div>

	<div class="aidf-notice aidf-notice--info">
		<span class="dashicons dashicons-info"></span>
		<div>
			<?php
			echo wp_kses(
				sprintf(
					/* translators: %s: link to the status tab */
					__( 'This preview reflects your current saved settings. Changes made on other tabs must be saved first. Visit the %s to see which files are active and their URLs.', 'ai-discovery-files' ),
					'<a href="' . esc_url( admin_url( 'admin.php?page=ai-discovery-files&tab=status' ) ) . '">' . esc_html__( 'Status tab', 'ai-discovery-files' ) . '</a>'
				),
				array( 'a' => array( 'href' => array() ) )
			);
			?>
		</div>
	</div>

<?php endif; ?>
