<?php
/**
 * Permissions settings tab.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$settings = AIDF_Plugin::get_settings();
?>

<div class="aidf-notice aidf-notice--info">
	<span class="dashicons dashicons-info"></span>
	<div>
		<?php esc_html_e( 'These settings control how AI systems may use your content. They are published in ai.txt and ai.json so AI systems can respect your preferences.', 'ai-discovery-files' ); ?>
	</div>
</div>

<!-- AI Content Usage -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-admin-page"></span>
			<?php esc_html_e( 'AI Content Usage', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">
		<div class="aidf-permission-card">
			<div class="aidf-permission-card-title">
				<?php esc_html_e( 'How may AI systems use your content?', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'This controls how AI systems reference your content at query time — when a user asks about your business. It is separate from whether your content is used for AI model training.', 'ai-discovery-files' ) ); ?>
			</div>
			<p class="aidf-permission-card-desc"><?php esc_html_e( 'Controls whether AI systems like ChatGPT, Claude, and Gemini may reference, quote, or summarise content from your website.', 'ai-discovery-files' ); ?></p>

			<div class="aidf-radio-group">
				<label class="aidf-radio-option">
					<input type="radio" name="aidf_settings[ai_usage]" value="allow" <?php checked( $settings['ai_usage'], 'allow' ); ?>>
					<span class="aidf-radio-option-text"><?php esc_html_e( 'Allow freely', 'ai-discovery-files' ); ?></span>
					<span class="aidf-radio-option-hint"><?php esc_html_e( 'No restrictions', 'ai-discovery-files' ); ?></span>
				</label>
				<label class="aidf-radio-option">
					<input type="radio" name="aidf_settings[ai_usage]" value="allow_with_attribution" <?php checked( $settings['ai_usage'], 'allow_with_attribution' ); ?>>
					<span class="aidf-radio-option-text"><?php esc_html_e( 'Allow with attribution', 'ai-discovery-files' ); ?></span>
					<span class="aidf-radio-option-hint"><?php esc_html_e( 'Recommended', 'ai-discovery-files' ); ?></span>
				</label>
				<label class="aidf-radio-option">
					<input type="radio" name="aidf_settings[ai_usage]" value="restrict" <?php checked( $settings['ai_usage'], 'restrict' ); ?>>
					<span class="aidf-radio-option-text"><?php esc_html_e( 'Restrict usage', 'ai-discovery-files' ); ?></span>
					<span class="aidf-radio-option-hint"><?php esc_html_e( 'Reference only', 'ai-discovery-files' ); ?></span>
				</label>
				<label class="aidf-radio-option">
					<input type="radio" name="aidf_settings[ai_usage]" value="prohibit" <?php checked( $settings['ai_usage'], 'prohibit' ); ?>>
					<span class="aidf-radio-option-text"><?php esc_html_e( 'Prohibit', 'ai-discovery-files' ); ?></span>
					<span class="aidf-radio-option-hint"><?php esc_html_e( 'No AI usage', 'ai-discovery-files' ); ?></span>
				</label>
			</div>
		</div>
	</div>
</div>

<!-- AI Training -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-database"></span>
			<?php esc_html_e( 'AI Model Training', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">
		<div class="aidf-permission-card">
			<div class="aidf-permission-card-title">
				<?php esc_html_e( 'May your content be used for AI training?', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'Training incorporates your content into the AI model itself — it becomes part of the model\'s knowledge. This is different from AI systems reading your content to answer questions in real time.', 'ai-discovery-files' ) ); ?>
			</div>
			<p class="aidf-permission-card-desc"><?php esc_html_e( 'Controls whether your content can be included in datasets used to train AI models. This is separate from AI systems using your content at query time.', 'ai-discovery-files' ); ?></p>

			<div class="aidf-radio-group">
				<label class="aidf-radio-option">
					<input type="radio" name="aidf_settings[ai_training]" value="allow" <?php checked( $settings['ai_training'], 'allow' ); ?>>
					<span class="aidf-radio-option-text"><?php esc_html_e( 'Allow training', 'ai-discovery-files' ); ?></span>
				</label>
				<label class="aidf-radio-option">
					<input type="radio" name="aidf_settings[ai_training]" value="restrict" <?php checked( $settings['ai_training'], 'restrict' ); ?>>
					<span class="aidf-radio-option-text"><?php esc_html_e( 'Restrict training', 'ai-discovery-files' ); ?></span>
					<span class="aidf-radio-option-hint"><?php esc_html_e( 'Recommended', 'ai-discovery-files' ); ?></span>
				</label>
				<label class="aidf-radio-option">
					<input type="radio" name="aidf_settings[ai_training]" value="prohibit" <?php checked( $settings['ai_training'], 'prohibit' ); ?>>
					<span class="aidf-radio-option-text"><?php esc_html_e( 'Prohibit training', 'ai-discovery-files' ); ?></span>
				</label>
			</div>
		</div>
	</div>
</div>

<!-- Content Licence -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-media-text"></span>
			<?php esc_html_e( 'Content Licence', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">
		<div class="aidf-permission-card">
			<div class="aidf-permission-card-title"><?php esc_html_e( 'Under what licence is your content published?', 'ai-discovery-files' ); ?></div>
			<p class="aidf-permission-card-desc"><?php esc_html_e( 'Tells AI systems the legal terms under which your content may be used. Published in ai.txt and ai.json.', 'ai-discovery-files' ); ?></p>

			<div class="aidf-field" style="margin-top: 12px;">
				<select name="aidf_settings[content_licence]" class="aidf-select">
					<option value="" <?php selected( $settings['content_licence'], '' ); ?>><?php esc_html_e( 'Not specified', 'ai-discovery-files' ); ?></option>
					<option value="all_rights_reserved" <?php selected( $settings['content_licence'], 'all_rights_reserved' ); ?>><?php esc_html_e( 'All Rights Reserved', 'ai-discovery-files' ); ?></option>
					<option value="cc_by" <?php selected( $settings['content_licence'], 'cc_by' ); ?>><?php esc_html_e( 'CC BY 4.0 — Attribution', 'ai-discovery-files' ); ?></option>
					<option value="cc_by_sa" <?php selected( $settings['content_licence'], 'cc_by_sa' ); ?>><?php esc_html_e( 'CC BY-SA 4.0 — Attribution ShareAlike', 'ai-discovery-files' ); ?></option>
					<option value="cc_by_nc" <?php selected( $settings['content_licence'], 'cc_by_nc' ); ?>><?php esc_html_e( 'CC BY-NC 4.0 — Attribution NonCommercial', 'ai-discovery-files' ); ?></option>
					<option value="cc_by_nd" <?php selected( $settings['content_licence'], 'cc_by_nd' ); ?>><?php esc_html_e( 'CC BY-ND 4.0 — Attribution NoDerivatives', 'ai-discovery-files' ); ?></option>
					<option value="cc0" <?php selected( $settings['content_licence'], 'cc0' ); ?>><?php esc_html_e( 'CC0 — Public Domain', 'ai-discovery-files' ); ?></option>
				</select>
			</div>
		</div>
	</div>
</div>

<!-- Citation Format -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-format-quote"></span>
			<?php esc_html_e( 'Citation Preference', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">
		<div class="aidf-field">
			<label class="aidf-label" for="aidf-citation-format">
				<?php esc_html_e( 'Preferred Citation Format', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'Tell AI systems exactly how to credit you when referencing your content. Without this, each AI system uses its own format.', 'ai-discovery-files' ) ); ?>
			</label>
			<input type="text"
			       id="aidf-citation-format"
			       name="aidf_settings[citation_format]"
			       value="<?php echo esc_attr( $settings['citation_format'] ); ?>"
			       class="aidf-input aidf-input--wide"
			       placeholder="<?php esc_attr_e( 'e.g. Source: Company Name (https://example.com)', 'ai-discovery-files' ); ?>">
			<p class="aidf-description"><?php esc_html_e( 'How AI systems should cite your content when attribution is required. Leave blank to let AI systems decide.', 'ai-discovery-files' ); ?></p>
		</div>
	</div>
</div>

<!-- Crawler Policy -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-search"></span>
			<?php esc_html_e( 'AI Crawler Access', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">
		<div class="aidf-permission-card">
			<div class="aidf-permission-card-title">
				<?php esc_html_e( 'Which AI crawlers may access your site?', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'AI crawlers (like GPTBot, ClaudeBot, Bingbot) visit your site to index content for their AI systems. This setting is published in robots-ai.txt alongside your standard robots.txt.', 'ai-discovery-files' ) ); ?>
			</div>
			<p class="aidf-permission-card-desc"><?php esc_html_e( 'Published in robots-ai.txt to guide AI crawler behaviour alongside your robots.txt.', 'ai-discovery-files' ); ?></p>

			<div class="aidf-radio-group">
				<label class="aidf-radio-option">
					<input type="radio" name="aidf_settings[crawler_policy]" value="allow_all" <?php checked( $settings['crawler_policy'], 'allow_all' ); ?>>
					<span class="aidf-radio-option-text"><?php esc_html_e( 'Allow all AI crawlers', 'ai-discovery-files' ); ?></span>
				</label>
				<label class="aidf-radio-option">
					<input type="radio" name="aidf_settings[crawler_policy]" value="allow_known" <?php checked( $settings['crawler_policy'], 'allow_known' ); ?>>
					<span class="aidf-radio-option-text"><?php esc_html_e( 'Allow known AI crawlers', 'ai-discovery-files' ); ?></span>
					<span class="aidf-radio-option-hint"><?php esc_html_e( 'Recommended', 'ai-discovery-files' ); ?></span>
				</label>
				<label class="aidf-radio-option">
					<input type="radio" name="aidf_settings[crawler_policy]" value="restrict" <?php checked( $settings['crawler_policy'], 'restrict' ); ?>>
					<span class="aidf-radio-option-text"><?php esc_html_e( 'Restrict to search engines only', 'ai-discovery-files' ); ?></span>
				</label>
			</div>
		</div>
	</div>
</div>
