<?php
/**
 * Identity settings tab.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$settings   = AIDF_Plugin::get_settings();
$site_pages = get_pages( array( 'post_status' => 'publish', 'sort_column' => 'post_title', 'number' => 100 ) );
if ( ! is_array( $site_pages ) ) {
	$site_pages = array();
}

// Normalise legacy services string to array for the repeater.
$services = $settings['services'];
if ( is_string( $services ) && ! empty( $services ) ) {
	$services = array();
	$lines    = preg_split( '/[\r\n]+/', $settings['services'] );
	foreach ( $lines as $line ) {
		$line = trim( $line );
		if ( empty( $line ) ) {
			continue;
		}
		if ( false !== strpos( $line, '|' ) ) {
			$parts = explode( '|', $line, 2 );
			$services[] = array( 'name' => trim( $parts[0] ), 'url' => trim( $parts[1] ) );
		} else {
			$services[] = array( 'name' => $line, 'url' => '' );
		}
	}
} elseif ( ! is_array( $services ) ) {
	$services = array();
}

// Business types that require registration numbers.
$registered_types = AIDF_Plugin::get_registered_business_types();
$show_company     = in_array( $settings['business_type'], $registered_types, true );
$show_vat         = ! empty( $settings['vat_registered'] );
$show_custom_hours = ( 'custom' === $settings['operating_hours_preset'] );
$show_ecommerce    = ! empty( $settings['is_ecommerce'] );
?>

<!-- Tier Progress -->
<?php include AIDF_PLUGIN_DIR . 'admin/views/partials/tier-progress.php'; ?>

<!-- Business Identity -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<div>
			<h2 class="aidf-panel-title">
				<span class="dashicons dashicons-building"></span>
				<?php esc_html_e( 'Business Identity', 'ai-discovery-files' ); ?>
			</h2>
			<p class="aidf-panel-subtitle"><?php esc_html_e( 'Core information about your organisation. Used across all AI Discovery Files.', 'ai-discovery-files' ); ?></p>
		</div>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-field-row">
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-business-name">
					<?php esc_html_e( 'Business Name', 'ai-discovery-files' ); ?>
					<span class="aidf-label-hint"><?php esc_html_e( '(required)', 'ai-discovery-files' ); ?></span>
				</label>
				<input type="text"
				       id="aidf-business-name"
				       name="aidf_settings[business_name]"
				       value="<?php echo esc_attr( $settings['business_name'] ); ?>"
				       class="aidf-input"
				       placeholder="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>">
				<p class="aidf-description"><?php esc_html_e( 'Your primary business or organisation name. This is the canonical name AI systems will use.', 'ai-discovery-files' ); ?></p>
			</div>

			<div class="aidf-field">
				<label class="aidf-label" for="aidf-legal-name">
					<?php esc_html_e( 'Legal Name', 'ai-discovery-files' ); ?>
					<span class="aidf-label-hint"><?php esc_html_e( '(optional)', 'ai-discovery-files' ); ?></span>
				</label>
				<input type="text"
				       id="aidf-legal-name"
				       name="aidf_settings[legal_name]"
				       value="<?php echo esc_attr( $settings['legal_name'] ); ?>"
				       class="aidf-input"
				       placeholder="<?php esc_html_e( 'e.g. Company Name Ltd', 'ai-discovery-files' ); ?>">
				<p class="aidf-description"><?php esc_html_e( 'Registered legal entity name, if different from business name.', 'ai-discovery-files' ); ?></p>
			</div>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-tagline">
				<?php esc_html_e( 'Tagline / Description', 'ai-discovery-files' ); ?>
			</label>
			<input type="text"
			       id="aidf-tagline"
			       name="aidf_settings[tagline]"
			       value="<?php echo esc_attr( $settings['tagline'] ); ?>"
			       class="aidf-input aidf-input--wide"
			       placeholder="<?php echo esc_attr( get_bloginfo( 'description' ) ); ?>">
			<p class="aidf-description"><?php esc_html_e( 'A concise description of what your organisation does. Used in the llms.txt blockquote.', 'ai-discovery-files' ); ?></p>
		</div>

	</div>
</div>

<!-- Contact Information -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-email"></span>
			<?php esc_html_e( 'Contact Information', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-field-row">
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-email">
					<?php esc_html_e( 'Contact Email', 'ai-discovery-files' ); ?>
					<span class="aidf-label-hint"><?php esc_html_e( '(required)', 'ai-discovery-files' ); ?></span>
				</label>
				<input type="email"
				       id="aidf-email"
				       name="aidf_settings[contact_email]"
				       value="<?php echo esc_attr( $settings['contact_email'] ); ?>"
				       class="aidf-input">
			</div>

			<div class="aidf-field">
				<label class="aidf-label" for="aidf-phone">
					<?php esc_html_e( 'Phone Number', 'ai-discovery-files' ); ?>
					<span class="aidf-label-hint"><?php esc_html_e( '(optional)', 'ai-discovery-files' ); ?></span>
				</label>
				<input type="text"
				       id="aidf-phone"
				       name="aidf_settings[contact_phone]"
				       value="<?php echo esc_attr( $settings['contact_phone'] ); ?>"
				       class="aidf-input">
			</div>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-contact-url">
				<?php esc_html_e( 'Contact Page URL', 'ai-discovery-files' ); ?>
			</label>
			<div class="aidf-url-with-picker">
				<input type="url"
				       id="aidf-contact-url"
				       name="aidf_settings[contact_url]"
				       value="<?php echo esc_url( $settings['contact_url'] ); ?>"
				       class="aidf-input"
				       placeholder="https://">
				<select class="aidf-page-picker" data-target="aidf-contact-url">
					<option value=""><?php esc_html_e( 'Select a page…', 'ai-discovery-files' ); ?></option>
					<?php foreach ( $site_pages as $page ) : ?>
						<option value="<?php echo esc_url( get_permalink( $page ) ); ?>"><?php echo esc_html( $page->post_title ); ?></option>
					<?php endforeach; ?>
				</select>
			</div>
		</div>

	</div>
</div>

<!-- Location -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-location"></span>
			<?php esc_html_e( 'Location', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-address"><?php esc_html_e( 'Street Address', 'ai-discovery-files' ); ?></label>
			<input type="text"
			       id="aidf-address"
			       name="aidf_settings[address]"
			       value="<?php echo esc_attr( $settings['address'] ); ?>"
			       class="aidf-input aidf-input--wide"
			       placeholder="<?php esc_attr_e( 'e.g. 5 Epping Close', 'ai-discovery-files' ); ?>">
		</div>

		<div class="aidf-field-row">
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-city"><?php esc_html_e( 'City / Town', 'ai-discovery-files' ); ?></label>
				<input type="text" id="aidf-city" name="aidf_settings[location_city]" value="<?php echo esc_attr( $settings['location_city'] ); ?>" class="aidf-input">
			</div>
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-region"><?php esc_html_e( 'Region / State', 'ai-discovery-files' ); ?></label>
				<input type="text" id="aidf-region" name="aidf_settings[location_region]" value="<?php echo esc_attr( $settings['location_region'] ); ?>" class="aidf-input">
			</div>
		</div>

		<div class="aidf-field-row">
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-postcode"><?php esc_html_e( 'Postcode / ZIP', 'ai-discovery-files' ); ?></label>
				<input type="text" id="aidf-postcode" name="aidf_settings[postcode]" value="<?php echo esc_attr( $settings['postcode'] ); ?>" class="aidf-input" placeholder="<?php esc_attr_e( 'e.g. NN15 6RW', 'ai-discovery-files' ); ?>">
			</div>
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-country"><?php esc_html_e( 'Country', 'ai-discovery-files' ); ?></label>
				<input type="text" id="aidf-country" name="aidf_settings[location_country]" value="<?php echo esc_attr( $settings['location_country'] ); ?>" class="aidf-input" placeholder="<?php esc_attr_e( 'e.g. United Kingdom', 'ai-discovery-files' ); ?>">
			</div>
		</div>

	</div>
</div>

<!-- Business Details -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-portfolio"></span>
			<?php esc_html_e( 'Business Details', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-field-row">
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-industry"><?php esc_html_e( 'Industry / Sector', 'ai-discovery-files' ); ?></label>
				<?php $industries = AIDF_Plugin::get_industries(); ?>
				<select id="aidf-industry" name="aidf_settings[industry]" class="aidf-select">
					<option value=""><?php esc_html_e( '— Select industry —', 'ai-discovery-files' ); ?></option>
					<?php foreach ( $industries as $value => $label ) : ?>
						<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $settings['industry'], $value ); ?>><?php echo esc_html( $label ); ?></option>
					<?php endforeach; ?>
				</select>
			</div>
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-business-type"><?php esc_html_e( 'Business Type', 'ai-discovery-files' ); ?></label>
				<select id="aidf-business-type" name="aidf_settings[business_type]" class="aidf-select">
					<option value=""><?php esc_html_e( '— Select type —', 'ai-discovery-files' ); ?></option>
					<?php
					$business_types = array(
						'Sole Trader'              => __( 'Sole Trader', 'ai-discovery-files' ),
						'Partnership'              => __( 'Partnership', 'ai-discovery-files' ),
						'Limited Company'          => __( 'Limited Company (Ltd)', 'ai-discovery-files' ),
						'Limited Liability Partnership' => __( 'Limited Liability Partnership (LLP)', 'ai-discovery-files' ),
						'Public Limited Company'   => __( 'Public Limited Company (PLC)', 'ai-discovery-files' ),
						'Corporation'              => __( 'Corporation', 'ai-discovery-files' ),
						'LLC'                      => __( 'LLC', 'ai-discovery-files' ),
						'Non-Profit'               => __( 'Non-Profit / Charity', 'ai-discovery-files' ),
						'Government'               => __( 'Government / Public Sector', 'ai-discovery-files' ),
						'Cooperative'              => __( 'Cooperative', 'ai-discovery-files' ),
						'Freelancer'               => __( 'Freelancer / Independent', 'ai-discovery-files' ),
						'Other'                    => __( 'Other', 'ai-discovery-files' ),
					);
					foreach ( $business_types as $value => $label ) :
						?>
						<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $settings['business_type'], $value ); ?>><?php echo esc_html( $label ); ?></option>
					<?php endforeach; ?>
				</select>
			</div>
		</div>

		<!-- Company Number (conditional: shown for Ltd, LLP, PLC, Corporation, LLC) -->
		<div class="aidf-conditional-group" id="aidf-company-fields"<?php if ( ! $show_company ) : ?> style="display:none;"<?php endif; ?>>
			<div class="aidf-field-row">
				<div class="aidf-field">
					<label class="aidf-label" for="aidf-company-number">
						<?php esc_html_e( 'Company Registration Number', 'ai-discovery-files' ); ?>
						<?php AIDF_Admin::tooltip( __( 'Your official company registration number (e.g. Companies House number in the UK). Included in identity.json for verification.', 'ai-discovery-files' ) ); ?>
					</label>
					<input type="text"
					       id="aidf-company-number"
					       name="aidf_settings[company_number]"
					       value="<?php echo esc_attr( $settings['company_number'] ); ?>"
					       class="aidf-input"
					       placeholder="<?php esc_attr_e( 'e.g. 12345678', 'ai-discovery-files' ); ?>">
				</div>
				<div class="aidf-field">
					<label class="aidf-label" for="aidf-jurisdiction">
						<?php esc_html_e( 'Jurisdiction', 'ai-discovery-files' ); ?>
						<?php AIDF_Admin::tooltip( __( 'The country or state where your company is registered. Helps AI systems verify your business.', 'ai-discovery-files' ) ); ?>
					</label>
					<input type="text"
					       id="aidf-jurisdiction"
					       name="aidf_settings[company_jurisdiction]"
					       value="<?php echo esc_attr( $settings['company_jurisdiction'] ); ?>"
					       class="aidf-input"
					       placeholder="<?php esc_attr_e( 'e.g. England and Wales', 'ai-discovery-files' ); ?>">
				</div>
			</div>
		</div>

		<!-- VAT Registration -->
		<div class="aidf-field">
			<div class="aidf-toggle-row">
				<label class="aidf-switch">
					<input type="hidden" name="aidf_settings[vat_registered]" value="0">
					<input type="checkbox"
					       id="aidf-vat-registered"
					       name="aidf_settings[vat_registered]"
					       value="1"
					       <?php checked( $settings['vat_registered'] ); ?>>
					<span class="aidf-slider"></span>
				</label>
				<div>
					<span class="aidf-toggle-label"><?php esc_html_e( 'VAT Registered', 'ai-discovery-files' ); ?></span>
				</div>
			</div>
		</div>

		<!-- VAT Number (conditional: shown when VAT registered) -->
		<div class="aidf-conditional-group" id="aidf-vat-fields"<?php if ( ! $show_vat ) : ?> style="display:none;"<?php endif; ?>>
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-vat-number">
					<?php esc_html_e( 'VAT Number', 'ai-discovery-files' ); ?>
				</label>
				<input type="text"
				       id="aidf-vat-number"
				       name="aidf_settings[vat_number]"
				       value="<?php echo esc_attr( $settings['vat_number'] ); ?>"
				       class="aidf-input"
				       style="max-width: 300px;"
				       placeholder="<?php esc_attr_e( 'e.g. GB123456789', 'ai-discovery-files' ); ?>">
				<p class="aidf-description"><?php esc_html_e( 'Included in identity.json as a verification identifier.', 'ai-discovery-files' ); ?></p>
			</div>
		</div>

		<div class="aidf-field-row">
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-founded"><?php esc_html_e( 'Founded Year', 'ai-discovery-files' ); ?></label>
				<input type="text" id="aidf-founded" name="aidf_settings[founded_year]" value="<?php echo esc_attr( $settings['founded_year'] ); ?>" class="aidf-input" placeholder="<?php esc_attr_e( 'e.g. 2010', 'ai-discovery-files' ); ?>">
			</div>
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-employees"><?php esc_html_e( 'Employee Count', 'ai-discovery-files' ); ?></label>
				<select id="aidf-employees" name="aidf_settings[employee_count]" class="aidf-select">
					<option value=""><?php esc_html_e( '— Select range —', 'ai-discovery-files' ); ?></option>
					<?php
					$employee_ranges = array(
						'Solo'       => __( 'Solo (1)', 'ai-discovery-files' ),
						'2-10'       => __( '2-10', 'ai-discovery-files' ),
						'11-50'      => __( '11-50', 'ai-discovery-files' ),
						'51-200'     => __( '51-200', 'ai-discovery-files' ),
						'201-500'    => __( '201-500', 'ai-discovery-files' ),
						'501-1000'   => __( '501-1,000', 'ai-discovery-files' ),
						'1001-5000'  => __( '1,001-5,000', 'ai-discovery-files' ),
						'5001-10000' => __( '5,001-10,000', 'ai-discovery-files' ),
						'10001+'     => __( '10,001+', 'ai-discovery-files' ),
					);
					foreach ( $employee_ranges as $value => $label ) :
						?>
						<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $settings['employee_count'], $value ); ?>><?php echo esc_html( $label ); ?></option>
					<?php endforeach; ?>
				</select>
			</div>
		</div>

		<div class="aidf-field-row">
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-customer-type">
					<?php esc_html_e( 'Customer Type', 'ai-discovery-files' ); ?>
					<?php AIDF_Admin::tooltip( __( 'Helps AI systems understand who your target audience is when recommending your business.', 'ai-discovery-files' ) ); ?>
				</label>
				<select id="aidf-customer-type" name="aidf_settings[customer_type]" class="aidf-select">
					<option value=""><?php esc_html_e( '— Select —', 'ai-discovery-files' ); ?></option>
					<option value="B2B" <?php selected( $settings['customer_type'], 'B2B' ); ?>><?php esc_html_e( 'B2B (Business to Business)', 'ai-discovery-files' ); ?></option>
					<option value="B2C" <?php selected( $settings['customer_type'], 'B2C' ); ?>><?php esc_html_e( 'B2C (Business to Consumer)', 'ai-discovery-files' ); ?></option>
					<option value="Both" <?php selected( $settings['customer_type'], 'Both' ); ?>><?php esc_html_e( 'Both B2B and B2C', 'ai-discovery-files' ); ?></option>
				</select>
			</div>
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-offering-type">
					<?php esc_html_e( 'What Do You Offer?', 'ai-discovery-files' ); ?>
					<?php AIDF_Admin::tooltip( __( 'Tells AI systems whether you sell products, deliver services, or both.', 'ai-discovery-files' ) ); ?>
				</label>
				<select id="aidf-offering-type" name="aidf_settings[offering_type]" class="aidf-select">
					<option value=""><?php esc_html_e( '— Select —', 'ai-discovery-files' ); ?></option>
					<option value="Products" <?php selected( $settings['offering_type'], 'Products' ); ?>><?php esc_html_e( 'Products', 'ai-discovery-files' ); ?></option>
					<option value="Services" <?php selected( $settings['offering_type'], 'Services' ); ?>><?php esc_html_e( 'Services', 'ai-discovery-files' ); ?></option>
					<option value="Both" <?php selected( $settings['offering_type'], 'Both' ); ?>><?php esc_html_e( 'Both Products and Services', 'ai-discovery-files' ); ?></option>
				</select>
			</div>
		</div>

		<div class="aidf-field">
			<div class="aidf-toggle-row">
				<label class="aidf-switch">
					<input type="hidden" name="aidf_settings[is_ecommerce]" value="0">
					<input type="checkbox"
					       id="aidf-is-ecommerce"
					       name="aidf_settings[is_ecommerce]"
					       value="1"
					       <?php checked( $settings['is_ecommerce'] ); ?>>
					<span class="aidf-slider"></span>
				</label>
				<div>
					<span class="aidf-toggle-label">
						<?php esc_html_e( 'E-commerce website', 'ai-discovery-files' ); ?>
						<?php AIDF_Admin::tooltip( __( 'Enable if you sell products or accept payments through your website. Adds e-commerce context to your discovery files.', 'ai-discovery-files' ) ); ?>
					</span>
					<p class="aidf-toggle-description"><?php esc_html_e( 'Your website has an online shop or accepts payments for products/services.', 'ai-discovery-files' ); ?></p>
				</div>
			</div>
		</div>

		<!-- Products URL (conditional: shown when E-commerce enabled) -->
		<div class="aidf-conditional-group" id="aidf-ecommerce-fields"<?php if ( ! $show_ecommerce ) : ?> style="display:none;"<?php endif; ?>>
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-products-url"><?php esc_html_e( 'Products / Pricing Page', 'ai-discovery-files' ); ?></label>
				<div class="aidf-url-with-picker">
					<input type="url" id="aidf-products-url" name="aidf_settings[products_url]" value="<?php echo esc_url( $settings['products_url'] ); ?>" class="aidf-input" placeholder="https://">
					<select class="aidf-page-picker" data-target="aidf-products-url">
						<option value=""><?php esc_html_e( 'Select a page…', 'ai-discovery-files' ); ?></option>
						<?php foreach ( $site_pages as $page ) : ?>
							<option value="<?php echo esc_url( get_permalink( $page ) ); ?>"><?php echo esc_html( $page->post_title ); ?></option>
						<?php endforeach; ?>
					</select>
				</div>
				<p class="aidf-description"><?php esc_html_e( 'Linked from llms.txt as a key commercial page.', 'ai-discovery-files' ); ?></p>
			</div>
		</div>

	</div>
</div>

<!-- Services & Offerings -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<div>
			<h2 class="aidf-panel-title">
				<span class="dashicons dashicons-clipboard"></span>
				<?php esc_html_e( 'Services & Offerings', 'ai-discovery-files' ); ?>
			</h2>
			<p class="aidf-panel-subtitle"><?php esc_html_e( 'List what you do and what you don\'t do. This is critical for preventing AI hallucination.', 'ai-discovery-files' ); ?></p>
		</div>
	</div>
	<div class="aidf-panel-body">

		<!-- Services Repeater -->
		<div class="aidf-field">
			<label class="aidf-label">
				<?php esc_html_e( 'Services / Products Offered', 'ai-discovery-files' ); ?>
			</label>

			<div class="aidf-service-list" id="aidf-services-list">
				<div class="aidf-service-empty" id="aidf-services-empty"<?php if ( ! empty( $services ) ) : ?> style="display:none;"<?php endif; ?>>
					<span class="dashicons dashicons-clipboard"></span>
					<p><?php esc_html_e( 'No services added yet. Add what your business offers so AI systems can accurately describe you.', 'ai-discovery-files' ); ?></p>
				</div>

				<?php foreach ( $services as $index => $service ) : ?>
					<div class="aidf-service-item" data-index="<?php echo esc_attr( $index ); ?>">
						<div class="aidf-service-item-header">
							<span class="aidf-service-item-number">S<?php echo esc_html( $index + 1 ); ?></span>
							<button type="button" class="aidf-service-remove" title="<?php esc_attr_e( 'Remove', 'ai-discovery-files' ); ?>">
								<span class="dashicons dashicons-no-alt"></span>
							</button>
						</div>
						<input type="text"
						       name="aidf_settings[services][<?php echo esc_attr( $index ); ?>][name]"
						       value="<?php echo esc_attr( $service['name'] ); ?>"
						       class="aidf-service-name"
						       placeholder="<?php esc_attr_e( 'Service or product name', 'ai-discovery-files' ); ?>">
						<input type="url"
						       name="aidf_settings[services][<?php echo esc_attr( $index ); ?>][url]"
						       value="<?php echo isset( $service['url'] ) ? esc_url( $service['url'] ) : ''; ?>"
						       class="aidf-service-url"
						       placeholder="<?php esc_attr_e( 'Page URL (optional)', 'ai-discovery-files' ); ?>">
					</div>
				<?php endforeach; ?>
			</div>

			<div class="aidf-service-add">
				<button type="button" id="aidf-add-service" class="aidf-btn aidf-btn--secondary aidf-btn--sm">
					<span class="dashicons dashicons-plus-alt2"></span>
					<?php esc_html_e( 'Add Service', 'ai-discovery-files' ); ?>
				</button>
			</div>
			<p class="aidf-description"><?php esc_html_e( 'Each service gets a name and an optional link to its page on your site. Appears in llms.txt and identity.json.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-not-services">
				<?php esc_html_e( 'Services NOT Offered', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'Explicitly listing services you don\'t offer prevents AI hallucination — where AI incorrectly attributes services to your business based on your industry.', 'ai-discovery-files' ) ); ?>
			</label>
			<textarea id="aidf-not-services"
			          name="aidf_settings[not_services]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( "App Development\nHosting", 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['not_services'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'One per line. Prevents AI systems from incorrectly attributing services to you.', 'ai-discovery-files' ); ?></p>
		</div>

	</div>
</div>

<!-- Service Areas & Hours -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-location-alt"></span>
			<?php esc_html_e( 'Coverage & Availability', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-service-areas">
				<?php esc_html_e( 'Service Areas / Geographic Coverage', 'ai-discovery-files' ); ?>
			</label>
			<textarea id="aidf-service-areas"
			          name="aidf_settings[service_areas]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( "United Kingdom\nEurope\nWorldwide", 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['service_areas'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'One area per line. Helps AI answer "do they serve my area?" questions.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-not-service-areas">
				<?php esc_html_e( 'Areas NOT Covered', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'Prevents AI systems from recommending you for geographic areas outside your coverage. Especially useful for local businesses.', 'ai-discovery-files' ) ); ?>
			</label>
			<textarea id="aidf-not-service-areas"
			          name="aidf_settings[not_service_areas]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( "Scotland\nNorthern Ireland", 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['not_service_areas'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'One area per line. Prevents AI from recommending you for areas you don\'t cover.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-hours-preset"><?php esc_html_e( 'Operating Hours', 'ai-discovery-files' ); ?></label>
			<?php $presets = AIDF_Plugin::get_operating_hours_presets(); ?>
			<select id="aidf-hours-preset" name="aidf_settings[operating_hours_preset]" class="aidf-select" style="max-width: 360px;">
				<?php foreach ( $presets as $value => $label ) : ?>
					<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $settings['operating_hours_preset'], $value ); ?>><?php echo esc_html( $label ); ?></option>
				<?php endforeach; ?>
			</select>
		</div>

		<!-- Custom hours (conditional) -->
		<div class="aidf-conditional-group" id="aidf-custom-hours-field"<?php if ( ! $show_custom_hours ) : ?> style="display:none;"<?php endif; ?>>
			<div class="aidf-field">
				<label class="aidf-label" for="aidf-operating-hours"><?php esc_html_e( 'Custom Hours', 'ai-discovery-files' ); ?></label>
				<input type="text"
				       id="aidf-operating-hours"
				       name="aidf_settings[operating_hours]"
				       value="<?php echo esc_attr( $settings['operating_hours'] ); ?>"
				       class="aidf-input"
				       placeholder="<?php esc_attr_e( 'e.g. Mon-Thu 9am-6pm, Fri 9am-4pm GMT', 'ai-discovery-files' ); ?>">
				<p class="aidf-description"><?php esc_html_e( 'Enter your operating hours in any readable format. Used in identity.json.', 'ai-discovery-files' ); ?></p>
			</div>
		</div>

	</div>
</div>

<!-- Online Presence -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-share"></span>
			<?php esc_html_e( 'Online Presence', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-social-links">
				<?php esc_html_e( 'Social Media & Profile URLs', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'Included in identity.json so AI systems can verify your identity across platforms and link to your official profiles.', 'ai-discovery-files' ) ); ?>
			</label>
			<textarea id="aidf-social-links"
			          name="aidf_settings[social_links]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( "https://linkedin.com/company/yourcompany\nhttps://x.com/yourcompany\nhttps://facebook.com/yourcompany", 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['social_links'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'One URL per line. Included in identity.json so AI systems can link to your profiles.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label"><?php esc_html_e( 'Logo', 'ai-discovery-files' ); ?></label>
			<div class="aidf-media-picker" id="aidf-logo-picker">
				<input type="hidden" id="aidf-logo-url" name="aidf_settings[logo_url]" value="<?php echo esc_url( $settings['logo_url'] ); ?>">
				<div class="aidf-media-preview" id="aidf-logo-preview"<?php echo empty( $settings['logo_url'] ) ? ' style="display:none;"' : ''; ?>>
					<img src="<?php echo esc_url( $settings['logo_url'] ); ?>" alt="<?php esc_attr_e( 'Logo preview', 'ai-discovery-files' ); ?>">
				</div>
				<div class="aidf-media-actions">
					<button type="button" class="aidf-btn aidf-btn--secondary aidf-btn--small" id="aidf-logo-select">
						<span class="dashicons dashicons-format-image"></span>
						<?php echo empty( $settings['logo_url'] ) ? esc_html__( 'Select Logo', 'ai-discovery-files' ) : esc_html__( 'Change Logo', 'ai-discovery-files' ); ?>
					</button>
					<button type="button" class="aidf-btn aidf-btn--ghost aidf-btn--small" id="aidf-logo-remove"<?php echo empty( $settings['logo_url'] ) ? ' style="display:none;"' : ''; ?>>
						<span class="dashicons dashicons-no-alt"></span>
						<?php esc_html_e( 'Remove', 'ai-discovery-files' ); ?>
					</button>
				</div>
			</div>
			<p class="aidf-description"><?php esc_html_e( 'Your logo image. Defaults to the site logo if set. Used in identity.json.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-privacy-url"><?php esc_html_e( 'Privacy Policy URL', 'ai-discovery-files' ); ?></label>
			<div class="aidf-url-with-picker">
				<input type="url" id="aidf-privacy-url" name="aidf_settings[privacy_policy_url]" value="<?php echo esc_url( $settings['privacy_policy_url'] ); ?>" class="aidf-input" placeholder="https://">
				<select class="aidf-page-picker" data-target="aidf-privacy-url">
					<option value=""><?php esc_html_e( 'Select a page…', 'ai-discovery-files' ); ?></option>
					<?php foreach ( $site_pages as $page ) : ?>
						<option value="<?php echo esc_url( get_permalink( $page ) ); ?>"><?php echo esc_html( $page->post_title ); ?></option>
					<?php endforeach; ?>
				</select>
			</div>
			<p class="aidf-description"><?php esc_html_e( 'Auto-detected from WordPress Settings if set.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-terms-url"><?php esc_html_e( 'Terms of Service URL', 'ai-discovery-files' ); ?></label>
			<div class="aidf-url-with-picker">
				<input type="url" id="aidf-terms-url" name="aidf_settings[terms_url]" value="<?php echo esc_url( $settings['terms_url'] ); ?>" class="aidf-input" placeholder="https://">
				<select class="aidf-page-picker" data-target="aidf-terms-url">
					<option value=""><?php esc_html_e( 'Select a page…', 'ai-discovery-files' ); ?></option>
					<?php foreach ( $site_pages as $page ) : ?>
						<option value="<?php echo esc_url( get_permalink( $page ) ); ?>"><?php echo esc_html( $page->post_title ); ?></option>
					<?php endforeach; ?>
				</select>
			</div>
		</div>

	</div>
</div>
