<?php
/**
 * Content settings tab — brand names, voice, key people, and FAQs.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$settings   = AIDF_Plugin::get_settings();
$faqs       = is_array( $settings['faqs'] ) ? $settings['faqs'] : array();
$key_people = is_array( $settings['key_people'] ) ? $settings['key_people'] : array();
?>

<!-- Brand Names -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-tag"></span>
			<?php esc_html_e( 'Brand Names', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-brand-alt">
				<?php esc_html_e( 'Also Known As', 'ai-discovery-files' ); ?>
			</label>
			<textarea id="aidf-brand-alt"
			          name="aidf_settings[brand_alternates]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( "Company Inc.\nTheCompany\nTCO", 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['brand_alternates'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'Acceptable alternative names, abbreviations, or common misspellings. One per line.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-brand-never">
				<?php esc_html_e( 'Never Call Us', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'AI systems sometimes confuse similarly-named businesses. List names that should never be attributed to your organisation to prevent misidentification.', 'ai-discovery-files' ) ); ?>
			</label>
			<textarea id="aidf-brand-never"
			          name="aidf_settings[brand_never]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( "Some Other Company\nA Competitor Name", 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['brand_never'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'Names that should never be used to refer to your organisation. Prevents AI confusion with similar entities.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-brand-pronunciation">
				<?php esc_html_e( 'Pronunciation Guide', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'For voice AI assistants like Siri, Alexa, and Google Assistant. Ensures they say your business name correctly when speaking to users.', 'ai-discovery-files' ) ); ?>
			</label>
			<input type="text"
			       id="aidf-brand-pronunciation"
			       name="aidf_settings[brand_pronunciation]"
			       value="<?php echo esc_attr( $settings['brand_pronunciation'] ); ?>"
			       class="aidf-input aidf-input--wide"
			       placeholder="<?php esc_attr_e( 'e.g. "365i" is said "three-six-five-eye"', 'ai-discovery-files' ); ?>">
			<p class="aidf-description"><?php esc_html_e( 'How to say your business name. Helps AI voice assistants pronounce it correctly.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-brand-misspellings">
				<?php esc_html_e( 'Common Misspellings', 'ai-discovery-files' ); ?>
			</label>
			<textarea id="aidf-brand-misspellings"
			          name="aidf_settings[brand_misspellings]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( "Compny Name\nCompanie Name", 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['brand_misspellings'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'Known misspellings of your business name. AI can auto-correct these in responses.', 'ai-discovery-files' ); ?></p>
		</div>

	</div>
</div>

<!-- Brand Voice & Messaging -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<div>
			<h2 class="aidf-panel-title">
				<span class="dashicons dashicons-megaphone"></span>
				<?php esc_html_e( 'Brand Voice & Messaging', 'ai-discovery-files' ); ?>
			</h2>
			<p class="aidf-panel-subtitle"><?php esc_html_e( 'Control how AI systems describe your business in their responses.', 'ai-discovery-files' ); ?></p>
		</div>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-brand-voice">
				<?php esc_html_e( 'Brand Voice', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'Describe your brand\'s tone and personality. AI systems will try to match this when generating text about your business.', 'ai-discovery-files' ) ); ?>
			</label>
			<textarea id="aidf-brand-voice"
			          name="aidf_settings[brand_voice]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( 'e.g. Professional but approachable. We use plain English, avoid jargon, and speak with quiet confidence rather than hype.', 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['brand_voice'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'Describe your brand\'s tone and personality. Published in brand.txt so AI systems match your voice.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-brand-taglines">
				<?php esc_html_e( 'Taglines / Straplines', 'ai-discovery-files' ); ?>
			</label>
			<textarea id="aidf-brand-taglines"
			          name="aidf_settings[brand_taglines]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( "Your digital partner for growth\nBuilding better websites since 2010", 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['brand_taglines'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'One per line. Official taglines AI may use when mentioning your brand.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-brand-boilerplate">
				<?php esc_html_e( 'Boilerplate / About Text', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'A short "about us" paragraph that AI systems can use verbatim when a brief description is needed. Think press release footer.', 'ai-discovery-files' ) ); ?>
			</label>
			<textarea id="aidf-brand-boilerplate"
			          name="aidf_settings[brand_boilerplate]"
			          class="aidf-textarea aidf-textarea--tall"
			          placeholder="<?php esc_attr_e( 'e.g. Acme Ltd is a UK-based web design agency specialising in WordPress development for SMEs. Founded in 2010, we help businesses grow their online presence with accessible, high-performance websites.', 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['brand_boilerplate'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'A short "about" paragraph AI can use verbatim. Think press release footer or LinkedIn summary.', 'ai-discovery-files' ); ?></p>
		</div>

	</div>
</div>

<!-- Key People -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<div>
			<h2 class="aidf-panel-title">
				<span class="dashicons dashicons-groups"></span>
				<?php esc_html_e( 'Key People', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'Listing key people helps AI systems answer "who runs this company?" questions accurately instead of guessing or hallucinating.', 'ai-discovery-files' ) ); ?>
			</h2>
			<p class="aidf-panel-subtitle"><?php esc_html_e( 'Leadership and key team members. Used in brand.txt and llms.txt.', 'ai-discovery-files' ); ?></p>
		</div>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-person-list" id="aidf-people-list">
			<div class="aidf-person-empty" id="aidf-people-empty"<?php if ( ! empty( $key_people ) ) : ?> style="display:none;"<?php endif; ?>>
				<span class="dashicons dashicons-groups"></span>
				<p><?php esc_html_e( 'No key people added yet. Add founders, directors, or other public-facing team members.', 'ai-discovery-files' ); ?></p>
			</div>

			<?php foreach ( $key_people as $index => $person ) : ?>
				<div class="aidf-person-item" data-index="<?php echo esc_attr( $index ); ?>">
					<div class="aidf-person-item-header">
						<span class="aidf-person-item-number">P<?php echo esc_html( $index + 1 ); ?></span>
						<button type="button" class="aidf-person-remove" title="<?php esc_attr_e( 'Remove', 'ai-discovery-files' ); ?>">
							<span class="dashicons dashicons-no-alt"></span>
						</button>
					</div>
					<input type="text"
					       name="aidf_settings[key_people][<?php echo esc_attr( $index ); ?>][name]"
					       value="<?php echo esc_attr( $person['name'] ); ?>"
					       class="aidf-person-name"
					       placeholder="<?php esc_attr_e( 'Full name', 'ai-discovery-files' ); ?>">
					<input type="text"
					       name="aidf_settings[key_people][<?php echo esc_attr( $index ); ?>][role]"
					       value="<?php echo esc_attr( isset( $person['role'] ) ? $person['role'] : '' ); ?>"
					       class="aidf-person-role"
					       placeholder="<?php esc_attr_e( 'Role (e.g. Managing Director)', 'ai-discovery-files' ); ?>">
					<input type="url"
					       name="aidf_settings[key_people][<?php echo esc_attr( $index ); ?>][url]"
					       value="<?php echo isset( $person['url'] ) ? esc_url( $person['url'] ) : ''; ?>"
					       class="aidf-person-url"
					       placeholder="<?php esc_attr_e( 'Profile URL (LinkedIn, team page, etc.)', 'ai-discovery-files' ); ?>">
				</div>
			<?php endforeach; ?>
		</div>

		<div class="aidf-person-add">
			<button type="button" id="aidf-add-person" class="aidf-btn aidf-btn--secondary aidf-btn--sm">
				<span class="dashicons dashicons-plus-alt2"></span>
				<?php esc_html_e( 'Add Person', 'ai-discovery-files' ); ?>
			</button>
		</div>

	</div>
</div>

<!-- FAQs -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<div>
			<h2 class="aidf-panel-title">
				<span class="dashicons dashicons-format-chat"></span>
				<?php esc_html_e( 'Frequently Asked Questions', 'ai-discovery-files' ); ?>
				<?php AIDF_Admin::tooltip( __( 'Pre-answered questions give AI systems authoritative answers about your business, reducing the chance of AI making up incorrect information (hallucination).', 'ai-discovery-files' ) ); ?>
			</h2>
			<p class="aidf-panel-subtitle"><?php esc_html_e( 'Pre-answered questions for AI systems. These appear in faq-ai.txt and help AI give accurate answers about your business.', 'ai-discovery-files' ); ?></p>
		</div>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-faq-list" id="aidf-faq-list">
			<div class="aidf-faq-empty" id="aidf-faq-empty"<?php if ( ! empty( $faqs ) ) : ?> style="display:none;"<?php endif; ?>>
				<span class="dashicons dashicons-format-chat"></span>
				<p><?php esc_html_e( 'No FAQs yet. Add questions that AI systems should be able to answer about your business.', 'ai-discovery-files' ); ?></p>
			</div>

			<?php foreach ( $faqs as $index => $faq ) : ?>
				<div class="aidf-faq-item" data-index="<?php echo esc_attr( $index ); ?>">
					<div class="aidf-faq-item-header">
						<span class="aidf-faq-item-number">Q<?php echo esc_html( $index + 1 ); ?></span>
						<button type="button" class="aidf-faq-remove" title="<?php esc_attr_e( 'Remove', 'ai-discovery-files' ); ?>">
							<span class="dashicons dashicons-no-alt"></span>
						</button>
					</div>
					<input type="text"
					       name="aidf_settings[faqs][<?php echo esc_attr( $index ); ?>][q]"
					       value="<?php echo esc_attr( isset( $faq['q'] ) ? $faq['q'] : '' ); ?>"
					       class="aidf-faq-question"
					       placeholder="<?php esc_attr_e( 'Question…', 'ai-discovery-files' ); ?>">
					<textarea name="aidf_settings[faqs][<?php echo esc_attr( $index ); ?>][a]"
					          class="aidf-faq-answer"
					          placeholder="<?php esc_attr_e( 'Answer…', 'ai-discovery-files' ); ?>"><?php echo esc_textarea( isset( $faq['a'] ) ? $faq['a'] : '' ); ?></textarea>
				</div>
			<?php endforeach; ?>
		</div>

		<div class="aidf-faq-add">
			<button type="button" id="aidf-add-faq" class="aidf-btn aidf-btn--secondary aidf-btn--sm">
				<span class="dashicons dashicons-plus-alt2"></span>
				<?php esc_html_e( 'Add FAQ', 'ai-discovery-files' ); ?>
			</button>
		</div>

	</div>
</div>
