<?php
/**
 * Technical / Advanced settings tab.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$settings = AIDF_Plugin::get_settings();
?>

<!-- Developer Information -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-editor-code"></span>
			<?php esc_html_e( 'Developer Information', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-tech-stack">
				<?php esc_html_e( 'Technology Stack', 'ai-discovery-files' ); ?>
			</label>
			<textarea id="aidf-tech-stack"
			          name="aidf_settings[tech_stack]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( 'e.g. WordPress, WooCommerce, React frontend, REST API', 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['tech_stack'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'Additional technologies and frameworks beyond WordPress. Auto-detected platform info is always included.', 'ai-discovery-files' ); ?></p>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-dev-notes">
				<?php esc_html_e( 'Developer Notes', 'ai-discovery-files' ); ?>
			</label>
			<textarea id="aidf-dev-notes"
			          name="aidf_settings[developer_notes]"
			          class="aidf-textarea aidf-textarea--tall"
			          placeholder="<?php esc_attr_e( 'Any technical context relevant for developers or AI systems integrating with your site.', 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['developer_notes'] ); ?></textarea>
		</div>

		<div class="aidf-field">
			<label class="aidf-label" for="aidf-api-info">
				<?php esc_html_e( 'API Information', 'ai-discovery-files' ); ?>
			</label>
			<textarea id="aidf-api-info"
			          name="aidf_settings[api_info]"
			          class="aidf-textarea"
			          placeholder="<?php esc_attr_e( 'e.g. REST API available at /wp-json/wp/v2/, authentication via OAuth 2.0', 'ai-discovery-files' ); ?>"><?php echo esc_textarea( $settings['api_info'] ); ?></textarea>
			<p class="aidf-description"><?php esc_html_e( 'If your site exposes an API, describe it here. Published in developer-ai.txt.', 'ai-discovery-files' ); ?></p>
		</div>

	</div>
</div>

<!-- File Generation Settings -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-admin-settings"></span>
			<?php esc_html_e( 'Generation Settings', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">

		<div class="aidf-toggle-row">
			<label class="aidf-switch">
				<input type="hidden" name="aidf_settings[spec_attribution]" value="0">
				<input type="checkbox"
				       name="aidf_settings[spec_attribution]"
				       value="1"
				       <?php checked( $settings['spec_attribution'] ); ?>
				       class="aidf-attribution-toggle">
				<span class="aidf-slider"></span>
			</label>
			<div>
				<span class="aidf-toggle-label">
					<?php esc_html_e( 'Include specification attribution', 'ai-discovery-files' ); ?>
					<?php AIDF_Admin::tooltip( __( 'Adds a small comment to each file linking to the specification. This helps AI systems understand the file format and qualifies your site for a full directory listing with backlinks.', 'ai-discovery-files' ) ); ?>
					<span class="aidf-badge aidf-badge--recommended"><?php esc_html_e( 'Recommended', 'ai-discovery-files' ); ?></span>
				</span>
				<p class="aidf-toggle-description"><?php esc_html_e( 'Adds a comment linking to the AI Discovery Files specification. These files are machine-readable only and not indexed by search engines, so this has no effect on SEO. Enabling it helps AI systems understand the file format and qualifies your site for a full listing with backlinks in the AI Visibility Directory.', 'ai-discovery-files' ); ?></p>
			</div>
		</div>

	</div>
</div>

<!-- Auto-Detected Information -->
<div class="aidf-panel">
	<div class="aidf-panel-header">
		<h2 class="aidf-panel-title">
			<span class="dashicons dashicons-info-outline"></span>
			<?php esc_html_e( 'Auto-Detected Information', 'ai-discovery-files' ); ?>
		</h2>
	</div>
	<div class="aidf-panel-body">

		<p class="aidf-description" style="margin-bottom: var(--aidf-sp-4);">
			<?php esc_html_e( 'The following information is automatically detected from your WordPress installation and included in developer-ai.txt.', 'ai-discovery-files' ); ?>
		</p>

		<table style="width: 100%; max-width: 520px; border-collapse: collapse;">
			<?php
			$auto_data = array(
				__( 'WordPress', 'ai-discovery-files' )  => get_bloginfo( 'version' ),
				__( 'PHP', 'ai-discovery-files' )         => phpversion(),
				__( 'Theme', 'ai-discovery-files' )       => wp_get_theme()->get( 'Name' ),
				__( 'Language', 'ai-discovery-files' )     => get_bloginfo( 'language' ),
				__( 'Character Set', 'ai-discovery-files' ) => get_bloginfo( 'charset' ),
				__( 'Timezone', 'ai-discovery-files' )     => wp_timezone_string(),
			);

			foreach ( $auto_data as $label => $value ) :
				?>
				<tr>
					<td style="padding: 6px 12px 6px 0; font-size: 13px; color: var(--aidf-text-secondary); border-bottom: 1px solid var(--aidf-border-light);">
						<?php echo esc_html( $label ); ?>
					</td>
					<td style="padding: 6px 0; font-family: var(--aidf-font-mono); font-size: 13px; border-bottom: 1px solid var(--aidf-border-light);">
						<?php echo esc_html( $value ); ?>
					</td>
				</tr>
			<?php endforeach; ?>
		</table>

	</div>
</div>
