<?php
/**
 * Main settings page template.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$settings    = AIDF_Plugin::get_settings();
$current_tab = AIDF_Admin::get_current_tab();
$tabs        = AIDF_Admin::get_tabs();
$page_url    = admin_url( 'admin.php?page=ai-discovery-files' );
?>
<div class="aidf-wrap">

	<!-- Header -->
	<div class="aidf-header">
		<div class="aidf-header-left">
			<div class="aidf-header-icon">
				<span class="dashicons dashicons-visibility"></span>
			</div>
			<h1 class="aidf-header-title">
				<?php esc_html_e( 'AI Discovery Files', 'ai-discovery-files' ); ?>
				<span class="aidf-header-version">v<?php echo esc_html( AIDF_VERSION ); ?></span>
			</h1>
		</div>
		<div class="aidf-header-right">
			<a href="https://www.ai-visibility.org.uk/specifications/" target="_blank" rel="noopener" class="aidf-header-link">
				<?php esc_html_e( 'Specification', 'ai-discovery-files' ); ?> &#8599;
			</a>
			<a href="https://www.ai-visibility.org.uk/specifications/quick-start/" target="_blank" rel="noopener" class="aidf-header-link">
				<?php esc_html_e( 'Quick Start', 'ai-discovery-files' ); ?> &#8599;
			</a>
		</div>
	</div>

	<!-- Tab Navigation -->
	<nav class="aidf-tabs" role="tablist">
		<?php
		$tab_icons = array(
			'identity'    => 'dashicons-id-alt',
			'permissions' => 'dashicons-shield',
			'content'     => 'dashicons-edit-page',
			'advanced'    => 'dashicons-admin-tools',
			'preview'     => 'dashicons-media-code',
			'status'      => 'dashicons-yes-alt',
		);

		foreach ( $tabs as $slug => $label ) :
			$is_active = ( $slug === $current_tab );
			$icon      = isset( $tab_icons[ $slug ] ) ? $tab_icons[ $slug ] : 'dashicons-admin-generic';
			?>
			<a href="<?php echo esc_url( add_query_arg( 'tab', $slug, $page_url ) ); ?>"
			   class="aidf-tab <?php echo esc_attr( $is_active ? 'aidf-tab--active' : '' ); ?>"
			   role="tab"
			   aria-selected="<?php echo esc_attr( $is_active ? 'true' : 'false' ); ?>">
				<span class="dashicons <?php echo esc_attr( $icon ); ?>"></span>
				<?php echo esc_html( $label ); ?>
			</a>
		<?php endforeach; ?>
	</nav>

	<!-- Content -->
	<div class="aidf-content">
		<?php settings_errors( 'aidf_settings' ); ?>

		<?php include AIDF_PLUGIN_DIR . 'admin/views/partials/directory-cta.php'; ?>

		<?php if ( in_array( $current_tab, array( 'preview', 'status' ), true ) ) : ?>
			<?php include AIDF_PLUGIN_DIR . 'admin/views/tab-' . $current_tab . '.php'; ?>
		<?php else : ?>
			<form method="post" action="options.php" id="aidf-settings-form">
				<?php settings_fields( 'aidf_settings_group' ); ?>
				<?php include AIDF_PLUGIN_DIR . 'admin/views/tab-' . $current_tab . '.php'; ?>

				<!-- Persist active_files and spec_attribution across all tabs -->
				<?php if ( 'status' !== $current_tab ) : ?>
					<?php
					$active_files = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();
					$file_types   = AIDF_Plugin::get_file_types();

					foreach ( $file_types as $slug => $meta ) :
						if ( in_array( $slug, $active_files, true ) ) :
							?>
							<input type="hidden" name="aidf_settings[active_files][]" value="<?php echo esc_attr( $slug ); ?>" class="aidf-hidden-active-file" data-slug="<?php echo esc_attr( $slug ); ?>">
						<?php
						endif;
					endforeach;
					?>
					<input type="hidden" name="aidf_settings[spec_attribution]" value="<?php echo esc_attr( $settings['spec_attribution'] ? '1' : '0' ); ?>" class="aidf-hidden-attribution">
					<input type="hidden" name="aidf_settings[verify_code]" value="<?php echo esc_attr( isset( $settings['verify_code'] ) ? $settings['verify_code'] : '' ); ?>">
				<?php endif; ?>

				<!-- Save Button -->
				<div class="aidf-panel" style="margin-top: var(--aidf-sp-6);">
					<div class="aidf-actions">
						<div class="aidf-actions-left">
							<?php submit_button( __( 'Save Settings', 'ai-discovery-files' ), 'aidf-btn aidf-btn--primary', 'submit', false ); ?>
						</div>
						<div class="aidf-actions-right">
							<a href="<?php echo esc_url( add_query_arg( 'tab', 'preview', $page_url ) ); ?>" class="aidf-btn aidf-btn--secondary">
								<span class="dashicons dashicons-media-code"></span>
								<?php esc_html_e( 'Preview Files', 'ai-discovery-files' ); ?>
							</a>
						</div>
					</div>
				</div>
			</form>
		<?php endif; ?>
	</div>

	<?php include AIDF_PLUGIN_DIR . 'admin/views/partials/verify-modal.php'; ?>
</div>
