<?php
/**
 * Domain verification modal for the AI Visibility Directory.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$settings    = AIDF_Plugin::get_settings();
$verify_code = isset( $settings['verify_code'] ) ? $settings['verify_code'] : '';
$is_active   = ! empty( $verify_code );
$verify_url  = home_url( '/ai-visibility-verify.txt' );
?>

<div class="aidf-verify-modal" id="aidf-verify-modal" role="dialog" aria-modal="true" aria-labelledby="aidf-verify-modal-title" style="display: none;">
	<div class="aidf-verify-modal__backdrop" data-aidf-close-modal></div>
	<div class="aidf-verify-modal__card">

		<!-- Header -->
		<div class="aidf-verify-modal__header">
			<div class="aidf-verify-modal__header-content">
				<div class="aidf-verify-modal__header-icon">
					<span class="dashicons dashicons-shield-alt"></span>
				</div>
				<div>
					<h2 class="aidf-verify-modal__title" id="aidf-verify-modal-title">
						<?php esc_html_e( 'Verify Domain Ownership', 'ai-discovery-files' ); ?>
					</h2>
					<p class="aidf-verify-modal__subtitle">
						<?php esc_html_e( 'AI Visibility Directory', 'ai-discovery-files' ); ?>
					</p>
				</div>
			</div>
			<button type="button" class="aidf-verify-modal__close" data-aidf-close-modal aria-label="<?php esc_attr_e( 'Close', 'ai-discovery-files' ); ?>">
				<span class="dashicons dashicons-no-alt"></span>
			</button>
		</div>

		<!-- Body -->
		<div class="aidf-verify-modal__body">

			<!-- Intro -->
			<div class="aidf-verify-modal__intro">
				<p>
					<?php esc_html_e( 'The AI Visibility Directory showcases websites with active AI Discovery Files. After submitting your site, you\'ll receive a verification code to prove you own this domain.', 'ai-discovery-files' ); ?>
				</p>
				<p>
					<?php esc_html_e( 'Paste your code below and this plugin will automatically serve the verification file — no FTP or file editing needed.', 'ai-discovery-files' ); ?>
				</p>
			</div>

			<!-- Steps -->
			<div class="aidf-verify-modal__steps">
				<div class="aidf-verify-modal__step">
					<span class="aidf-verify-modal__step-number">1</span>
					<span class="aidf-verify-modal__step-text">
						<?php
						printf(
							wp_kses(
								/* translators: %s: URL to directory submission page */
								__( '<a href="%s" target="_blank" rel="noopener noreferrer">Submit your site</a> to the AI Visibility Directory', 'ai-discovery-files' ),
								array( 'a' => array( 'href' => array(), 'target' => array(), 'rel' => array() ) )
							),
							'https://www.ai-visibility.org.uk/submit/'
						);
						?>
					</span>
				</div>
				<div class="aidf-verify-modal__step">
					<span class="aidf-verify-modal__step-number">2</span>
					<span class="aidf-verify-modal__step-text"><?php esc_html_e( 'Copy the verification code you receive', 'ai-discovery-files' ); ?></span>
				</div>
				<div class="aidf-verify-modal__step">
					<span class="aidf-verify-modal__step-number">3</span>
					<span class="aidf-verify-modal__step-text"><?php esc_html_e( 'Paste it below and save', 'ai-discovery-files' ); ?></span>
				</div>
				<div class="aidf-verify-modal__step">
					<span class="aidf-verify-modal__step-number">4</span>
					<span class="aidf-verify-modal__step-text">
						<?php
						printf(
							wp_kses(
								/* translators: %s: URL to directory dashboard */
								__( 'Visit your <a href="%s" target="_blank" rel="noopener noreferrer">directory dashboard</a> and click Verify', 'ai-discovery-files' ),
								array( 'a' => array( 'href' => array(), 'target' => array(), 'rel' => array() ) )
							),
							'https://www.ai-visibility.org.uk/dashboard/'
						);
						?>
					</span>
				</div>
			</div>

			<!-- Code Input -->
			<div class="aidf-verify-modal__field">
				<label for="aidf-verify-code" class="aidf-verify-modal__label">
					<?php esc_html_e( 'Verification Code', 'ai-discovery-files' ); ?>
				</label>
				<div class="aidf-verify-modal__input-wrap">
					<input type="text"
					       id="aidf-verify-code"
					       class="aidf-verify-modal__input"
					       value="<?php echo esc_attr( $verify_code ); ?>"
					       placeholder="<?php esc_attr_e( 'e.g. ai-visibility-verify=f1ade5505a308e39258ae94535be28a4', 'ai-discovery-files' ); ?>"
					       spellcheck="false"
					       autocomplete="off">
				</div>
			</div>

			<!-- Status -->
			<div class="aidf-verify-modal__status <?php echo $is_active ? 'aidf-verify-modal__status--active' : ''; ?>" id="aidf-verify-status">
				<?php if ( $is_active ) : ?>
					<span class="dashicons dashicons-yes-alt"></span>
					<span>
						<?php esc_html_e( 'Verification file is live at', 'ai-discovery-files' ); ?>
						<a href="<?php echo esc_url( $verify_url ); ?>" target="_blank" rel="noopener"><?php echo esc_url( $verify_url ); ?></a>
					</span>
				<?php else : ?>
					<span class="dashicons dashicons-info-outline"></span>
					<span><?php esc_html_e( 'No verification code set. Enter your code above to activate.', 'ai-discovery-files' ); ?></span>
				<?php endif; ?>
			</div>

		</div>

		<!-- Footer -->
		<div class="aidf-verify-modal__footer">
			<div class="aidf-verify-modal__footer-left">
				<a href="https://www.ai-visibility.org.uk/dashboard/" target="_blank" rel="noopener noreferrer" class="aidf-verify-modal__dashboard-link">
					<span class="dashicons dashicons-external"></span>
					<?php esc_html_e( 'Open Directory Dashboard', 'ai-discovery-files' ); ?>
				</a>
			</div>
			<div class="aidf-verify-modal__footer-right">
				<button type="button" class="aidf-btn aidf-btn--secondary" data-aidf-close-modal>
					<?php esc_html_e( 'Close', 'ai-discovery-files' ); ?>
				</button>
				<button type="button" class="aidf-btn aidf-btn--primary" id="aidf-verify-save">
					<span class="dashicons dashicons-yes"></span>
					<?php esc_html_e( 'Save Code', 'ai-discovery-files' ); ?>
				</button>
			</div>
		</div>

	</div>
</div>
