<?php
/**
 * Tier progress bar partial.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$settings     = AIDF_Plugin::get_settings();
$active_files = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();
$file_types   = AIDF_Plugin::get_file_types();

// Count files per tier.
$tier_counts = array(
	'essential'   => array( 'total' => 0, 'active' => 0 ),
	'recommended' => array( 'total' => 0, 'active' => 0 ),
	'complete'    => array( 'total' => 0, 'active' => 0 ),
);

foreach ( $file_types as $slug => $meta ) {
	$tier = $meta['tier'];
	++$tier_counts[ $tier ]['total'];

	if ( in_array( $slug, $active_files, true ) ) {
		++$tier_counts[ $tier ]['active'];
	}
}

// Determine current tier.
$essential_done   = $tier_counts['essential']['active'] === $tier_counts['essential']['total'];
$recommended_done = $tier_counts['recommended']['active'] === $tier_counts['recommended']['total'];
$complete_done    = $tier_counts['complete']['active'] === $tier_counts['complete']['total'];

$total_files  = count( $file_types );
$active_count = count( $active_files );
$percentage   = $total_files > 0 ? round( ( $active_count / $total_files ) * 100 ) : 0;

// Determine progress bar class.
$bar_class = 'essential';
if ( $essential_done && $recommended_done ) {
	$bar_class = 'complete';
} elseif ( $essential_done ) {
	$bar_class = 'recommended';
}
?>

<div class="aidf-tier-progress">
	<div class="aidf-tier-progress-label">
		<?php
		printf(
			/* translators: %1$d: active file count, %2$d: total file count */
			esc_html__( '%1$d of %2$d files active', 'ai-discovery-files' ),
			intval( $active_count ),
			intval( $total_files )
		);
		?>
	</div>

	<div class="aidf-tier-bar">
		<div class="aidf-tier-bar-fill aidf-tier-bar-fill--<?php echo esc_attr( $bar_class ); ?>"
		     style="width: <?php echo esc_attr( $percentage ); ?>%;"></div>
	</div>

	<div class="aidf-tier-steps">
		<?php
		$steps = array(
			'essential'   => array(
				'label' => __( 'Essential', 'ai-discovery-files' ),
				'done'  => $essential_done,
				'count' => $tier_counts['essential']['active'] . '/' . $tier_counts['essential']['total'],
			),
			'recommended' => array(
				'label' => __( 'Recommended', 'ai-discovery-files' ),
				'done'  => $essential_done && $recommended_done,
				'count' => $tier_counts['recommended']['active'] . '/' . $tier_counts['recommended']['total'],
			),
			'complete'    => array(
				'label' => __( 'Complete', 'ai-discovery-files' ),
				'done'  => $essential_done && $recommended_done && $complete_done,
				'count' => $tier_counts['complete']['active'] . '/' . $tier_counts['complete']['total'],
			),
		);

		$prev_done = true;

		foreach ( $steps as $step_slug => $step ) :
			$class = '';

			if ( $step['done'] ) {
				$class = 'aidf-tier-step--done';
			} elseif ( $prev_done ) {
				$class = 'aidf-tier-step--current';
			}

			$prev_done = $step['done'];
			?>
			<div class="aidf-tier-step <?php echo esc_attr( $class ); ?>">
				<span class="aidf-tier-dot">
					<?php if ( $step['done'] ) : ?>
						<span class="dashicons dashicons-yes"></span>
					<?php endif; ?>
				</span>
				<span class="aidf-tier-step-label"><?php echo esc_html( $step['label'] ); ?></span>
				<span class="aidf-tier-step-count"><?php echo esc_html( $step['count'] ); ?></span>
			</div>
		<?php endforeach; ?>
	</div>
</div>
