<?php
/**
 * CTA banner — AI Visibility Directory promotion.
 *
 * Displays when user has 2+ active AI Discovery Files.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

// Count active files.
$settings     = AIDF_Plugin::get_settings();
$active_files = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();
$active_count = count( $active_files );

if ( $active_count < 2 ) {
	return;
}
?>

<div class="aidf-directory-cta">
	<div class="aidf-directory-cta__content">
		<div class="aidf-directory-cta__icon">
			<span class="dashicons dashicons-awards"></span>
		</div>

		<div class="aidf-directory-cta__text">
			<h3 class="aidf-directory-cta__headline">
				<?php esc_html_e( 'Get Listed in the AI Visibility Directory', 'ai-discovery-files' ); ?>
			</h3>
			<p class="aidf-directory-cta__description">
				<?php
				printf(
					/* translators: %d: number of active AI Discovery Files */
					esc_html__( 'You have %d active AI Discovery Files — your site qualifies for the official directory. Get discovered by AI systems and featured alongside other AI-visible websites.', 'ai-discovery-files' ),
					absint( $active_count )
				);
				?>
			</p>
		</div>

		<div class="aidf-directory-cta__actions">
			<a href="https://www.ai-visibility.org.uk/submit/"
			   class="aidf-directory-cta__button"
			   target="_blank"
			   rel="noopener noreferrer">
				<?php esc_html_e( 'Submit Your Site', 'ai-discovery-files' ); ?>
				<span class="dashicons dashicons-external"></span>
			</a>
			<button type="button" class="aidf-directory-cta__button aidf-directory-cta__button--verify" id="aidf-open-verify-cta">
				<span class="dashicons dashicons-shield-alt"></span>
				<?php esc_html_e( 'Verify Domain', 'ai-discovery-files' ); ?>
			</button>
		</div>
	</div>
</div>
