<?php  if ( ! defined( 'ABSPATH' ) ) exit;?>
<div class="container mx-auto mt-10">
    <div class="bg-white mb-8 px-4 py-3 max-w-2xl mx-auto rounded-lg">
        <ol class="items-center w-full space-y-4 sm:flex sm:space-x-8 sm:space-y-0 rtl:space-x-reverse">
            <li class="flex items-center text-green-600 space-x-2.5 rtl:space-x-reverse">
                <span class="flex items-center justify-center w-8 h-8 border bg-green-500 text-white border-green-600 rounded-full shrink-0">1</span>
                <span>
                    <h3 class="font-medium leading-tight text-green-600 ">Create account</h3>
                    <p class="text-sm">Create&nbsp;Ordemio&nbsp;account</p>
                </span>
            </li>
            <li class="flex items-center text-green-600 space-x-2.5 rtl:space-x-reverse">
                <span class="flex items-center justify-center w-8 h-8 border bg-green-500 text-white border-green-600 rounded-full shrink-0">2</span>
                <span>
                    <h3 class="font-medium leading-tight text-green-600 ">Create Assistant</h3>
                    <p class="text-sm">Set up assistant fields</p>
                </span>
            </li>
            <li class="flex items-center text-blue-600 dark:text-blue-500 space-x-2.5 rtl:space-x-reverse">
                <span class="flex items-center justify-center w-8 h-8 border border-blue-600 rounded-full shrink-0 dark:border-blue-500">
                    3
                </span>
                <span>
                    <h3 class="font-medium leading-tight text-blue-600">Training</h3>
                    <p class="text-sm">Training&nbsp;assistant</p>
                </span>
            </li>
        </ol>
    </div>
    <div class="bg-white p-8 max-w-xl mx-auto rounded-lg">
        <div class="mx-auto mb-5">
            <h4 class="text-xl font-bold">Training data</h4>
            <p class="mt-2 text-xsm text-gray-500 ">
                Your assistant is now being trained on test data. This may take a few seconds. The limits below apply only to the free plan.
            </p>
        </div>
        <div class="mx-auto mb-5">
            <div class="flex flex-row justify-between">
                <div class="flex flex-row gap-2" id="mainStatus">
                    <div role="status">
                        <svg aria-hidden="true" class="inline w-4 h-4 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                        <span class="sr-only">Loading...</span>
                    </div>
                    <div class="font-medium">
                        Fetching ...
                    </div>
                </div>
                <div class="flex flex-row gap-4">
                    <div class="text-gray-600 font-medium">
                        <span id="chCnt">0</span> of 300K characters
                    </div>
                    <div class="text-gray-500">
                        <span id="lnkCnt">0</span> of 15 links
                    </div>
                </div>
            </div>


            <div class="relative overflow-x-auto mt-5">
                <div class="rounded-lg border border-gray-100">
                    <table class="w-full text-sm text-left rtl:text-right text-gray-500" id="linksTable">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-100">
                        <tr>
                            <th scope="col" class="px-6 py-3">
                                URL
                            </th>
                            <th scope="col" class="px-6 py-3">
                                <div class="flex items-center">
                                    Size (Characters)
                                </div>
                            </th>
                            <th scope="col" class="px-6 py-3">
                                <div class="flex items-center">
                                    Status
                                </div>
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div id="finButton"></div>
        <div>
            
        </div>
    </div>
</div>