<?php
/**
 * Uninstall script for: AI Alt Text Builder
 *
 * What this does:
 * - Removes the plugin’s persistent options from wp_options.
 * - Cleans up ONLY metadata the plugin created itself (the alt-score stored as _aatb_score).
 * - Intentionally DOES NOT modify your image ALT texts (_wp_attachment_image_alt) or other third-party data.
 *
 * Safety:
 * - Runs only when triggered by WordPress’ uninstall flow and the guard below is satisfied.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/* --------------------------------------------------------------------------
 * 1) Remove plugin options
 * ----------------------------------------------------------------------- */
delete_option( 'aatb_settings' );

/* --------------------------------------------------------------------------
 * 2) Optional, safe cleanups
 *    - Delete our own post meta used for scoring from all attachments.
 *    - If per-user membership tokens were stored for this plugin, remove them.
 *    - These queries are idempotent and safe to execute even if nothing matches.
 * ----------------------------------------------------------------------- */
global $wpdb;

/* Remove the score meta this plugin sets (_aatb_score). */
$wpdb->query(
	$wpdb->prepare(
		"DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s",
		'_aatb_score'
	)
);

/* If membership tokens were stored per user for this plugin, clean them up too. */
$wpdb->query(
	$wpdb->prepare(
		"DELETE FROM {$wpdb->usermeta} WHERE meta_key = %s",
		'ai-alt-text-builder_membership_tokens'
	)
);

/* Note: We deliberately do not touch core/third-party fields like _wp_attachment_image_alt. */
