<?php
/*  AI Alt Text Builder — Settings Page (Admin)
 *  Version: 1.0.7
 *  -----------------------------------------------------------
 *  • Two tabs: (1) Site Key Management, (2) Alt-Text Settings
 *  • Vision models: gpt-4o-mini / gpt-4o / gpt-4.1
 *  • Usage overview (Limit / Remaining / Progress bar)
 *  • Saves Custom Prompt (appended/forwarded by backend)
 *  -----------------------------------------------------------
 */
if ( ! defined( 'ABSPATH' ) ) exit;

function aatb_register_settings() {}

function aatb_render_settings_page() {
        $st = [];

	$opt   = get_option( 'aatb_settings', [] ); // uses AATB_SETTINGS_SLUG
	$token = $opt['site_token']   ?? '';
	$model = $opt['model_choice'] ?? 'gpt-4o-mini';
	$lang  = $opt['lang_choice']  ?? 'en';

	$tab = ( isset($_GET['tab']) && $_GET['tab']==='alt-settings' )
	     ? 'alt-settings' : 'site-key';

	/* ───────────── FORM SUBMISSIONS (nonce-protected) ───────────── */
	if ( isset($_POST['aatb_action']) ) {
    $action = sanitize_key( wp_unslash( $_POST['aatb_action'] ) );
    if ( ! check_admin_referer( $action ) ) {
        wp_die( 'Bad nonce' );
    }
    if ( ! current_user_can( 'manage_options' ) ) {
        wp_die( 'Unauthorized' );
    }

		/* 1) Save Site Key */
		if ( $_POST['aatb_action'] === 'aatb_save_site_key' ) {
			$new = sanitize_text_field( wp_unslash( $_POST['site_token'] ?? '' ) );
			$chk = $new ? aatb_check_token_status( $new ) : [ 'error' => 'empty' ];

			if ( ! empty( $chk['error'] ) ) {
				echo '<div class="notice notice-error"><p><strong>Site Key Error:</strong> '
				     . esc_html( (string)$chk['error'] ) . '</p></div>';
				unset( $opt['site_token'] );
			} else {
				$opt['site_token'] = $new;
				echo '<div class="notice notice-success is-dismissible"><p>Site Key saved.</p></div>';
			}
			update_option( 'aatb_settings', $opt );
			$token = $opt['site_token'] ?? '';
			$tab   = 'site-key';
		}

		/* 2) Alt-Text settings (model + language + custom prompt) */
		if ( $_POST['aatb_action'] === 'aatb_save_alt_settings' ) {

			$allowed = ['gpt-4o-mini','gpt-4o','gpt-4.1'];
			$chosen  = sanitize_text_field( $_POST['model_choice'] ?? 'gpt-4o-mini' );
			$opt['model_choice'] = in_array( $chosen, $allowed, true ) ? $chosen : 'gpt-4o-mini';

			$sel = sanitize_text_field( $_POST['lang_choice'] ?? 'en' );
			$opt['lang_choice'] = ( $sel === 'other' )
				? sanitize_text_field( $_POST['lang_custom'] ?? 'en' )
				: $sel;

			// Keep custom prompt size reasonable to avoid provider errors on extreme inputs
			$cp = sanitize_textarea_field( $_POST['custom_prompt'] ?? '' );
			if ( mb_strlen( $cp ) > 1500 ) { $cp = mb_substr( $cp, 0, 1500 ); }
			$opt['custom_prompt'] = $cp;

			update_option( 'aatb_settings', $opt );

			$model = $opt['model_choice'];
			$lang  = $opt['lang_choice'];
			$tab   = 'alt-settings';

			echo '<div class="notice notice-success is-dismissible"><p>Settings saved.</p></div>';
		}
	}

	/* ───────────── TOKEN / USAGE NORMALIZATION ───────────── */
	$usage=$limit=$remain=$site_usage=null;
	$membership='free';
	$allowed_models_ui = ['gpt-4o-mini','gpt-4o','gpt-4.1']; // default UI allow list

	if ( $token ) {
		$st = aatb_check_token_status( $token );
		if ( empty( $st['error'] ) ) {

			$site_usage = (int)($st['site_usage'] ?? 0);
			$limit = (int)(
				$st['plan_limit_total']
				?? $st['plan_limit']
				?? $st['token_limit']
				?? 0
			);

			$usage_total = null;
			foreach ( ['usage_total','all_usage','total_usage','token_usage','usage'] as $k ) {
				if ( isset($st[$k]) ) { $usage_total = (int)$st[$k]; break; }
			}
			if ( $usage_total === null ) { $usage_total = max(0, (int)$site_usage); }

			$remain     = aatb_status_remaining( $st );
			$usage      = (int)$usage_total;
			$membership = strtolower( trim( $st['membership'] ?? 'free' ) );

			// If backend explicitly returns allowed models, respect it visually
			if ( ! empty( $st['allowed_models'] ) && is_array( $st['allowed_models'] ) ) {
				$allowed_models_ui = array_values( array_intersect( $allowed_models_ui, $st['allowed_models'] ) );
				if ( empty($allowed_models_ui) ) { $allowed_models_ui = ['gpt-4o-mini']; }
			}
		}
	}

	// Canonical models
	$canonical = ['gpt-4o-mini','gpt-4o','gpt-4.1'];

	// Membership-based gating
	$gate = [
  'free'    => ['gpt-4o-mini'],
  'starter' => ['gpt-4o-mini','gpt-4.1'],
  'creator' => ['gpt-4o-mini','gpt-4.1','gpt-4o'],
  'expert'  => ['gpt-4o-mini','gpt-4.1','gpt-4o'],
];

	// Prefer membership rules; otherwise fall back to backend's allowed models
	if ( isset($gate[$membership]) ) {
	  $allowed_models_ui = array_values( array_intersect($canonical, $gate[$membership]) );
	} elseif ( !empty($st['allowed_models']) && is_array($st['allowed_models']) ) {
	  $allowed_models_ui = array_values( array_intersect($canonical, $st['allowed_models']) );
	} else {
	  $allowed_models_ui = ['gpt-4o-mini'];
	}

	// Ensure selected model remains valid
	if ( ! in_array($model, $allowed_models_ui, true) ) {
	  $model = 'gpt-4o-mini';
	  $opt['model_choice'] = $model;
	  update_option('aatb_settings', $opt);
	}

	/* Keep selection valid (defensive) */
	if ( ! in_array( $model, $allowed_models_ui, true ) ) {
		$model               = 'gpt-4o-mini';
		$opt['model_choice'] = $model;
		update_option( 'aatb_settings', $opt );
	}

	$btn_label = ( $membership === 'free' ) ? 'GET PREMIUM NOW' : 'BUY TOKENS';
	$btn_url   = ( $membership === 'free' )
		? 'https://rankpilotai.com/ai-alt-text-builder-pricing/'
		: 'https://rankpilotai.com/tokens-1/?plugin=ai-alt-text-builder';

	$dis = empty( $token ) ? 'disabled' : '';
	?>

	<div class="aatb-settings-wrap">

		<!-- HEADER -->
		<div class="aatb-header">
			<div class="aatb-header-inner">
				<div class="aatb-header-left">
					<div class="aatb-logo-icon">
						<img src="<?php echo esc_url( AATB_URL . 'admin/assets/img/header-logo.png' ); ?>" alt="AI Alt Text Builder" width="36" height="36">
					</div>
					<div>
						<h1 class="aatb-header-title">AI Alt Text Builder</h1>
						<p class="aatb-header-subtitle">Media Library ALT Text Generator</p>
					</div>
				</div>
				<div class="aatb-header-right">
					<span class="aatb-version-badge">v<?php echo esc_html( AATB_VERSION ); ?></span>
				</div>
			</div>
		</div>

		<!-- LAYOUT -->
		<div class="aatb-layout">

			<!-- SIDEBAR -->
			<aside class="aatb-sidebar">
				<nav class="aatb-nav">
					<a href="<?php echo esc_url( add_query_arg('tab','site-key',admin_url('admin.php?page=ai-alt-text-builder')) ); ?>"
					   class="aatb-nav-item <?php echo $tab==='site-key' ? 'active' : ''; ?>">
						<span class="aatb-nav-icon">
							<svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
								<path d="M21 2l-2 2m-7.61 7.61a5.5 5.5 0 1 1-7.778 7.778 5.5 5.5 0 0 1 7.777-7.777zm0 0L15.5 7.5m0 0l3 3L22 7l-3-3m-3.5 3.5L19 4"/>
							</svg>
						</span>
						<span>Site Key Management</span>
					</a>
					<a href="<?php echo esc_url( add_query_arg('tab','alt-settings',admin_url('admin.php?page=ai-alt-text-builder')) ); ?>"
					   class="aatb-nav-item <?php echo $tab==='alt-settings' ? 'active' : ''; ?>">
						<span class="aatb-nav-icon">
							<svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
								<circle cx="12" cy="12" r="3"/>
								<path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06A1.65 1.65 0 0 0 4.68 15a1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06A1.65 1.65 0 0 0 9 4.68a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/>
							</svg>
						</span>
						<span>Alt-Text Settings</span>
					</a>
				</nav>

				<div class="aatb-sidebar-info">
					<p>Generate SEO-friendly ALT text for your Media Library images with one click. Supports bulk generation and multiple languages.</p>
					<a href="https://rankpilotai.com/ai-alt-text-builder/" target="_blank" rel="noopener" class="aatb-sidebar-link">
						<svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"/><polyline points="15 3 21 3 21 9"/><line x1="10" y1="14" x2="21" y2="3"/></svg>
						Documentation
					</a>
				</div>
			</aside>

			<!-- CONTENT -->
			<main class="aatb-content">

			<?php /* ---- TAB 1: SITE KEY ---- */ ?>
			<?php if ( $tab === 'site-key' ) : ?>

				<div class="aatb-content-header">
					<h2>Site Key Management</h2>
					<p>Connect your site to RankPilotAI by entering your Site Key below.</p>
				</div>

				<?php if ( ! $token ) : ?>

					<div class="aatb-card">
						<div class="aatb-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 2l-2 2m-7.61 7.61a5.5 5.5 0 1 1-7.778 7.778 5.5 5.5 0 0 1 7.777-7.777zm0 0L15.5 7.5m0 0l3 3L22 7l-3-3m-3.5 3.5L19 4"/></svg>
							<h3>Enter Your Site Key</h3>
						</div>
						<form method="post" class="aatb-form">
							<?php wp_nonce_field('aatb_save_site_key'); ?>
							<input type="hidden" name="aatb_action" value="aatb_save_site_key">
							<div class="aatb-field">
								<label for="aatb_site_token">Site Key</label>
								<input type="text" id="aatb_site_token" name="site_token" placeholder="rp_xxxxxxxxxxxxxxxxx" required>
								<p class="aatb-field-hint">Generate a Site Key in your account at
									<a href="https://rankpilotai.com" target="_blank" rel="noopener">RankPilotAI.com</a></p>
							</div>
							<button type="submit" class="aatb-btn aatb-btn-primary">
								<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/><polyline points="17 21 17 13 7 13 7 21"/><polyline points="7 3 7 8 15 8"/></svg>
								Save Site Key
							</button>
						</form>
					</div>

				<?php else : ?>

					<!-- Active Key Card -->
					<div class="aatb-card">
						<div class="aatb-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>
							<h3>Active Site Key</h3>
							<span class="aatb-badge aatb-badge-success">Connected</span>
						</div>
						<div class="aatb-token-display">
							<code><?php echo esc_html( $token ); ?></code>
						</div>
					</div>

					<?php if ( $usage !== null ) : ?>
					<!-- Usage Card -->
					<div class="aatb-card">
						<div class="aatb-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 20V10"/><path d="M18 20V4"/><path d="M6 20v-4"/></svg>
							<h3>Usage Overview</h3>
						</div>

						<div class="aatb-usage-grid">
							<div class="aatb-usage-stat">
								<span class="aatb-usage-label">Website</span>
								<span class="aatb-usage-value"><?php echo esc_html( parse_url( home_url(), PHP_URL_HOST ) ); ?></span>
							</div>
							<div class="aatb-usage-stat">
								<span class="aatb-usage-label">Used</span>
								<span class="aatb-usage-value aatb-usage-number"><?php echo esc_html( number_format_i18n( (int) $usage ) ); ?></span>
							</div>
							<div class="aatb-usage-stat">
								<span class="aatb-usage-label">Plan Limit</span>
								<span class="aatb-usage-value aatb-usage-number"><?php echo esc_html( number_format_i18n( (int) $limit ) ); ?></span>
							</div>
							<div class="aatb-usage-stat">
								<span class="aatb-usage-label">Remaining</span>
								<span class="aatb-usage-value aatb-usage-number <?php echo (int)$remain === 0 ? 'aatb-danger' : 'aatb-success'; ?>">
									<?php echo esc_html( number_format_i18n( (int) $remain ) ); ?>
								</span>
							</div>
						</div>

						<?php
						$pct = $limit ? round( ( ( (int) $limit - (int) $remain ) / max( 1, (int) $limit ) ) * 100 ) : 0;
						$pct = max( 0, min( 100, (int) $pct ) );
						$bar_color = ( (int) $remain === 0 ) ? '#ef4444' : '#3b82f6';
						?>
						<div class="aatb-progress-wrap">
							<div class="aatb-progress-bar">
								<div class="aatb-progress-fill" style="width:<?php echo (int) $pct; ?>%;background:<?php echo esc_attr( $bar_color ); ?>;"></div>
							</div>
							<span class="aatb-progress-label"><?php echo (int) $pct; ?>% used</span>
						</div>

						<div class="aatb-usage-cta">
							<a href="<?php echo esc_url( $btn_url ); ?>" target="_blank" rel="noopener" class="aatb-btn aatb-btn-primary">
								<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"/><polyline points="15 3 21 3 21 9"/><line x1="10" y1="14" x2="21" y2="3"/></svg>
								<?php echo esc_html( $btn_label ); ?>
							</a>
						</div>
					</div>
					<?php endif; ?>

					<!-- Update Key Card -->
					<div class="aatb-card">
						<div class="aatb-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"/><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"/></svg>
							<h3>Update Site Key</h3>
						</div>
						<form method="post" class="aatb-form">
							<?php wp_nonce_field('aatb_save_site_key'); ?>
							<input type="hidden" name="aatb_action" value="aatb_save_site_key">
							<div class="aatb-field-row">
								<input type="text" name="site_token" value="<?php echo esc_attr( $token ); ?>" placeholder="rp_xxxxxxxxxxxxxxxxx">
								<button type="submit" class="aatb-btn aatb-btn-primary">Save</button>
							</div>
						</form>
					</div>

				<?php endif; ?>

			<?php /* ---- TAB 2: ALT-TEXT SETTINGS ---- */ ?>
			<?php else : ?>

				<div class="aatb-content-header">
					<h2>Alt-Text Settings</h2>
					<p>Configure how AI Alt Text Builder generates ALT text for your images.</p>
				</div>

				<?php if ( empty( $token ) ) : ?>
					<div class="aatb-alert aatb-alert-warning">
						<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/><line x1="12" y1="9" x2="12" y2="13"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>
						<div>
							<strong>Site Key Required</strong>
							<p>Please enter a Site Key in the <a href="<?php echo esc_url( add_query_arg('tab','site-key',admin_url('admin.php?page=ai-alt-text-builder')) ); ?>">Site Key Management</a> tab first.</p>
						</div>
					</div>
				<?php endif; ?>

				<form method="post">
					<?php wp_nonce_field('aatb_save_alt_settings'); ?>
					<input type="hidden" name="aatb_action" value="aatb_save_alt_settings">

					<!-- Model Selection -->
					<div class="aatb-card">
						<div class="aatb-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="12 2 2 7 12 12 22 7 12 2"/><polyline points="2 17 12 22 22 17"/><polyline points="2 12 12 17 22 12"/></svg>
							<h3>AI Model</h3>
						</div>

						<div class="aatb-model-grid">
							<label class="aatb-model-card <?php echo ($model === 'gpt-4o-mini') ? 'selected' : ''; ?>">
								<input type="radio" name="model_choice" value="gpt-4o-mini"
									   <?php checked( $model, 'gpt-4o-mini' ); ?> <?php echo $dis; ?>>
								<div class="aatb-model-card-inner">
									<span class="aatb-model-dot" style="background:#22c55e;"></span>
									<div class="aatb-model-info">
										<strong>GPT-4o-mini</strong>
										<span class="aatb-model-tag">Economical</span>
									</div>
									<span class="aatb-model-cost">1 token</span>
								</div>
							</label>

							<label class="aatb-model-card <?php echo ($model === 'gpt-4.1') ? 'selected' : ''; ?> <?php echo !in_array('gpt-4.1',$allowed_models_ui,true) ? 'disabled' : ''; ?>">
								<input type="radio" name="model_choice" value="gpt-4.1"
									   <?php checked( $model, 'gpt-4.1' ); ?>
									   <?php echo (!in_array('gpt-4.1',$allowed_models_ui,true) || $dis) ? 'disabled' : ''; ?>>
								<div class="aatb-model-card-inner">
									<span class="aatb-model-dot" style="background:#3b82f6;"></span>
									<div class="aatb-model-info">
										<strong>GPT-4.1</strong>
										<span class="aatb-model-tag">Balanced</span>
									</div>
									<span class="aatb-model-cost">3 tokens</span>
								</div>
							</label>

							<label class="aatb-model-card <?php echo ($model === 'gpt-4o') ? 'selected' : ''; ?> <?php echo !in_array('gpt-4o',$allowed_models_ui,true) ? 'disabled' : ''; ?>">
								<input type="radio" name="model_choice" value="gpt-4o"
									   <?php checked( $model, 'gpt-4o' ); ?>
									   <?php echo (!in_array('gpt-4o',$allowed_models_ui,true) || $dis) ? 'disabled' : ''; ?>>
								<div class="aatb-model-card-inner">
									<span class="aatb-model-dot" style="background:#a855f7;"></span>
									<div class="aatb-model-info">
										<strong>GPT-4o</strong>
										<span class="aatb-model-tag">Premium</span>
									</div>
									<span class="aatb-model-cost">5 tokens</span>
								</div>
							</label>
						</div>

						<p class="aatb-card-hint">All models support vision (image analysis). Some models may be unavailable on your current plan.</p>
					</div>

					<!-- Language Selection -->
					<div class="aatb-card">
						<div class="aatb-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><line x1="2" y1="12" x2="22" y2="12"/><path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"/></svg>
							<h3>Alt-Text Language</h3>
						</div>

						<div class="aatb-field">
							<select id="lang_choice" name="lang_choice" <?php echo $dis; ?>>
								<option value="en" <?php selected($lang,'en'); ?>>English</option>
								<option value="de" <?php selected($lang,'de'); ?>>Deutsch</option>
								<option value="fr" <?php selected($lang,'fr'); ?>>Fran&ccedil;ais</option>
								<option value="es" <?php selected($lang,'es'); ?>>Espa&ntilde;ol</option>
								<option value="tr" <?php selected($lang,'tr'); ?>>T&uuml;rk&ccedil;e</option>
								<option value="other" <?php if( ! in_array($lang,['en','de','fr','es','tr'],true) ) echo 'selected'; ?>>
									Other / Custom
								</option>
							</select>
							<input type="text" id="lang_custom" name="lang_custom"
								placeholder="e.g. Italian, Dutch, Arabic"
								value="<?php echo esc_attr( ! in_array($lang,['en','de','fr','es','tr'],true) ? $lang : '' ); ?>"
								style="margin-top:8px;<?php echo in_array($lang,['en','de','fr','es','tr'],true) ? 'display:none;' : ''; ?>">
							<p class="aatb-field-hint">Select "Other / Custom" and type the language exactly as you'd like it.</p>
						</div>
					</div>

					<!-- Custom Prompt -->
					<div class="aatb-card">
						<div class="aatb-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/></svg>
							<h3>Custom Prompt</h3>
						</div>

						<div class="aatb-field">
							<textarea id="custom_prompt" name="custom_prompt" rows="4"
									  placeholder="e.g. Always mention the brand name first..." <?php echo $dis; ?>><?php
								echo esc_textarea( $opt['custom_prompt'] ?? '' ); ?></textarea>
							<p class="aatb-field-hint">
								Optional. Add brand or style guidance. Your note is appended to the built-in instructions
								and takes priority over general rules; the 125-character limit always applies.
								Leave blank to use defaults.
							</p>
						</div>
					</div>

					<!-- Save Button -->
					<div class="aatb-form-actions">
						<button type="submit" class="aatb-btn aatb-btn-primary aatb-btn-lg" <?php echo $dis; ?>>
							<svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/><polyline points="17 21 17 13 7 13 7 21"/><polyline points="7 3 7 8 15 8"/></svg>
							<?php echo empty( $token ) ? 'Save (needs Site Key)' : 'Save Changes'; ?>
						</button>
					</div>
				</form>

			<?php endif; ?>

			</main>
		</div>
	</div>

	<!-- =========================================================
	      SETTINGS PAGE CSS
	========================================================= -->
	<style>
	/* ========== RESET & BASE ========== */
	.aatb-settings-wrap{
		max-width:1200px;
		margin:0 20px 40px 0;
		font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Ubuntu,Cantarell,"Helvetica Neue",Arial,sans-serif;
		font-size:14px;
		color:#1e293b;
		line-height:1.6;
	}
	.aatb-settings-wrap *{box-sizing:border-box;}

	/* ========== HEADER ========== */
	.aatb-header{
		background:linear-gradient(135deg,#0f172a 0%,#1e3a5f 50%,#1e40af 100%);
		border-radius:12px 12px 0 0;
		padding:0;
		margin-top:20px;
	}
	.aatb-header-inner{
		display:flex;
		align-items:center;
		justify-content:space-between;
		padding:24px 32px;
	}
	.aatb-header-left{display:flex;align-items:center;gap:16px;}
	.aatb-logo-icon{
		width:48px;height:48px;
		background:rgba(255,255,255,.12);
		border-radius:12px;
		display:flex;align-items:center;justify-content:center;
		color:#fff;
		flex-shrink:0;
	}
	.aatb-logo-icon img{border-radius:6px;}
	.aatb-header-title{
		font-size:22px;font-weight:700;color:#fff;margin:0;line-height:1.2;
	}
	.aatb-header-subtitle{
		font-size:13px;color:rgba(255,255,255,.65);margin:2px 0 0;
	}
	.aatb-version-badge{
		background:rgba(255,255,255,.15);
		color:rgba(255,255,255,.85);
		padding:4px 12px;
		border-radius:20px;
		font-size:12px;
		font-weight:600;
	}

	/* ========== LAYOUT ========== */
	.aatb-layout{
		display:flex;
		background:#f8fafc;
		border:1px solid #e2e8f0;
		border-top:none;
		border-radius:0 0 12px 12px;
		min-height:500px;
	}

	/* ========== SIDEBAR ========== */
	.aatb-sidebar{
		width:280px;
		background:#fff;
		border-right:1px solid #e2e8f0;
		border-radius:0 0 0 12px;
		padding:24px 16px;
		display:flex;
		flex-direction:column;
		flex-shrink:0;
	}
	.aatb-nav{display:flex;flex-direction:column;gap:4px;}
	.aatb-nav-item{
		display:flex;align-items:center;gap:12px;
		padding:12px 16px;
		border-radius:8px;
		color:#475569;
		text-decoration:none;
		font-size:14px;
		font-weight:500;
		transition:all .15s ease;
	}
	.aatb-nav-item:hover{background:#f1f5f9;color:#1e293b;}
	.aatb-nav-item.active{
		background:linear-gradient(135deg,#eff6ff,#dbeafe);
		color:#1d4ed8;
		font-weight:600;
		box-shadow:0 0 0 1px rgba(59,130,246,.2);
	}
	.aatb-nav-icon{display:flex;align-items:center;flex-shrink:0;}

	.aatb-sidebar-info{
		margin-top:auto;
		padding:16px;
		background:#f8fafc;
		border-radius:8px;
		border:1px solid #e2e8f0;
	}
	.aatb-sidebar-info p{
		font-size:12px;color:#64748b;margin:0 0 12px;line-height:1.5;
	}
	.aatb-sidebar-link{
		display:inline-flex;align-items:center;gap:6px;
		font-size:12px;color:#3b82f6;text-decoration:none;font-weight:500;
	}
	.aatb-sidebar-link:hover{color:#1d4ed8;text-decoration:underline;}

	/* ========== CONTENT ========== */
	.aatb-content{
		flex:1;
		padding:32px;
		min-width:0;
	}
	.aatb-content-header{margin-bottom:28px;}
	.aatb-content-header h2{
		font-size:22px;font-weight:700;color:#0f172a;margin:0 0 6px;
	}
	.aatb-content-header p{
		font-size:14px;color:#64748b;margin:0;
	}

	/* ========== CARDS ========== */
	.aatb-card{
		background:#fff;
		border:1px solid #e2e8f0;
		border-radius:10px;
		padding:24px;
		margin-bottom:20px;
		transition:box-shadow .2s ease;
	}
	.aatb-card:hover{box-shadow:0 1px 8px rgba(0,0,0,.04);}
	.aatb-card-header{
		display:flex;
		align-items:center;
		gap:10px;
		margin-bottom:20px;
		padding-bottom:16px;
		border-bottom:1px solid #f1f5f9;
		color:#334155;
	}
	.aatb-card-header h3{
		font-size:16px;font-weight:600;margin:0;color:#0f172a;flex:1;
	}
	.aatb-card-hint{
		font-size:12px;color:#94a3b8;margin:16px 0 0;line-height:1.5;
	}
	.aatb-card-hint code{
		background:#f1f5f9;padding:1px 6px;border-radius:3px;font-size:11px;
	}

	/* ========== BADGES ========== */
	.aatb-badge{
		padding:3px 10px;border-radius:20px;font-size:11px;font-weight:600;letter-spacing:.3px;text-transform:uppercase;
	}
	.aatb-badge-success{background:#dcfce7;color:#16a34a;}

	/* ========== FORMS ========== */
	.aatb-form{display:flex;flex-direction:column;gap:20px;}
	.aatb-field{display:flex;flex-direction:column;gap:6px;}
	.aatb-field label{font-size:13px;font-weight:600;color:#334155;}
	.aatb-field input[type="text"],
	.aatb-field textarea,
	.aatb-field select{
		width:100%;
		padding:10px 14px;
		font-size:14px;
		border:1px solid #cbd5e1;
		border-radius:8px;
		background:#fff;
		color:#1e293b;
		transition:border-color .15s ease,box-shadow .15s ease;
		font-family:inherit;
	}
	.aatb-field input[type="text"]:focus,
	.aatb-field textarea:focus,
	.aatb-field select:focus{
		outline:none;
		border-color:#3b82f6;
		box-shadow:0 0 0 3px rgba(59,130,246,.12);
	}
	.aatb-field textarea{resize:vertical;min-height:100px;}
	.aatb-field select{
		appearance:none;
		-webkit-appearance:none;
		-moz-appearance:none;
		background:#fff
			url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='%23334155'%3E%3Cpath d='M7 10l5 5 5-5'/%3E%3C/svg%3E")
			no-repeat right 12px center;
		background-size:14px 14px;
		padding-right:40px;
	}
	.aatb-field-hint{
		font-size:12px;color:#94a3b8;margin:0;line-height:1.5;
	}
	.aatb-field-hint a{color:#3b82f6;text-decoration:none;}
	.aatb-field-hint a:hover{text-decoration:underline;}

	.aatb-field-row{
		display:flex;gap:10px;align-items:center;
	}
	.aatb-field-row input[type="text"]{
		flex:1;
		padding:10px 14px;
		font-size:14px;
		border:1px solid #cbd5e1;
		border-radius:8px;
		background:#fff;
		color:#1e293b;
		transition:border-color .15s ease,box-shadow .15s ease;
	}
	.aatb-field-row input[type="text"]:focus{
		outline:none;
		border-color:#3b82f6;
		box-shadow:0 0 0 3px rgba(59,130,246,.12);
	}

	/* ========== BUTTONS ========== */
	.aatb-btn{
		display:inline-flex;align-items:center;justify-content:center;gap:8px;
		padding:10px 20px;
		font-size:14px;font-weight:600;
		border:none;border-radius:8px;
		cursor:pointer;
		text-decoration:none;
		transition:all .15s ease;
		line-height:1.4;
	}
	.aatb-btn-primary{
		background:linear-gradient(135deg,#2563eb,#1d4ed8);
		color:#fff !important;
		box-shadow:0 1px 3px rgba(37,99,235,.3);
	}
	.aatb-btn-primary:hover{
		background:linear-gradient(135deg,#3b82f6,#2563eb);
		box-shadow:0 2px 8px rgba(37,99,235,.35);
		transform:translateY(-1px);
		color:#fff !important;
	}
	.aatb-btn-primary:active{transform:translateY(0);}
	.aatb-btn-primary:disabled,.aatb-btn-primary[disabled]{
		opacity:.5;cursor:not-allowed;transform:none;
	}
	.aatb-btn-lg{padding:12px 28px;font-size:15px;}

	/* ========== TOKEN DISPLAY ========== */
	.aatb-token-display{
		background:#f8fafc;
		border:1px solid #e2e8f0;
		border-radius:8px;
		padding:12px 16px;
	}
	.aatb-token-display code{
		font-size:14px;color:#334155;background:none;
		word-break:break-all;
	}

	/* ========== USAGE ========== */
	.aatb-usage-grid{
		display:grid;
		grid-template-columns:repeat(4,1fr);
		gap:16px;
		margin-bottom:20px;
	}
	.aatb-usage-stat{
		background:#f8fafc;
		border:1px solid #e2e8f0;
		border-radius:8px;
		padding:14px 16px;
		text-align:center;
	}
	.aatb-usage-label{
		display:block;font-size:11px;font-weight:600;
		color:#94a3b8;text-transform:uppercase;letter-spacing:.5px;
		margin-bottom:6px;
	}
	.aatb-usage-value{
		display:block;font-size:14px;font-weight:700;color:#0f172a;
		word-break:break-all;
	}
	.aatb-usage-number{font-size:20px;}
	.aatb-usage-value.aatb-danger{color:#ef4444;}
	.aatb-usage-value.aatb-success{color:#22c55e;}

	.aatb-progress-wrap{
		display:flex;align-items:center;gap:12px;
		margin-bottom:20px;
	}
	.aatb-progress-bar{
		flex:1;height:10px;
		background:#e2e8f0;border-radius:10px;
		overflow:hidden;
	}
	.aatb-progress-fill{
		height:100%;border-radius:10px;
		transition:width .6s ease;
	}
	.aatb-progress-label{
		font-size:12px;font-weight:600;color:#64748b;
		white-space:nowrap;
	}
	.aatb-usage-cta{padding-top:4px;}

	/* ========== MODEL CARDS ========== */
	.aatb-model-grid{
		display:grid;
		grid-template-columns:repeat(3,1fr);
		gap:12px;
	}
	.aatb-model-card{
		position:relative;
		border:2px solid #e2e8f0;
		border-radius:10px;
		padding:16px;
		cursor:pointer;
		transition:all .15s ease;
		background:#fff;
	}
	.aatb-model-card:hover:not(.disabled){
		border-color:#93c5fd;
		background:#f8fafc;
	}
	.aatb-model-card.selected{
		border-color:#3b82f6;
		background:linear-gradient(135deg,#eff6ff,#dbeafe);
		box-shadow:0 0 0 1px rgba(59,130,246,.2);
	}
	.aatb-model-card.disabled{
		opacity:.45;cursor:not-allowed;pointer-events:none;
	}
	.aatb-model-card input[type="radio"]{
		position:absolute;opacity:0;width:0;height:0;pointer-events:none;
	}
	.aatb-model-card-inner{
		display:flex;
		align-items:center;
		gap:10px;
	}
	.aatb-model-dot{
		width:10px;height:10px;
		border-radius:50%;
		flex-shrink:0;
	}
	.aatb-model-info{
		flex:1;min-width:0;
	}
	.aatb-model-info strong{
		display:block;font-size:14px;color:#0f172a;
	}
	.aatb-model-tag{
		font-size:11px;color:#64748b;
	}
	.aatb-model-cost{
		font-size:12px;font-weight:600;
		color:#3b82f6;
		white-space:nowrap;
		background:#eff6ff;
		padding:3px 8px;
		border-radius:6px;
	}

	/* ========== ALERT ========== */
	.aatb-alert{
		display:flex;align-items:flex-start;gap:12px;
		padding:16px 20px;
		border-radius:10px;
		margin-bottom:24px;
	}
	.aatb-alert svg{flex-shrink:0;margin-top:2px;}
	.aatb-alert strong{display:block;margin-bottom:4px;}
	.aatb-alert p{margin:0;font-size:13px;}
	.aatb-alert a{color:inherit;text-decoration:underline;}
	.aatb-alert-warning{
		background:#fef3c7;border:1px solid #fde68a;color:#92400e;
	}
	.aatb-alert-warning svg{color:#f59e0b;}

	/* ========== FORM ACTIONS ========== */
	.aatb-form-actions{
		padding-top:8px;
	}

	/* ========== RESPONSIVE ========== */
	@media (max-width:900px){
		.aatb-settings-wrap{margin:0 10px 30px 0;}
		.aatb-header-inner{padding:20px 24px;}
		.aatb-layout{flex-direction:column;border-radius:0 0 12px 12px;}
		.aatb-sidebar{
			width:100%;
			border-right:none;
			border-bottom:1px solid #e2e8f0;
			border-radius:0;
			padding:20px 16px;
		}
		.aatb-nav{flex-direction:row;gap:8px;}
		.aatb-nav-item{font-size:13px;padding:10px 14px;}
		.aatb-sidebar-info{display:none;}
		.aatb-content{padding:24px 20px;}

		.aatb-usage-grid{grid-template-columns:repeat(2,1fr);}
		.aatb-model-grid{grid-template-columns:1fr;}
		.aatb-field-row{flex-direction:column;}
		.aatb-field-row input[type="text"]{width:100%;}
		.aatb-btn{width:100%;justify-content:center;}
	}

	@media (max-width:480px){
		.aatb-header-inner{flex-direction:column;align-items:flex-start;gap:12px;}
		.aatb-header-right{align-self:flex-end;}
		.aatb-usage-grid{grid-template-columns:1fr 1fr;}
		.aatb-nav{flex-direction:column;}
	}
	</style>
	<script>
	(function(){
		var cards = document.querySelectorAll('.aatb-model-card');
		cards.forEach(function(card){
			var radio = card.querySelector('input[type="radio"]');
			if(!radio) return;
			card.addEventListener('click', function(e){
				if(card.classList.contains('disabled')) return;
				if(radio.disabled) return;
				cards.forEach(function(c){ c.classList.remove('selected'); });
				card.classList.add('selected');
				radio.checked = true;
			});
		});
	})();
	</script>
	<?php
}
