/*  AI Alt Text Builder — admin.js (1.0.0)  */
jQuery(function ($){

	/*──────────────── Single “Generate” button ────────────────*/
	$(document).on('click','.aatb-gen',function (e){
		e.preventDefault();

		const $btn  = $(this),
		      id    = Number( $btn.data('id') || 0 ),
		      $stat = $('#aatb-status-' + id);

		if ( ! id ) return;

		$stat.text('…');
		$btn.prop('disabled', true);

		$.post( AATB_Ajax.url, {
			action : 'aatb_generate_alt',
			nonce  : AATB_Ajax.nonce,
			id     : id
		}, function (r){

			$btn.prop('disabled', false);

			if ( ! r || ! r.success ){
				alert( 'AI Error: ' + ( r?.data?.msg || 'unknown' ) );
				$stat.text('');
				return;
			}

			const alt = r.data.alt || '';

			/* → If on the attachment edit screen, update the textarea */
			$('#attachment_alt').val( alt );

			/* → Update inputs inside the Media Modal */
			$('#attachments-' + id + '-alt').val( alt );
			$('input[name="attachments['+id+'][alt]"]').val( alt );

			/* → Compute a simple score */
			const len = $.trim( alt ).length;
			let   sc  = 0;
			if      ( len === 0   ) sc = 0;
			else if ( len <= 125 ) sc = 100;
			else if ( len <= 150 ) sc = 80;
			else if ( len <= 175 ) sc = 60;
			else if ( len <= 200 ) sc = 20;

			const col = ( sc >= 100 ) ? '#0091e0' : ( sc >= 67 ? '#ffab00' : '#dc3232' );

			/* → Badge (post.php) */
			const $badge = $('#aatb-score-'+id);
			if ($badge.length){
			   $badge.css({background:col}).text(sc+' / 100').show();
			}

			$stat.css('color', col).text('Done');

			/* → Update the badge in the list column */
			const $cell = $('td.aatb_score[data-colname]').filter(function (){
				return $(this).closest('tr').attr('id') === 'post-' + id;
			});
			if ( $cell.length ){
				$cell.html(
					'<span style="background:'+col+';padding:4px 7px;border-radius:3px;'+
					'color:#fff;font-size:11px;font-weight:600;">'+sc+' / 100</span>'
				);
			}

		}, 'json').fail(function (x){
			console.error( x.responseText );
			$btn.prop('disabled', false );
			$stat.text('');
			alert('Request failed: check console / server logs.');
		});
	});

	/*──────────────── AJAX error guard (expired nonce) ────────*/
	$(document).ajaxError(function (e,xhr,opts){
		if (opts.data && opts.data.indexOf('aatb_generate_alt')!==-1){
			if (xhr.status===403 || xhr.responseText==='-1'){
				location.reload(); // reload the page if the nonce has expired
			}
		}
	});

});

/*──────────────── Attachment edit screen (post.php) ───────────────*/
jQuery(function ($) {

	if ( !$('body').hasClass('post-type-attachment') ) return;

	const $alt = $('#attachment_alt');                 // textarea
	const id   = Number( $('#post_ID').val() || 0 );
	if ( !id || !$alt.length ) return;

	/* wrapper */
	const $wrap = $('<div/>',{
		class:'aatb-post-wrap',
		css:{marginTop:'8px',display:'flex',alignItems:'center',gap:'10px'}
	});

	/* button */
	const $btn = $('<button/>',{
		type:'button',
		class:'button button-primary aatb-gen',
		text:'Generate with AI Alt Text Builder',
		'data-id':id
	});

	/* status & score */
	const $stat  = $('<span/>',{id:'aatb-status-'+id});
	const $badge = $('<span/>',{
		id:'aatb-score-'+id,
		css:{
			background:'#dc3232',color:'#fff',fontSize:'11px',fontWeight:'600',
			borderRadius:'3px',padding:'3px 6px',display:'none'
		}
	});

	$wrap.append($btn,$stat,$badge).insertAfter($alt);
});

/*──────────────── Bulk result: highlight model selector if tokens were insufficient ───────────────*/
jQuery(function($){
  function getParam(name){ 
    try{ return new URL(location.href).searchParams.get(name); }
    catch(_){ return null; } 
  }
  if (getParam('aatb_binsufficient')==='1'){
    var $sel = $('#model_choice');
    if ($sel.length){
      $sel.css({ outline:'2px solid #ffb300', transition:'outline .2s' });
      $('html,body').animate({scrollTop: $sel.offset().top - 100}, 300);
    }
  }
});
// Toggle the “Other / Custom” language field on settings page
jQuery(function($){
  var sel  = $('#lang_choice');
  var cust = $('#lang_custom');
  if(!sel.length || !cust.length) return;
  function toggle(){
    if(sel.val() === 'other'){ cust.show().prop('required', true); }
    else { cust.hide().prop('required', false); }
  }
  sel.on('change', toggle);
  toggle();
});
// Bulk job runner for aatb_job param (was inline in admin_notices)
jQuery(function($){
  function getParam(name){
    try{ return new URL(location.href).searchParams.get(name); }
    catch(_){ return null; }
  }
  var job = getParam('aatb_job');
  if(!job) return;

  var nonce = (typeof AATB_Ajax !== 'undefined' && AATB_Ajax.nonce) ? AATB_Ajax.nonce : '';
  var stopping = false;

  function render(s){
    var proc = Number(s.processed||0), tot = Number(s.total||0),
        done = Number(s.done||0), fail = Number(s.fail||0);
    $('#aatb-bulk-p').text('processed ' + proc + '/' + tot + ' - success ' + done + ', failed ' + fail);
  }

  function finish(s){
    var u = new URL(location.href);
    u.searchParams.delete('aatb_job');
    if(s){ u.searchParams.set('aatb_done', s.done||0); u.searchParams.set('aatb_fail', s.fail||0); }
    location.href = u.toString();
  }

  function step(){
    if(stopping) return;
    $.post(ajaxurl,{action:'aatb_bulk_step',job:job,nonce:nonce},function(r){
      if(!r || !r.success){ console.error(r); $('#aatb-bulk-p').text('error'); return; }
      var s=r.data; render(s);
      if(s.cancelled || (s.remaining||0)===0){ finish(s); }
      else { step(); }
    },'json').fail(function(){ setTimeout(step, 1200); });
  }

  $(document).on('click', '#aatb-bulk-cancel', function(){
    if(stopping) return; stopping = true;
    $('#aatb-bulk-p').text('cancelling…');
    $.post(ajaxurl,{action:'aatb_bulk_cancel',job:job,nonce:nonce},function(){
      step();
    },'json').fail(function(){ step(); });
  });

  step();
});
