<?php
namespace ahrefs\AhrefsSeo;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'AHREFS_SEO_DIR', __DIR__ );
define( 'AHREFS_SEO_VENDOR_DIR', AHREFS_SEO_DIR . '/vendor-prefixed' );
if ( ! defined( 'AHREFS_SEO_URL' ) ) {
	define( 'AHREFS_SEO_URL', plugin_dir_url( __FILE__ ) );
}
define( 'AHREFS_SEO_IMAGES_URL', AHREFS_SEO_URL . 'assets/images/' );

// php 7.1 - static type declaration: strict mode enabled & return type declarations, include void return type.
define( 'AHREFS_SEO_CLASSES', AHREFS_SEO_DIR . '/' . ( version_compare( PHP_VERSION, '7.1.0' ) >= 0 ? 'php7' : 'php5' ) );

/**
 * Load own classes.
 *
 * @return void
 */
function classes_loader() {
	spl_autoload_register(
		function( $class ) {
			$prefix = 'ahrefs\AhrefsSeo\\';
			$len    = strlen( $prefix );
			if ( 0 !== strncmp( $prefix, $class, $len ) ) {
				return;
			}
			$class = substr( $class, $len );
			$dir   = '';
			if ( false !== strpos( $class, '\\' ) ) {
				list( $dir, $class ) = explode( '\\', $class );
				$dir                 = '/' . strtolower( str_replace( '_', '-', $dir ) );
			}
			$relative_class = strtolower( str_replace( '_', '-', $class ) );
			$file           = AHREFS_SEO_CLASSES . $dir . str_replace( '\\', '/', '/class-' . $relative_class ) . '.php';
			if ( file_exists( $file ) ) {
				require_once $file;
			}
		}
	);

	require_once AHREFS_SEO_VENDOR_DIR . '/autoload.php';
}

/**
 * Load all vendor prefixed files.
 *
 * @return void
 */
function files_loader() {
	$files       = require AHREFS_SEO_VENDOR_DIR . '/composer/autoload_files.php';
	$shared_dirs = array( 'ahrefs', 'bugsnag', 'composer', 'ralouphie/getallheaders', 'symfony' ); // files in these dirs are not prefixed, we should share them with Composer.
	foreach ( $files as $file_identifier => $file ) {
		$shared_file = false;
		array_walk(
			$shared_dirs,
			function( $dir ) use ( &$shared_file, $file ) {
				$shared_file = $shared_file || ( false !== strpos( $file, "/$dir/" ) );
			}
		);

		if ( false !== strpos( $file, '/guzzlehttp/guzzle/src/functions_include.php' ) ) {
			$file = AHREFS_SEO_VENDOR_DIR . '/guzzlehttp/guzzle/src/functions.php'; // skip checks and load main file.
		}
		/* Always load file if it has prefixed code. Load shared code if was not loaded already, at the same manner, as autoload_real.php @generated by Composer do. */
		if ( ! $shared_file || empty( $GLOBALS['__composer_autoload_files'][ $file_identifier ] ) ) {
			require_once $file;
			if ( $shared_file ) {
				$GLOBALS['__composer_autoload_files'][ $file_identifier ] = true; // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
			}
		}
	}
}
classes_loader();
files_loader();
