<?php
/**
 * Uninstall Script for Agents24x7 Connector
 * 
 * This file is executed when the plugin is deleted (not just deactivated)
 * Ensures complete cleanup of all plugin data
 */

// If uninstall is not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Include required files
require_once plugin_dir_path(__FILE__) . 'includes/class-integration.php';

// Complete site cleanup
$integration = new Agents24x7_Integration();
$integration->disconnect_site();

// Remove all plugin options
delete_option('agents24x7_version');

// Remove any cached data
wp_cache_flush();

// Note: WordPress automatically removes plugin files
// This script only handles database cleanup