<?php
/**
 * Plugin Name: Agents24x7 – AI Helper for Your Site: write SEO posts, grow traffic
 * Description: Get your own AI assistant to help manage your WordPress content in just 3 clicks! Transform your site with intelligent automation that works 24/7.
 * Version: 1.0.5
 * Author: Agents24x7
 * Author URI: https://www.agents24x7.com
 * License: GPL v2 or later
 * Text Domain: agents24x7
 * Requires at least: 5.0
 * Tested up to: 6.8.1
 * Requires PHP: 7.4
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

define('AGENTS24X7_VERSION', '1.0.5');
define('AGENTS24X7_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('AGENTS24X7_PLUGIN_URL', plugin_dir_url(__FILE__));
define('AGENTS24X7_PLUGIN_BASENAME', plugin_basename(__FILE__));

// Load classes with OAuth authentication
require_once AGENTS24X7_PLUGIN_DIR . 'includes/class-logger.php';
require_once AGENTS24X7_PLUGIN_DIR . 'includes/class-plugin.php';
require_once AGENTS24X7_PLUGIN_DIR . 'includes/class-auth.php';
require_once AGENTS24X7_PLUGIN_DIR . 'includes/class-api-proxy.php';
require_once AGENTS24X7_PLUGIN_DIR . 'includes/class-integration.php';

function agents24x7_activate() {
    add_option('agents24x7_version', AGENTS24X7_VERSION);
    flush_rewrite_rules();
}

function agents24x7_deactivate() {
    // Complete site disconnection - remove all plugin credentials
    $integration = new Agents24x7_Integration();
    $integration->disconnect_site();
    
    // Remove OAuth token
    $auth = new Agents24x7_Auth();
    $auth->disconnect();
    
    // Remove plugin options
    delete_option('agents24x7_version');
    
    flush_rewrite_rules();
}

register_activation_hook(__FILE__, 'agents24x7_activate');
register_deactivation_hook(__FILE__, 'agents24x7_deactivate');

function agents24x7_init() {
    new Agents24x7_Plugin();
}

add_action('plugins_loaded', 'agents24x7_init');