<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Custom template for displaying single AffiliLabs Products (affl_product).
 * This template is loaded via the 'template_include' hook in AffiliLabs class.
 */


affl_import(AFFILILABS_SERVICE_PRODUCT_FILE);

get_header();

?>

<div id="primary" class="content-area affl-single-product-template">
	<main id="main" class="site-main">

	<?php
	if ( have_posts() ) :
		while ( have_posts() ) :
			the_post();

			$product_id = get_the_ID();
			$template_id = get_post_meta($product_id, AFFILILABS_META_KEY_APPLIED_PRODUCT_TEMPLATE_ID, true);
			$template_applied = false;

			if ($template_id) {
				$template = get_post($template_id);
				if ($template && $template->post_type === 'affl_template') {
					$template_modules = get_post_meta($template_id, '_affl_template_data', true);
					if (!empty($template_modules)) {
						$template_applied = true;
						
						foreach ($template_modules as $module) {
                $shortcode_output = do_shortcode('[affl_' . $module . ' id="' . $product_id . '"]');

                if (empty(trim($shortcode_output))) {
                      continue;
                }

                $class_name = 'affl_' . str_replace('_', '-', $module);

                if ($module === 'name') {
                      affl_print('<h1 class="' . esc_attr($class_name) . '">' . $shortcode_output . '</h1>');
                } elseif ($module === 'description' || $module === 'features' || $module === 'pros' || $module === 'cons' || $module === 'criteria') {
                      affl_print('<div class="entry-content ' . esc_attr($class_name) . '">' . $shortcode_output . '</div>');
                } else {
                      affl_print('<div class="' . esc_attr($class_name) . '">' . $shortcode_output . '</div>');
                }
            }
					}
				}
			}
			
			if (!$template_applied) {
				$rating = get_post_meta( $product_id, AFFILILABS_META_KEY_RATING, true );
				$affiliate_link = get_post_meta( $product_id, AFFILILABS_META_KEY_AFFILIATE_LINK, true );
				$pros = get_post_meta( $product_id, AFFILILABS_META_KEY_PROS, true );
				$cons = get_post_meta( $product_id, AFFILILABS_META_KEY_CONS, true );
	
				?>
	
				<article id="post-<?php the_ID(); ?>" <?php post_class('affl-product-entry'); ?>>
	
					<header class="entry-header affl-product-header">
						<?php
						if ( has_post_thumbnail() ) :
							?>
							<div class="affl-product-image">
								<?php the_post_thumbnail( 'medium' ); ?>
							</div>
							<?php
						endif;
	
						the_title( '<h1 class="entry-title affl-product-title">', '</h1>' );
	
						if ( ! empty( $rating ) ) :
							$rating_html = AFFLProductService::get_rating_stars_html( (float) $rating );
							if ( ! empty( $rating_html ) ) :
								affl_print( '<div class="affl-product-rating">' . $rating_html . '</div>' );
							endif;
						endif;
	
						if ( ! empty( $affiliate_link ) ) :
							?>
							<div class="affl-product-affiliate-link">
								<a href="<?php affl_print( esc_url( $affiliate_link ) ); ?>" target="_blank" rel="nofollow" class="affl-button affl-button-primary">
									<?php affl_print( esc_html__( 'Get Product', 'affililabs' ) . '*'); ?>
								</a>
							</div>
							<?php
						endif;
						?>
					</header>
	
					<div class="entry-content affl-product-content">
						<?php
						if ( ! empty( $pros ) ) :
							?>
							<div class="affl-product-pros">
								<h3><?php affl_print( esc_html__( 'Pros', 'affililabs' ) ); ?></h3>
								<?php
	
								$pro_items = AFFLProductService::get_list_items_as_array( $pros );
								if ( ! empty( $pro_items ) ) :
									affl_print( '<ul class="affl-product-list affl-product-list--pros">' );
									foreach ( $pro_items as $item ) {
										if ( ! empty( $item ) ) {
											affl_print( '<li><img src="' . esc_url( AFFILILABS_ASSETS_CHECK_FILLED_SVG ) . '" alt="Pro" class="affl-list-icon"> ' . esc_html( $item ) . '</li>' );
										}
									}
									affl_print( '</ul>' );
								endif;
								?>
							</div>
							<?php
						endif;
	
						if ( ! empty( $cons ) ) :
							?>
							<div class="affl-product-cons">
								<h3><?php affl_print( esc_html__( 'Cons', 'affililabs' ) ); ?></h3>
								<?php
								$con_items = AFFLProductService::get_list_items_as_array( $cons );
								if ( ! empty( $con_items ) ) :
									affl_print( '<ul class="affl-product-list affl-product-list--cons">' );
									foreach ( $con_items as $item ) {
										if ( ! empty( $item ) ) {
											affl_print( '<li><img src="' . esc_url( AFFILILABS_ASSETS_CLOSE_SQUARE_FILLED_RED_SVG ) . '" alt="Con" class="affl-list-icon"> ' . esc_html( $item ) . '</li>' );
										}
									}
									affl_print( '</ul>' );
								endif;
								?>
							</div>
							<?php
						endif;
	
						the_content();
	
						wp_link_pages(
							array(
								'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'affililabs' ),
								'after'  => '</div>',
							)
						);
						?>
					</div>
	
					<footer class="entry-footer">
						<?php edit_post_link( esc_html__( 'Edit', 'affililabs' ), '<span class="edit-link">', '</span>' ); ?>
					</footer>
				</article>
			<?php } ?>

			<?php
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;

		endwhile;

	else :
		get_template_part( 'template-parts/content', 'none' );

	endif;
	?>

	</main>
</div>

<?php
get_sidebar();
get_footer();
