<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_SERVICE_SETTINGS_FILE);

class AFFLUserService {

    public static function get_user_quota() {
        if (!class_exists('AFFLSettingsService')) {
            affl_import(AFFILILABS_SERVICE_SETTINGS_FILE);
        }

        $internal_key = AFFLSettingsService::get_internal_api_key();
        
        $freemius_user_id = '';
        $freemius_secret_key = '';
        if (function_exists('affl_fs')) {
            $freemius_user_id = affl_fs()->get_user()->id ?? '';
            $freemius_secret_key = affl_fs()->get_user()->secret_key ?? '';
        }

        $response = wp_remote_post('https://api.affililabs.ai/user/usage', array(
            'method'    => 'POST',
            'body'      => json_encode(array(
                'freemius_user_id' => $freemius_user_id,
                'freemius_secret_key' => $freemius_secret_key,
                'api_key' => $internal_key,
            )),
            'headers'   => array(
                'Content-Type' => 'application/json'
            ),
            'timeout' => 30
        ));

        if (is_wp_error($response)) {
            AFFL_LoggerService::log(esc_html($response->get_error_message()));
            throw new Exception(esc_html($response->get_error_message()));
        }

        $response_code = wp_remote_retrieve_response_code($response);
        $body = wp_remote_retrieve_body($response);

        if ($response_code !== 200) {
            AFFL_LoggerService::log("AI API returned status code " . esc_html($response_code) . ". Body: " . esc_html($body) . ". Response: " . esc_html(print_r($response, true)), 'ERROR');
        }

        $data = json_decode($body, true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception(esc_html__('Error decoding JSON response: ', 'affililabs') . esc_html(json_last_error_msg()));
        }

        return $data;
    }
}
