<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_SERVICE_PRODUCT_FILE);

function affililabs_seal_shortcode_assets() {
    wp_enqueue_style(
        'affl-seal',
        AFFILILABS_SHORTCODE_SEAL_CSS_URL,
        array(),
        AFFILILABS_VERSION
    );
}

function affililabs_get_seal_template($options) {
    if (isset($options['id'])) {
        $product_id = $options['id'];
    } else {
        $product_id = get_the_ID();
    }
    
    $product_data = AFFLProductService::get_product_by_id($product_id);

    if (!$product_data) {
        return '';
    }

    $url = site_url();
    $url = preg_replace("/\w+:\/\//", "", $url);
    $url = preg_replace("/\w+:\/\/w{3}\./", "", $url);

    $rating = floatval($product_data['rating']);
    $rating_score = number_format($rating, 1);
    
    // Calculate rating text (predicate) based on score (German grading scale approximation)
    $rating_text = __('Sehr gut', 'affililabs');
    $predicate_color = '#2ecc71'; // Green for good ratings

    if ($rating >= 4.5) {
        $rating_text = __('Sehr gut', 'affililabs');
        $predicate_color = '#2ecc71';
    } elseif ($rating >= 3.5) {
        $rating_text = __('Gut', 'affililabs');
        $predicate_color = '#27ae60';
    } elseif ($rating >= 2.5) {
        $rating_text = __('Befriedigend', 'affililabs');
        $predicate_color = '#f1c40f';
    } elseif ($rating >= 1.5) {
        $rating_text = __('Genügend', 'affililabs');
        $predicate_color = '#e67e22';
    } else {
        $rating_text = __('Nicht Genügend', 'affililabs');
        $predicate_color = '#e74c3c';
    }

    $star_rating = AFFLProductService::get_rating_stars_html($rating, 'Rating', 'width: 14px; height: auto;');
    $product_link = get_permalink($product_id);
    $product_url = $product_data['affiliate_link'];
    $short_title = $product_data['name'];
    $current_date = gmdate('m/Y');
    $favicon_url = get_site_icon_url();
    $site_url = get_site_url();
    
    // Use the first category as the product group
    $product_group = '';
    if (!empty($product_data['category_names'])) {
        $product_group = $product_data['category_names'][0];
    }

    $host_title = wp_parse_url($site_url, PHP_URL_HOST);
    
    // If product_url is an affiliate link, we might want to show the domain of the product page or the site itself.
    // The original code parsed the domain from $product_url (which was get_permalink there).
    // Here we have $product_url as the affiliate link. 
    // Let's stick to the site's host title for the "Favicon of..." alt text.
    
    $host_title = ucwords(str_replace('-', ' ', $host_title));
    $host_title_parts = explode('.', $host_title);
    $host_title = $host_title_parts[0];

    // Display URL (ABRUF: ...)
    // The original code parsed the domain from the product permalink.
    // Let's use the product permalink for the display URL to keep it clean.
    $display_url_raw = get_permalink($product_id);
    $display_url = '';
    if(preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})(?P<rest>\/[^?]*)?(?P<query>\?.*)?$/i', $display_url_raw, $regs)) {
        $display_url_parts = array();
        $display_url_parts[0] = $regs['domain'];
        $display_url_parts[1] = $regs['rest'];
        $display_url = implode('', $display_url_parts);
    } else {
        $display_url = $display_url_raw;
    }

    $abruf = esc_html__('ABRUF', 'affililabs');

    $sealclass = 'affl-seal';
    // Custom text option removed as it's not in AFFL settings yet. 
    // We can use the product group (category) as a fallback or leave empty.
    $custom_text = '';
    if (isset($options['custom_text'])) {
        $custom_text = $options['custom_text'];
    } else {
        $custom_text = $product_group;
    }

    $mode = '';
    $small_mode_class = '';

    if (isset($options['mode'])) {
        $mode = $options['mode'];
    }

    if ($mode == 'small') {
        $small_mode_class = "affl-seal-mode-small";

        $output = "
            <div class='$sealclass-placeholder $small_mode_class'>
                <header class='$sealclass-header' style='background-color: $predicate_color;'>
                    <img class='$sealclass-favicon' src='$favicon_url' alt='Favicon of $host_title' />
                    <span class='$sealclass-title'>$host_title</span>
                </header>
                <div class='$sealclass-main'>
                    <div class='$sealclass-predicate-text'>$rating_text</div>

                    <div class='$sealclass-german-flag-stripes'>
                        <span class='$sealclass-german-flag-stripe-black'></span>
                        <span class='$sealclass-german-flag-stripe-red'></span>
                        <span class='$sealclass-german-flag-stripe-yellow'></span>
                    </div>

                    <div class='$sealclass-rating-section'>
                        <span class='$sealclass-rating-score'>$rating_score</span>
                        <div class='$sealclass-rating-text-wrapper'>
                            <span class='$sealclass-rating-text-pre'>$custom_text</span>
                            <span class='$sealclass-rating-text'>
                                <time class='$sealclass-current-date'>$current_date</time>
                            </span>
                        </div>
                    </div>
                    <footer class='$sealclass-footer'>
                        <a class='$sealclass-product-link' href='$product_link' title='$short_title'>$abruf: $display_url</a>
                    </footer>
                </div>
            </div>
        ";

        return $output;
    }

    $output = "
        <div class=$sealclass-placeholder>
            <header class='$sealclass-header' style='background-color: $predicate_color;'>
                <img class='$sealclass-favicon' src='$favicon_url' alt='Favicon of $host_title' />
                <span class='$sealclass-title'>$host_title</span>
            </header>
            <div class='$sealclass-main'>
                <div class='$sealclass-custom-text'>$custom_text</div>
                <div class='$sealclass-predicate-text'>$rating_text</div>
                <div class='$sealclass-german-flag-stripes'>
                    <span class='$sealclass-german-flag-stripe-black'></span>
                    <span class='$sealclass-german-flag-stripe-red'></span>
                    <span class='$sealclass-german-flag-stripe-yellow'></span>
                </div>
                <div class='$sealclass-rating-section'>
                    <span class='$sealclass-rating-score'>$rating_score</span>
                    <div class='$sealclass-rating-text-wrapper'>
                        <span class='$sealclass-rating-text-pre'>Note:</span>
                        <span class='$sealclass-rating-text'>$rating_text</span>
                    </div>
                </div>
                <div class='$sealclass-star-rating'>$star_rating</div>
                <div class='$sealclass-short-title'>$short_title</div>
                <footer class='$sealclass-footer'>
                    <a class='$sealclass-product-link' href='$product_link' title='$short_title'>$abruf: $display_url</a>
                    <time class='$sealclass-current-date'>$current_date</time>
                </footer>
            </div>
        </div>
    ";

    return $output;
}

function affililabs_seal_shortcode($atts, $content = null) {
    $default = array(
        'id' => null,
        'mode' => null,
        'custom_text' => null,
    );
    
    $options = shortcode_atts($default, $atts);
    
    affililabs_seal_shortcode_assets();

    ob_start();
    try {
        affl_print(affililabs_get_seal_template($options));
    } catch (Exception $e) {
        affl_print('Error while rendering template: ' . $e->getMessage());
    }

    return ob_get_clean();
}

add_shortcode('affl_seal', 'affililabs_seal_shortcode');
