<?php

if (!defined('ABSPATH')) {
    exit;
}

affl_import(AFFILILABS_SERVICE_PRODUCT_FILE);
affl_import(AFFILILABS_SERVICE_CRITERIA_FILE);
affl_import(AFFILILABS_COMPARISON_TABLE_SERVICE_FILE);

class AFFLComparisonTableShortcode {

    public function __construct() {
        add_action('wp_enqueue_scripts', array($this, 'enqueue_styles'));
        add_shortcode('affl_table', array($this, 'render_shortcode'));
    }

    public function enqueue_styles() {
        wp_enqueue_style('affililabs-comparison-table', AFFILILABS_COMPARISON_TABLE_SHORTCODE_CSS_URL, array(), AFFILILABS_VERSION);
        
        wp_enqueue_script('affililabs-comparison-table', AFFILILABS_COMPARISON_TABLE_SHORTCODE_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
    }

    public function render_shortcode($atts, $content = null) {
        $atts = shortcode_atts(array(
            'id' => null,
            'theme' => 'light',
            'mode' => 'advanced',
            'best_price_color' => '',
            'best_quality_color' => '',
            'best_cost_benefit_color' => '',
            'template_id' => null,
            'live_template_modules' => null
        ), $atts);

        $table_id = null;
        $template_id = $atts['template_id'] ? intval($atts['template_id']) : null;

        if (!empty($atts['id'])) {
            $table_id = intval($atts['id']);
        } else {
            $post_id = get_the_ID();
            if ($post_id) {
                 $table_id = get_post_meta($post_id, '_affl_associated_comparison_table', true);
            }
            if (empty($table_id)) {
                 return __('No comparison table ID specified or associated.', 'affililabs');
            }
            $table_id = intval($table_id);
        }

        if (!$template_id && $table_id) {
            $template_id = get_post_meta($table_id, '_affl_applied_template_id', true); 
            $template_id = $template_id ? intval($template_id) : null;
        }

        try {
            $table_data = AFFLComparisonTableService::get_table_data($table_id);
            if (empty($table_data)) {
                return __('Comparison table data not found.', 'affililabs');
            }
        } catch (Exception $e) {
            AFFL_LoggerService::log('Error fetching table data for shortcode ID ' . esc_html($table_id) . ': ' . esc_html($e->getMessage()), 'ERROR');
            if (current_user_can('edit_posts')) {
                return sprintf(
                    /* translators: %1$s: List ID, %2$s: Error details */
                    esc_html__('Error: Could not load List ID %1$s. It may have been deleted or is invalid. (Details: %2$s)', 'affililabs'),
                    esc_html($table_id),
                    esc_html($e->getMessage())
                );
            }
            return esc_html__('Error: Could not load the specified list.', 'affililabs');
        }

        $live_template_modules = isset($atts['live_template_modules']) && is_array($atts['live_template_modules']) 
                                 ? $atts['live_template_modules'] 
                                 : null;
        
        return $this->render_comparison_table_html($table_data, $atts, $template_id, $live_template_modules); 
    }

    private function render_comparison_table_html($table_data, $atts, $template_id = null, $live_template_modules = null) {
        if (empty($table_data['products'])) {
            return __('No products to display in the comparison table.', 'affililabs');
        }

        $final_template_modules = null;
        if (is_array($live_template_modules) && !empty($live_template_modules)) {
             $final_template_modules = $live_template_modules;
        }
        elseif ($template_id) { 
            $template_post = get_post($template_id);
            if ($template_post && $template_post->post_type === 'affl_template' && $template_post->post_status === 'publish') {
                $template_meta = get_post_meta($template_id, '_affl_template_data', true);
                if (is_array($template_meta) && !empty($template_meta)) {
                    $final_template_modules = $template_meta;
                    AFFL_LoggerService::debug('Using saved template structure for template ID ' . esc_html($template_id) . ': ' . esc_html(print_r($final_template_modules, true)), 'DEBUG');
                } else {
                     AFFL_LoggerService::log('Saved template meta _affl_template_data not found or not a non-empty array for template ID ' . esc_html($template_id), 'WARNING');
                }
            } else {
                 AFFL_LoggerService::log('Template post not found or not valid for template ID ' . esc_html($template_id), 'WARNING');
            }
        }

        $default_modules = ['price', 'rating', 'criteria', 'buy_button'];
        $modules_to_render = is_array($final_template_modules) && !empty($final_template_modules) 
                             ? $final_template_modules 
                             : $default_modules;

        if ($live_template_modules !== null) {
            AFFL_LoggerService::debug('Preview Render - Live Modules Received by AJAX: ' . esc_html(print_r($live_template_modules, true)), 'DEBUG'); 
            AFFL_LoggerService::debug('Preview Render - Template ID Received: ' . esc_html(print_r($template_id, true)), 'DEBUG');
            AFFL_LoggerService::debug('Preview Render - Final Modules To Render: ' . esc_html(print_r($modules_to_render, true)), 'DEBUG'); 
        }

        $theme = $atts['theme'] ?? 'light';
        $mode = $atts['mode'] ?? 'advanced';
        $best_price_color = $atts['best_price_color'] ?? '';
        $best_quality_color = $atts['best_quality_color'] ?? '';
        $best_cost_benefit_color = $atts['best_cost_benefit_color'] ?? '';
        
        $themes = array('light', 'dark', 'modern-blue');
        $modes = array('advanced', 'simple');

        if (!in_array($theme, $themes)) {
            $theme = 'light';
        }

        if (!in_array($mode, $modes)) {
            $mode = 'advanced';
        }

        $theme_class = 'affl-comparison-table--theme-' . esc_attr($theme);
        $mode_class = 'affl-comparison-table--mode-' . esc_attr($mode);

        ob_start();
        ?>
        <div class="affl-comparison-table <?php affl_print(esc_attr($theme_class)); ?> <?php affl_print(esc_attr($mode_class)); ?>"
             <?php if (!empty($best_price_color)) : ?>data-best-price-color="<?php affl_print(esc_attr($best_price_color)); ?>"<?php endif; ?>
             <?php if (!empty($best_quality_color)) : ?>data-best-quality-color="<?php affl_print(esc_attr($best_quality_color)); ?>"<?php endif; ?>
             <?php if (!empty($best_cost_benefit_color)) : ?>data-best-cost-benefit-color="<?php affl_print(esc_attr($best_cost_benefit_color)); ?>"<?php endif; ?>>
            <div class="affl-comparison-table__title-wrapper">
                <h2 class="affl-comparison-table__title"><?php affl_print(esc_html($table_data['title'])); ?></h2>
            </div>
            
            <?php
            if (count($table_data['products']) > 3) : ?>
            <div class="affl-comparison-table__nav-arrow affl-comparison-table__nav-arrow--left affl-comparison-table__nav-arrow--hidden">
                <img src="<?php affl_print(esc_url(AFFILILABS_ASSETS_ARROW_LEFT_SVG)); ?>" alt="<?php affl_print(esc_attr__('Scroll Left', 'affililabs')); ?>">
            </div>
            <div class="affl-comparison-table__nav-arrow affl-comparison-table__nav-arrow--right">
                <img src="<?php affl_print(esc_url(AFFILILABS_ASSETS_ARROW_RIGHT_SVG)); ?>" alt="<?php affl_print(esc_attr__('Scroll Right', 'affililabs')); ?>">
            </div>
            <?php endif; ?>
            <?php
                    $ordered_products = $this->get_ordered_products($table_data);

                    AFFL_LoggerService::debug('AFFL Comparison Table -- Products (Ordered): ' . esc_html(print_r($ordered_products, true)), 'DEBUG');
                    ?>

            <div class="affl-comparison-table__sticky-product-header affl-comparison-table__sticky-product-header--hidden">
                <div class="affl-comparison-table__sticky-criteria-placeholder">
                    <?php affl_print(esc_html__('Criteria', 'affililabs')); ?>
                </div>
                <div class="affl-comparison-table__sticky-products-wrapper">
                    <?php foreach ($ordered_products as $product) : ?>
                        <?php list($sticky_tier_class, ) = $this->get_tier_details($product['id'], $table_data['tiers'], 'cell'); ?>
                        <div class="affl-comparison-table__sticky-product-item <?php affl_print(esc_attr($sticky_tier_class)); ?>" data-product-id="<?php affl_print(esc_attr($product['id'])); ?>">
                            <img src="<?php affl_print(esc_url($product['image_url'] ?? '')); ?>" alt="<?php affl_print(esc_attr($product['name'])); ?>" class="affl-comparison-table__sticky-product-image">
                            <span class="affl-comparison-table__sticky-product-name"><?php affl_print(esc_html($product['name'])); ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="affl-comparison-table__scroll-container">
                <div class="affl-comparison-table__grid">
                    <?php
                    ?>
                    <div class="affl-comparison-table__row affl-comparison-table__header-row">
                        <div class="affl-comparison-table__cell affl-comparison-table__header-cell affl-comparison-table__header-cell--criteria">
                            <?php affl_print(esc_html__('Criteria', 'affililabs')); ?>
                        </div>
                        <?php
                        

                        AFFL_LoggerService::debug('AFFL Comparison Table -- Products (Ordered): ' . esc_html(print_r($ordered_products, true)), 'DEBUG');
                        foreach ($ordered_products as $product) : 
                            $has_tier = !empty($table_data['tiers']) && is_array($table_data['tiers']) && in_array($product['id'], $table_data['tiers']);
                            
                            list($tier_class, $tier_text) = $this->get_tier_details($product['id'], $table_data['tiers']);
                            ?>
                            <div class="affl-comparison-table__cell affl-comparison-table__header-cell affl-comparison-table__header-cell--product
                                 <?php if ($tier_class === 'affl-comparison-table__tier-indicator--best-price') affl_print(' affl-comparison-table__header-cell--best-price'); ?>
                                 <?php if ($tier_class === 'affl-comparison-table__tier-indicator--best-quality') affl_print(' affl-comparison-table__header-cell--best-quality'); ?>
                                 <?php if ($tier_class === 'affl-comparison-table__tier-indicator--best-cost-benefit') affl_print(' affl-comparison-table__header-cell--best-cost-benefit'); ?>">
                                <div class="affl-comparison-table__product-header">
                                    <?php if ($has_tier && !empty($tier_text)) : ?>
                                        <div class="affl-comparison-table__tier-badge <?php affl_print(esc_attr($tier_class)); ?>">
                                            <?php affl_print(esc_html($tier_text)); ?>
                                        </div>
                                    <?php endif; ?>
                                    <div class="affl-comparison-table__product-image-container">
                                        <a href="<?php affl_print(esc_url(get_permalink($product['id']))); ?>" target="_blank" rel="nofollow" class="affl-comparison-table__product-image-link">
                                             <img src="<?php affl_print(esc_url($product['image_url'] ?? '')); ?>" alt="<?php affl_print(esc_attr($product['name'])); ?>" class="affl-comparison-table__product-image">
                                         </a>
                                     </div>
                                     <a href="<?php affl_print(esc_url(get_permalink($product['id']))); ?>" target="_blank" rel="nofollow" class="affl-comparison-table__product-name"><?php affl_print(esc_html($product['name'])); ?></a>
                                 </div>
                             </div>
                         <?php endforeach; ?>
                     </div>
                     
                     <?php 
                     foreach ($modules_to_render as $module_id) :
                         switch ($module_id) {
                             case 'price':
                                 ?>
                                 <div class="affl-comparison-table__row affl-comparison-table__price-row">
                                     <div class="affl-comparison-table__cell affl-comparison-table__criteria-cell">
                                         <?php affl_print(esc_html__('Price', 'affililabs')); ?>
                                     </div>
                                     <?php foreach ($ordered_products as $product) : ?>
                                         <?php list($tier_cell_class, ) = $this->get_tier_details($product['id'], $table_data['tiers'], 'cell'); ?>
                                         <div class="affl-comparison-table__cell affl-comparison-table__product-cell affl-comparison-table__product-cell--price <?php affl_print(esc_attr($tier_cell_class)); ?>"
                                              data-label="<?php affl_print(esc_attr__('Price', 'affililabs')); ?>">
                                             <?php affl_print(esc_html(($product['price_currency'] ?? '$') . ' ' . ($product['price'] ?? 'N/A'))); ?>
                                         </div>
                                     <?php endforeach; ?>
                                 </div>
                                 <?php
                                 break;
 
                             case 'rating':
                             case 'star_rating':
                                 $has_ratings = false;
                                 foreach ($table_data['products'] as $p) { if (!empty($p['rating'])) { $has_ratings = true; break; } }
                                 
                                 if ($has_ratings): ?>
                                 <div class="affl-comparison-table__row affl-comparison-table__rating-row">
                                     <div class="affl-comparison-table__cell affl-comparison-table__criteria-cell">
                                         <?php affl_print(esc_html__('Rating', 'affililabs')); ?>
                                     </div>
                                     <?php foreach ($ordered_products as $product) : ?>
                                          <?php list($tier_cell_class, ) = $this->get_tier_details($product['id'], $table_data['tiers'], 'cell'); ?>
                                         <div class="affl-comparison-table__cell affl-comparison-table__product-cell affl-comparison-table__product-cell--rating <?php affl_print(esc_attr($tier_cell_class)); ?>"
                                              data-label="<?php affl_print(esc_attr__('Rating', 'affililabs')); ?>">
                                             <?php 
                                                 $rating_value = !empty($product['rating']) ? floatval($product['rating']) : 0;
                                                 affl_print(esc_html($rating_value > 0 ? number_format($rating_value, 1) : 'N/A')); 
                                             ?>
                                         </div>
                                     <?php endforeach; ?>
                                 </div>
                                 <?php endif;
                                 break;
                                 
 
                             case 'criteria':
                             case 'criterias':
                                 if (!empty($table_data['linked_criteria_details'])) :
                                     foreach ($table_data['linked_criteria_details'] as $criterion) :
                                         if (empty($criterion['fields']) || !is_array($criterion['fields'])) continue;
                                         
                                         foreach ($criterion['fields'] as $field) :
                                             if (empty($field['name']) || !isset($field['definition_id'])) continue;
                                             
                                             $row_class = ($mode === 'simple') ? 'affl-comparison-table__row--hidden' : '';
                                             $field_name = $field['name'];
                                             $field_type = isset($field['type']) ? $field['type'] : 'text';
                                             $definition_id = $field['definition_id'];
                                         ?>
                                         <div class="affl-comparison-table__row affl-comparison-table__criteria-field-row <?php affl_print(esc_attr($row_class)); ?>">
                                             <div class="affl-comparison-table__cell affl-comparison-table__criteria-cell">
                                                 <?php affl_print(esc_html($field_name)); ?>
                                             </div>
                                             <?php foreach ($ordered_products as $product) : ?>
                                                 <?php list($tier_cell_class, ) = $this->get_tier_details($product['id'], $table_data['tiers'], 'cell'); ?>
                                                 <div class="affl-comparison-table__cell affl-comparison-table__product-cell affl-comparison-table__product-cell--criteria-field <?php affl_print(esc_attr($tier_cell_class)); ?>"
                                                      data-label="<?php affl_print(esc_attr($field_name)); ?>">
                                                     <?php
                                                     $field_value_display = '';
                                                     if (class_exists('AFFLCriteriaService')) {
                                                         $product_field_values = AFFLCriteriaService::get_criterion_values_for_product($product['id'], $criterion['id']);
                                                         $field_value_display = $this->format_field_value($product_field_values, $definition_id, $field_type);
                                                     } else {
                                                          AFFL_LoggerService::log('AFFLCriteriaService class not found.', 'ERROR');
                                                     }
                                                     affl_print($field_value_display);
                                                     ?>
                                                 </div>
                                             <?php endforeach; ?>
                                         </div>
                                         <?php
                                         endforeach; // End individual fields loop
                                     endforeach; // End criteria loop
                                 endif;
                                 break;
                             
                             case 'buy_button':
                                 ?>
                                  <div class="affl-comparison-table__row affl-comparison-table__buy-row">
                                     <div class="affl-comparison-table__cell affl-comparison-table__criteria-cell">
                                         <?php affl_print(esc_html__('Buy', 'affililabs')); ?>
                                     </div>
                                     <?php foreach ($ordered_products as $product) : ?>
                                          <?php list($tier_cell_class, ) = $this->get_tier_details($product['id'], $table_data['tiers'], 'cell'); ?>
                                         <div class="affl-comparison-table__cell affl-comparison-table__product-cell affl-comparison-table__product-cell--buy <?php affl_print(esc_attr($tier_cell_class)); ?>"
                                              data-label="<?php affl_print(esc_attr__('Buy', 'affililabs')); ?>">
                                             <a href="<?php affl_print(esc_url($product['affiliate_link'] ?? '#')); ?>" class="affl-button" target="_blank" rel="nofollow"><?php affl_print(esc_html__('Buy Now', 'affililabs') . '*'); ?></a>
                                         </div>
                                     <?php endforeach; ?>
                                 </div>
                                 <?php
                                 break;
                             
                             case 'product_image':
                                  ?>
                                  <div class="affl-comparison-table__row affl-comparison-table__image-row">
                                     <div class="affl-comparison-table__cell affl-comparison-table__criteria-cell">
                                         <?php affl_print(esc_html__('Image', 'affililabs')); ?>
                                     </div>
                                     <?php foreach ($ordered_products as $product) : ?>
                                          <?php list($tier_cell_class, ) = $this->get_tier_details($product['id'], $table_data['tiers'], 'cell'); ?>
                                         <div class="affl-comparison-table__cell affl-comparison-table__product-cell affl-comparison-table__product-cell--image <?php affl_print(esc_attr($tier_cell_class)); ?>"
                                              data-label="<?php affl_print(esc_attr__('Image', 'affililabs')); ?>">
                                              <img src="<?php affl_print(esc_url($product['image_url'] ?? AFFILILABS_DEFAULT_PRODUCT_IMAGE)); ?>" alt="<?php affl_print(esc_attr($product['name'])); ?>" style="max-height: 60px; width: auto;">
                                         </div>
                                     <?php endforeach; ?>
                                 </div>
                                 <?php
                                 break;
                             case 'product_title':
                                  ?>
                                  <div class="affl-comparison-table__row affl-comparison-table__title-row">
                                     <div class="affl-comparison-table__cell affl-comparison-table__criteria-cell">
                                         <?php affl_print(esc_html__('Product', 'affililabs')); ?>
                                     </div>
                                     <?php foreach ($ordered_products as $product) : ?>
                                          <?php list($tier_cell_class, ) = $this->get_tier_details($product['id'], $table_data['tiers'], 'cell'); ?>
                                         <div class="affl-comparison-table__cell affl-comparison-table__product-cell affl-comparison-table__product-cell--title <?php affl_print(esc_attr($tier_cell_class)); ?>"
                                              data-label="<?php affl_print(esc_attr__('Product', 'affililabs')); ?>">
                                              <a href="<?php affl_print(esc_url(get_permalink($product['id']))); ?>" target="_blank" rel="nofollow"><?php affl_print(esc_html($product['name'] ?? 'N/A')); ?></a>
                                         </div>
                                     <?php endforeach; ?>
                                 </div>
                                 <?php
                                 break;
                              case 'marketplace_logo':
                                  $has_marketplaces = false;
                                  AFFL_LoggerService::debug('AFFL_Table Products inspect: ' . esc_html(print_r($table_data['products'], true)), 'DEBUG');
                                  foreach ($table_data['products'] as $p) { if (!empty($p['marketplace_id'])) { $has_marketplaces = true; break; } }
 
                                  if ($has_marketplaces): ?>
                                  <div class="affl-comparison-table__row affl-comparison-table__marketplace-row">
                                     <div class="affl-comparison-table__cell affl-comparison-table__criteria-cell">
                                         <?php affl_print(esc_html__('Marketplace', 'affililabs')); ?>
                                     </div>
                                     <?php foreach ($ordered_products as $product) : ?>
                                          <?php list($tier_cell_class, ) = $this->get_tier_details($product['id'], $table_data['tiers'], 'cell'); ?>
                                         <div class="affl-comparison-table__cell affl-comparison-table__product-cell affl-comparison-table__product-cell--marketplace <?php affl_print(esc_attr($tier_cell_class)); ?>"
                                              data-label="<?php affl_print(esc_attr__('Marketplace', 'affililabs')); ?>">
                                              <?php
                                              $marketplace_name_to_display = '';
                                              $marketplace_image_to_display = '';
 
                                              if (!empty($product['marketplace_id'])) {
                                                affl_import(AFFILILABS_SERVICE_MARKETPLACES);
                                                $fetched_marketplace = AFFLMarketplaceService::get_marketplace_by_id($product['marketplace_id']);
 
                                                if ($fetched_marketplace && !empty($fetched_marketplace['name'])) {
                                                    $marketplace_name_to_display = esc_html($fetched_marketplace['name']);
                                                    if (!empty($fetched_marketplace['image_url'])) {
                                                        $marketplace_image_to_display = '<img src="' . esc_url($fetched_marketplace['image_url']) . '" alt="' . esc_attr($fetched_marketplace['name']) . '" style="max-height: 50px; width: auto; object-fit: contain">';
                                                    }
                                                } else {
                                                     AFFL_LoggerService::log('Marketplace data not found or invalid for ID: ' . esc_html($product['marketplace_id']), 'WARNING');
                                                }
                                              } else {
                                                   AFFL_LoggerService::debug('Product ID ' . esc_html($product['id']) . ' has no marketplace_id.', 'DEBUG');
                                              }
 
                                              affl_print($marketplace_image_to_display);
                                              affl_print( '<p>' . $marketplace_name_to_display . '</p>');
                                              ?>
                                         </div>
                                     <?php endforeach; ?>
                                 </div>
                                  <?php endif;
                                  break;
                               case 'rating_badge':
                                   $has_any_tier = !empty($table_data['tiers']['best_price']) || !empty($table_data['tiers']['best_quality']) || !empty($table_data['tiers']['best_cost_benefit']);
                                   if ($has_any_tier): ?>
                                   <div class="affl-comparison-table__row affl-comparison-table__badge-row">
                                      <div class="affl-comparison-table__cell affl-comparison-table__criteria-cell">
                                          <?php affl_print(esc_html__('Badge', 'affililabs')); ?>
                                      </div>
                                      <?php foreach ($ordered_products as $product) : ?>
                                           <?php list($tier_cell_class, $tier_text) = $this->get_tier_details($product['id'], $table_data['tiers']); ?>
                                           <?php list($tier_indicator_class, ) = $this->get_tier_details($product['id'], $table_data['tiers'], 'indicator'); ?>
                                          <div class="affl-comparison-table__cell affl-comparison-table__product-cell affl-comparison-table__product-cell--badge <?php affl_print(esc_attr($tier_cell_class)); ?>"
                                               data-label="<?php affl_print(esc_attr__('Badge', 'affililabs')); ?>">
                                               <?php if (!empty($tier_text)): ?>
                                                   <span class="affl-comparison-table__tier-indicator <?php affl_print(esc_attr($tier_indicator_class)); ?>">
                                                       <?php affl_print(esc_html($tier_text)); ?>
                                                   </span>
                                               <?php endif; ?>
                                          </div>
                                      <?php endforeach; ?>
                                  </div>
                                   <?php endif;
                                   break;
 
                            default:
                               AFFL_LoggerService::log('Unknown module type in template: ' . esc_html($module_id), 'WARNING');
                               break;
                    }
                endforeach; ?>
 
                </div>
             </div>
        </div>
        <?php
        return ob_get_clean();
    }
 
    /**
     * Helper function to get ordered products (tiered first)
     */
    private function get_ordered_products($table_data) {
        $tiered_products = array();
        $non_tiered_products = array();
 
        foreach ($table_data['products'] as $product) {
            if (!empty($table_data['tiers']['best_price']) && $product['id'] == $table_data['tiers']['best_price']) {
                $tiered_products['best_price'] = $product;
            } elseif (!empty($table_data['tiers']['best_quality']) && $product['id'] == $table_data['tiers']['best_quality']) {
                $tiered_products['best_quality'] = $product;
            } elseif (!empty($table_data['tiers']['best_cost_benefit']) && $product['id'] == $table_data['tiers']['best_cost_benefit']) {
                $tiered_products['best_cost_benefit'] = $product;
            } else {
                $non_tiered_products[] = $product;
            }
        }
 
        $ordered_tiered_products = array();
        $tier_order = ['best_quality', 'best_cost_benefit', 'best_price'];
        foreach($tier_order as $tier_key) {
            if (isset($tiered_products[$tier_key])) {
                 $ordered_tiered_products[] = $tiered_products[$tier_key];
            }
        }
 
        return array_merge($ordered_tiered_products, $non_tiered_products);
    }
 
    /**
     * Helper function to get tier class and text
     */
    private function get_tier_details($product_id, $tiers, $type = 'indicator') {
        $tier_class = '';
        $tier_text = '';
        $base_class_prefix = ($type === 'cell') ? 'affl-comparison-table__product-cell--' : 'affl-comparison-table__tier-indicator--';
 
        if (!empty($tiers['best_price']) && $product_id == $tiers['best_price']) {
            $tier_class = $base_class_prefix . 'best-price';
            $tier_text = __('Best Price', 'affililabs');
        } elseif (!empty($tiers['best_quality']) && $product_id == $tiers['best_quality']) {
            $tier_class = $base_class_prefix . 'best-quality';
            $tier_text = __('Best Quality', 'affililabs');
        } elseif (!empty($tiers['best_cost_benefit']) && $product_id == $tiers['best_cost_benefit']) {
            $tier_class = $base_class_prefix . 'best-cost-benefit';
            $tier_text = __('Best Cost-Benefit', 'affililabs');
        }
        return [$tier_class, $tier_text];
    }
 
     /**
      * Helper function to format criterion values for display
      */
     private function format_field_value($product_field_values, $definition_id_to_find, $field_type) {
         $field_value = '';
         $field_value_display = '';
 
         $field_value_display = '';
 
         if (!is_array($product_field_values)) {
             return $field_value_display;
         }
 
         foreach ($product_field_values as $value_item) {
             if (!isset($value_item[AFFILILABS_META_KEY_PRODUCT_CRITERION_VALUE_DEFINITION_ID]) ||
                 $value_item[AFFILILABS_META_KEY_PRODUCT_CRITERION_VALUE_DEFINITION_ID] != $definition_id_to_find) {
                 continue;
             }
             
             $field_value = $value_item['value'] ?? '';
             $field_unit = $value_item['unit'] ?? '';
 
             if ($field_type === 'boolean') {
                 if ($field_value === 'yes') {
                     $field_value_display = '✓';
                 } elseif ($field_value === 'no') {
                     $field_value_display = '✗';
                 } else {
                     $field_value_display = esc_html($field_value); // Display raw value if not yes/no
                 }
             } else {
                 if (!empty($field_value) && !empty($field_unit)) {
                     $field_value_display = esc_html($field_value) . ' <span class="affl-comparison-table__field-unit">' . esc_html($field_unit) . '</span>';
                 } else {
                     $field_value_display = esc_html($field_value);
                 }
             }
             return $field_value_display;
         }
         return $field_value_display;
     }
 
 }
 
 new AFFLComparisonTableShortcode();
