<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class AFFL_LoggerService {

    public static function log(string $message, string $type='ERROR', string $log_file_name = 'error.log'): void {
        $upload_dir_info = wp_upload_dir();
        $uploads_log_path = trailingslashit($upload_dir_info['basedir']) . 'affililabs-logs/';

        if (!file_exists($uploads_log_path)) {
            wp_mkdir_p($uploads_log_path);
        }

        $time_now = gmdate('Y-m-d H:i:s');
        $prefix = '[AffiliLabs]';
        $append_file_mode = 3;
        $log_message = "[{$time_now} UTC] {$prefix}::{$type}: {$message}\n";
        
        // Write to uploads log file
        error_log(
            $log_message,
            $append_file_mode,
            $uploads_log_path . $log_file_name
        );

        // Also log to the general PHP error log
        error_log($log_message);
    }

    public static function debug(string $message, string $type='DEBUG', string $log_file_name = 'debug.log') {
        if (!defined('AFFILILABS_ENABLE_DEBUG_OPTION')) {
            if (defined('AFFILILABS_PLUGIN_CONSTANTS_PATH')) {
                affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
            }
        }

        $debug_enabled = (int) get_option(AFFILILABS_ENABLE_DEBUG_OPTION, 0);

        if ($debug_enabled === 1) {
            self::log($message, $type, $log_file_name);
        }
    }

}
