<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class AFFLLogService {

    public function get_logs(string $log_file_name = 'error.log') {
        // Prioritize logs from the uploads folder because it has persistence
        $uploads_log_file = AFFILILABS_UPLOADS_LOG_PATH . $log_file_name;
        if (file_exists($uploads_log_file)) {
            return file_get_contents($uploads_log_file);
        }

        // Fallback
        $local_log_file = AFFILILABS_LOG_PATH . $log_file_name;
        if (file_exists($local_log_file)) {
            return file_get_contents($local_log_file);
        }

        return esc_html__('No logs found.', 'affililabs');
    }

    public function get_general_log() {
        if (!defined('WP_CONTENT_DIR')) {
            return esc_html__('WP_CONTENT_DIR is not defined. Cannot locate general log file.', 'affililabs');
        }

        $general_log_file = WP_CONTENT_DIR . '/debug.log';

        if (file_exists($general_log_file)) {
            return file_get_contents($general_log_file);
        }

        return esc_html__('No general WordPress/PHP logs found.', 'affililabs');
    }
}
