<?php
if (!defined('ABSPATH')) {
    exit;
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);

$templates_args = array(
    'post_type' => AFFILILABS_CPT_TEMPLATE,
    'posts_per_page' => -1,
    'meta_query' => array(
        array(
            'key' => AFFILILABS_META_KEY_TEMPLATE_TYPE,
            'value' => 'comparison_table',
            'compare' => '=',
        ),
    ),
);
$comparison_table_templates = get_posts($templates_args);

$single_product_templates_args = array(
    'post_type' => AFFILILABS_CPT_TEMPLATE,
    'posts_per_page' => -1,
    'meta_query' => array(
        array(
            'key' => AFFILILABS_META_KEY_TEMPLATE_TYPE,
            'value' => 'single_product',
            'compare' => '=',
        ),
    ),
);
$single_product_templates = get_posts($single_product_templates_args);

$listicle_templates_args = array(
    'post_type' => AFFILILABS_CPT_TEMPLATE,
    'posts_per_page' => -1,
    'meta_query' => array(
        array(
            'key' => AFFILILABS_META_KEY_TEMPLATE_TYPE,
            'value' => 'listicle',
            'compare' => '=',
        ),
    ),
);
$listicle_templates = array();

$sidebar = new AffiliLabs_Sidebar();
$sidebar->load_scripts();
$navbar = new AffiliLabs_Navbar();
$navbar->load_scripts();
$button = new AffiliLabs_Button();
$modal = new AffiliLabs_Modal();
$modal->load_scripts();
$modal->init();
$spinner = new AffiliLabs_Spinner();
$spinner->load_scripts();
$spinner->init();

wp_enqueue_style('affililabs-templates', AFFILILABS_TEMPLATES_CSS_URL, array(), AFFILILABS_VERSION);
wp_enqueue_script('affililabs-templates', AFFILILABS_TEMPLATES_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
wp_localize_script(
    'affililabs-templates',
    'affililabs_templates',
    array(
        'i18n' => array(
            'delete_confirm_title' => esc_html__('Delete Confirmation', 'affililabs'),
            'delete_confirm' => esc_html__('Are you sure you want to delete this template?', 'affililabs'),
            'delete_confirm_button_confirm' => esc_html__('Delete', 'affililabs'),
            'delete_confirm_button_cancel' => esc_html__('Cancel', 'affililabs'),
            'delete_success_title' => esc_html__('Success', 'affililabs'),
            'delete_success_message' => esc_html__('The template was successfully deleted.', 'affililabs'),
            'delete_error_title' => esc_html__('Error', 'affililabs'),
            'delete_error_message' => esc_html__('Error deleting template.', 'affililabs'),
        ),
        'nonce' => wp_create_nonce('affl_admin_nonce'),
    )
);
?>

<div class="affililabs-plugin">
    <?php $sidebar->render('templates'); ?>
    <main class="affililabs-plugin__main">
        <?php $navbar->render(); ?>
        <header class="affililabs-plugin__header">
            <h1><?php affl_print(esc_html__('Templates', 'affililabs')); ?></h1>
        </header>
        
        <section class="affililabs-plugin__intro">
            <div class="affililabs-plugin__intro__text">
                <div>
                  <p><b><?php affl_print(esc_html__("Create, customize, and reuse templates!", 'affililabs')); ?></b></p>
                  <p class="affililabs-plugin__intro__description"><?php affl_print(esc_html__('Templates allow you to create reusable designs for your comparison tables and listicles. Create a template once and use it anywhere on your site.', 'affililabs')); ?></p>
                </div>
            </div>
        </section>
        
        <section class="affililabs-plugin__template-section">
            <div class="affililabs-plugin__section-header">
                <h2><?php affl_print(esc_html__('Comparison Table Templates', 'affililabs')); ?></h2>
                <?php $button->render(__('Create Comparison Table Template', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-template-editor&type=comparison_table'), 'affl_admin_nonce', 'nonce'))); ?>
            </div>
            
            <div class="affililabs-plugin__template-cards">
                <?php if (empty($comparison_table_templates)): ?>
                    <div class="affililabs-plugin__empty-state">
                        <p><?php affl_print(esc_html__('No comparison table templates yet.', 'affililabs')); ?></p>
                        <p><?php affl_print(esc_html__('Create your first template to get started!', 'affililabs')); ?></p>
                        <?php $button->render(__('Create Template', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-template-editor&type=comparison_table'), 'affl_admin_nonce', 'nonce'))); ?>
                    </div>
                <?php else: ?>
                    <?php foreach ($comparison_table_templates as $template): ?>
                        <div class="affililabs-plugin__template-card">
                            <div class="affililabs-plugin__template-card__header">
                                <h3><?php affl_print(esc_html($template->post_title)); ?></h3>
                                <div class="affililabs-plugin__template-card__actions">
                                    <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-template-editor&template_id=' . $template->ID), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin__edit-btn">
                                        <?php affl_print(esc_html__('Edit', 'affililabs')); ?>
                                    </a>
                                    <img src="<?php affl_print(AFFILILABS_ASSETS_TRASH_SVG); ?>" alt="trash-icon" class="affililabs-plugin__trash-icon affililabs-plugin__delete-btn" data-template-id="<?php affl_print(esc_attr($template->ID)); ?>" data-template-name="<?php affl_print(esc_attr($template->post_title)); ?>" />
                                </div>
                            </div>
                            <div class="affililabs-plugin__template-card__preview">
                                <img src="<?php affl_print(AFFILILABS_ASSETS_TABLE_SVG); ?>" alt="Template preview" class="affililabs-plugin__template-preview">
                            </div>
                            <div class="affililabs-plugin__template-card__footer">
                                <span class="affililabs-plugin__template-card__date">
                                    <?php affl_print(esc_html__('Created: ', 'affililabs') . date_i18n(get_option('date_format'), strtotime($template->post_date))); ?>
                                </span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </section>
        
        <section class="affililabs-plugin__template-section">
            <div class="affililabs-plugin__section-header">
                <h2><?php affl_print(esc_html__('Single Product Templates', 'affililabs')); ?></h2>
                <?php $button->render(__('Create Single Product Template', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-template-editor&type=single_product'), 'affl_admin_nonce', 'nonce'))); ?>
            </div>
            
            <div class="affililabs-plugin__template-cards">
                <?php if (empty($single_product_templates)): ?>
                    <div class="affililabs-plugin__empty-state">
                        <p><?php affl_print(esc_html__('No single product templates yet.', 'affililabs')); ?></p>
                        <p><?php affl_print(esc_html__('Create your first template to get started!', 'affililabs')); ?></p>
                        <?php $button->render(__('Create Template', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-template-editor&type=single_product'), 'affl_admin_nonce', 'nonce'))); ?>
                    </div>
                <?php else: ?>
                    <?php foreach ($single_product_templates as $template): ?>
                        <div class="affililabs-plugin__template-card">
                            <div class="affililabs-plugin__template-card__header">
                                <h3><?php affl_print(esc_html($template->post_title)); ?></h3>
                                <div class="affililabs-plugin__template-card__actions">
                                    <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-template-editor&template_id=' . $template->ID . '&type=single_product'), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin__edit-btn">
                                        <?php affl_print(esc_html__('Edit', 'affililabs')); ?>
                                    </a>
                                    <img src="<?php affl_print(AFFILILABS_ASSETS_TRASH_SVG); ?>" alt="trash-icon" class="affililabs-plugin__trash-icon affililabs-plugin__delete-btn" data-template-id="<?php affl_print(esc_attr($template->ID)); ?>" data-template-name="<?php affl_print(esc_attr($template->post_title)); ?>" />
                                </div>
                            </div>
                            <div class="affililabs-plugin__template-card__preview">
                                <img src="<?php affl_print(AFFILILABS_ASSETS_DOCUMENT_SVG); ?>" alt="Template preview" class="affililabs-plugin__template-preview">
                            </div>
                            <div class="affililabs-plugin__template-card__footer">
                                <span class="affililabs-plugin__template-card__date">
                                    <?php affl_print(esc_html__('Created: ', 'affililabs') . date_i18n(get_option('date_format'), strtotime($template->post_date))); ?>
                                </span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </section>

        <section class="affililabs-plugin__template-section">
            <div class="affililabs-plugin__section-header">
                <h2><?php affl_print(esc_html__('Listicle Templates', 'affililabs')); ?></h2>
                <?php $button->render(__('Create Listicle Template', 'affililabs') . ' +', '#', '', 'disabled'); ?>
            </div>
            
            <div class="affililabs-plugin__coming-soon">
                <div class="affililabs-plugin__empty-state">
                    <p><?php affl_print(esc_html__('Listicle templates coming soon!', 'affililabs')); ?></p>
                    <p><?php affl_print(esc_html__('This feature is currently under development.', 'affililabs')); ?></p>
                </div>
            </div>
        </section>
    </main>
</div>
