jQuery(document).ready(function ($) {
    const {
        delete_confirm_title,
        delete_confirm,
        delete_confirm_button_confirm,
        delete_confirm_button_cancel,
        delete_success_title,
        delete_success_message,
        delete_error_title,
        delete_error_message,
    } = affililabs_templates.i18n;
    const { nonce } = affililabs_templates;

    $(".affililabs-plugin__delete-btn").on("click", function (e) {
        e.preventDefault();

        const template_id = $(this).data("template-id");
        const template_name = $(this).data("template-name");
        const $card = $(this).closest(".affililabs-plugin__template-card");
        
        window.affililabs_modal.confirm(
            delete_confirm_title,
            delete_confirm + ' "' + template_name + '"',
            function() {
                delete_template(template_id, $card);
            },
            {
                buttons: {
                    confirm: delete_confirm_button_confirm,
                    cancel: delete_confirm_button_cancel
                }
            }
        );
    });
    
    function delete_template(template_id, $card) {
        $.ajax({
            url: ajaxurl,
            type: "POST",
            data: {
                action: "affililabs_delete_template",
                template_id: template_id,
                nonce: nonce
            },
            beforeSend: function() {
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.show('Deleting template...');
                }
            },
            success: function (response) {
                if (response.data.status === "ok") {
                    $card.fadeOut("fast", function() {
                        $(this).remove();
                        
                        if ($(".affililabs-plugin__template-card").length === 0) {
                            $(".affililabs-plugin__template-cards").html(`
                                <div class="affililabs-plugin__empty-state">
                                    <p>${window.affililabs_templates.i18n.no_templates_yet}</p>
                                    <p>${window.affililabs_templates.i18n.create_first_template}</p>
                                    <a href="${window.affililabs_templates.create_url}" class="affililabs-plugin__button">
                                        ${window.affililabs_templates.i18n.create_template} +
                                    </a>
                                </div>
                            `);
                        }
                    });
                    
                    window.affililabs_modal.notice(
                        delete_success_title,
                        delete_success_message
                    );
                } else {
                    console.error("[Response.data.status.error] Error deleting template:", response.data);
                    window.affililabs_modal.error(
                        delete_error_title,
                        delete_error_message + ": " + (response.data.message || "Could not delete the template.")
                    );
                }
            },
            error: function (xhr, status, error) {
                console.error("[Response.error] Error deleting template:", xhr, status, error);
                
                window.affililabs_modal.error(
                    delete_error_title,
                    delete_error_message + ": " + (xhr.responseJSON ? xhr.responseJSON.message : error)
                );
            },
            complete: function() {
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.hide();
                }
            }
        });
    }
});
