<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'affililabs'));
}


affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);

// Nonce verification
if (!isset($_GET['nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['nonce'])), 'affl_admin_nonce')) {
    wp_die(esc_html__('Security check failed.', 'affililabs'));
}

$template_type = isset($_GET['type']) ? sanitize_text_field(wp_unslash($_GET['type'])) : 'comparison_table';
if (!in_array($template_type, ['comparison_table', 'single_product'])) {
    $template_type = 'comparison_table';
}
$template_id = isset($_GET['template_id']) ? intval($_GET['template_id']) : null;

$template_data = array(
    'id' => $template_id,
    'title' => '',
    'type' => $template_type,
    'rows' => array(),
    'css' => '',
    'last_updated' => '',
    'applied_table_ids' => array()
);

if ($template_id) {
    if ($template_type === 'comparison_table') {
        $applied_ids = get_post_meta($template_id, '_affl_applied_table_ids', true);
        if (is_array($applied_ids)) {
            $template_data['applied_table_ids'] = array_map('intval', $applied_ids);
        }
    }
    // Custom fields for single_product will be loaded via AJAX
}

$sidebar = new AffiliLabs_Sidebar();
$sidebar->load_scripts();
$navbar = new AffiliLabs_Navbar();
$navbar->load_scripts();
$button = new AffiliLabs_Button();
$modal = new AffiliLabs_Modal();
$modal->load_scripts();
$modal->init();
$spinner = new AffiliLabs_Spinner();
$spinner->load_scripts();
$spinner->init();

wp_enqueue_script('jquery-ui-core');
wp_enqueue_script('jquery-ui-sortable');
wp_enqueue_script('jquery-ui-draggable');
wp_enqueue_script('jquery-ui-droppable');


wp_enqueue_style('affililabs-template-editor', AFFILILABS_TEMPLATE_EDITOR_CSS_URL, array(), AFFILILABS_VERSION);
wp_add_inline_style('affililabs-template-editor', '.template-editor__module-icon img { width: 30px; height: 30px; }');
wp_enqueue_script('affililabs-template-editor', AFFILILABS_TEMPLATE_EDITOR_JS_URL, array('jquery'), AFFILILABS_VERSION, true);


if ($template_type === 'comparison_table') {
    wp_enqueue_style('affililabs-comparison-table', AFFILILABS_COMPARISON_TABLE_SHORTCODE_CSS_URL, array(), AFFILILABS_VERSION);
    wp_enqueue_script('affililabs-comparison-table', AFFILILABS_COMPARISON_TABLE_SHORTCODE_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
} else if ($template_type === 'single_product') {
    wp_enqueue_style('affililabs-single-product', AFFILILABS_SINGLE_PRODUCT_TEMPLATE_CSS_URL, array(), AFFILILABS_VERSION);
    wp_enqueue_style('affililabs-shortcode-seal', AFFILILABS_SHORTCODE_SEAL_CSS_URL, array(), AFFILILABS_VERSION);
}

$products_options = array();
$products_args = array(
    'post_type' => AFFILILABS_CPT_PRODUCT,
    'post_status' => 'any',
    'posts_per_page' => -1,
    'orderby' => 'title',
    'order' => 'ASC',
);
$products_query = new WP_Query($products_args);
if ($products_query->have_posts()) {
    while ($products_query->have_posts()) {
        $products_query->the_post();
        $products_options[get_the_ID()] = get_the_title();
    }
    wp_reset_postdata();
}
$initial_preview_product_id = null;

$comparison_tables_options = array();
$comparison_tables_args = array(
    'post_type' => AFFILILABS_CPT_COMPARISON_TABLE,
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'title',
    'order' => 'ASC',
);
$comparison_tables_query = new WP_Query($comparison_tables_args);
if ($comparison_tables_query->have_posts()) {
    while ($comparison_tables_query->have_posts()) {
        $comparison_tables_query->the_post();
        $comparison_tables_options[get_the_ID()] = get_the_title();
    }
    wp_reset_postdata();
}
$initial_preview_table_id = null;

$available_modules = array();

if ($template_type === 'comparison_table') {
    $available_modules = array(
        array(
            'id' => 'star_rating',
            'name' => __('Star Rating', 'affililabs'),
            'description' => __('Show product rating with stars', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_STAR_SIMPLE_SVG
        ),
        array(
            'id' => 'marketplace_logo',
            'name' => __('Marketplace Logo', 'affililabs'),
            'description' => __('Display marketplace logo', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_PRICE_TAG_SVG
        ),
        array(
            'id' => 'price',
            'name' => __('Price', 'affililabs'),
            'description' => __('Show product price', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_DOLLAR_SVG
        ),
        array(
            'id' => 'buy_button',
            'name' => __('Buy Button', 'affililabs'),
            'description' => __('Add a buy button with affiliate link', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_CART_FAST_SVG
        ),
        array(
            'id' => 'criterias',
            'name' => __('Criterias', 'affililabs'),
            'description' => __('Display product criterias', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_CHECKLIST_SVG
        ),
        array(
            'id' => 'rating_badge',
            'name' => __('Rating Badge', 'affililabs'),
            'description' => __('Show special rating badge (Best Price, etc.)', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_BADGE_SVG
        )
    );
} else {
    $available_modules = array(
        array(
            'id' => 'name',
            'name' => __('Name', 'affililabs'),
            'description' => __('Product name', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_DOCUMENT_SVG
        ),
        array(
            'id' => 'image',
            'name' => __('Image', 'affililabs'),
            'description' => __('Product image', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_IMAGE_SVG
        ),
        array(
            'id' => 'price',
            'name' => __('Price', 'affililabs'),
            'description' => __('Product price', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_DOLLAR_SVG
        ),
        array(
            'id' => 'rating',
            'name' => __('Rating', 'affililabs'),
            'description' => __('Product rating', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_STAR_SIMPLE_SVG
        ),
        array(
            'id' => 'description',
            'name' => __('Description', 'affililabs'),
            'description' => __('Product description', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_MEMO_SVG
        ),
        array(
            'id' => 'features',
            'name' => __('Features', 'affililabs'),
            'description' => __('Product features list', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_CHECKLIST_SVG
        ),
        array(
            'id' => 'pros',
            'name' => __('Pros', 'affililabs'),
            'description' => __('Product pros list', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_PLUS_CIRCLE_SVG
        ),
        array(
            'id' => 'cons',
            'name' => __('Cons', 'affililabs'),
            'description' => __('Product cons list', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_CLOSE_SQUARE_SVG
        ),
        array(
            'id' => 'button',
            'name' => __('Button', 'affililabs'),
            'description' => __('Affiliate link button', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_CART_FAST_SVG
        ),
        array(
            'id' => 'criteria',
            'name' => __('Criteria', 'affililabs'),
            'description' => __('Product criteria', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_PENCIL_RULER_SVG
        ),
        array(
            'id' => 'seal',
            'name' => __('Seal', 'affililabs'),
            'description' => __('Product seal', 'affililabs'),
            'icon' => AFFILILABS_ASSETS_BADGE_SVG
        ),
    );
}

wp_localize_script(
    'affililabs-template-editor',
    'affililabs_template_editor',
    array(
        'template_id' => $template_id,
        'template_type' => $template_type,
        'modules' => $available_modules,
        'applied_table_ids' => $template_data['applied_table_ids'],
        'assets_url' => AFFILILABS_ASSETS_URL,
        'sample_image_url' => AFFILILABS_ASSETS_IMAGE_SVG,
        'nonce' => wp_create_nonce('affl_admin_nonce'),
        'ajax_render_action' => $template_type === 'comparison_table' ? 'affl_render_table_preview' : 'affl_render_single_product_preview',
        'initial_preview_table_id' => $initial_preview_table_id,
        'initial_preview_product_id' => $initial_preview_product_id,
        'i18n' => array(
            'loading_preview' => __('Loading preview...', 'affililabs'),
            'preview_error' => __('Error loading preview.', 'affililabs'),
            'no_tables_found' => __('No comparison tables found to preview.', 'affililabs'),
            'no_products_found' => __('No products found to preview.', 'affililabs'),
            'select_table_preview' => __('Select Table to Preview:', 'affililabs'),
            'select_product_preview' => __('Select Product to Preview:', 'affililabs'),
            'load_success_title' => __('Success', 'affililabs'),
            'load_success_message' => __('Template loaded successfully', 'affililabs'),
            'save_success_title' => __('Success', 'affililabs'),
            'save_success_message' => __('Template saved successfully', 'affililabs'),
            'save_error_title' => __('Error', 'affililabs'),
            'save_error_message' => __('Error saving template', 'affililabs'),
            'delete_row_confirm' => __('Are you sure you want to delete this row?', 'affililabs'),
            'delete_module_confirm' => __('Are you sure you want to remove this module?', 'affililabs'),
            'drag_here' => __('Drag elements here to build your template', 'affililabs'),
            'preview_updated' => __('Preview updated', 'affililabs'),
            'template_name_required' => __('Please enter a template name', 'affililabs'),
            'add_row' => __('Add Row', 'affililabs'),
            'add_column' => __('Add Column', 'affililabs'),
            'delete_row' => __('Delete Row', 'affililabs'),
            'delete_column' => __('Delete Column', 'affililabs'),
        )
    )
);
?>

<div class="affililabs-plugin template-editor">
    <?php $sidebar->render('templates'); ?>
    <main class="affililabs-plugin__main">
        <?php $navbar->render(); ?>
        
        <header class="affililabs-plugin__header">
            <h1><?php affl_print($template_id ? esc_html__('Edit Template', 'affililabs') : esc_html__('Create Template', 'affililabs')); ?></h1>
            <div class="affililabs-plugin__header-actions">
                <a href="<?php affl_print(esc_url(admin_url('admin.php?page=affililabs-templates'))); ?>" class="affililabs-plugin__button">
                    <img class="affililabs-plugin__button-icon" src="<?php affl_print(esc_url(AFFILILABS_ASSETS_ARROW_LEFT_SVG)); ?>" alt="<?php affl_print(esc_attr(__('Back', 'affililabs'))); ?>">
                    <span class="affililabs-plugin__button-text"><?php affl_print(esc_html(__('Back to Templates', 'affililabs'))); ?></span>
                </a>
                <button class="affililabs-plugin__button" id="save-template-button"><?php affl_print(esc_html(__('Save Template', 'affililabs'))); ?></button>
            </div>
        </header>
        
        <input type="hidden" id="template-id" value="<?php affl_print(esc_attr($template_id)); ?>">
        <input type="hidden" id="template-type" value="<?php affl_print(esc_attr($template_type)); ?>">
        
        <section class="template-editor__main-content">
            <div class="template-editor__top-panels">
                 <div class="template-editor__config-panel">
                    <div class="template-editor__config-section">
                        <h3><?php affl_print(esc_html(__('Basic Settings', 'affililabs'))); ?></h3>
                    <div class="template-editor__form-field">
                        <label for="template-name"><?php affl_print(esc_html(__('Template Name', 'affililabs'))); ?></label>
                        <input type="text" id="template-name" value="<?php affl_print(esc_attr($template_data['title'])); ?>" placeholder="<?php affl_print(esc_attr(__('Enter template name', 'affililabs'))); ?>">
                    </div>
                </div>
                
                <div class="template-editor__config-section">
                    <h3><?php affl_print(esc_html(__('Available Modules', 'affililabs'))); ?></h3>
                    <p class="template-editor__module-instruction"><?php affl_print(esc_html(__('Drag and drop these modules to the canvas', 'affililabs'))); ?></p>
                    
                    <div class="template-editor__modules-container">
                        <?php foreach ($available_modules as $module): ?>
                            <div class="template-editor__module" data-module-id="<?php affl_print(esc_attr($module['id'])); ?>" draggable="true">
                                <div class="template-editor__module-icon">
                                    <img src="<?php affl_print(esc_url($module['icon'])); ?>" alt="<?php affl_print(esc_attr($module['name'])); ?>">
                                </div>
                                <div class="template-editor__module-info">
                                    <h4><?php affl_print(esc_html($module['name'])); ?></h4>
                                    <p><?php affl_print(esc_html($module['description'])); ?></p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <?php if ($template_type === 'comparison_table') : ?>
                <div class="template-editor__config-section">
                    <h3><?php affl_print(esc_html(__('Apply Template To Tables', 'affililabs'))); ?></h3>
                    <p class="template-editor__module-instruction"><?php affl_print(esc_html(__('Select the comparison tables this template should apply to.', 'affililabs'))); ?></p>
                    <div class="template-editor__table-selector-container">
                        <?php if (!empty($comparison_tables_options)): ?>
                            <?php foreach ($comparison_tables_options as $id => $title): ?>
                                <div class="template-editor__table-selector-item">
                                    <input type="checkbox"
                                           id="apply-table-<?php affl_print(esc_attr($id)); ?>"
                                           name="applied_tables[]"
                                           value="<?php affl_print(esc_attr($id)); ?>"
                                           <?php checked(in_array($id, $template_data['applied_table_ids'])); ?>
                                           class="template-editor__table-checkbox">
                                    <label for="apply-table-<?php affl_print(esc_attr($id)); ?>"><?php affl_print(esc_html($title)); ?> (ID: <?php affl_print(esc_html($id)); ?>)</label>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <p><?php affl_print(esc_html(__('No comparison tables found.', 'affililabs'))); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                </div>
                

                <div class="template-editor__canvas-container">
                    <div class="template-editor__canvas-header">
                        <h3><?php affl_print(esc_html(__('Template Editor', 'affililabs'))); ?></h3>
                    </div>
                    
                    <div class="template-editor__canvas" id="template-canvas">
                        <div class="template-editor__empty-state" id="empty-canvas-message">
                            <img src="<?php affl_print(esc_url(AFFILILABS_ASSETS_PLUS_CIRCLE_SVG)); ?>" alt="Add content">
                            <p><?php affl_print(esc_html(__('Add a row and drag elements here to start building your template', 'affililabs'))); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="template-editor__preview-panel template-editor__preview-panel--bottom">
                <div class="template-editor__preview-header">
                    <div class="template-editor__preview-header-title-wrapper">
                        <h3><?php affl_print(esc_html(__('Live Preview', 'affililabs'))); ?></h3>
                        <span class="affililabs-tooltip"
                            aria-label="<?php affl_print(esc_attr__('This preview is a reference and may not be a perfect representation of the final page. Results can vary due to theme, other plugins, and dynamic content.', 'affililabs')); ?>">
                            <img
                                src="<?php affl_print(esc_url(AFFILILABS_ASSETS_QUESTION_MARK_SVG)); ?>"
                                alt="<?php affl_print(esc_attr__('Help', 'affililabs')); ?>"
                                width="16"
                                class="template-editor__preview-header-tooltip-icon"
                            >
                        </span>
                    </div>
                    <div class="template-editor__preview-controls">
                        <?php if ($template_type === 'comparison_table') : ?>
                            <?php if (!empty($comparison_tables_options)) : ?>
                                <label for="preview-table-select"><?php affl_print(esc_html(__('Table:', 'affililabs'))); ?></label>
                                <select id="preview-table-select">
                                    <option value=""><?php affl_print(esc_html(__('-- Choose a table --', 'affililabs'))); ?></option>
                                    <?php foreach ($comparison_tables_options as $id => $title) : ?>
                                        <option value="<?php affl_print(esc_attr($id)); ?>"><?php affl_print(esc_html($title)); ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <button type="button" id="refresh-preview-button" class="affililabs-plugin__button affililabs-plugin__button--secondary" title="<?php affl_print(esc_attr(__('Refresh Preview', 'affililabs'))); ?>">
                                    <span class="dashicons dashicons-update"></span>
                                </button>
                            <?php else : ?>
                                <p><?php affl_print(esc_html(__('No comparison tables found to preview.', 'affililabs'))); ?></p>
                            <?php endif; ?>
                        <?php else : ?>
                            <?php if (!empty($products_options)) : ?>
                                <label for="preview-product-select"><?php affl_print(esc_html(__('Product:', 'affililabs'))); ?></label>
                                <select id="preview-product-select">
                                    <option value=""><?php affl_print(esc_html(__('-- Choose a product --', 'affililabs'))); ?></option>
                                    <?php foreach ($products_options as $id => $title) : ?>
                                        <option value="<?php affl_print(esc_attr($id)); ?>"><?php affl_print(esc_html($title)); ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <button type="button" id="refresh-preview-button" class="affililabs-plugin__button affililabs-plugin__button--secondary" title="<?php affl_print(esc_attr(__('Refresh Preview', 'affililabs'))); ?>">
                                    <span class="dashicons dashicons-update"></span>
                                </button>
                            <?php else : ?>
                                <p><?php affl_print(esc_html(__('No products found to preview.', 'affililabs'))); ?></p>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="template-editor__preview-content" id="preview-container">
                    <div class="template-editor__preview-loading">
                        <p><?php affl_print(esc_html(__('Loading preview...', 'affililabs'))); ?></p>
                    </div>
                </div>

            </div>
        </section>
    </main>
</div>

<template id="row-template">
    <div class="template-editor__row" data-row-id="{row-id}">
        <div class="template-editor__row-header">
            <div class="template-editor__row-handle">
                <span class="dashicons dashicons-menu"></span>
            </div>
            <div class="template-editor__row-title">
                <?php affl_print(esc_html(__('Row', 'affililabs'))); ?> <span class="row-number"></span>
            </div>
            <div class="template-editor__row-actions">
                <button type="button" class="template-editor__row-action add-column" title="<?php affl_print(esc_attr(__('Add Column', 'affililabs'))); ?>">
                    <span class="dashicons dashicons-plus-alt"></span>
                </button>
                <button type="button" class="template-editor__row-action delete-row" title="<?php affl_print(esc_attr(__('Delete Row', 'affililabs'))); ?>">
                    <span class="dashicons dashicons-trash"></span>
                </button>
            </div>
        </div>
        <div class="template-editor__row-content">
        </div>
    </div>
</template>

<template id="column-template">
    <div class="template-editor__column" data-column-id="{column-id}">
        <div class="template-editor__column-header">
            <div class="template-editor__column-handle">
                <span class="dashicons dashicons-move"></span>
            </div>
            <div class="template-editor__column-actions">
                <button type="button" class="template-editor__column-action delete-column" title="<?php affl_print(esc_attr(__('Delete Column', 'affililabs'))); ?>">
                    <span class="dashicons dashicons-no"></span>
                </button>
            </div>
        </div>
        <div class="template-editor__dropzone" data-drop-id="{drop-id}">
            <div class="template-editor__dropzone-placeholder">
                <?php affl_print(esc_html(__('Drop module here', 'affililabs'))); ?>
            </div>
        </div>
    </div>
</template>

<template id="module-instance-template">
    <div class="template-editor__module-instance" data-module-type="{module-type}">
        <div class="template-editor__module-instance-header">
            <div class="template-editor__module-handle">
                <span class="dashicons dashicons-menu"></span>
            </div>
            <div class="template-editor__module-instance-title">{module-name}</div>
            <div class="template-editor__module-instance-actions">
                <button type="button" class="template-editor__module-instance-action delete-module" title="<?php affl_print(esc_attr(__('Remove Module', 'affililabs'))); ?>">
                    <span class="dashicons dashicons-no"></span>
                </button>
            </div>
        </div>
        <div class="template-editor__module-instance-content">
             <div class="template-editor__module-icon">
                 <img src="{module-icon}" alt="{module-name}">
             </div>
             <div class="template-editor__module-info">
                 <h4>{module-name}</h4>
             </div>
        </div>
    </div>
</template>
