<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

global $affl_fs;

$fs_plugin_id = affl_fs()->get_id() ?? 16031;
$fs   = freemius($fs_plugin_id);

$user                   = $fs->get_user();
$site                   = $fs->get_site();

$license                = $fs->_get_license();

if (is_object($license)) {
	$license_expiration		= $license->expiration;
    $secret_key             = $license->secret_key;
    $obsfucated_key         = '**************************' . substr($secret_key, -5);
} else {

    $license_expiration = null;
    $secret_key         = null;
    $obsfucated_key     = null;
}

$upgrade_url = affl_fs()->get_upgrade_url();

$name = ucfirst(esc_html(wp_get_current_user()->display_name ?? wp_get_current_user()->user_nicename)) ?? esc_html__('Visitor', 'affililabs');

if (is_object($user)) {
    $name = $user->get_name() ?? $name;
    $fs->_account_page_load();
}

affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_SERVICE_SETTINGS_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);


$sidebar = new AffiliLabs_Sidebar();
$sidebar->load_scripts();
$navbar = new AffiliLabs_Navbar();
$navbar->load_scripts();
$modal_component = new Affililabs_Modal();
$modal_component->load_scripts();
$modal_component->init();
$spinner_component = new Affililabs_Spinner();
$spinner_component->load_scripts();
$spinner_component->init();

wp_enqueue_style('affililabs-settings', AFFILILABS_SETTINGS_CSS_URL, array(), AFFILILABS_VERSION);
wp_enqueue_script('affililabs-settings', AFFILILABS_SETTINGS_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
wp_localize_script('affililabs-settings', 'affl_settings_data', array(
   'nonce'    => wp_create_nonce('affl_admin_nonce') ,
   'i18n'     => array(
       'save_success_title' => esc_html__('API Key Saved', 'affililabs'),
       'save_error_title' => esc_html__('Error Saving Key', 'affililabs'),
       'delete_success_title' => esc_html__('API Key Deleted', 'affililabs'),
       'delete_error_title' => esc_html__('Error Deleting Key', 'affililabs'),
       'ajax_error' => esc_html__('An unexpected error occurred while communicating with the server. Please try again.', 'affililabs'),
       'current_key_ends_with' => esc_html__('Current key ends with:', 'affililabs'),
       'confirm_delete_title' => esc_html__('Confirm Delete', 'affililabs'),
       'confirm_delete' => esc_html__('Are you sure you want to delete the API key?', 'affililabs'),
       'saving_product_slug' => esc_html__('Saving Product Slug...', 'affililabs'),
       'product_slug_save_success_message' => esc_html__('Product slug saved successfully. Please re-save your permalinks in WordPress settings if changes are not immediately visible.', 'affililabs'),
       'saving_api_key' => esc_html__('Saving API Key...', 'affililabs'),
       'api_key_saved_success_message' => esc_html__('API Key saved successfully.', 'affililabs'),
       'deleting_api_key' => esc_html__('Deleting API Key...', 'affililabs'),
       'api_key_deleted_success_message' => esc_html__('API Key deleted successfully.', 'affililabs'),
       'saving_debug_settings' => esc_html__('Saving Debug Settings...', 'affililabs'),
       'debug_settings_saved_success_message' => esc_html__('Debug settings saved successfully.', 'affililabs'),
       'saving_ai_language' => esc_html__('Saving AI Language Settings...', 'affililabs'),
       'ai_language_saved_success_message' => esc_html__('AI language settings saved successfully.', 'affililabs'),
       'saving_formatting_settings_loading' => esc_html__('Saving Formatting Settings...', 'affililabs'),
       'saving_archive_page_loading' => esc_html__('Saving Archive Page Settings...', 'affililabs'),
       'archive_page_settings_saved_message' => esc_html__('Archive page settings saved successfully.', 'affililabs'),
       'saving_op_elements_loading' => esc_html__('Saving Optimizepress Elements Settings...', 'affililabs'),
       'op_elements_saved_message' => esc_html__('Optimizepress Elements settings saved successfully.', 'affililabs'),
       'resetting_op_elements_loading' => esc_html__('Resetting Optimizepress Elements...', 'affililabs'),
       'reset_op_elements_success_message' => esc_html__('Optimizepress Global Elements reset successfully and integration disabled.', 'affililabs'),
       'confirm_reset_op_elements_title' => esc_html__('Confirm Reset', 'affililabs'),
       'confirm_reset_op_elements' => esc_html__('Are you sure you want to reset all AffiliLabs Optimizepress Global Elements? This will delete them and disable the integration.', 'affililabs'),
       'ajax_error_alert' => esc_html__('AJAX Error!', 'affililabs'),
       'saving_template_settings_loading' => esc_html__('Saving Template Settings...', 'affililabs'),
       'template_settings_saved_message' => esc_html__('Template settings saved successfully.', 'affililabs'),
       'saving_danger_zone_settings_loading' => esc_html__('Saving Danger Zone Settings...', 'affililabs'),
       'danger_zone_settings_saved_message' => esc_html__('Danger Zone settings saved successfully.', 'affililabs'),
   )
));

$current_api_key = AFFLSettingsService::get_internal_api_key();
$obfuscated_api_key = '';
if (!empty($current_api_key)) {
    $len = strlen($current_api_key);
    $obfuscated_api_key = str_repeat('*', max(0, $len - 5)) . substr($current_api_key, -5);
}

?>

<div class="affililabs-plugin">
    <?php $sidebar->render('settings'); ?>
    <main id="affililabs-plugin__settings" class="affililabs-plugin__main">
        <?php $navbar->render(); ?>

        <section class="affililabs-plugin__container">
            <div class="affililabs-plugin__card affililabs-plugin__card--info">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Hello', 'affililabs') . ' ' . esc_html($name)); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <?php if (affl_fs()->is_not_paying()) : ?>
                        <h2 class="affililabs-plugin__card__subtitle"><?php affl_print(esc_html__('You are on', 'affililabs') . ' ' . esc_html($fs->get_plan()->title ?? esc_html__('Free', 'affililabs')) . ' ' . esc_html__('plan', 'affililabs')); ?></h2>
                        <a href="<?php affl_print(esc_url($upgrade_url)); ?>" class="affililabs-plugin__button affililabs-plugin__button--primary">
                            <?php affl_print(esc_html__('UPGRADE YOUR PLAN', 'affililabs')); ?>
                        </a>
                    <?php elseif (affl_fs()->is_trial()) : ?>
                        <h2 class="affililabs-plugin__card__subtitle"><?php affl_print(esc_html__('You are on', 'affililabs') . ' ' . esc_html($fs->get_plan()->title)); ?> <?php affl_print(esc_html__('plan', 'affililabs')); ?></h2>
                    <?php elseif (affl_fs()->is_premium()) : ?>
                        <h2 class="affililabs-plugin__card__subtitle"><?php affl_print(esc_html__('You are on', 'affililabs') . ' ' . esc_html($fs->get_plan()->title)); ?> <?php affl_print(esc_html__('plan', 'affililabs')); ?></h2>
                        <?php if ($license_expiration) : ?>
                            <p class="affililabs-plugin__card__text">
                                <?php affl_print(esc_html__('License expires in:', 'affililabs') . ' ' . esc_html(human_time_diff(time(), strtotime($license_expiration)))); ?>
                            </p>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </section>

        <section class="affililabs-plugin__content-grid" style="display: none;">
            <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Product Box', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('Choose default template*', 'affililabs')); ?></p>
                </div>
            </div>
            <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Comparison Table', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('Choose default template*', 'affililabs')); ?></p>
                </div>
            </div>
            <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Marketplaces', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('This is Marketplaces settings*', 'affililabs')); ?></p>
                </div>
            </div>
        </section>

        <section class="affililabs-plugin__container">
             <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Debug Settings', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('Enable debug mode to log detailed information about plugin operations, errors, and API requests to the plugin\'s error log file. This is useful for troubleshooting and development purposes. Logs are saved in the /log directory within this plugin by default. They are also saved in the standard general log file.', 'affililabs')); ?></p>
                    <div class="affililabs-plugin__settings__input-group">
                        <label for="affl-enable-debug">
                            <input type="checkbox" id="affl-enable-debug" name="affl_enable_debug" value="1" <?php checked(1, get_option(AFFILILABS_ENABLE_DEBUG_OPTION, 0)); ?>>
                            <?php affl_print(esc_html__('Enable Debug Mode', 'affililabs')); ?>
                        </label>
                    </div>
                    <div class="affl-flex-between">
                      <button type="button" id="affl-save-debug-button" class="affililabs-plugin__button affililabs-plugin__button--primary">
                          <?php affl_print(esc_html__('Save Debug Settings', 'affililabs')); ?>
                      </button>
                    </div>
                </div>
            </div>
        </section>

        <section class="affililabs-plugin__container">
             <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('API Configuration', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('Enter your internal AffiliLabs Cloud API key. This key takes priority over the Freemius license key for specific internal operations. OBS: This key is not necessary for the operations of this plugin. Only add it if you are sure.', 'affililabs')); ?></p>
                    
                    <div style="margin-bottom: 15px;">
                        <label for="affl-internal-api-key" style="display: block; margin-bottom: 5px; font-weight: bold;"><?php affl_print(esc_html__('AffiliLabs Cloud API Key', 'affililabs')); ?></label>
                        <input type="text" id="affl-internal-api-key" name="affl_internal_api_key" class="regular-text" placeholder="<?php affl_print(esc_attr($obfuscated_api_key)); ?>" style="width: 100%; padding: 8px;">
                        <?php if (!empty($obfuscated_api_key)): ?>
                            <p class="description" style="font-size: 12px; color: #666;"><?php affl_print(esc_html__('Current key ends with:', 'affililabs') . ' ' . esc_html(substr($current_api_key, -5))); ?></p>
                        <?php endif; ?>
                    </div>


                    <div class="affl-flex-between">
                      <button type="button" id="affl-save-api-key-button" class="affililabs-plugin__button affililabs-plugin__button--primary">
                          <?php affl_print(esc_html__('Save API Key', 'affililabs')); ?>
                      </button>
                      <button type="button" id="affl-delete-api-key-button" class="affililabs-plugin__button affililabs-plugin__button--danger" <?php affl_print(empty($current_api_key) ? 'disabled' : ''); ?>><?php
                        affl_print(esc_html__('Delete API Key', 'affililabs'));
                      ?></button>
                    </div>
                </div>
            </div>
        </section>

        <section class="affililabs-plugin__container">
          <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Optimizepress Integration', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('Enable this option to register AffiliLabs product fields as global elements in Optimizepress, allowing them to be used as drag-and-drop blocks in the Optimizepress editor.', 'affililabs')); ?></p>
                    <div class="affililabs-plugin__card__info-message">
                        <p><?php
                            affl_print(
                                wp_kses(
                                    sprintf(
                                        /* translators: %s: URL to Optimizepress settings page */
                                        __('This is an experimental feature. To use it, you need to enable the AffiliLabs Products custom post type on Optimizepress settings at <a href="%s" target="_blank">Optimizepress Settings</a> and then save Optimizepress settings.', 'affililabs'),
                                        esc_url(admin_url('admin.php?page=op-dashboard-settings'))
                                    ),
                                    array('a' => array('href' => array(), 'target' => array()))
                                )
                            );
                        ?></p>
                    </div>
                    <div class="affililabs-plugin__settings__input-group">
                        <label for="affl-enable-op-global-elements">
                            <input type="checkbox" id="affl-enable-op-global-elements" name="affl_enable_op_global_elements" value="1" <?php checked(1, AFFLSettingsService::get_enable_op_global_elements()); ?>>
                            <?php affl_print(esc_html__('Enable AffiliLabs Product Field Global Elements', 'affililabs')); ?>
                        </label>
                    </div>
                    <div class="affl-flex-between">
                      <button type="button" id="affl-save-op-elements-button" class="affililabs-plugin__button affililabs-plugin__button--primary">
                          <?php affl_print(esc_html__('Save Optimizepress Elements Settings', 'affililabs')); ?>
                      </button>
                      <span aria-label="<?php affl_print(esc_attr__('Remove all AffiliLabs product field global elements from Optimizepress and disable this integration option.', 'affililabs')); ?>" class="affililabs-tooltip affililabs-tooltip--left">
                        <button type="button" id="affl-reset-op-elements-button" class="affililabs-plugin__button affililabs-plugin__button--danger">
                            <?php affl_print(esc_html__('Reset Optimizepress Elements', 'affililabs')); ?>
                        </button>
                      </span>
                    </div>
                </div>
            </div>
        </section>

        <section class="affililabs-plugin__container">
            <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Single Product Template', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('Enable this option to use the custom AffiliLabs template for single product pages. If this option is disabled, the default theme template will be used.', 'affililabs')); ?></p>
                    <div class="affililabs-plugin__settings__input-group">
                        <label for="affl-enable-custom-template">
                            <input type="checkbox" id="affl-enable-custom-template" name="affl_enable_custom_template" value="1" <?php checked(1, AFFLSettingsService::get_enable_custom_template()); ?>>
                            <?php affl_print(esc_html__('Enable Custom Product Template', 'affililabs')); ?>
                        </label>
                    </div>
                    <div class="affl-flex-between">
                        <button type="button" id="affl-save-custom-template-button" class="affililabs-plugin__button affililabs-plugin__button--primary">
                            <?php affl_print(esc_html__('Save Template Settings', 'affililabs')); ?>
                        </button>
                    </div>
                </div>
            </div>
        </section>

        <section class="affililabs-plugin__container">
             <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('AI Settings', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('Select the language for AI-powered actions. This will influence the language used in AI-generated content.', 'affililabs')); ?></p>
                    
                    <div class="affililabs-plugin__settings__input-group">
                        <label for="affl-ai-language"><?php affl_print(esc_html__('AI Action Language', 'affililabs')); ?></label>
                        <?php $current_ai_language = AFFLSettingsService::get_ai_language(); ?>
                        <select id="affl-ai-language" name="affl_ai_language" class="affililabs-plugin__settings__full-width-input">
                            <option value="english" <?php selected('english', $current_ai_language); ?>><?php affl_print(esc_html__('English', 'affililabs')); ?></option>
                            <option value="spanish" <?php selected('spanish', $current_ai_language); ?>><?php affl_print(esc_html__('Spanish', 'affililabs')); ?></option>
                            <option value="french" <?php selected('french', $current_ai_language); ?>><?php affl_print(esc_html__('French', 'affililabs')); ?></option>
                            <option value="portuguese" <?php selected('portuguese', $current_ai_language); ?>><?php affl_print(esc_html__('Portuguese', 'affililabs')); ?></option>
                            <option value="german" <?php selected('german', $current_ai_language); ?>><?php affl_print(esc_html__('German', 'affililabs')); ?></option>
                            <option value="italian" <?php selected('italian', $current_ai_language); ?>><?php affl_print(esc_html__('Italian', 'affililabs')); ?></option>
                            <option value="russian" <?php selected('russian', $current_ai_language); ?>><?php affl_print(esc_html__('Russian', 'affililabs')); ?></option>
                            <option value="polish" <?php selected('polish', $current_ai_language); ?>><?php affl_print(esc_html__('Polish', 'affililabs')); ?></option>
                            <option value="greek" <?php selected('greek', $current_ai_language); ?>><?php affl_print(esc_html__('Greek', 'affililabs')); ?></option>
                            <option value="hindi" <?php selected('hindi', $current_ai_language); ?>><?php affl_print(esc_html__('Hindi', 'affililabs')); ?></option>
                            <option value="urdu" <?php selected('urdu', $current_ai_language); ?>><?php affl_print(esc_html__('Urdu', 'affililabs')); ?></option>
                            <option value="bengali" <?php selected('bengali', $current_ai_language); ?>><?php affl_print(esc_html__('Bengali', 'affililabs')); ?></option>
                            <option value="turkish" <?php selected('turkish', $current_ai_language); ?>><?php affl_print(esc_html__('Turkish', 'affililabs')); ?></option>
                            <option value="standard_arabic" <?php selected('standard_arabic', $current_ai_language); ?>><?php affl_print(esc_html__('Standard Arabic', 'affililabs')); ?></option>
                            <option value="mandarin_chinese" <?php selected('mandarin_chinese', $current_ai_language); ?>><?php affl_print(esc_html__('Mandarin Chinese', 'affililabs')); ?></option>
                            <option value="japanese" <?php selected('japanese', $current_ai_language); ?>><?php affl_print(esc_html__('Japanese', 'affililabs')); ?></option>
                            <option value="korean" <?php selected('korean', $current_ai_language); ?>><?php affl_print(esc_html__('Korean', 'affililabs')); ?></option>
                            <option value="other" <?php selected('other', $current_ai_language); ?>><?php affl_print(esc_html__('Other (specify below)', 'affililabs')); ?></option>
                        </select>
                    </div>

                    <div class="affililabs-plugin__settings__input-group" id="affl-custom-language-group" style="display: <?php affl_print($current_ai_language === 'other' ? 'block' : 'none'); ?>;">
                        <label for="affl-custom-language"><?php affl_print(esc_html__('Custom Language', 'affililabs')); ?></label>
                        <input type="text" id="affl-custom-language" name="affl_custom_language" class="regular-text affililabs-plugin__settings__full-width-input" value="<?php affl_print(esc_attr($current_ai_language === 'other' ? AFFLSettingsService::get_ai_language() : '')); ?>">
                    </div>

                    <div class="affl-flex-between">
                      <button type="button" id="affl-save-ai-language-button" class="affililabs-plugin__button affililabs-plugin__button--primary">
                          <?php affl_print(esc_html__('Save AI Settings', 'affililabs')); ?>
                      </button>
                    </div>
                </div>
            </div>
        </section>

        <section class="affililabs-plugin__container">
            <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Formatting Settings', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('Select the default separator for lists like Pros, Cons, and Short Features.', 'affililabs')); ?></p>
                    
                    <div class="affililabs-plugin__settings__input-group">
                        <label for="affl-list-separator"><?php affl_print(esc_html__('List Separator', 'affililabs')); ?></label>
                        <?php $current_list_separator = AFFLSettingsService::get_list_separator(); ?>
                        <select id="affl-list-separator" name="affl_list_separator" class="affililabs-plugin__settings__full-width-input">
                            <option value="newline" <?php selected('newline', $current_list_separator); ?>><?php affl_print(esc_html__('Newline', 'affililabs')); ?></option>
                            <option value="comma" <?php selected('comma', $current_list_separator); ?>><?php affl_print(esc_html__('Comma', 'affililabs')); ?></option>
                        </select>
                    </div>

                    <div class="affl-flex-between">
                      <button type="button" id="affl-save-list-separator-button" class="affililabs-plugin__button affililabs-plugin__button--primary">
                          <?php affl_print(esc_html__('Save Formatting Settings', 'affililabs')); ?>
                      </button>
                    </div>
                </div>
            </div>
        </section>

        <section class="affililabs-plugin__container">
             <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Archive Page Settings', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__("Enable this option to create a dedicated page at /products/category/ that lists all top-level product categories. This makes it easier for your visitors to navigate and discover categories.", 'affililabs')); ?></p>
                    <div class="affililabs-plugin__settings__input-group">
                        <label for="affl-enable-all-categories-page">
                            <input type="checkbox" id="affl-enable-all-categories-page" name="affl_enable_all_categories_page" value="1" <?php checked(1, AFFLSettingsService::get_enable_all_categories_page()); ?>>
                            <?php affl_print(esc_html__("Enable 'All Categories' Page", 'affililabs')); ?>
                        </label>
                    </div>
                    <div class="affl-flex-between">
                      <button type="button" id="affl-save-all-categories-setting-button" class="affililabs-plugin__button affililabs-plugin__button--primary">
                          <?php affl_print(esc_html__('Save Archive Page Settings', 'affililabs')); ?>
                      </button>
                    </div>
                </div>
            </div>
        </section>
        <section class="affililabs-plugin__container">
             <div class="affililabs-plugin__card">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title"><?php affl_print(esc_html__('Permalink Settings', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('Customize the slug for your product URLs. After changing, you must re-save your permalinks in WordPress settings for changes to take effect.', 'affililabs')); ?></p>
                    
                    <div class="affililabs-plugin__settings__input-group">
                        <label for="affl-product-slug"><?php affl_print(esc_html__('Product Slug', 'affililabs')); ?></label>
                        <input type="text" id="affl-product-slug" name="affl_product_slug" class="regular-text affililabs-plugin__settings__full-width-input" value="<?php affl_print(esc_attr(get_option(AFFILILABS_PRODUCT_SLUG_OPTION, AFFILILABS_CPT_PRODUCT))); ?>">
                    </div>


                    <h3 class="affililabs-plugin__card__subtitle" style="margin-top: 20px;"><?php affl_print(esc_html__('Advanced', 'affililabs')); ?></h3>
                    <div class="affililabs-plugin__card__info-message" style="background-color: #fff5f5; border-left: 4px solid #dc3232;">
                        <p style="color: #dc3232; margin: 0;"><?php affl_print(esc_html__('Warning! Enabling this "hide" option can cause conflicts with other pages and posts. Use with caution.', 'affililabs')); ?></p>
                    </div>
                    
                    <div class="affililabs-plugin__settings__input-group">
                        <label for="affl-hide-product-slug">
                            <input type="checkbox" id="affl-hide-product-slug" name="affl_hide_product_slug" value="1" <?php checked(1, get_option(AFFILILABS_HIDE_PRODUCT_SLUG_OPTION, 0)); ?>>
                            <?php affl_print(esc_html__('Completely hide the product slug from the URL', 'affililabs')); ?>
                        </label>
                    </div>

                    <div class="affl-flex-between">
                      <button type="button" id="affl-save-product-slug-button" class="affililabs-plugin__button affililabs-plugin__button--primary">
                          <?php affl_print(esc_html__('Save Product Slug', 'affililabs')); ?>
                      </button>
                      <a href="<?php affl_print(esc_url(admin_url('options-permalink.php'))); ?>" class="affililabs-plugin__button affililabs-plugin__button--secondary">
                          <?php affl_print(esc_html__('Go to Permalinks Settings', 'affililabs')); ?>
                      </a>
                    </div>
                </div>
            </div>
        </section>

        <section class="affililabs-plugin__container">
            <div class="affililabs-plugin__card" style="border-left: 4px solid #dc3232; background-color: #fff5f5;">
                <div class="affililabs-plugin__card__header">
                    <h1 class="affililabs-plugin__card__title" style="color: #dc3232;"><?php affl_print(esc_html__('Danger Zone', 'affililabs')); ?></h1>
                </div>
                <div class="affililabs-plugin__card__body">
                    <p class="affililabs-plugin__card__text"><?php affl_print(esc_html__('Enable this option to delete all AffiliLabs data (options, products, logs, etc.) when you uninstall the plugin. This action is irreversible.', 'affililabs')); ?></p>
                    <div class="affililabs-plugin__settings__input-group">
                        <label for="affl-cleanup-on-uninstall">
                            <input type="checkbox" id="affl-cleanup-on-uninstall" name="affl_cleanup_on_uninstall" value="1" <?php checked(1, get_option('affililabs_cleanup_on_uninstall', 0)); ?>>
                            <?php affl_print(esc_html__('Delete all data on uninstall', 'affililabs')); ?>
                        </label>
                    </div>
                    <div class="affl-flex-between">
                        <button type="button" id="affl-save-cleanup-setting-button" class="affililabs-plugin__button affililabs-plugin__button--danger">
                            <?php affl_print(esc_html__('Save Danger Zone Settings', 'affililabs')); ?>
                        </button>
                    </div>
                </div>
            </div>
        </section>

        <?php if (is_object($user)) : ?>
        <section class="affililabs-plugin__account">
            <div class="affililabs-plugin__card">
                <?php $fs->_account_page_render(); ?>
            </div>
        </section>
        <?php endif; ?>
    </main>
</div>
