jQuery(document).ready(function ($) {
    const {
      save_success_title,
      save_error_title,
      delete_success_title,
      delete_error_title,
      ajax_error,
      current_key_ends_with,
      confirm_delete,
      confirm_delete_title,
      product_slug_save_success,
      product_slug_save_error,
      saving_product_slug,
      product_slug_save_success_message,
      saving_api_key,
      api_key_saved_success_message,
      deleting_api_key,
      api_key_deleted_success_message,
      saving_debug_settings,
      debug_settings_saved_success_message,
      ajax_error_alert,
      saving_ai_language,
      ai_language_saved_success_message,
      saving_formatting_settings_loading,
      saving_archive_page_loading,
      archive_page_settings_saved_message,
      saving_op_elements_loading,
      op_elements_saved_message,
      resetting_op_elements_loading,
      reset_op_elements_success_message,
      confirm_reset_op_elements_title,
      confirm_reset_op_elements,
      saving_template_settings_loading,
      template_settings_saved_message,
      saving_danger_zone_settings_loading,
      danger_zone_settings_saved_message,
    } = affl_settings_data.i18n;
    const { nonce } = affl_settings_data;

    const save_api_key_button = $('#affl-save-api-key-button');
    const delete_api_key_button = $('#affl-delete-api-key-button');
    const api_key_input = $('#affl-internal-api-key');
    const save_debug_button = $('#affl-save-debug-button');
    const enable_debug_checkbox = $('#affl-enable-debug');
    const save_product_slug_button = $('#affl-save-product-slug-button');
    const product_slug_input = $('#affl-product-slug');
    const hide_product_slug_checkbox = $('#affl-hide-product-slug');
    const ai_language_select = $('#affl-ai-language');
    const custom_language_input = $('#affl-custom-language');
    const custom_language_group = $('#affl-custom-language-group');
    const save_ai_language_button = $('#affl-save-ai-language-button');
    const list_separator_select = $('#affl-list-separator');
    const save_list_separator_button = $('#affl-save-list-separator-button');
    const save_all_categories_setting_button = $('#affl-save-all-categories-setting-button');
    const enable_all_categories_page_checkbox = $('#affl-enable-all-categories-page');
    const save_op_elements_button = $('#affl-save-op-elements-button');
    const reset_op_elements_button = $('#affl-reset-op-elements-button');
    const enable_op_global_elements_checkbox = $('#affl-enable-op-global-elements');
    const save_custom_template_button = $('#affl-save-custom-template-button');
    const enable_custom_template_checkbox = $('#affl-enable-custom-template');
    const modal = window.affililabs_modal;
    const spinner = window.affililabs_spinner;

    if (ai_language_select.val() === 'other') {
        custom_language_group.show();
    } else {
        custom_language_group.hide();
    }

    ai_language_select.on('change', function() {
        if ($(this).val() === 'other') {
            custom_language_group.slideDown();
        } else {
            custom_language_group.slideUp();
        }
    });

    save_ai_language_button.on('click', function() {
        let ai_language = ai_language_select.val();
        if (ai_language === 'other') {
            ai_language = custom_language_input.val().trim();
        }

        if (spinner) {
            spinner.show(saving_ai_language);
        }
        save_ai_language_button.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'affl_save_ai_language',
                nonce: nonce,
                ai_language: ai_language
            },
            success: function(response) {
                if (spinner) {
                    spinner.hide();
                }

                if (response.data.status === 'ok') {
                    if (modal) {
                        modal.success(save_success_title, response.data.message || ai_language_saved_success_message);
                    }
                } else {
                    console.error('[Response.status.error] Error saving AI language settings:', response.data);
                    const error_text = response.data && response.data.message ? response.data.message : ajax_error;
                    if (modal) modal.error(save_error_title, error_text);
                }
            },
            error: function(jq_xhr, text_status, error_thrown) {
                if (spinner) {
                    spinner.hide();
                }
                console.error("AJAX Error saving AI language settings:", text_status, error_thrown, jq_xhr);
                if (!modal) {
                    console.error("AffiliLabs Modal object not found.");
                    alert(ajax_error_alert);
                    return;
                }
                const error_text = jq_xhr.data.message || ajax_error;
                if (modal) modal.error(save_error_title, error_text);
            },
            complete: function() {
                if (spinner) {
                    spinner.hide();
                }
                save_ai_language_button.prop('disabled', false);
            }
        });
    });

    save_product_slug_button.on('click', function() {
        const product_slug = product_slug_input.val().trim();
        const hide_product_slug = hide_product_slug_checkbox.is(':checked') ? 1 : 0;
    
        if (spinner) {
            spinner.show(saving_product_slug);
        }
        save_product_slug_button.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'affl_save_product_slug',
                nonce: nonce,
                product_slug: product_slug,
                hide_product_slug: hide_product_slug
            },
            success: function(response) {
                if (spinner) {
                    spinner.hide();
                }

                if (response.data.status === 'ok') {
                    if (modal) {
                        modal.success(product_slug_save_success, product_slug_save_success_message);
                    }
                } else {
                    console.error('[Response.status.error] Error saving product slug:', response.data);
                    const error_text = response.data && response.data.message ? response.data.message : ajax_error;
                    if (modal) modal.error(product_slug_save_error, error_text);
                }
            },
            error: function(jq_xhr, text_status, error_thrown) {
                if (spinner) {
                    spinner.hide();
                }
                console.error("AJAX Error saving product slug:", text_status, error_thrown, jq_xhr);
                if (!modal) {
                    console.error("AffiliLabs Modal object not found.");
                    alert(ajax_error_alert);
                    return;
                }
                const error_text = jq_xhr.response_json && jq_xhr.response_json.data && jq_xhr.response_json.data.message ? jq_xhr.response_json.data.message : ajax_error;
                if (modal) modal.error(product_slug_save_error, error_text);
            },
            complete: function() {
                if (spinner) {
                    spinner.hide();
                }
                save_product_slug_button.prop('disabled', false);
            }
        });
    });

    save_api_key_button.on('click', function () {
        const api_key = api_key_input.val().trim();

        if (spinner) {
            spinner.show(saving_api_key);
        }
        save_api_key_button.prop('disabled', true);
        console.log('Saving API Key:', api_key);
        console.log({modal, spinner});

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'affl_save_internal_api_key',
                nonce: nonce,
                api_key: api_key
            },
            success: function (response) {
                if (spinner) {
                    spinner.hide();
                }

                if (response.data.status === 'ok') {
                    if(modal) {
                      modal.success(save_success_title, response.data.message || api_key_saved_success_message);
                    }

                    const obfuscated_key = response.data && response.data.obfuscated_key ? response.data.obfuscated_key : '';
                    const last_five = response.data && response.data.last_five ? response.data.last_five : '';
                    
                    api_key_input.attr('placeholder', obfuscated_key);
                    api_key_input.val('');

                    const description_p = api_key_input.next('p.description');
                    const desc_text = current_key_ends_with || 'Current key ends with:';
                    if (last_five) {
                         if (description_p.length) {
                            description_p.text(desc_text + ' ' + last_five);
                         } else {
                             $('<p class="description" style="font-size: 12px; color: #666;"></p>')
                                 .text(desc_text + ' ' + last_five)
                                 .insertAfter(api_key_input);
                         }
                        delete_api_key_button.prop('disabled', false);
                    } else {
                        description_p.remove();
                        delete_api_key_button.prop('disabled', true);
                    }
                } else {
                    console.error('[Response.status.error] Error saving API key:', response.data);
                    const error_text = response.data && response.data.message ? response.data.message : ajax_error;
                    if (modal) modal.error(save_error_title, error_text);
                }
            },
            error: function (jq_xhr, text_status, error_thrown) {
                 if (spinner) {
                    spinner.hide();
                }
                console.error("Response.Error:", text_status, error_thrown, jq_xhr);
                
                if (!modal) {
                    console.error("AffiliLabs Modal object not found.");
                    alert(ajax_error_alert);
                    return;
                }

                const error_text = jq_xhr.data.message || ajax_error;
                if (modal) modal.error(save_error_title, error_text);
            },
            complete: function () {
                if (spinner) {
                    spinner.hide();
                }
                save_api_key_button.prop('disabled', false);
            }
        });
    });

    delete_api_key_button.on('click', function(){
        if (modal.confirm) {
            modal.confirm(confirm_delete_title, confirm_delete, function() {
                delete_api_key();
            });
        } else {
            if (confirm(confirm_delete)) {
                delete_api_key();
            }
        }
    });

    function delete_api_key() {
      if (spinner) {
          spinner.show(deleting_api_key);
      }
      delete_api_key_button.prop('disabled', true);

      $.ajax({
          url: ajaxurl,
          type: 'POST',
          data: {
              action: 'affl_delete_internal_api_key',
              nonce: nonce
          },
          success: function(response) {
              if (spinner) spinner.hide();

              if (response.data.status === 'ok') {
                  if (modal) {
                      modal.success(delete_success_title, response.data.message || api_key_deleted_success_message);
                  }
                  api_key_input.attr('placeholder', '');
                  api_key_input.val('');
                  api_key_input.next('p.description').remove();
              } else {
                  console.error('[Response.status.error] Error deleting API key:', response.data);
                  const error_message_text = response.data && response.data.message ? response.data.message : ajax_error;
                  if (modal) {
                      modal.error(delete_error_title, error_message_text);
                  }
                  delete_api_key_button.prop('disabled', false);
              }
            },
            error: function(jq_xhr, text_status, error_thrown) {
                if (spinner) spinner.hide();
                console.error("AJAX Error deleting API key:", text_status, error_thrown, jq_xhr.responseText);
                 if (modal) {
                    modal.error(delete_error_title, ajax_error);
                }
                delete_api_key_button.prop('disabled', false);
            },
            complete: function() {
                if (spinner) spinner.hide();
            }
        });
    }
    save_debug_button.on('click', function() {
        const is_debug_enabled = enable_debug_checkbox.is(':checked') ? 1 : 0;

        if (spinner) {
            spinner.show(saving_debug_settings);
        }
        save_debug_button.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'affl_save_debug_mode',
                nonce: nonce,
                enable_debug: is_debug_enabled
            },
            success: function(response) {
                if (spinner) {
                    spinner.hide();
                }

                if (response.data.status === 'ok') {
                    if (modal) {
                        modal.success(save_success_title, response.data.message || debug_settings_saved_success_message);
                    }
                } else {
                    console.error('[Response.status.error] Error saving debug settings:', response.data);
                    const error_text = response.data && response.data.message ? response.data.message : ajax_error;
                    if (modal) modal.error(save_error_title, error_text);
                }
            },
            error: function(jq_xhr, text_status, error_thrown) {
                if (spinner) {
                    spinner.hide();
                }
                console.error("AJAX Error saving debug settings:", text_status, error_thrown, jq_xhr);
                if (!modal) {
                    console.error("AffiliLabs Modal object not found.");
                    alert(ajax_error_alert);
                    return;
                }
                const error_text = jq_xhr.data.message || ajax_error;
                if (modal) modal.error(save_error_title, error_text);
            },
            complete: function() {
                if (spinner) {
                    spinner.hide();
                }
                save_debug_button.prop('disabled', false);
            }
        });
    });

    save_list_separator_button.on('click', function() {
        const list_separator = list_separator_select.val();

        if (spinner) {
            spinner.show(saving_formatting_settings_loading);
        }
        save_list_separator_button.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'affl_save_list_separator',
                nonce: nonce,
                list_separator: list_separator
            },
            success: function(response) {
                if (spinner) {
                    spinner.hide();
                }

                if (response.data.status === 'ok') {
                    if (modal) {
                        modal.success(save_success_title, response.data.message || 'Formatting settings saved successfully.');
                    }
                } else {
                    console.error('[Response.status.error] Error saving formatting settings:', response.data);
                    const error_text = response.data && response.data.message ? response.data.message : ajax_error;
                    if (modal) modal.error(save_error_title, error_text);
                }
            },
            error: function(jq_xhr, text_status, error_thrown) {
                if (spinner) {
                    spinner.hide();
                }
                console.error("AJAX Error saving formatting settings:", text_status, error_thrown, jq_xhr);
                if (!modal) {
                    console.error("AffiliLabs Modal object not found.");
                    alert(ajax_error_alert);
                    return;
                }
                const error_text = jq_xhr.data.message || ajax_error;
                if (modal) modal.error(save_error_title, error_text);
            },
            complete: function() {
                if (spinner) {
                    spinner.hide();
                }
                save_list_separator_button.prop('disabled', false);
            }
        });
    });

    save_all_categories_setting_button.on('click', function() {
        const enable_all_categories_page = enable_all_categories_page_checkbox.is(':checked') ? 1 : 0;

        if (spinner) {
            spinner.show(saving_archive_page_loading);
        }
        save_all_categories_setting_button.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'affl_save_enable_all_categories_page',
                nonce: nonce,
                enable_all_categories_page: enable_all_categories_page
            },
            success: function(response) {
                if (spinner) {
                    spinner.hide();
                }

                if (response.data.status === 'ok') {
                    if (modal) {
                        modal.success(save_success_title, response.data.message || archive_page_settings_saved_message);
                    }
                } else {
                    console.error('[Response.status.error] Error saving archive page settings:', response.data);
                    const error_text = response.data && response.data.message ? response.data.message : ajax_error;
                    if (modal) modal.error('Error', error_text);
                }
            },
            error: function(jq_xhr, text_status, error_thrown) {
                if (spinner) {
                    spinner.hide();
                }
                console.error("AJAX Error saving archive page settings:", text_status, error_thrown, jq_xhr);
                if (!modal) {
                    console.error("AffiliLabs Modal object not found.");
                    alert(ajax_error_alert);
                    return;
                }
                const error_text = jq_xhr.data.message || ajax_error;
                if (modal) modal.error('Error', error_text);
            },
            complete: function() {
                if (spinner) {
                    spinner.hide();
                }
                save_all_categories_setting_button.prop('disabled', false);
            }
        });
    });

    save_op_elements_button.on('click', function() {
        if (save_op_elements_button.prop('disabled')) {
            return;
        }

        const enable_op_global_elements = enable_op_global_elements_checkbox.is(':checked') ? 1 : 0;
        
        if (spinner) {
            spinner.show(saving_op_elements_loading);
        }

        save_op_elements_button.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'affl_save_enable_op_global_elements',
                nonce: nonce,
                enable_op_global_elements: enable_op_global_elements
            },
            success: function(response) {
                if (spinner) {
                    spinner.hide();
                }

                if (response.data.status === 'ok') {
                    if (modal) {
                        modal.success(save_success_title, response.data.message || op_elements_saved_message);
                    }
                } else {
                    console.error('[Response.status.error] Error saving Optimizepress elements settings:', response.data);
                    const error_text = response.data && response.data.message ? response.data.message : ajax_error;
                    if (modal) modal.error(save_error_title, error_text);
                }
            },
            error: function(jq_xhr, text_status, error_thrown) {
                if (spinner) {
                    spinner.hide();
                }
                console.error("AJAX Error saving Optimizepress elements settings:", text_status, error_thrown, jq_xhr);
                if (!modal) {
                    console.error("AffiliLabs Modal object not found.");
                    alert(ajax_error_alert);
                } else {
                    const error_text = jq_xhr.data.message || ajax_error;
                    if (modal) modal.error(save_error_title, error_text);
                }
            },
            complete: function() {
                if (spinner) {
                    spinner.hide();
                }
                save_op_elements_button.prop('disabled', false);
            }
        });
    });

    reset_op_elements_button.on('click', function() {
        if (modal.confirm) {
            modal.confirm(confirm_reset_op_elements_title, confirm_reset_op_elements, function() {
                reset_op_elements();
            });
        } else {
            if (confirm(confirm_reset_op_elements)) {
                reset_op_elements();
            }
        }
    });

    function reset_op_elements() {
        if (spinner) {
            spinner.show(resetting_op_elements_loading);
        }
        reset_op_elements_button.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'affl_reset_op_global_elements',
                nonce: nonce
            },
            success: function(response) {
                if (spinner) {
                    spinner.hide();
                }

                if (response.data.status === 'ok') {
                    if (modal) {
                        modal.success(save_success_title, response.data.message || reset_op_elements_success_message);
                    }
                    enable_op_global_elements_checkbox.prop('checked', false); // Uncheck the checkbox
                } else {
                    console.error('[Response.status.error] Error resetting Optimizepress elements:', response.data);
                    const error_text = response.data && response.data.message ? response.data.message : ajax_error;
                    if (modal) modal.error(save_error_title, error_text);
                }
            },
            error: function(jq_xhr, text_status, error_thrown) {
                if (spinner) {
                    spinner.hide();
                }
                console.error("AJAX Error resetting Optimizepress elements:", text_status, error_thrown, jq_xhr);
                if (!modal) {
                    console.error("AffiliLabs Modal object not found.");
                    alert(ajax_error_alert);
                } else {
                    const error_text = jq_xhr.data.message || ajax_error;
                    if (modal) modal.error(save_error_title, error_text);
                }
            },
            complete: function() {
                if (spinner) {
                    spinner.hide();
                }
                reset_op_elements_button.prop('disabled', false);
            }
        });
    }

    save_custom_template_button.on('click', function() {
        const enable_custom_template = enable_custom_template_checkbox.is(':checked') ? 1 : 0;

        if (spinner) {
            spinner.show(saving_template_settings_loading);
        }
        save_custom_template_button.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'affl_save_enable_custom_template',
                nonce: nonce,
                enable_custom_template: enable_custom_template
            },
            success: function(response) {
                if (spinner) {
                    spinner.hide();
                }

                if (response.data.status === 'ok') {
                    if (modal) {
                        modal.success(save_success_title, response.data.message || template_settings_saved_message);
                    }
                } else {
                    console.error('[Response.status.error] Error saving template settings:', response.data);
                    const error_text = response.data && response.data.message ? response.data.message : ajax_error;
                    if (modal) modal.error(save_error_title, error_text);
                }
            },
            error: function(jq_xhr, text_status, error_thrown) {
                if (spinner) {
                    spinner.hide();
                }
                console.error("AJAX Error saving template settings:", text_status, error_thrown, jq_xhr);
                if (!modal) {
                    console.error("AffiliLabs Modal object not found.");
                    alert(ajax_error_alert);
                    return;
                }
                const error_text = jq_xhr.data.message || ajax_error;
                if (modal) modal.error(save_error_title, error_text);
            },
            complete: function() {
                if (spinner) {
                    spinner.hide();
                }
                save_custom_template_button.prop('disabled', false);
            }
        });
    });

    const save_cleanup_setting_button = $('#affl-save-cleanup-setting-button');
    const cleanup_on_uninstall_checkbox = $('#affl-cleanup-on-uninstall');

    save_cleanup_setting_button.on('click', function() {
        const cleanup_on_uninstall = cleanup_on_uninstall_checkbox.is(':checked') ? 1 : 0;

        if (spinner) {
            spinner.show(saving_danger_zone_settings_loading);
        }
        save_cleanup_setting_button.prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'affililabs_save_cleanup_on_uninstall',
                nonce: nonce,
                cleanup_on_uninstall: cleanup_on_uninstall
            },
            success: function(response) {
                if (spinner) {
                    spinner.hide();
                }

                if (response.data.status === 'ok') {
                    if (modal) {
                        modal.success(save_success_title, response.data.message || danger_zone_settings_saved_message);
                    }
                } else {
                    console.error('[Response.status.error] Error saving cleanup settings:', response.data);
                    const error_text = response.data && response.data.message ? response.data.message : ajax_error;
                    if (modal) modal.error(save_error_title, error_text);
                }
            },
            error: function(jq_xhr, text_status, error_thrown) {
                if (spinner) {
                    spinner.hide();
                }
                console.error("AJAX Error saving cleanup settings:", text_status, error_thrown, jq_xhr);
                if (!modal) {
                    console.error("AffiliLabs Modal object not found.");
                    alert(ajax_error_alert);
                    return;
                }
                const error_text = jq_xhr.data.message || ajax_error;
                if (modal) modal.error(save_error_title, error_text);
            },
            complete: function() {
                if (spinner) {
                    spinner.hide();
                }
                save_cleanup_setting_button.prop('disabled', false);
            }
        });
    });
});
