<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);
affl_import(AFFILILABS_SERVICE_MARKETPLACES);

$products_args = array(
    'post_type' => AFFILILABS_CPT_PRODUCT,
    'posts_per_page' => -1,
);
$products_query = new WP_Query($products_args);
$products = $products_query->posts;

$categories = get_terms(array(
    'taxonomy' => AFFILILABS_TAXONOMY_PRODUCT_CATEGORY,
    'hide_empty' => false,
));

$marketplaces_args = array(
    'post_type' => AFFILILABS_CPT_MARKETPLACE,
    'posts_per_page' => -1,
);
$marketplaces_query = new WP_Query($marketplaces_args);
$marketplaces = $marketplaces_query->posts; // @TODO: Keep this for the filter dropdown below, maybe refactor later

 $all_marketplaces = AFFLMarketplaceService::get_all_marketplaces(['orderby' => 'name', 'order' => 'ASC']);
 $digistore_marketplace_id = null;
 $finder_marketplaces = [];
 $digistore_affiliate_id = null;

     $digistore_marketplace_id = get_option(AFFILILABS_DIGISTORE_MARKETPLACE_ID, null);
     $finder_marketplaces = array_filter($all_marketplaces, function($marketplace) use ($digistore_marketplace_id) {
         return !empty($digistore_marketplace_id) && $marketplace['id'] == $digistore_marketplace_id;
     });

     if ($digistore_marketplace_id > 1) {
         $digistore_affiliate_id = get_post_meta($digistore_marketplace_id, AFFILILABS_META_KEY_MARKETPLACE_AFFILIATE_ID, true);
     }

$sidebar = new AffiliLabs_Sidebar();
$sidebar->load_scripts();
$navbar = new AffiliLabs_Navbar();
$navbar->load_scripts();
$button = new AffiliLabs_Button();
$modal = new AffiliLabs_Modal();
$modal->load_scripts();
$modal->init();
$spinner = new AffiliLabs_Spinner();
$spinner->load_scripts();
$spinner->init();
$video_frame = new AffiliLabs_VideoFrame();
$video_frame->load_scripts();
$video_frame->init();

 wp_enqueue_media();
 wp_enqueue_style('affililabs-products-edit', AFFILILABS_PRODUCTS_EDIT_CSS_URL, array(), AFFILILABS_VERSION);
 wp_enqueue_style('affililabs-products', AFFILILABS_PRODUCTS_CSS_URL, array(), AFFILILABS_VERSION);
 wp_enqueue_script('affililabs-products', AFFILILABS_PRODUCTS_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
 wp_localize_script('affililabs-products', 'affililabs_products', array(
     'find_products_nonce' => wp_create_nonce('affl_admin_nonce'),
     'find_products_action' => 'affl_find_products',
     'save_imported_product_action' => 'affililabs_save_product',
     'digistore_marketplace_id' => $digistore_marketplace_id,
     'digistore_affiliate_id' => $digistore_affiliate_id,
     'i18n' => array(
         'delete' => esc_html__('Delete', 'affililabs'),
         'delete_confirm' => esc_html__('Are you sure you want to delete this product?', 'affililabs'),
         'delete_success' => esc_html__('Product deleted successfully.', 'affililabs'),
         'delete_error' => esc_html__('Error deleting product.', 'affililabs'),
         'delete_error_unknown' => esc_html__('An error occurred while trying to delete the product.', 'affililabs'),
         'import_success_title' => esc_html__('Success', 'affililabs'),
         'import_success_message' => esc_html__('Product imported successfully.', 'affililabs'),
         'error' => esc_html__('Error', 'affililabs'),
         'no_products_found' => esc_html__('No products found matching your criteria.', 'affililabs'),
         'finding_products' => esc_html__('Finding products...', 'affililabs'),
         'find_products_error' => esc_html__('Error finding products. Please try again.', 'affililabs'),
         'no_results_found' => esc_html__('No products found for this keyword.', 'affililabs'),
         'add_to_my_products' => esc_html__('Add to My Products', 'affililabs'),
         'enter_keyword' => esc_html__('Please enter a keyword.', 'affililabs'),
         'import_success_title' => esc_html__('Success', 'affililabs'),
         'import_success_message' => esc_html__('Product imported successfully!', 'affililabs'),
         'copied' => esc_html__('Copied!', 'affililabs'),
         'failed_to_copy' => esc_html__('Failed to copy', 'affililabs'),
         'button_edit_text' => esc_html__('Edit', 'affililabs'),
         'button_view_text' => esc_html__('View', 'affililabs'),
     ),
     'assets' => array(
         'trash_icon_url' => esc_url(AFFILILABS_ASSETS_TRASH_SVG),
         'star_full_url' => esc_url(AFFILILABS_ASSETS_STAR_FULL_SVG),
         'star_half_url' => esc_url(AFFILILABS_ASSETS_STAR_HALF_SVG),
         'star_empty_url' => esc_url(AFFILILABS_ASSETS_STAR_EMPTY_SVG),
         'default_image_url' => esc_url(AFFILILABS_DEFAULT_PRODUCT_IMAGE),
         'copy_icon_url' => esc_url(AFFILILABS_ASSETS_COPY_SVG),
     ),
 ));
?>

<div class="affililabs-plugin">
    <?php $sidebar->render('products'); ?>
    <main class="affililabs-plugin__main">
        <?php $navbar->render(); ?>
        <header class="affililabs-plugin__header">
            <h1><?php affl_print(esc_html__('Products', 'affililabs')); ?></h1>
            <?php $button->render(__('Add New Product', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-product-edit'), 'affl_admin_nonce', 'nonce'))); ?>
        </header>
        <section class="affililabs-plugin__intro">
            <div class="affililabs-plugin__intro__text">
                <div>
                  <p><b><?php affl_print(esc_html__("Let's get started!", 'affililabs')); ?></b></p>
                  <p class="affililabs-plugin__intro__description"><?php affl_print(esc_html__('Easiest way to automate your repeating tasks. We bring together your favorite products and tools into one place, so you can finish more work in less time.', 'affililabs')); ?></p>
                </div>
                <?php $button->render(__('Add New Product', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-product-edit'), 'affl_admin_nonce', 'nonce'))); ?>
            </div>
            <div class="affililabs-plugin__intro__video">
                <?php $video_frame->render(''); ?>
            </div>
        </section>
        <section class="affililabs-plugin__product-finder">
            <h2><?php affl_print(esc_html__('Find Products Online', 'affililabs')); ?></h2>
            <p><?php affl_print(esc_html__('Search for products on supported marketplaces to add them to your collection.', 'affililabs')); ?></p>
            <div class="affililabs-plugin__product-finder__controls">
                <div class="affililabs-plugin__filter-group">
                    <label for="product-finder-marketplace"><?php affl_print(esc_html__('Marketplace:', 'affililabs')); ?></label>
                    <select id="product-finder-marketplace" class="affililabs-plugin__filter-select">
                        <?php if (!empty($finder_marketplaces)): ?>
                            <?php foreach ($finder_marketplaces as $marketplace): ?>
                                <option value="<?php affl_print(esc_attr($marketplace['id'])); ?>" <?php selected($marketplace['id'], $digistore_marketplace_id); ?>>
                                    <?php affl_print(esc_html($marketplace['name'])); ?>
                                </option>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <option value="" disabled><?php affl_print(esc_html(__('No marketplaces available', 'affililabs'))); ?></option>
                        <?php endif; ?>
                    </select>
                    <div class="affililabs-plugin__search-container">
                    <input id="product-finder-keyword" type="text" class="affililabs-plugin__search" placeholder="<?php affl_print(esc_html__('Enter keyword...', 'affililabs')); ?>">
                    </div>
                    <button id="product-finder-button" class="affililabs-plugin__button affililabs-plugin__button--secondary">
                        <?php affl_print(esc_html__('Find Products', 'affililabs')); ?>
                    </button>
                </div>

                <div id="digistore-filters" class="affililabs-plugin__filter-group-container" style="display: none;">

                    <div class="affililabs-plugin__filter-group">
                        <label for="product-finder-sort"><?php affl_print(esc_html__('Sort by:', 'affililabs')); ?></label>
                        <select id="product-finder-sort" class="affililabs-plugin__filter-select">
                            <option value="stars" selected><?php affl_print(esc_html__('Popularity', 'affililabs')); ?></option>
                            <option value="earningsPerOrder"><?php affl_print(esc_html__('Earnings Per Order', 'affililabs')); ?></option>
                            <option value="earningsPerOrderformClick"><?php affl_print(esc_html__('Earnings Per Cart Visitor', 'affililabs')); ?></option>
                            <option value="publishDate"><?php affl_print(esc_html__('Publish Date', 'affililabs')); ?></option>
                            <option value="clickToOrderformConversion"><?php affl_print(esc_html__('Cart Conversion', 'affililabs')); ?></option>
                            <option value="cancellationRate"><?php affl_print(esc_html__('Cancellation Rate', 'affililabs')); ?></option>
                        </select>
                    </div>

                    <div class="affililabs-plugin__filter-group">
                        <label for="product-finder-currency"><?php affl_print(esc_html__('Currency:', 'affililabs')); ?></label>
                        <select id="product-finder-currency" class="affililabs-plugin__filter-select">
                            <option value="USD" selected><?php affl_print(esc_html__('USD (US Dollar)', 'affililabs')); ?></option>
                            <option value="EUR"><?php affl_print(esc_html__('EUR (Euro)', 'affililabs')); ?></option>
                            <option value="PLN"><?php affl_print(esc_html__('PLN (Polish Zloty)', 'affililabs')); ?></option>
                            <option value="CHF"><?php affl_print(esc_html__('CHF (Swiss Franc)', 'affililabs')); ?></option>
                            <option value="GBP"><?php affl_print(esc_html__('GBP (Pound Sterling)', 'affililabs')); ?></option>
                        </select>
                    </div>

                    <div class="affililabs-plugin__filter-group affililabs-plugin__filter-group--checkboxes">
                        <label><?php affl_print(esc_html__('Language(s):', 'affililabs')); ?></label>
                        <div id="product-finder-language-checkboxes" class="affililabs-plugin__checkbox-group-container">
                            <?php
                            $languages = [
                                'de' => __('German (de)', 'affililabs'),
                                'en' => __('English (en)', 'affililabs'),
                                'es' => __('Spanish (es)', 'affililabs'),
                                'nl' => __('Dutch (nl)', 'affililabs'),
                                'fr' => __('French (fr)', 'affililabs'),
                                'it' => __('Italian (it)', 'affililabs'),
                                'sl' => __('Slovenian (sl)', 'affililabs'),
                                'pl' => __('Polish (pl)', 'affililabs'),
                                'pt' => __('Portuguese (pt)', 'affililabs'),
                            ];
                            foreach ($languages as $code => $name): ?>
                                <div class="affililabs-plugin__checkbox-item">
                                    <input type="checkbox" id="lang-<?php affl_print(esc_attr($code)); ?>" name="product-finder-language[]" value="<?php affl_print(esc_attr($code)); ?>">
                                    <label for="lang-<?php affl_print(esc_attr($code)); ?>"><?php affl_print(esc_html($name)); ?></label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                         <small><?php affl_print(esc_html__('Leave empty for all languages.', 'affililabs')); ?></small>
                    </div>

                    <div class="affililabs-plugin__filter-group affililabs-plugin__filter-group--checkboxes">
                        <label><?php affl_print(esc_html__('Categories:', 'affililabs')); ?></label>
                        <div id="product-finder-category-checkboxes" style="display: flex; flex-direction: column; gap: 15px;">
                            <?php
                            $category_groups = [
                                __('Digital Products', 'affililabs') => [
                                    __('Animals & Pets', 'affililabs') => '15',
                                    __('Betting Systems', 'affililabs') => '18',
                                    __('Business & Investment', 'affililabs') => '10',
                                    __('Computer & Internet', 'affililabs') => '19',
                                    __('Dancing & Music', 'affililabs') => '17',
                                    __('Dating, Relationships & Romance', 'affililabs') => '12',
                                    __('Education', 'affililabs') => '24',
                                    __('Email Marketing', 'affililabs') => '33',
                                    __('Family & Children', 'affililabs') => '14',
                                    __('Fashion', 'affililabs') => '63',
                                    __('Fiction', 'affililabs') => '35',
                                    __('Food & Drink', 'affililabs') => '41',
                                    __('Fun & Games', 'affililabs') => '62',
                                    __('Green Products & Environmental Protection', 'affililabs') => '25',
                                    __('Health & Fitness', 'affililabs') => '6',
                                    __('Hobby & Craft', 'affililabs') => '31',
                                    __('Home & Garden', 'affililabs') => '21',
                                    __('Hotels & Gastronomy', 'affililabs') => '37',
                                    __('Languages', 'affililabs') => '26',
                                    __('Law & Justice', 'affililabs') => '16',
                                    __('Online Marketing & E-Business', 'affililabs') => '20',
                                    __('Personal Development', 'affililabs') => '8',
                                    __('Photography & Film', 'affililabs') => '57',
                                    __('Politics & Economy', 'affililabs') => '27',
                                    __('Profession & Job', 'affililabs') => '23',
                                    __('Services', 'affililabs') => '29',
                                    __('Social Media', 'affililabs') => '30',
                                    __('Software', 'affililabs') => '11',
                                    __('Spirituality & Esotericism', 'affililabs') => '13',
                                    __('Sport', 'affililabs') => '28',
                                    __('Survival', 'affililabs') => '66',
                                    __('Trading Products', 'affililabs') => '9',
                                    __('Travel & Culture', 'affililabs') => '22',
                                ],
                                __('Events & Seminars', 'affililabs') => [
                                    __('Animals & Pets', 'affililabs') => '59',
                                    __('Finances', 'affililabs') => '51',
                                    __('Leadership & Management', 'affililabs') => '43',
                                    __('Office Organization', 'affililabs') => '47',
                                    __('Online Marketing', 'affililabs') => '45',
                                    __('Personal Development', 'affililabs') => '7',
                                    __('Project Management', 'affililabs') => '53',
                                    __('Real Estate', 'affililabs') => '49',
                                    __('Sales Training', 'affililabs') => '55',
                                ],
                                __('Services', 'affililabs') => [
                                    __('Fashion', 'affililabs') => '61',
                                    __('Marketing Services', 'affililabs') => '39',
                                ],
                                __('Shipping Products', 'affililabs') => [
                                    __('Skin Care', 'affililabs') => '64',
                                    __('Food Supplements', 'affililabs') => '65',
                                ],
                            ];
                            
                            $group_index = 0;
                            foreach ($category_groups as $group_label => $categories): 
                                $group_index++;
                            ?>
                                <strong style="display: block; margin-bottom: 5px;"><?php affl_print(esc_html($group_label)); ?></strong>
                                <div class="affililabs-plugin__checkbox-group-container">
                                    <?php foreach ($categories as $name => $id): 
                                        // Ensure unique ID for label association
                                        $unique_id = 'cat-' . $id . '-' . $group_index . '-' . sanitize_title($name);
                                    ?>
                                        <div class="affililabs-plugin__checkbox-item">
                                            <input type="checkbox" id="<?php affl_print(esc_attr($unique_id)); ?>" name="product-finder-category[]" value="<?php affl_print(esc_attr($id)); ?>">
                                            <label for="<?php affl_print(esc_attr($unique_id)); ?>"><?php affl_print(esc_html($name)); ?></label>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                         <small><?php affl_print(esc_html__('Leave empty for all categories.', 'affililabs')); ?></small>
                    </div>

                </div>
            </div>
        </section>
        <section class="affililabs-plugin__list">
            <h2><?php affl_print(esc_html__('My Products', 'affililabs')); ?></h2>
            <div class="affililabs-plugin__filters">
                <div class="affililabs-plugin__search-container">
                    <input id="product-search" type="text" class="affililabs-plugin__search" placeholder="<?php affl_print(esc_html__('Search products...', 'affililabs')); ?>">
                </div>
                <div class="affililabs-plugin__dropdown-filters">
                    <div class="affililabs-plugin__filter-group">
                        <label for="product-sort"><?php affl_print(esc_html__('Sort by:', 'affililabs')); ?></label>
                        <select id="product-sort" class="affililabs-plugin__filter-select">
                            <option value="default"><?php affl_print(esc_html__('Default Order', 'affililabs')); ?></option>
                            <option value="name-asc"><?php affl_print(esc_html__('Name (A-Z)', 'affililabs')); ?></option>
                            <option value="name-desc"><?php affl_print(esc_html__('Name (Z-A)', 'affililabs')); ?></option>
                            <option value="price-asc"><?php affl_print(esc_html__('Price (Low to High)', 'affililabs')); ?></option>
                            <option value="price-desc"><?php affl_print(esc_html__('Price (High to Low)', 'affililabs')); ?></option>
                            <option value="rating-desc"><?php affl_print(esc_html__('Rating (High to Low)', 'affililabs')); ?></option>
                            <option value="rating-asc"><?php affl_print(esc_html__('Rating (Low to High)', 'affililabs')); ?></option>
                        </select>
                    </div>
                    <div class="affililabs-plugin__filter-group">
                        <label for="product-filter"><?php affl_print(esc_html__('Filter by:', 'affililabs')); ?></label>
                        <select id="product-filter" class="affililabs-plugin__filter-select">
                            <option value=""><?php affl_print(esc_html__('All Products', 'affililabs')); ?></option>
                            <optgroup label="<?php affl_print(esc_html__('Categories', 'affililabs')); ?>">
                                <?php foreach ($categories as $category): ?>
                                    <option value="category-<?php affl_print(esc_attr($category->term_id)); ?>"><?php affl_print(esc_html($category->name)); ?></option>
                                <?php endforeach; ?>
                            </optgroup>
                            <optgroup label="<?php affl_print(esc_html__('Marketplaces', 'affililabs')); ?>">
                                <?php foreach ($marketplaces as $marketplace): ?>
                                    <option value="marketplace-<?php affl_print(esc_attr($marketplace->ID)); ?>"><?php affl_print(esc_html($marketplace->post_title)); ?></option>
                                <?php endforeach; ?>
                            </optgroup>
                            <optgroup label="<?php affl_print(esc_html__('Ratings', 'affililabs')); ?>">
                                <option value="rating-5"><?php affl_print(esc_html__('5 Stars Only', 'affililabs')); ?></option>
                                <option value="rating-4"><?php affl_print(esc_html__('4+ Stars', 'affililabs')); ?></option>
                                <option value="rating-3"><?php affl_print(esc_html__('3+ Stars', 'affililabs')); ?></option>
                                <option value="rating-2"><?php affl_print(esc_html__('2+ Stars', 'affililabs')); ?></option>
                                <option value="rating-1"><?php affl_print(esc_html__('1+ Stars', 'affililabs')); ?></option>
                                <option value="rating-0.1"><?php affl_print(esc_html__('Any Rating', 'affililabs')); ?></option>
                            </optgroup>
                        </select>
                    </div>
                </div>
            </div>
            <div class="affililabs-plugin__card-container">
                <?php foreach ($products as $product):
                        $post = get_post($product);
                        $product_rating = get_post_meta($post->ID, AFFILILABS_META_KEY_RATING, true);
                        $product_price = get_post_meta($post->ID, AFFILILABS_META_KEY_PRICE, true);
                        $marketplace_id = get_post_meta($post->ID, AFFILILABS_META_KEY_MARKETPLACE, true);
                        $category_terms = wp_get_post_terms($post->ID, AFFILILABS_TAXONOMY_PRODUCT_CATEGORY);
                        $category_ids = array();
                        
                        if (!is_wp_error($category_terms) && !empty($category_terms)) {
                            foreach ($category_terms as $term) {
                            $category_ids[] = (string)$term->term_id;
                        }
                    }
                    
                        $category_ids_string = implode(',', $category_ids);
                ?>
                    <div class="affililabs-plugin__card" 
                         data-product-id="<?php affl_print(esc_attr($post->ID)); ?>"
                         data-product-name="<?php affl_print(esc_attr($post->post_title)); ?>"
                         data-product-price="<?php affl_print(esc_attr($product_price)); ?>"
                         data-rating="<?php affl_print(esc_attr($product_rating)); ?>"
                         data-marketplace-id="<?php affl_print(esc_attr($marketplace_id)); ?>"
                         data-category-ids="<?php affl_print(esc_attr($category_ids_string)); ?>">
                        <img src="<?php affl_print(AFFILILABS_ASSETS_COPY_SVG); ?>" class="affililabs-plugin__card__copy-id-btn" data-product-id="<?php affl_print(esc_attr($post->ID)); ?>" title="<?php affl_print(esc_attr__('Copy Product ID', 'affililabs')); ?>" />
                        <span class="affililabs-plugin__card__id-badge">ID: <?php affl_print(esc_html($post->ID)); ?></span>
                        <div class="affililabs-plugin__card__image-container">
                            <img src="<?php affl_print(esc_url(get_the_post_thumbnail_url($post->ID) ?? AFFILILABS_DEFAULT_PRODUCT_IMAGE)); ?>" alt="<?php affl_print(esc_attr($post->post_title)); ?>" class="affililabs-plugin__card__image">
                        </div>
                        <div class="affililabs-plugin__card__content">
                            <div class="affililabs-plugin__card__title-container">
                                <strong class="affililabs-plugin__card__title"><?php affl_print(esc_html($post->post_title)); ?></strong>
                                <?php
                                if (!empty($marketplace_id)):
                                    $marketplace_post = get_post($marketplace_id);
                                    if ($marketplace_post): ?>
                                        <span class="affililabs-plugin__card__marketplace">
                                            <?php affl_print(esc_html($marketplace_post->post_title)); ?>
                                        </span>
                                    <?php endif;
                                endif; ?>
                            </div>
                            <p class="affililabs-plugin__card__price">
                                <?php 
                                $currency = get_post_meta($post->ID, AFFILILABS_META_KEY_PRICE_CURRENCY, true);
                                
                                if ($currency) {
                                    affl_print(esc_html($currency));
                                } else {
                                    affl_print(esc_html('$'));
                                }
                                
                                affl_print(esc_html($product_price));
                                ?>
                            </p>
                            
                            <?php
                            if (!empty($category_terms)): ?>
                                <div class="affililabs-plugin__card__category-container">
                                    <strong><?php affl_print(esc_html__('Category:', 'affililabs')); ?></strong>
                                    <span class="affililabs-plugin__card__category">
                                        <?php affl_print(esc_html($category_terms[0]->name)); ?>
                                    </span>
                                </div>
                            <?php endif; ?>                            
                            
                            <?php
                                if (!empty($product_rating)):
                                    $rating_html = AFFLProductService::get_rating_stars_html((float)$product_rating);
                                    if (!empty($rating_html)):
                            ?>
                                <div class="affililabs-plugin__card__rating">
                                    <?php affl_print($rating_html); ?>
                                </div>
                            <?php
                                    endif;
                                endif;
                        ?>
                    </div>
                    <div class="affililabs-plugin__card__footer">
                        <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-product-edit&product_id=' . $post->ID), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin__edit-btn"><?php affl_print(esc_html__('Edit', 'affililabs')); ?></a>
                        <a href="<?php affl_print(esc_url(get_permalink($post->ID))); ?>" class="affililabs-plugin__edit-btn affililabs-plugin__view-btn" target="_blank"><?php affl_print(esc_html__('View', 'affililabs')); ?></a>
                        <img src="<?php affl_print(AFFILILABS_ASSETS_TRASH_SVG); ?>" alt="trash-icon" class="affililabs-plugin__trash-icon affililabs-plugin__delete-btn" data-product-id="<?php affl_print(esc_attr($post->ID)); ?>" data-product-name="<?php affl_print(esc_attr($post->post_title)); ?>" />
                    </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="affililabs-plugin__no-results" style="display: none; text-align: center; padding: 30px;">
                <p><?php affl_print(esc_html__('No products found matching your criteria.', 'affililabs')); ?></p>
            </div>
        </section>
    </main>

    <div id="product-finder-modal" class="affililabs-plugin__products__modal">
        <div class="affililabs-plugin__products__modal__overlay"></div>
        <div class="affililabs-plugin__products__modal__container">
        <div class="affililabs-plugin__products__modal__header">
            <h3 class="affililabs-plugin__products__modal__title"><?php affl_print(esc_html__('Product Finder Results', 'affililabs')); ?></h3>
            <span class="affililabs-plugin__products__modal__close">&times;</span>
        </div>
        <div class="affililabs-plugin__products__modal__content">
            <div id="product-finder-results" class="affililabs-plugin__card-container--modal">
            </div>
        </div>
    </div>
</div>

<div id="product-import-modal" class="affililabs-plugin__products__modal">
    <div class="affililabs-plugin__products__modal__overlay"></div>
    <div class="affililabs-plugin__products__modal__container" style="width: 700px; max-width: 90%;">
        <div class="affililabs-plugin__products__modal__header">
            <h3 class="affililabs-plugin__products__modal__title"><?php affl_print(esc_html__('Add Product to Collection', 'affililabs')); ?></h3>
            <span class="affililabs-plugin__products__modal__close">&times;</span>
        </div>
        <div class="affililabs-plugin__products__modal__content">
            <div class="affililabs-plugin-product-edit__config affililabs-plugin__import-modal__main-content">
                
                <input type="hidden" id="import-product-external-id" value="">
                <input type="hidden" id="import-product-marketplace-source" value="">
                <input type="hidden" id="import-product-image-url-source" value="">
                <input type="hidden" id="import-product-image-id" value="">


                <div class="affililabs-plugin-product-edit__config__field">
                    <label for="import-product-name"><?php affl_print(esc_html__('Product Name', 'affililabs')); ?></label>
                    <input type="text" id="import-product-name" name="import-product-name" placeholder="<?php affl_print(esc_html__('Enter product name', 'affililabs'));?>" value="">
                </div>

                <div class="affililabs-plugin-product-edit__config__field">
                    <label for="import-product-price"><?php affl_print(esc_html__('Price', 'affililabs')); ?></label>
                    <div class="affililabs-plugin-product-edit__price-container">
                        <input type="text" id="import-product-price" name="import-product-price" value="">
                        <select id="import-product-price-currency" name="import-product-price-currency">
                            <option value="$">$ (USD)</option>
                            <option value="€">€ (EUR)</option>
                            <option value="£">£ (GBP)</option>
                            <option value="¥">¥ (CNY)</option>
                            <option value="₹">₹ (INR)</option>
                            <option value="custom">Custom</option>
                        </select>
                        <input type="text" id="import-product-price-custom-currency" name="import-product-price-custom-currency"
                               class="product-price-custom-currency" value="" placeholder="C$, R$, etc." style="display: none; width: 100px; min-width: 100px;">
                    </div>
                </div>

                <div class="affililabs-plugin-product-edit__config__field">
                    <label for="import-product-affiliate-link"><?php affl_print(esc_html__('Affiliate Link', 'affililabs')); ?></label>
                    <input type="text" id="import-product-affiliate-link" name="import-product-affiliate-link" value="">
                </div>

                 <div class="affililabs-plugin-product-edit__config__field">
                    <label for="import-product-category"><?php affl_print(esc_html__('Category', 'affililabs')); ?></label>
                    <select id="import-product-category" name="import-product-category">
                        <option value="">-- Select Category --</option>
                        <?php
                        $import_categories = get_terms(array('taxonomy' => AFFILILABS_TAXONOMY_PRODUCT_CATEGORY, 'hide_empty' => false));
                        foreach ($import_categories as $category) {
                            affl_print('<option value="' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</option>');
                        }
                        ?>
                    </select>
                </div>

                <div class="affililabs-plugin-product-edit__config__field">
                    <label for="import-product-marketplace"><?php affl_print(esc_html__('Marketplace', 'affililabs')); ?></label>
                    <select id="import-product-marketplace" name="import-product-marketplace">
                        <option value=""><?php affl_print(esc_html__('-- Select Marketplace --', 'affililabs')); ?></option>
                        <?php
                        if (!empty($all_marketplaces)) {
                            foreach ($all_marketplaces as $marketplace) {
                                ?>
                                <option value="<?php affl_print(esc_attr($marketplace['id'])); ?>">
                                    <?php affl_print(esc_html($marketplace['name'])); ?>
                                </option>
                                <?php
                            }
                        }
                        ?>
                    </select>
                     <small><?php affl_print(esc_html__('Assign this product to one of your configured marketplaces.', 'affililabs')); ?></small>
                </div>
                
                <div class="affililabs-plugin-product-edit__config__field">
                    <label for="import-product-image"><?php affl_print(esc_html__('Product Image', 'affililabs')); ?></label>
                    <div class="affililabs-plugin-product-edit__config__image-upload">
                        <img id="import-product-image-preview" class="affililabs-plugin-product-edit__product-image" src="" alt="Product Image Preview" style="max-width: 80%; display: block; margin-bottom: 10px;">
                        <button type="button" class="button" id="import-upload-product-image-button"><?php affl_print(esc_html__('Select/Upload Image', 'affililabs')); ?></button>
                        <small><?php affl_print(esc_html__('Leave empty or select to override the fetched image.', 'affililabs')); ?></small>
                    </div>
                </div>

                <div class="affililabs-plugin-product-edit__config__field">
                    <label for="import-product-description"><?php affl_print(esc_html__('Description', 'affililabs')); ?></label>
                    <textarea id="import-product-description" name="import-product-description" rows="4" style="width:100%;"></textarea>
                </div>

            </div>
        </div>
        <div class="affililabs-plugin__products__modal__footer">
            <div class="affililabs-plugin__products__modal__buttons">
                 <button type="button" class="affililabs-plugin__products__modal__button affililabs-plugin__products__modal__button--neutral" data-close-modal><?php affl_print(esc_html__('Cancel', 'affililabs')); ?></button>
                 <button type="button" id="save-imported-product-button" class="affililabs-plugin__products__modal__button affililabs-plugin__products__modal__button--primary"><?php affl_print(esc_html__('Save Product', 'affililabs')); ?></button>
            </div>
        </div>
    </div>
</div>


</div>
