<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'affililabs'));
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);
affl_import(AFFILILABS_SERVICE_CRITERIA_FILE);
affl_import(AFFILILABS_SERVICE_PRODUCT_FILE);
// Nonce verification
if (!isset($_GET['nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['nonce'])), 'affl_admin_nonce')) {
    wp_die(esc_html__('Security check failed.', 'affililabs'));
}

$product_id = intval($_GET['product_id'] ?? null);
$product_edit = new AFFLProductEdit();
$product_edit->load_scripts();
$product_edit->render($product_id);

class AFFLProductEdit {
    public function load_scripts() {
        wp_enqueue_media();
        wp_enqueue_style('affililabs-products-edit', AFFILILABS_PRODUCTS_EDIT_CSS_URL, array(), AFFILILABS_VERSION);
        wp_enqueue_script('socket-io', AFFILILABS_ASSETS_URL . 'js/socket.io.min.js', array(), '4.7.2', true);
        wp_enqueue_script('affililabs-products-edit', AFFILILABS_PRODUCTS_EDIT_JS_URL, array('jquery', 'socket-io'), AFFILILABS_VERSION, true);
    }

    public function render($product_id=null) {
        $is_product_id_valid = intval($product_id) > 1; // non empty array can be 1 (intval), so we need to check if it's greater than 1
        if($is_product_id_valid) {
            $product = get_post($product_id);
            $product_terms = get_the_terms($product->ID, AFFILILABS_TAXONOMY_PRODUCT_CATEGORY);
            $category_slug = (is_array($product_terms) && !empty($product_terms)) ? $product_terms[0]->slug : null;
            $marketplace_id =
                get_post_meta($product->ID, AFFILILABS_META_KEY_MARKETPLACE, true);

            $product_details = array(
                'id' => $product->ID,
                'name' => $product->post_title,
                'price' => get_post_meta($product->ID, AFFILILABS_META_KEY_PRICE, true),
                'price_currency' => get_post_meta($product->ID, AFFILILABS_META_KEY_PRICE_CURRENCY, true),
                'affiliate_link' => get_post_meta($product->ID, AFFILILABS_META_KEY_AFFILIATE_LINK, true),
                'rating' => get_post_meta($product->ID, AFFILILABS_META_KEY_RATING, true),
                'category' => $category_slug,
                'marketplace_id' => $marketplace_id,
                'image_url' => get_the_post_thumbnail_url($product->ID),
                'status_mode' => get_post_meta($product->ID, AFFILILABS_META_KEY_PRODUCT_STATUS_MODE, true) ?? 'manual',
                'description' => $product->post_content,
                'short_features' => get_post_meta($product->ID, AFFILILABS_META_KEY_SHORT_FEATURES, true),
                'pros' => get_post_meta($product->ID, AFFILILABS_META_KEY_PROS, true),
                'cons' => get_post_meta($product->ID, AFFILILABS_META_KEY_CONS, true),
                'rating_rationale' => get_post_meta($product->ID, AFFILILABS_META_KEY_RATING_RATIONALE, true),
                'rating_sources' => get_post_meta($product->ID, AFFILILABS_META_KEY_RATING_SOURCES, true),
                'criteria_sources' => get_post_meta($product->ID, AFFILILABS_META_KEY_CRITERIA_SOURCES, true),
                'applied_template_id' => get_post_meta($product->ID, AFFILILABS_META_KEY_APPLIED_PRODUCT_TEMPLATE_ID, true),
            );
        } else {
            $product_id = null;
            $product_details = array();
            $product_details['name'] = '';
            $product_details['price'] = null;
            $product_details['price_currency'] = '$';
            $product_details['affiliate_link'] = '';
            $product_details['rating'] = '';
            $product_details['category'] = '';
            $product_details['marketplace_id'] = '';
            $product_details['image_url'] = AFFILILABS_DEFAULT_PRODUCT_IMAGE;
            $product_details['status_mode'] = 'manual';
            $product_details['description'] = '';
            $product_details['short_features'] = [];
            $product_details['pros'] = [];
            $product_details['cons'] = [];
            $product_details['rating_rationale'] = '';
            $product_details['rating_sources'] = [];
            $product_details['criteria_sources'] = [];
            $product_details['applied_template_id'] = null;
        }

        $sidebar = new AffiliLabs_Sidebar();
        $sidebar->load_scripts();
        $navbar = new AffiliLabs_Navbar();
        $navbar->load_scripts();
        $button = new AffiliLabs_Button();
        $modal = new AffiliLabs_Modal();
        $modal->load_scripts();
        $modal->init();
        $spinner = new AffiliLabs_Spinner();
        $spinner->load_scripts();
        $spinner->init();
        $video_frame = new AffiliLabs_VideoFrame();
        $video_frame->load_scripts();
        $video_frame->init();

        $single_product_templates_args = array(
            'post_type' => AFFILILABS_CPT_TEMPLATE,
            'posts_per_page' => -1,
            'meta_query' => array(
                array(
                    'key' => AFFILILABS_META_KEY_TEMPLATE_TYPE,
                    'value' => 'single_product',
                    'compare' => '=',
                ),
            ),
            'post_status' => 'any',
        );
        $single_product_templates = get_posts($single_product_templates_args);

        // Prepare AI Config
        if (!class_exists('AFFLSettingsService')) {
             affl_import(AFFILILABS_SERVICE_SETTINGS_FILE);
        }
        $internal_key = AFFLSettingsService::get_internal_api_key();
        $ai_language = AFFLSettingsService::get_ai_language();
        $freemius_user_id = '';
        $freemius_secret_key = '';
        if (function_exists('affl_fs')) {
            $freemius_user_id = affl_fs()->get_user()->id ?? '';
            $freemius_secret_key = affl_fs()->get_user()->secret_key ?? '';
        }

        wp_localize_script('affililabs-products-edit', 'affililabs_products_edit', array(
            'nonce' => wp_create_nonce('affl_admin_nonce'),
            'list_separator' => AFFLSettingsService::get_list_separator(),
            'templates' => array_map(function($t) { return array('ID' => $t->ID, 'post_title' => $t->post_title); }, $single_product_templates),
            'ai_config' => array(
                'socket_url' => 'https://api.affililabs.ai',
                'api_key' => $internal_key,
                'language' => $ai_language,
                'freemius_user_id' => $freemius_user_id,
                'freemius_secret_key' => $freemius_secret_key,
                'question_mark_svg' => AFFILILABS_ASSETS_QUESTION_MARK_SVG
            ),
            'i18n' => array(
                'save_success' => esc_html__('Product saved successfully.', 'affililabs'),
                'save_error' => esc_html__('Error saving product.', 'affililabs'),
                'save_error_unknown' => esc_html__('An error occurred while trying to save the product.', 'affililabs'),
                'save_success_title' => esc_html__('Success', 'affililabs'),
                'save_error_title' => esc_html__('Error', 'affililabs'),
                'save_error_unknown_title' => esc_html__('Error', 'affililabs'),
                'save_error_unknown_message' => esc_html__('An unknown error occurred while trying to save the product.', 'affililabs'),
                'save_error_server_connection_title' => esc_html__('Error', 'affililabs'),
                'save_error_server_connection_message' => esc_html__('Failed to connect to the server. Please try again later.', 'affililabs'),
                'file_upload_button_text' => esc_html__('Use this image', 'affililabs'),
                'file_upload_button_title' => esc_html__('Select or Upload a Product Image', 'affililabs'),
                'price_format_error' => esc_html__('Price must be a valid number format (e.g., 1.234,50 or 1,234.50).', 'affililabs'),
                'price_negative_error' => esc_html__('Price must be a non-negative number.', 'affililabs'),
                'rating_error' => esc_html__('Rating must be a number between 0 and 5, and in a valid format (e.g., 4.5 or 4,5).', 'affililabs'),
                'apply_suggestion_button_message' => esc_html__('Apply', 'affililabs'),
                'deny_suggestion_button_message' => esc_html__('Deny', 'affililabs'),
                'no_criteria_for_category' => esc_html__('No criteria found for this category.', 'affililabs'),
                'loading_criteria_message' => esc_html__('Loading criteria...', 'affililabs'),
                'error_message' => esc_html__('Error', 'affililabs'),
                'error_unknown_message' => esc_html__('An unknown error occurred.', 'affililabs'),
                'add_new_category_title' => esc_html__('Add New Category', 'affililabs'),
                'add_new_marketplace_title' => esc_html__('Add New Marketplace', 'affililabs'),
                'name_label' => esc_html__('Name', 'affililabs'),
                'slug_label' => esc_html__('Slug', 'affililabs'),
                'description_label' => esc_html__('Description', 'affililabs'),
                'save_button' => esc_html__('Save', 'affililabs'),
                'saving_category_message' => esc_html__('Saving category...', 'affililabs'),
                'category_created_message' => esc_html__('Category created successfully.', 'affililabs'),
                'saving_marketplace_message' => esc_html__('Saving marketplace...', 'affililabs'),
                'marketplace_created_message' => esc_html__('Marketplace created successfully.', 'affililabs'),
                'name_slug_required_error' => esc_html__('Name and Slug are required.', 'affililabs'),
                'name_required_error' => esc_html__('Name is required.', 'affililabs'),
                'rating_product_with_ai' => esc_html__('Analyzing and rating product with AI...', 'affililabs'),
                'ai_rating_error_title' => esc_html__('AI Rating Error', 'affililabs'),
                'deep_review_product_with_ai' => esc_html__('Generating deep review with AI...', 'affililabs'),
                'deep_review_error_title' => esc_html__('AI Deep Review Error', 'affililabs'),
                'edit_template' => esc_html__('Edit Template', 'affililabs'),
                'create_new_template' => esc_html__('Create New Template', 'affililabs'),
                'no_criteria_found_message' => esc_html__('No criteria found to fill.', 'affililabs'),
                'filling_criteria_with_ai_message' => esc_html__('Filling Criteria with AI...', 'affililabs'),
                'fill_criteria_with_ai' => esc_html__('Fill criteria with AI', 'affililabs'),
                'criteria_filled_successfully_message' => esc_html__('Criteria filled successfully!', 'affililabs'),
                'no_criteria_data_received_from_ai_message' => esc_html__('No criteria data received from AI.', 'affililabs'),
                'unknown_error' => esc_html__('An unknown error occurred.', 'affililabs'),
                'no_content_received_error' => esc_html__('No content received.', 'affililabs'),
                'deep_review_title' => esc_html__('Deep Review Generation', 'affililabs'),
                'deep_review_initializing' => esc_html__('Initializing AI...', 'affililabs'),
                'deep_review_writing' => esc_html__('Writing...', 'affililabs'),
                'deep_review_completed' => esc_html__('Completed successfully!', 'affililabs'),
                'close' => esc_html__('Close', 'affililabs'),
                'generate_review' => esc_html__('Generate Review', 'affililabs'),
            ),
        ));

        ?>
        <div class="affililabs-plugin-product-edit">
            <?php $sidebar->render('products'); ?>
            <main class="affililabs-plugin-product-edit__main">
                <?php $navbar->render(); ?>
                <header class="affililabs-plugin-product-edit__header">
                    <h1><?php affl_print(esc_html__('Edit this Product', 'affililabs')); ?></h1>
                    <?php $button->render(__('See your stats', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs')), AFFILILABS_ASSETS_PULSE_WHITE_SVG); ?>
                </header>
                <section class="affililabs-plugin-product-edit__intro">
                    <div class="affililabs-plugin-product-edit__intro__text">
                        <p><b><?php affl_print(esc_html__("Let's get started!", 'affililabs')); ?></b></p>
                        <p class="affililabs-plugin-product-edit__intro__description"><?php affl_print(esc_html__('Easiest way to automate your repeating tasks. We bring together your favorite products and tools into one place, so you can finish more work in less time.', 'affililabs')); ?></p>
                        <div class="affililabs-plugin-product-edit__intro__actions">
                            <?php $button->render(__('See all Products', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs-products')), AFFILILABS_ASSETS_LETTER_P_SVG); ?>
                            <?php if ($is_product_id_valid): ?>
                                <?php $button->render(__('See this product page', 'affililabs'), get_permalink($product_id), AFFILILABS_ASSETS_EYE_LIGHT_SVG, '_blank', 'affililabs-plugin__button--secondary'); ?>
                            <?php endif; ?>
                        </div>

                    </div>
                    <div class="affililabs-plugin-product-edit__intro__video">
                        <?php $video_frame->render(''); ?>
                    </div>
                </section>
                <section class="affililabs-plugin-product-edit__config">
                    <ul class="affililabs-plugin-product-edit__config__tabs">
                        <li class="affililabs-plugin-product-edit__config__tab affililabs-plugin-product-edit__config__tab--active" data-tab="basics"><?php affl_print(esc_html__('BASICS', 'affililabs')); ?></li>
                        <li class="affililabs-plugin-product-edit__config__tab" data-tab="details"><?php affl_print(esc_html__('DETAILS', 'affililabs')); ?></li>
                        <li class="affililabs-plugin-product-edit__config__tab" data-tab="criteria"><?php affl_print(esc_html__('CRITERIA', 'affililabs')); ?></li>
                        <li class="affililabs-plugin-product-edit__config__tab" data-tab="template"><?php affl_print(esc_html__('TEMPLATE', 'affililabs')); ?></li>
                        <li class="affililabs-plugin-product-edit__config__tab" data-tab="nerd"><?php affl_print(esc_html__('NERD', 'affililabs')); ?></li>
                    </ul>
                    <button class="affililabs-plugin__button affililabs-plugin__product-edit-ai-button"><?php affl_print(esc_html__('Fill data with AI', 'affililabs')); ?></button>
                    <div class="affililabs-plugin-product-edit__config__tab-content affililabs-plugin-product-edit__config__tab-content--active" data-tab-content="basics">
                        <div class="affililabs-plugin-product-edit__config__field">
                            <input type="hidden" id="product-id" name="product-id" value="<?php affl_print(esc_attr($product_id)); ?>">
                            <label for="product-name"><?php affl_print(esc_html__('Product Name', 'affililabs')); ?></label>
                            <input type="text" id="product-name" name="product-name"
                                    placeholder="<?php affl_print(esc_html__('The name of your product', 'affililabs'));?>"
                                    value="<?php affl_print(esc_attr($product_details['name'])); ?>"
                            >
                        </div>
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-price"><?php affl_print(esc_html__('Price', 'affililabs')); ?></label>
                            <div class="affililabs-plugin-product-edit__price-container">
                                <input type="text" id="product-price" name="product-price" value="<?php affl_print(esc_attr($product_details['price'])); ?>" pattern="^(?:\d{1,3}(?:[.,]\d{3})*|\d+)(?:[.,]\d+)?$">
                                <select id="product-price-currency" name="product-price-currency">
                                    <option value="$" <?php selected(($product_details['price_currency'] ?? '$'), '$'); ?>>$ (USD)</option>
                                    <option value="€" <?php selected(($product_details['price_currency'] ?? '$'), '€'); ?>>€ (EUR)</option>
                                    <option value="£" <?php selected(($product_details['price_currency'] ?? '$'), '£'); ?>>£ (GBP)</option>
                                    <option value="¥" <?php selected(($product_details['price_currency'] ?? '$'), '¥'); ?>>¥ (CNY)</option>
                                    <option value="₹" <?php selected(($product_details['price_currency'] ?? '$'), '₹'); ?>>₹ (INR)</option>
                                    <option value="custom" <?php selected((!in_array(($product_details['price_currency'] ?? '$'), array('$', '€', '£', '¥', '₹'))), true); ?>>Custom</option>
                                </select>
                                <input type="text" id="product-price-custom-currency" name="product-price-custom-currency" 
                                     class="product-price-custom-currency" 
                                     value="<?php affl_print((!in_array(($product_details['price_currency'] ?? '$'), array('$', '€', '£', '¥', '₹'))) ? esc_attr($product_details['price_currency']) : ''); ?>" 
                                     placeholder="C$, R$, etc."
                                     style="display: <?php affl_print((!in_array(($product_details['price_currency'] ?? '$'), array('$', '€', '£', '¥', '₹'))) ? 'block' : 'none'); ?>; width: 100px; min-width: 100px;">
                            </div>
                        </div>
                        <div class="affililabs-plugin-product-edit__config__field">
                          <label for="product-affiliate-link"><?php affl_print(esc_html__('Affiliate Link', 'affililabs')); ?></label>
                          <input type="text" id="product-affiliate-link" name="product-affiliate-link" value="<?php affl_print(esc_attr($product_details['affiliate_link'] ?? '')); ?>">
                        </div>
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-rating"><?php affl_print(esc_html__('Rating', 'affililabs')); ?></label>
                            <div class="affililabs-plugin-product-edit__config__field-with-button">
                               <input type="text" id="product-rating" name="product-rating" value="<?php affl_print(esc_attr($product_details['rating'] ?? 0)); ?>" pattern="^(?:[0-4]([.,]\d)?|5([.,]0)?)$">
                               <button class="affililabs-plugin__button affililabs-plugin__product-edit-rate-ai-button"><?php affl_print(esc_html__('Rate with AI', 'affililabs')); ?></button>
                               <span class="affililabs-tooltip"
                                      aria-label="<?php affl_print(esc_attr__('The "Rate with AI" feature provides a more in-depth analysis and higher quality rating compared to the general "Fill data with AI" feature.', 'affililabs')); ?>"> 
                                <img
                                      src="<?php affl_print(esc_url(AFFILILABS_ASSETS_QUESTION_MARK_SVG)); ?>"
                                      alt="<?php affl_print(esc_attr__('Help', 'affililabs')); ?>"
                                      width="16"
                                      style="margin-left: 10px;"
                                  >
                               </span>
                            </div>
                        </div>
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-rating-rationale"><?php affl_print(esc_html__('Rating Rationale', 'affililabs')); ?></label>
                            <textarea id="product-rating-rationale" name="product-rating-rationale"><?php affl_print(esc_textarea($product_details['rating_rationale'] ?? '')); ?></textarea>
                        </div>  
                        <input type="hidden" id="product-rating-sources" name="product-rating-sources" value="<?php affl_print(AFFLProductService::format_list_for_display($product_details['rating_sources'])); ?>">
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-image"><?php affl_print(esc_html__('Product Image', 'affililabs')); ?></label>
                            <div class="affililabs-plugin-product-edit__config__image-upload">
                                <img id="product-image-preview" class="affililabs-plugin-product-edit__product-image" src="<?php affl_print(esc_url($product_details['image_url'] ?? '')); ?>" alt="Product Image">
                                <button type="button" class="button" id="upload-product-image-button"><?php affl_print(esc_html__('Select Product Image', 'affililabs')); ?></button>
                            </div>
                        </div>
                        <button class="affililabs-plugin__button affililabs-plugin__product-edit-save-button" data-save-tab="basics"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                    </div>

                    <div class="affililabs-plugin-product-edit__config__tab-content" data-tab-content="criteria">
                        <h2><?php affl_print(esc_html__('Criteria', 'affililabs')); ?></h2>
                        <div id="affililabs-criteria-container">
                            <?php
                            if($product_id) {
                                $criteria = AFFLCriteriaService::get_criteria_for_product($product_id);
                                
                                AFFL_LoggerService::debug('Product Edit - Criteria: ' . esc_html(print_r($criteria, true)), 'DEBUG');
                                
                                if (!empty($criteria)):
                                    ?>
                                    <div class="affililabs-plugin-product-edit__ai-criteria-button-container" style="display: flex; align-items: center; margin-bottom: 20px;">
                                        <button class="affililabs-plugin__button affililabs-plugin__product-edit-ai-criteria-button"><?php affl_print(esc_html__('Fill Criteria with AI', 'affililabs')); ?></button>
                                        <span class="affililabs-tooltip"
                                                aria-label="<?php affl_print(esc_attr__('The "Fill Criteria with AI" feature provides a more in-depth analysis and higher quality rating compared to the general "Fill data with AI" feature.', 'affililabs')); ?>"> 
                                            <img
                                                src="<?php affl_print(esc_url(AFFILILABS_ASSETS_QUESTION_MARK_SVG)); ?>"
                                                alt="<?php affl_print(esc_attr__('Help', 'affililabs')); ?>"
                                                width="16"
                                                style="margin-left: 10px;"
                                            >
                                        </span>
                                    </div>
                                    <?php
                                    foreach ($criteria as $criterion):
                                        $fields = get_post_meta($criterion['id'], AFFILILABS_META_KEY_CRITERION, true) ?? [];
                                        
                                        AFFL_LoggerService::debug('Criterion ID: ' . esc_html($criterion['id']) . ' Fields: ' . esc_html(print_r($fields, true)), 'DEBUG');
                                        
                                        if (empty($fields)) continue;
                                        ?>
                                        <div class="affililabs-plugin-product-edit__config__criterion" data-criterion-id="<?php affl_print(esc_attr($criterion['id'])); ?>">
                                            <h3><?php affl_print(esc_html($criterion['title'])); ?></h3>
                                            <p class="description"><?php affl_print(esc_html($criterion['description'])); ?></p>
                                            
                                            <?php foreach ($fields as $field):
                                                if (!is_array($field) || empty($field['name']) || empty($field['definition_id'])) {
                                                    AFFL_LoggerService::debug('Product Edit - Skipping field render due to missing name or definition ID: ' . esc_html(print_r($field, true)), 'DEBUG');
                                                    continue;
                                                }
                                                
                                                $definition_id = intval($field['definition_id']);
                                                
                                                $all_criterion_values = get_post_meta($product_id, AFFILILABS_META_KEY_PRODUCT_CRITERION_VALUES, true);
                                                
                                                if (is_array($all_criterion_values) && isset($all_criterion_values[$criterion['id']])) {
                                                    AFFL_LoggerService::debug('Saved values for Criterion ' . esc_html($criterion['id']) . ': ' . esc_html(print_r($all_criterion_values[$criterion['id']], true)), 'DEBUG');
                                                } else {
                                                    AFFL_LoggerService::debug('No saved values for Criterion ' . esc_html($criterion['id']), 'DEBUG');
                                                }
                                                
                                                $field_value = '';
                                                
                                                if (is_array($all_criterion_values) && isset($all_criterion_values[$criterion['id']]['fields']['items']) && is_array($all_criterion_values[$criterion['id']]['fields']['items'])) {
                                                    foreach ($all_criterion_values[$criterion['id']]['fields']['items'] as $item) {
                                                        if (isset($item[AFFILILABS_META_KEY_PRODUCT_CRITERION_VALUE_DEFINITION_ID]) && $item[AFFILILABS_META_KEY_PRODUCT_CRITERION_VALUE_DEFINITION_ID] === $definition_id) {
                                                            $field_value = $item['value'];
                                                            break;
                                                        }
                                                    }
                                                }
                                                
                                                $field_type = $field['type'] ?? 'text';
                                                $field_unit = $field['unit'] ?? '';
                                                $input_id = 'criterion-' . $criterion['id'] . '-field-def-' . $definition_id;
                                                ?>
                                                
                                                <div class="affililabs-plugin-product-edit__config__field">
                                                    <label for="<?php affl_print(esc_attr($input_id)); ?>"><?php affl_print(esc_html($field['name'])); ?></label>
                                                    
                                                    <?php if ($field_type === 'text'): ?>
                                                        <input
                                                            type="text"
                                                            id="<?php affl_print(esc_attr($input_id)); ?>"
                                                            name="criterion_value_<?php affl_print($criterion['id']); ?>_<?php affl_print(esc_attr($field['name'])); ?>"
                                                            value="<?php affl_print(esc_attr($field_value)); ?>"
                                                            data-field-name="<?php affl_print(esc_attr($field['name'])); ?>"
                                                            data-definition-id="<?php affl_print(esc_attr($definition_id)); ?>"
                                                            data-field-type="<?php affl_print(esc_attr($field_type)); ?>"
                                                            data-criterion-id="<?php affl_print(esc_attr($criterion['id'])); ?>"
                                                        >
                                                    
                                                    <?php elseif ($field_type === 'number'): ?>
                                                        <div class="number-field-container">
                                                            <input
                                                                type="text"
                                                                id="<?php affl_print(esc_attr($input_id)); ?>"
                                                                name="criterion_value_<?php affl_print($criterion['id']); ?>_<?php affl_print(esc_attr($field['name'])); ?>"
                                                                value="<?php affl_print(esc_attr($field_value)); ?>"
                                                                data-field-name="<?php affl_print(esc_attr($field['name'])); ?>"
                                                                data-definition-id="<?php affl_print(esc_attr($definition_id)); ?>"
                                                                data-field-type="<?php affl_print(esc_attr($field_type)); ?>"
                                                                data-field-unit="<?php affl_print(esc_attr($field_unit)); ?>"
                                                                data-criterion-id="<?php affl_print(esc_attr($criterion['id'])); ?>"
                                                            >
                                                            <?php if (!empty($field_unit)): ?>
                                                                <span class="field-unit"><?php affl_print(esc_html($field_unit)); ?></span>
                                                            <?php endif; ?>
                                                        </div>
                                                    
                                                    <?php elseif ($field_type === 'boolean'): ?>
                                                        <select
                                                            id="<?php affl_print(esc_attr($input_id)); ?>"
                                                            name="criterion_value_<?php affl_print($criterion['id']); ?>_<?php affl_print(esc_attr($field['name'])); ?>"
                                                            data-field-name="<?php affl_print(esc_attr($field['name'])); ?>"
                                                            data-definition-id="<?php affl_print(esc_attr($definition_id)); ?>"
                                                            data-field-type="<?php affl_print(esc_attr($field_type)); ?>"
                                                            data-criterion-id="<?php affl_print(esc_attr($criterion['id'])); ?>"
                                                        >
                                                            <option value="" <?php selected($field_value, ''); ?>><?php affl_print(esc_html__('None', 'affililabs')); ?></option>
                                                            <option value="yes" <?php selected($field_value, 'yes'); ?>><?php affl_print(esc_html__('Yes', 'affililabs')); ?></option>
                                                            <option value="no" <?php selected($field_value, 'no'); ?>><?php affl_print(esc_html__('No', 'affililabs')); ?></option>
                                                        </select>
                                                    <?php endif; ?>
                                                </div>

                                            <?php endforeach; ?>
                                        </div>
                                    <?php
                                    endforeach;
                                    ?>
                                    <input type="hidden" id="product-criteria-sources" name="product-criteria-sources" value="<?php affl_print(AFFLProductService::format_list_for_display($product_details['criteria_sources'])); ?>">
                                    <button class="affililabs-plugin__button affililabs-plugin__product-edit-save-button" data-save-tab="criteria"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                                <?php else: ?>
                                    <p><?php affl_print(esc_html__('No criteria associated with this product. Criteria can be inherited from product category, product lists, or manually assigned.', 'affililabs')); ?></p>
                                <?php endif;
                            } else {
                                ?>
                                <p><?php affl_print(esc_html__('Select a category to see its criteria.', 'affililabs')); ?></p>
                                <?php
                            }
                            ?>
                        </div>
                    </div>

                    <div class="affililabs-plugin-product-edit__config__tab-content" data-tab-content="details">
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-category"><?php affl_print(esc_html__('Category', 'affililabs')); ?></label>
                            <div class="affililabs-plugin-product-edit__config__field-with-button">
                                <select id="product-category" name="product-category">
                                    <option value="">-- Select Category --</option>
                                    <?php
                                    $categories = get_terms(array(
                                        'taxonomy'   => AFFILILABS_TAXONOMY_PRODUCT_CATEGORY,
                                        'hide_empty' => false,
                                    ));
                                    foreach ($categories as $category) {
                                        affl_print('<option value="' . esc_attr($category->slug) . '" ' . selected($product_details['category'], $category->slug, false) . '>' . esc_html($category->name) . '</option>');
                                    }
                                    ?>
                                </select>
                                <button type="button" class="button" id="add-product-category-button"><?php affl_print(esc_html__('Add new Category', 'affililabs')); ?></button>
                            </div>
                        </div>
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-marketplace"><?php affl_print(esc_html__('Marketplace', 'affililabs')); ?></label>
                            <div class="affililabs-plugin-product-edit__config__field-with-button">
                                <?php
                                $marketplace_posts = get_posts(array(
                                    'post_type' => AFFILILABS_CPT_MARKETPLACE,
                                    'posts_per_page' => -1,
                                    'post_status' => 'any',
                                ));
                                ?>
                                <select id="product-marketplace" name="product-marketplace">
                                    <option value="">-- <?php affl_print(esc_html__('Select Marketplace', 'affililabs')); ?> --</option>
                                    <?php
                                    foreach ($marketplace_posts as $marketplace_post) {
                                        affl_print('<option value="' . esc_attr($marketplace_post->ID) . '" ' . selected($product_details['marketplace_id'], $marketplace_post->ID, false) . '>' . esc_html($marketplace_post->post_title) . '</option>');
                                    }
                                    ?>
                                </select>
                                <button type="button" class="button" id="add-marketplace-button"><?php affl_print(esc_html__('Add new Marketplace', 'affililabs')); ?></button>
                            </div>
                        </div>
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label><?php affl_print(esc_html__('Status Mode', 'affililabs')); ?></label>
                            <div class="affililabs-plugin-product-edit__config__status">
                                <?php
                                    $status_mode_text = ($product_details['status_mode'] === 'connected') ? esc_html__('Connected', 'affililabs') : esc_html__('Manual', 'affililabs');
                                    $status_mode_class = ($product_details['status_mode'] === 'connected') ? 'affililabs-plugin-product-edit__status-circle--connected' : 'affililabs-plugin-product-edit__status-circle--manual';
                                ?>
                                <span class="affililabs-plugin-product-edit__status-circle <?php affl_print(esc_attr($status_mode_class)); ?>"></span>
                                <span class="affililabs-plugin-product-edit__status-text"><?php affl_print($status_mode_text); ?></span>
                            </div>
                        </div>
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-description"><?php affl_print(esc_html__('Description', 'affililabs')); ?></label>
                            <textarea id="product-description" name="product-description"  class="affililabs-plugin-product-edit__config__description"><?php
                              affl_print($product_details['description']); 
                            ?></textarea>
                            <div style="margin-bottom: 10px; display: flex; align-items: center;">
                                <button class="affililabs-plugin__button affililabs-plugin__product-edit-deep-review-ai-button"><?php affl_print(esc_html__('Deep Review with AI', 'affililabs')); ?></button>
                                <span class="affililabs-tooltip"
                                    aria-label="<?php affl_print(esc_attr__('The "Deep Review with AI" feature generates a comprehensive review with multiple sections and paragraphs.', 'affililabs')); ?>">
                                    <img
                                        src="<?php affl_print(esc_url(AFFILILABS_ASSETS_QUESTION_MARK_SVG)); ?>"
                                        alt="<?php affl_print(esc_attr__('Help', 'affililabs')); ?>"
                                        width="16"
                                        style="margin-left: 10px;"
                                    >
                                </span>
                            </div>
                        </div>
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-short-features"><?php affl_print(esc_html__('Short Features', 'affililabs')); ?></label>
                            <textarea id="product-short-features" name="product-short-features" class="affililabs-plugin-product-edit__config__short_features"
                            ><?php affl_print(AFFLProductService::format_list_for_display($product_details['short_features'])); ?></textarea>
                        </div>
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-pros"><?php affl_print(esc_html__('Pros', 'affililabs')); ?></label>
                            <textarea id="product-pros" name="product-pros" class="affililabs-plugin-product-edit__config__pros"><?php affl_print(AFFLProductService::format_list_for_display($product_details['pros'])); ?></textarea>
                        </div>
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-cons"><?php affl_print(esc_html__('Cons', 'affililabs')); ?></label>
                            <textarea id="product-cons" name="product-cons" class="affililabs-plugin-product-edit__config__cons"><?php affl_print(AFFLProductService::format_list_for_display($product_details['cons'])); ?></textarea>
                        </div>
                        <button class="affililabs-plugin__button affililabs-plugin__product-edit-save-button" data-save-tab="details"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                    </div>

                    <div class="affililabs-plugin-product-edit__config__tab-content" data-tab-content="template">
                        <h2><?php affl_print(esc_html__('Template', 'affililabs')); ?></h2>
                        <div class="affililabs-plugin-product-edit__config__field">
                            <label for="product-template"><?php affl_print(esc_html__('Select Template', 'affililabs')); ?></label>
                            <div class="affililabs-plugin-product-edit__config__field-with-button">
                                <select id="product-template" name="product-template">
                                    <option value="">-- <?php affl_print(esc_html__('Select a Template', 'affililabs')); ?> --</option>
                                    <?php
                                    foreach ($single_product_templates as $template) {
                                        affl_print('<option value="' . esc_attr($template->ID) . '" ' . selected($product_details['applied_template_id'], $template->ID, false) . '>' . esc_html($template->post_title) . '</option>');
                                    }
                                    ?>
                                </select>
                                <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-template-editor&type=single_product'), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin__button affililabs-plugin__button--secondary" id="edit-template-button" target="_blank"><?php affl_print(esc_html__('Edit Template', 'affililabs')); ?></a>
                            </div>
                        </div>
                        <button class="affililabs-plugin__button affililabs-plugin__product-edit-save-button" data-save-tab="template"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                    </div>

                    <div class="affililabs-plugin-product-edit__config__tab-content" data-tab-content="nerd">
                        <div class="affililabs-plugin-product-edit__config__field affililabs-plugin__config__field--custom-field">
                            <label for="tags" class="affililabs-plugin__config__field-custom-label"><?php affl_print(esc_html__('Tags', 'affililabs')); ?></label>
                            <input type="text" id="tags" class="affililabs-plugin__config__field-custom-input" name="tags" value="">
                        </div>
                        <h3 class="affililabs-plugin-product-edit__custom-fields-heading"><?php affl_print(esc_html__('Custom Fields', 'affililabs')); ?></h3>
                        <div class="affililabs-plugin-product-edit__config__field affililabs-plugin__config__field--custom-field">
                            <label for="custom-field-1-name" class="affililabs-plugin__config__field-custom-label"><?php affl_print(esc_html__('Name', 'affililabs')); ?></label>
                            <input type="text" id="custom-field-1-name" class="affililabs-plugin__config__field-custom-input" name="custom-field-1-name" value="<?php affl_print(esc_attr(get_post_meta($product_details['id'] ?? 0, 'custom_field_1_name', true))); ?>">
                            <label for="custom-field-1-value" class="affililabs-plugin__config__field-custom-label"><?php affl_print(esc_html__('Value', 'affililabs')); ?></label>
                            <input type="text" id="custom-field-1-value" class="affililabs-plugin__config__field-custom-input" name="custom-field-1-value" value="<?php affl_print(esc_attr(get_post_meta($product_details['id'] ?? 0, 'custom_field_1', true))); ?>">
                        </div>
                        <button type="button" class="affililabs-plugin__button" id="add-new-field"><?php affl_print(esc_html__('Add New Field', 'affililabs')); ?></button>
                    </div>
                </section>
            </main>
        </div>

        <div id="affililabs-deep-review-content-template" style="display:none;">
            <div style="font-weight: 600; margin-bottom: 10px; display: flex; justify-content: space-between;">
                <span id="ai-deep-review-status-label"><?php affl_print(esc_html__('Ready', 'affililabs')); ?></span>
            </div>
            <textarea id="ai-deep-review-textarea" style="display:none;"></textarea>
            <div id="ai-deep-review-stream-container" style="margin-top: 0; padding: 15px; background: #1e1e1e; border: 1px solid #333; color: #a9b7c6; font-family: 'Consolas', 'Monaco', 'Courier New', monospace; font-size: 13px; border-radius: 4px; height: 300px; display: flex; flex-direction: column; box-shadow: inset 0 0 10px rgba(0,0,0,0.5);">
                <div id="ai-deep-review-stream-log" style="flex: 1; overflow-y: auto; white-space: pre-wrap; word-break: break-word; line-height: 1.6;"></div>
            </div>
        </div>

        <?php

    }
}
