<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'affililabs'));
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);

class AFFLProductCategoryEdit {
    public function load_scripts() {
        wp_enqueue_media();
        wp_enqueue_style('affililabs-product-category-edit', AFFILILABS_PRODUCT_CATEGORY_EDIT_CSS_URL, array(), AFFILILABS_VERSION);
        wp_enqueue_script('affililabs-product-category-edit', AFFILILABS_PRODUCT_CATEGORY_EDIT_JS_URL, array('jquery'), AFFILILABS_VERSION, true);

        // Nonce verification
        if (!isset($_GET['nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['nonce'])), 'affl_admin_nonce')) {
            wp_die(esc_html__('Security check failed.', 'affililabs'));
        }

        $term_id = intval($_GET['category_id'] ?? null);
        $criteria_groups = array();
        if ($term_id) {
            affl_import(AFFILILABS_SERVICE_CRITERIA_FILE);
            $criteria_groups = AFFLCriteriaService::get_criterions_by_categories(array($term_id));
        }

        wp_localize_script('affililabs-product-category-edit', 'affililabs_category_edit', array(
            'nonce' => wp_create_nonce('affl_admin_nonce'),
            'criteria_groups' => $criteria_groups,
            'i18n' => array(
                'saving' => esc_html__('Saving category...', 'affililabs'),
                'save_success_title' => esc_html__('Success', 'affililabs'),
                'save_success_message' => esc_html__('Category saved successfully.', 'affililabs'),
                'save_error_title' => esc_html__('Error', 'affililabs'),
                'save_error_message' => esc_html__('An unknown error occurred.', 'affililabs'),
                'field_name' => esc_html__('Field Name', 'affililabs'),
                'field_type' => esc_html__('Field Type', 'affililabs'),
                'unit' => esc_html__('Unit', 'affililabs'),
                'remove' => esc_html__('Remove', 'affililabs'),
                'add_field' => esc_html__('Add Field', 'affililabs'),
                'remove_criterion' => esc_html__('Remove Group', 'affililabs'),
                'criterion_object_name' => esc_html__('Criteria Group Name', 'affililabs'),
                'criterion_object_description' => esc_html__('Criteria Group Description', 'affililabs'),
                'ai_suggest_criteria_title' => esc_html__('AI Criteria Suggestions', 'affililabs'),
                'ai_suggest_criteria_loading' => esc_html__('Generating criteria suggestions...', 'affililabs'),
                'ai_suggest_criteria_error' => esc_html__('Could not get criteria suggestions. Please check your API key and try again.', 'affililabs'),
                'ai_suggest_criteria_no_suggestions' => esc_html__('No criteria suggestions found for this category.', 'affililabs'),
                'ai_suggest_criteria_accept' => esc_html__('Accept', 'affililabs'),
                'ai_suggest_criteria_saving' => esc_html__('Saving suggested criterion...', 'affililabs'),
                'ai_suggest_criteria_save_success' => esc_html__('Suggested criterion saved successfully!', 'affililabs'),
                'ai_suggest_criteria_save_error' => esc_html__('Error saving suggested criterion.', 'affililabs'),
                'no_fields_defined' => esc_html__('No fields defined for this criterion.', 'affililabs'),
                'ai_suggest_criteria_save_list_first' => esc_html__('Please save the category first before requesting AI criteria suggestions.', 'affililabs'),
                'ai_suggest_criteria_category_label' => esc_html__('Category', 'affililabs'),
                'ai_suggest_criteria_fields_label' => esc_html__('Fields', 'affililabs'),
                'ai_suggest_criteria_replacing_label' => esc_html__('Replacing existing criteria', 'affililabs'),
            ),
        ));
    }

    public function render($term_id = null) {
        $is_term_id_valid = intval($term_id) > 1;
        if($is_term_id_valid) {
            $term = get_term($term_id);
            $category_details = array(
                'id' => $term->term_id,
                'name' => $term->name,
                'slug' => $term->slug,
                'description' => $term->description,
            );
        } else {
            $term_id = null;
            $category_details = array(
                'id' => '',
                'name' => '',
                'slug' => '',
                'description' => '',
            );
        }

        $sidebar = new AffiliLabs_Sidebar();
        $navbar = new AffiliLabs_Navbar();
        $button = new AffiliLabs_Button();
        $modal = new AffiliLabs_Modal();
        $spinner = new AffiliLabs_Spinner();
        $video_frame = new AffiliLabs_VideoFrame();

        $sidebar->load_scripts();
        $navbar->load_scripts();
        $modal->load_scripts();
        $modal->init();
        $spinner->load_scripts();
        $spinner->init();
        $video_frame->load_scripts();
        $video_frame->init();

        ?>
        <div class="affililabs-plugin affililabs-plugin-product-category-edit">
            <?php $sidebar->render('product-categories'); ?>
            <main class="affililabs-plugin__main">
                <?php $navbar->render(); ?>
                <header class="affililabs-plugin__header">
                    <h1><?php affl_print(esc_html__('Edit Product Category', 'affililabs')); ?></h1>
                    <?php $button->render(__('See all Categories', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs-product-categories')), AFFILILABS_ASSETS_PULSE_WHITE_SVG); ?>
                </header>
                <section class="affililabs-plugin-product-category-edit__intro">
                    <div class="affililabs-plugin-product-category-edit__intro__text">
                        <p><b><?php affl_print(esc_html__("Let's get started!", 'affililabs')); ?></b></p>
                        <p class="affililabs-plugin-product-category-edit__intro__description"><?php affl_print(esc_html__('Organize your products effectively by creating and managing categories. This will help you structure your criteria and streamline your workflow.', 'affililabs')); ?></p>
                        <?php $button->render(__('See all Categories', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs-product-categories')), AFFILILABS_ASSETS_SHOP_WHITE_SVG); ?>
                    </div>
                    <div class="affililabs-plugin-product-category-edit__intro__video">
                        <?php $video_frame->render(''); ?>
                    </div>
                </section>
                <section class="affililabs-plugin-product-category-edit__config">
                    <ul class="affililabs-plugin-product-category-edit__config__tabs">
                        <li class="affililabs-plugin-product-category-edit__config__tab affililabs-plugin-product-category-edit__config__tab--active" data-tab="basics"><?php affl_print(esc_html__('BASICS', 'affililabs')); ?></li>
                        <li class="affililabs-plugin-product-category-edit__config__tab" data-tab="criteria"><?php affl_print(esc_html__('CRITERIA', 'affililabs')); ?></li>
                    </ul>
                    <div class="affililabs-plugin-product-category-edit__config__tab-content affililabs-plugin-product-category-edit__config__tab-content--active" data-tab-content="basics">
                        <div class="affililabs-plugin-product-category-edit__config__field">
                            <label for="category-name"><?php affl_print(esc_html__('Category Name', 'affililabs')); ?></label>
                            <input type="hidden" id="category-id" name="category-id" value="<?php affl_print(esc_attr($category_details['id'])); ?>">
                            <input type="text" id="category-name" name="category-name" value="<?php affl_print(esc_attr($category_details['name'])); ?>">
                        </div>
                        <div class="affililabs-plugin-product-category-edit__config__field">
                            <label for="category-slug"><?php affl_print(esc_html__('Slug', 'affililabs')); ?></label>
                            <input type="text" id="category-slug" name="category-slug" value="<?php affl_print(esc_attr($category_details['slug'])); ?>">
                        </div>
                        <div class="affililabs-plugin-product-category-edit__config__field">
                            <label for="category-description"><?php affl_print(esc_html__('Description', 'affililabs')); ?></label>
                            <textarea id="category-description" name="category-description"><?php affl_print(esc_textarea($category_details['description'])); ?></textarea>
                        </div>
                        <button class="affililabs-plugin__button affililabs-plugin-product-category-edit__save-button"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                    </div>
                    <div class="affililabs-plugin-product-category-edit__config__tab-content" data-tab-content="criteria">
                        <div id="affililabs-criteria-editor">
                            <div class="affililabs-plugin-lists__ai-suggest">
                                <span class="affililabs-plugin-lists__ai-suggest__text"><?php affl_print(esc_html__('Suggest criteria with AI', 'affililabs') . ': '); ?></span>
                                <span class="affililabs-plugin-lists__ai-suggest__button-wrapper affililabs-tooltip" aria-label="<?php affl_print(esc_attr(__('Suggest new criteria or replace current with AI', 'affililabs'))); ?>">
                                    <img id="ai-suggest-criteria-button" class="affililabs-plugin-lists__ai-suggest__button" src="<?php affl_print(AFFILILABS_ASSETS_STARS_SVG); ?>" alt="<?php affl_print(esc_attr(__('AI Suggest Criteria', 'affililabs'))); ?>" style="width: 32px;" />
                                </span>
                            </div>
                            <div id="ai-criteria-suggestions-container" class="affililabs-plugin__ai-suggestions" style="display: none;">
                                <h2><?php affl_print(esc_html(__('AI Criteria Suggestions', 'affililabs'))); ?></h2>
                                <div id="ai-criteria-suggestions-content">
                                    <p class="ai-loading-message"><?php affl_print(esc_html(__('Generating suggestions...', 'affililabs'))); ?></p>
                                </div>
                                <button id="close-ai-criteria-suggestions" class="affililabs-plugin__button affililabs-plugin__button--primary"><?php affl_print(esc_html(__('Close Suggestions', 'affililabs'))); ?></button>
                            </div>
                            <div id="criteria-list"></div>
                            <button type="button" id="add-criterion-button" class="affililabs-plugin__button affililabs-plugin__button--secondary" style="display: none;">
                                <?php affl_print(esc_html__('Add New Criteria Group', 'affililabs')); ?>
                            </button>
                        </div>
                        <button class="affililabs-plugin__button affililabs-plugin-product-category-edit__save-button"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                    </div>
                </section>
            </main>
        </div>
        <?php
    }
}

// Nonce verification
if (!isset($_GET['nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['nonce'])), 'affl_admin_nonce')) {
    wp_die(esc_html__('Security check failed.', 'affililabs'));
}

$category_id = intval($_GET['category_id'] ?? null);
$category_edit = new AFFLProductCategoryEdit();
$category_edit->load_scripts();
$category_edit->render($category_id);
