<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);

$sidebar = new AffiliLabs_Sidebar();
$navbar = new AffiliLabs_Navbar();
$button = new AffiliLabs_Button();
$modal = new AffiliLabs_Modal();
$spinner = new AffiliLabs_Spinner();
$video_frame = new AffiliLabs_VideoFrame();

$sidebar->load_scripts();
$navbar->load_scripts();
$modal->load_scripts();
$modal->init();
$spinner->load_scripts();
$spinner->init();
$video_frame->load_scripts();
$video_frame->init();

wp_enqueue_style('affililabs-product-categories', AFFILILABS_PRODUCT_CATEGORIES_CSS_URL, array(), AFFILILABS_VERSION);
wp_enqueue_script('affililabs-product-categories', AFFILILABS_PRODUCT_CATEGORIES_JS_URL, array('jquery'), AFFILILABS_VERSION, true);

wp_localize_script('affililabs-product-categories', 'affililabs_product_categories', array(
    'nonce' => wp_create_nonce('affl_admin_nonce'),
    'i18n' => array(
        'add_category_success' => esc_html__('Category added successfully', 'affililabs'),
        'add_category_success_message' => esc_html__('The category has been added successfully.', 'affililabs'),
        'add_category_error' => esc_html__('Error adding category', 'affililabs'),
        'add_category_error_message' => esc_html__('There was an error adding the category. Please try again.', 'affililabs'),
        'add_category_unknown' => esc_html__('An unknown error occurred while trying to add the category.', 'affililabs'),
        'add_category_error_empty' => esc_html__('Please fill in all fields.', 'affililabs'),
        'update_category_success' => esc_html__('Category updated successfully', 'affililabs'),
        'update_category_success_message' => esc_html__('The category has been updated successfully.', 'affililabs'),
        'update_category_error' => esc_html__('Error updating category', 'affililabs'),
        'update_category_unknown' => esc_html__('An unknown error occurred while trying to update the category.', 'affililabs'),
        'delete_category_success' => esc_html__('Category deleted', 'affililabs'),
        'delete_category_success_message' => esc_html__('The category has been deleted successfully.', 'affililabs'),
        'delete_category_error' => esc_html__('Error deleting category', 'affililabs'),
        'delete_category_unknown' => esc_html__('An unknown error occurred while trying to delete the category.', 'affililabs'),
        'delete_category_confirm_title' => esc_html__('Delete Category', 'affililabs'),
        'delete_category_confirm_message' => esc_html__('Are you sure you want to delete this category?', 'affililabs'),
    ),
    'assets' => array(
        'trash_icon' => AFFILILABS_ASSETS_TRASH_SVG,
    ),
));

$categories = get_terms(array(
    'taxonomy' => AFFILILABS_TAXONOMY_PRODUCT_CATEGORY,
    'hide_empty' => false,
));

if (!empty($categories) && !is_wp_error($categories)) {
    $all_category_ids = array_map(function(WP_Term $category) {
        return $category->term_id;
    }, $categories);
    _update_post_term_count($all_category_ids, get_taxonomy(AFFILILABS_TAXONOMY_PRODUCT_CATEGORY));
}   
?>

<div class="affililabs-plugin affililabs-plugin-product-categories">
    <?php $sidebar->render('product-categories'); ?>
    <main class="affililabs-plugin-product-categories__main">
        <?php $navbar->render(); ?>
        <header class="affililabs-plugin-product-categories__header">
            <h1><?php affl_print(esc_html__('Product Categories', 'affililabs')); ?></h1>
            <?php $button->render(__('Add New Category', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-product-category-edit'), 'affl_admin_nonce', 'nonce'))); ?>
        </header>
        <section class="affililabs-plugin-product-categories__intro">
            <div class="affililabs-plugin-product-categories__intro__text">
                <div>
                  <p><b><?php affl_print(esc_html__("Let's get started!", 'affililabs')); ?></b></p>
                  <p class="affililabs-plugin-product-categories__intro__description"><?php affl_print(esc_html__('Manage your product categories and link them with powerful criteria to streamline your product management.', 'affililabs')); ?></p>
                </div>
                <?php $button->render(__('Add New Category', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-product-category-edit'), 'affl_admin_nonce', 'nonce'))); ?>
            </div>
            <div class="affililabs-plugin-product-categories__intro__video">
                <?php $video_frame->render(''); ?>
            </div>
        </section>
        <section class="affililabs-plugin-product-categories__list">
            <table class="affililabs-plugin-product-categories__table">
                <thead>
                    <tr>
                        <th><?php affl_print(esc_html__('Name', 'affililabs')); ?></th>
                        <th><?php affl_print(esc_html__('Description', 'affililabs')); ?></th>
                        <th><?php affl_print(esc_html__('Slug', 'affililabs')); ?></th>
                        <th><?php affl_print(esc_html__('Count', 'affililabs')); ?></th>
                        <th class="affililabs-plugin-product-categories__actions-header"><?php affl_print(esc_html__('Actions', 'affililabs')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($categories as $category) : ?>
                        <tr>
                            <td>
                                <?php affl_print(esc_html($category->name)); ?>
                            </td>
                            <td><?php affl_print(esc_html($category->description)); ?></td>
                            <td><?php affl_print(esc_html($category->slug)); ?></td>
                            <td><?php affl_print(esc_html($category->count)); ?></td>
                            <td class="affililabs-plugin-product-categories__actions">
                                <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-product-category-edit&category_id=' . $category->term_id), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin-product-categories__edit-btn"><?php affl_print(esc_html__('Edit', 'affililabs')); ?></a>
                                <img src="<?php affl_print(AFFILILABS_ASSETS_TRASH_SVG); ?>" alt="trash-icon" class="affililabs-plugin-product-categories__trash-icon" data-category-id="<?php affl_print(esc_attr($category->term_id)); ?>" data-category-name="<?php affl_print(esc_attr($category->name)); ?>" />
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </section>
    </main>
</div>
