jQuery(document).ready(function($) {

    const {
        add_category_success,
        add_category_success_message,
        add_category_error,
        add_category_error_message,
        add_category_unknown,
        add_category_error_empty,
        update_category_success,
        update_category_success_message,
        update_category_error,
        update_category_error_message,
        update_category_unknown,
        delete_category_success,
        delete_category_success_message,
        delete_category_error,
        delete_category_error_message,
        delete_category_unknown,
        delete_category_confirm_title,
        delete_category_confirm_message,
    } = affililabs_product_categories.i18n;

    const {
        trash_icon,
    } = affililabs_product_categories.assets;

    const { nonce } = affililabs_product_categories;

    $('input#name').on('input', function() {
        let name = $(this).val().trim();
        let slug = name.toLowerCase().replace(/ /g, '-');
        $('input#slug').val(slug);
    });

    function edit_category() {
        let category_id = $(this).data('edit-category');
        let category_name = $(this).parents('tr').find('.affililabs-plugin-product-categories__name').text().trim();
        let category_slug = $(this).parents('tr').find('.affililabs-plugin-product-categories__slug').text().trim();

        console.log('category_id', category_id);
        console.log('category_name', category_name);
        console.log('category_slug', category_slug);

        $('.affililabs-plugin-product-categories__modal').show();

        $('.affililabs-plugin-product-categories__modal .affililabs-plugin-product-categories__modal-body input[name="name"]').val(category_name);
        $('.affililabs-plugin-product-categories__modal .affililabs-plugin-product-categories__modal-body input[name="slug"]').val(category_slug);

        $('.affililabs-plugin-product-categories__modal .affililabs-plugin-product-categories__modal-footer .affililabs-plugin-product-categories__modal-save').data('category-id', category_id);

        // hide modal on click outside
        $('.affililabs-plugin-product-categories__modal').on('click', function(e) {
            if (!$(e.target).closest('.affililabs-plugin-product-categories__modal-content').length) {
                $('.affililabs-plugin-product-categories__modal').hide();
            }
        });
    }
    
    function delete_category(category_id, $btn) {
        let data = {
            action: 'affililabs_delete_product_category',
            category_id: category_id,
            nonce: nonce,
        };
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: data,
            beforeSend: function() {
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.show('Deleting category...');
                }
            },
            success: function(response) {
                if (response.data.status === 'ok') {
                    console.log('Category deleted successfully!', response.data);
                    $btn.closest('tr').remove();
                    window.affililabs_modal.success(
                        delete_category_success,
                        delete_category_success_message
                    );
                } else {
                    console.error('[Response.data.status.error] Error deleting category:', response.data);
                    window.affililabs_modal.error(
                    delete_category_error,
                    delete_category_error_message + ": " + (response.data ? response.data.message : delete_category_unknown)
                );
            }
        },
        error: function(xhr, status, error) {
            console.error('[Response.error] Error deleting category:', xhr, status, error);
            window.affililabs_modal.error(
                delete_category_error,
                    'Error: ' + (error || xhr.responseJSON.data.message || delete_category_unknown)
                );
            },
            complete: function() {
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.hide();
                }
            }
        });
    }

    function add_category(event) {
        event.preventDefault();
        if ($('.affililabs-plugin-product-categories__form button[type="submit"]').prop('disabled')) {
            return;
        }

        const name = $('.affililabs-plugin-product-categories__form #name').val().trim();
        const slug = $('.affililabs-plugin-product-categories__form #slug').val().trim();

        if (!name || !slug) {
            window.affililabs_modal.error(
                add_category_error,
                add_category_error_empty
            );
            return;
        }

        let data = {
            action: 'affililabs_add_product_category',
            name: name,
            slug: slug,
            nonce: nonce,
        };
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: data,
            beforeSend: function() {
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.show('Adding category...');
                }
            },
            success: function(response) {
                if (response.data.status === 'ok') {
                    let new_category = '<tr>';
                    new_category += '<td class="affililabs-plugin-product-categories__name">' + data.name + '</td>';
                    new_category += '<td class="affililabs-plugin-product-categories__slug">' + data.slug + '</td>';
                    new_category += '<td class="affililabs-plugin-product-categories__count">0</td>';
                    new_category += '<td class="affililabs-plugin-product-categories__actions">';
                    new_category += '<a href="admin.php?page=affililabs-product-category-edit&category_id=' + response.data.term_id + '&nonce=' + nonce + '" class="affililabs-plugin-product-categories__edit-btn">Edit</a>';
                    new_category += '<img src="' + trash_icon + '" alt="trash-icon" class="affililabs-plugin__trash-icon affililabs-plugin-product-categories__delete-btn" data-delete-category="' + response.data.term_id + '" />';
                    new_category += '</td>';
                    new_category += '</tr>';
                    $('.affililabs-plugin-product-categories__list-table tbody').append(new_category);
                    $('.affililabs-plugin-product-categories__form #name').val('');
                    $('.affililabs-plugin-product-categories__form #slug').val('');
                    add_listeners();
                    window.affililabs_modal.success(
                        add_category_success,
                        add_category_success_message
                    );
                } else {
                    console.error('[Response.data.status.error] Error adding category:', response.data);
                    window.affililabs_modal.error(
                        add_category_error,
                        add_category_error_message + ": " + (response.data ? response.data.message : add_category_unknown)
                    );
                }
            },
            error: function(xhr, status, error) {
                console.error('[Response.error] Error adding category:', xhr, status, error);
                window.affililabs_modal.error(
                    add_category_error,
                    'Error: ' + (error || xhr.responseJSON.data.message || add_category_unknown)
                );
            },
            complete: function() {
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.hide();
                }
                $('.affililabs-plugin-product-categories__form button[type="submit"]').prop('disabled', false);
            }
        });
    }

    function update_category(category_id) {
        let category_name = $('.affililabs-plugin-product-categories__modal .affililabs-plugin-product-categories__modal-body input[name="name"]').val();
        let category_slug = $('.affililabs-plugin-product-categories__modal .affililabs-plugin-product-categories__modal-body input[name="slug"]').val();
        let data = {
            action: 'affililabs_update_product_category',
            category_id: category_id,
            category_name: category_name,
            category_slug: category_slug,
            nonce: nonce,
        };
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: data,
            beforeSend: function() {
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.show('Updating category...');
                }
            },
            success: function(response) {
                if (response.data.status === 'ok') {
                    let edit_button = $('button[data-edit-category="' + category_id + '"]');
                    edit_button.closest('tr').find('.affililabs-plugin-product-categories__name').text(category_name);
                edit_button.closest('tr').find('.affililabs-plugin-product-categories__slug').text(category_slug);
                window.affililabs_modal.success(
                    update_category_success,
                    update_category_success_message
                );
                $('.affililabs-plugin-product-categories__modal').hide();

                // clear form inputs
                $('.affililabs-plugin-product-categories__form input[name="name"]').val('');
                $('.affililabs-plugin-product-categories__form input[name="slug"]').val('');
                } else {
                    console.error('[Response.data.status.error] Error updating category:', response.data);
                    window.affililabs_modal.error(
                        update_category_error,
                        update_category_error_message + ": " + (response.data ? response.data.message : update_category_unknown)
                    );
                }
            },
            error: function(xhr, status, error) {
                console.error('[Response.error] Error updating category:', xhr, status, error);
                window.affililabs_modal.error(
                    update_category_error,
                    'Error: ' + (error || xhr.responseJSON.data.message || update_category_unknown)
                );
            },
            complete: function() {
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.hide();
                }
            }
        });
    }

    function add_listeners() {
        // edit button -> show modal
        $('.affililabs-plugin-product-categories__list-table tbody tr .affililabs-plugin-product-categories__edit-btn').off('click').on('click', edit_category);


        // close modal
        $('.affililabs-plugin-product-categories__modal-close').off('click').on('click', function() {
            $('.affililabs-plugin-product-categories__modal').hide();
        });

        // hide on esc
        $(document).on('keydown', function(e) {
            if (e.key === 'Escape') {
                $('.affililabs-plugin-product-categories__modal').hide();
            }
        });

        // update modal
        $('.affililabs-plugin-product-categories__modal .affililabs-plugin-product-categories__modal-footer .affililabs-plugin-product-categories__modal-save').off('click').on('click', function() {
            const category_id = $(this).data('category-id');
            update_category(category_id);
        });

        // update on enter if the modal is open
        $(document).on('keydown', function(e) {
            if (e.key === 'Enter' && $('.affililabs-plugin-product-categories__modal').is(':visible')) {
                const category_id = $('.affililabs-plugin-product-categories__modal .affililabs-plugin-product-categories__modal-footer .affililabs-plugin-product-categories__modal-save').data('category-id');
                update_category(category_id);
            }
        });

        // delete button
        $('.affililabs-plugin-product-categories__table tbody tr .affililabs-plugin-product-categories__trash-icon').off('click').on('click', function() {
            const $btn = $(this);
            const category_id = $btn.data('category-id');
            const category_name = $btn.data('category-name');
            
            window.affililabs_modal.confirm(
                delete_category_confirm_title,
                delete_category_confirm_message + ' "' + category_name + '"',
                function() {
                    delete_category(category_id, $btn);
                }
            );
        });

        $('.affililabs-plugin-product-categories__form button[type="submit"]').off('click').on('click', add_category);
    }

    add_listeners();
});
