<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SERVICE_MARKETPLACES);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);

$sidebar = new AffiliLabs_Sidebar();
$sidebar->load_scripts();
$navbar = new AffiliLabs_Navbar();
$navbar->load_scripts();
$button = new AffiliLabs_Button();
$modal = new AffiliLabs_Modal();
$modal->load_scripts();
$modal->init();
$spinner = new AffiliLabs_Spinner();
$spinner->load_scripts();
$spinner->init();
$video_frame = new AffiliLabs_VideoFrame();
$video_frame->load_scripts();
$video_frame->init();

wp_enqueue_style('affililabs-marketplaces', AFFILILABS_MARKETPLACES_CSS_URL, array(), AFFILILABS_VERSION);
wp_enqueue_script('affililabs-marketplaces', AFFILILABS_MARKETPLACES_JS_URL, array('jquery'), AFFILILABS_VERSION, true);

wp_localize_script('affililabs-marketplaces', 'affililabs_marketplaces', array(
  'nonce' => wp_create_nonce('affl_admin_nonce'),
  'i18n' => array(
    'delete_confirm' => esc_html__('Are you sure you want to delete this marketplace?', 'affililabs'),
    'delete_success_title' => esc_html__('Success', 'affililabs'),
    'delete_success' => esc_html__('Marketplace deleted successfully.', 'affililabs'),
    'delete_error' => esc_html__('Error deleting marketplace.', 'affililabs'),
    'delete_error_unknown' => esc_html__('An error occurred while trying to delete the marketplace.', 'affililabs'),
    'delete_confirm_title' => esc_html__('Delete Marketplace', 'affililabs'),
    'delete_confirm_button_confirm' => esc_html__('Delete', 'affililabs'),
    'delete_confirm_button_cancel' => esc_html__('Cancel', 'affililabs'),
  ),
));
?>

<div class="affililabs-plugin-marketplaces">
    <?php $sidebar->render('marketplaces'); ?>
    <main class="affililabs-plugin__main">
        <?php $navbar->render(); ?>
        <header class="affililabs-plugin-marketplaces__header">
            <h1><?php affl_print(esc_html__('Marketplaces', 'affililabs')); ?></h1>
            <?php $button->render(esc_html__('New Marketplace', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-marketplace-edit'), 'affl_admin_nonce', 'nonce'))); ?>
        </header>
        <section class="affililabs-plugin-marketplaces__intro">
            <div class="affililabs-plugin-marketplaces__intro__text">
                <p><b><?php affl_print(esc_html__("Let's get started!", 'affililabs')); ?></b></p>
                <p class="affililabs-plugin-marketplaces__intro__description"><?php affl_print(esc_html__('Easiest way to automate your repeating tasks. We bring together your favorite Marketplaces and tools into one place, so you can finish more work in less time.', 'affililabs')); ?></p>
                <?php $button->render(esc_html__('New Marketplace', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-marketplace-edit'), 'affl_admin_nonce', 'nonce'))); ?>
            </div>
            <div class="affililabs-plugin-marketplaces__intro__video">
                <?php $video_frame->render(''); ?>
            </div>
        </section>
        <section class="affililabs-plugin-marketplaces__list">
            <table class="affililabs-plugin-marketplaces__table">
                <thead>
                    <tr>
                        <th><?php affl_print(esc_html__('Shops', 'affililabs')); ?></th>
                        <th><?php affl_print(esc_html__('Total Products', 'affililabs')); ?></th>
                        <th><?php affl_print(esc_html__('Status', 'affililabs')); ?></th>
                        <th class="affililabs-plugin-marketplaces__last-update-header"><?php affl_print(esc_html__('Last Update', 'affililabs')); ?></th>
                        <th class="affililabs-plugin-marketplaces__actions-header"><?php affl_print(esc_html__('Actions', 'affililabs')); ?></th>
                    </tr>
                </thead>
                <tbody>
                  <?php
                    $marketplaces_args = array(
                      'post_type' => AFFILILABS_CPT_MARKETPLACE,
                      'posts_per_page' => -1,
                    );
                    $marketplaces_query = new WP_Query($marketplaces_args);
                    $marketplaces = $marketplaces_query->posts;
                    $manual_mode_class = 'affililabs-plugin-marketplaces__status-dot--manual';
                    $active_mode_class = 'affililabs-plugin-marketplaces__status-dot--active';

                    foreach ($marketplaces as $marketplace):
                      $post = get_post($marketplace);
                      $total_products = get_post_meta($post->ID, AFFILILABS_META_KEY_MARKETPLACE_TOTAL_PRODUCTS, true) ?? 0;
                      $status_mode = get_post_meta($post->ID, AFFILILABS_META_KEY_MARKETPLACE_STATUS_MODE, true) ?? 'manual';
                      $status_text = ($status_mode === 'active') ? esc_html__('Connected', 'affililabs') : esc_html__('Manual', 'affililabs');
                      $status_class = ($status_mode === 'active') ? $active_mode_class : $manual_mode_class;
                      $last_update_time = get_post_meta($post->ID, AFFILILABS_META_KEY_MARKETPLACE_LAST_UPDATE, true);
                      $last_update = $last_update_time ? human_time_diff(strtotime($last_update_time), current_time('timestamp')) . ' ' . esc_html__('ago', 'affililabs') : esc_html__('Never', 'affililabs');
                    ?>
                      <tr>
                        <td class="affililabs-plugin-marketplaces__shop-name">
                          <img src="<?php affl_print(esc_url(get_the_post_thumbnail_url($post->ID) ?? AFFILILABS_DEFAULT_PRODUCT_IMAGE)); ?>" alt="Marketplace Image" />
                          <?php affl_print(esc_html($post->post_title)); ?>
                        </td>
                        <td><?php affl_print(esc_html($total_products)); ?></td>
                        <td class="affililabs-plugin-marketplaces__status">
                          <span class="affililabs-plugin-marketplaces__status-dot <?php affl_print(esc_attr($status_class)); ?>"></span>
                          <?php affl_print($status_text); ?>
                        </td>
                        <td>
                          <span class="affililabs-plugin-marketplaces__update-time"><?php affl_print(esc_html($last_update)); ?></span>
                        </td>
                        <td class="affililabs-plugin-marketplaces__actions">
                          <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-marketplace-edit&marketplace_id=' . $post->ID), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin-marketplaces__edit-btn"><?php affl_print(esc_html__('Edit', 'affililabs')); ?></a>
                          <img class="affililabs-plugin-marketplaces__trash-icon" src="<?php affl_print(AFFILILABS_ASSETS_TRASH_SVG); ?>" alt="trash-icon" data-marketplace-id="<?php affl_print(esc_attr($post->ID)); ?>" data-marketplace-name="<?php affl_print(esc_attr($post->post_title)); ?>" />
                        </td>
                      </tr>
                    <?php endforeach; ?>
                </tbody>
            
            </table>
        </section>
    </main>
</div>
