jQuery(document).ready(function($) {
  const {
      delete_confirm,
      delete_confirm_title,
      delete_confirm_button_confirm,
      delete_confirm_button_cancel,
      delete_success_title,
      delete_success,
      delete_error,
      delete_error_title,
      delete_error_unknown
  } = affililabs_marketplaces.i18n;

  const { nonce } = affililabs_marketplaces;

  $('.affililabs-plugin-marketplaces__trash-icon').on('click', function() {
    const marketplace_id = $(this).data('marketplace-id');
    const marketplace_name = $(this).data('marketplace-name');

    const confirm_message = delete_confirm + ' "' + marketplace_name + '"';
    
    window.affililabs_modal.confirm(
      delete_confirm_title,
      confirm_message,
      function() {
        delete_marketplace(marketplace_id);
      },
      {
        buttons: {
          confirm: delete_confirm_button_confirm,
          cancel: delete_confirm_button_cancel
        }
      }
    );
  });
  
  function delete_marketplace(marketplace_id) {
    $.ajax({
      url: ajaxurl,
      type: 'POST',
      data: {
        'action': 'affililabs_delete_marketplace',
        'marketplace_id': marketplace_id,
        'nonce': nonce
      },
      beforeSend: function() {
        if (window.affililabs_spinner) {
          window.affililabs_spinner.show('Deleting marketplace...');
        }
      },
      success: function(response) {
        if (response.data.status === 'ok') {
          $(`.affililabs-plugin-marketplaces__trash-icon[data-marketplace-id="${marketplace_id}"]`)
            .closest("tr")
            .remove();
          
          window.affililabs_modal.success(
            delete_success_title,
            delete_success
          );
        } else {
          window.affililabs_modal.error(
            "Error",
            delete_error + ": " + (response.data.message || delete_error_unknown)
          );
        }
      },
      error: function(error) {
        console.error('Error deleting marketplace:', error);
        
        window.affililabs_modal.error(
          delete_error_title,
          delete_error_unknown
        );
      },
      complete: function() {
        if (window.affililabs_spinner) {
          window.affililabs_spinner.hide();
        }
      }
    });
  }
});
