<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);
affl_import(AFFILILABS_SERVICE_MARKETPLACES);
affl_import(AFFILILABS_SERVICE_MARKETPLACES);

wp_enqueue_media();

$sidebar = new AffiliLabs_Sidebar();
$sidebar->load_scripts();
$navbar = new AffiliLabs_Navbar();
$navbar->load_scripts();
$button = new AffiliLabs_Button();
$modal = new AffiliLabs_Modal();
$modal->load_scripts();
$modal->init();
$spinner = new AffiliLabs_Spinner();
$spinner->load_scripts();
$spinner->init();
$video_frame = new AffiliLabs_VideoFrame();
$video_frame->load_scripts();
$video_frame->init();

wp_enqueue_script('affililabs-marketplace-edit', AFFILILABS_MARKETPLACE_EDIT_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
wp_enqueue_style('affililabs-marketplace-edit', AFFILILABS_MARKETPLACE_EDIT_CSS_URL, array(), AFFILILABS_VERSION);

wp_localize_script('affililabs-marketplace-edit', 'affililabs_marketplace_edit', array(
  'nonce' => wp_create_nonce('affl_admin_nonce'),
  'i18n' => array(
    'save_success' => esc_html__('Marketplace saved successfully.', 'affililabs'),
    'save_error' => esc_html__('Error saving marketplace.', 'affililabs'),
    'save_error_unknown' => esc_html__('An error occurred while trying to save the marketplace.', 'affililabs'),
    'save_success_title' => esc_html__('Success', 'affililabs'),
    'save_error_title' => esc_html__('Error', 'affililabs'),
    'save_error_unknown_title' => esc_html__('Error', 'affililabs'),
    'save_error_server_connection_title' => esc_html__('Error', 'affililabs'),
    'save_error_server_connection_message' => esc_html__('Failed to connect to the server. Please try again later.', 'affililabs'),
    'file_upload_button_text' => esc_html__('Use this logo', 'affililabs'),
    'file_upload_button_title' => esc_html__('Select or Upload a Shop Logo', 'affililabs'),

  ),
));

// Nonce verification
if (!isset($_GET['nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['nonce'])), 'affl_admin_nonce')) {
    wp_die(esc_html__('Security check failed.', 'affililabs'));
}
$marketplace_id = intval($_GET['marketplace_id'] ?? null);
$category_slug =
  get_the_terms($marketplace_id, AFFILILABS_TAXONOMY_MARKETPLACE_CATEGORY)[0]->slug ?? null;

$is_marketplace_id_valid = $marketplace_id > 1;
if ($is_marketplace_id_valid) {
  $marketplace = get_post($marketplace_id);
  $marketplace_details = array(
    'id' => $marketplace->ID,
    'name' => $marketplace->post_title,
    'url' => get_post_meta($marketplace->ID, AFFILILABS_META_KEY_MARKETPLACE_URL, true),
    'shop_logo' => get_the_post_thumbnail_url($marketplace->ID),
    'category' => $category_slug,
    'api_key' => AFFLMarketplaceService::get_api_key($marketplace->post_title),
    'affiliate_id' => get_post_meta($marketplace->ID, AFFILILABS_META_KEY_MARKETPLACE_AFFILIATE_ID, true),
    'status_mode' => get_post_meta($marketplace->ID, AFFILILABS_META_KEY_MARKETPLACE_STATUS_MODE, true) ?? 'manual',
  );
} else {
  $marketplace_id = null;
  $marketplace_details = array(
    'id' => '',
    'name' => '',
    'url' => '',
    'shop_logo' => '',
    'api_key' => '',
    'status_mode' => 'manual',
  );
}

$status_mode_text = ($marketplace_details['status_mode'] === 'active') ? esc_html__('Connected', 'affililabs') : esc_html__('Manual', 'affililabs');
$status_mode_class = ($marketplace_details['status_mode'] === 'active') ? 'affililabs-plugin-marketplace-edit__config__status-circle--active' : 'affililabs-plugin-marketplace-edit__config__status-circle--manual';
?>

<div class="affililabs-plugin-marketplace-edit">
    <?php $sidebar->render('marketplaces'); ?>
    <main class="affililabs-plugin__main">
        <?php $navbar->render(); ?>
        <header class="affililabs-plugin-marketplace-edit__header">
            <h1><?php affl_print(esc_html__('Edit this Marketplace or Shop', 'affililabs')); ?></h1>
            <?php $button->render(__('See your stats', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs-marketplaces')), AFFILILABS_ASSETS_PULSE_WHITE_SVG); ?>
        </header>
        <section class="affililabs-plugin-marketplaces__intro">
            <div class="affililabs-plugin-marketplaces__intro__text">
                <p><b><?php affl_print(esc_html__("Let's get started!", 'affililabs')); ?></b></p>
                <p class="affililabs-plugin-marketplaces__intro__description"><?php affl_print(esc_html__('Easiest way to automate your repeating tasks. We bring together your favorite Marketplaces and tools into one place, so you can finish more work in less time.', 'affililabs')); ?></p>
                <?php $button->render(__('See all Marketplaces', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs-marketplaces')), AFFILILABS_ASSETS_SHOP_WHITE_SVG); ?>
            </div>
            <div class="affililabs-plugin-marketplaces__intro__video">
                <?php $video_frame->render(''); ?>
            </div>
        </section>
        <section class="affililabs-plugin-marketplace-edit__config">
            <ul class="affililabs-plugin-marketplace-edit__config__tabs">
                <li class="affililabs-plugin-marketplace-edit__config__tab affililabs-plugin-marketplace-edit__config__tab--active" data-tab="basics"><?php affl_print(esc_html__('BASICS', 'affililabs')); ?></li>
                <li class="affililabs-plugin-marketplace-edit__config__tab" data-tab="connection"><?php affl_print(esc_html__('CONNECTION', 'affililabs')); ?></li>
                <li class="affililabs-plugin-marketplace-edit__config__tab" data-tab="nerd"><?php affl_print(esc_html__('NERD', 'affililabs')); ?></li>
            </ul>
            <div class="affililabs-plugin-marketplace-edit__config__tab-content affililabs-plugin-marketplace-edit__config__tab-content--active" data-tab-content="basics">
                <div class="affililabs-plugin-marketplace-edit__config__field">
                    <label for="title" class="affililabs-plugin-marketplace-edit__config__field-label"><?php affl_print(esc_html__('Title', 'affililabs')); ?></label>
                    <input type="hidden" id="marketplace-id" name="marketplace-id" value="<?php affl_print(esc_attr($marketplace_id)); ?>">
                    <input type="text" id="marketplace-name" name="title" class="affililabs-plugin-marketplace-edit__config__field-input" value="<?php affl_print(esc_attr($marketplace_details['name'])); ?>">
                </div>
                <div class="affililabs-plugin-marketplace-edit__config__field">
                    <label for="shop-logo" class="affililabs-plugin-marketplace-edit__config__field-label"><?php affl_print(esc_html__('Shop Logo', 'affililabs')); ?></label>
                    <input type="hidden" id="shop-logo" name="shop-logo" value="<?php affl_print(esc_url($marketplace_details['shop_logo'])); ?>" />
                    <div class="affililabs-plugin-marketplace-edit__config__image-upload">
                      <img id="shop-logo-preview" src="<?php affl_print(esc_url($marketplace_details['shop_logo'] ?? AFFILILABS_DIGISTORE24_LOGO)); ?>" alt="Shop Logo" class="affililabs-plugin-marketplace-edit__config__shop-logo" style="max-width: 100px; display: <?php affl_print($marketplace_details['shop_logo'] ? 'block' : 'none'); ?>;">
                      <button type="button" class="button" id="upload-shop-logo-button"><?php affl_print(esc_html__('Select Shop Logo', 'affililabs')); ?></button>
                    </div>
                  </div>
                <button class="affililabs-plugin__button affililabs-plugin__marketplace-edit-save-button" data-save-tab="basics"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
            </div>

            <div class="affililabs-plugin-marketplace-edit__config__tab-content" data-tab-content="connection">
                <div style="display: none;" class="affililabs-plugin-marketplace-edit__config__field">
                    <label for="access-key"><?php affl_print(esc_html__('Access Key', 'affililabs')); ?></label>
                    <input type="text" id="marketplace-api-key" name="access-key" value="<?php affl_print(esc_attr($marketplace_details['api_key'])); ?>">
                </div>
                <div style="display: none;" class="affililabs-plugin-marketplace-edit__config__field">
                    <label for="secret-key"><?php affl_print(esc_html__('Secret Key', 'affililabs')); ?></label>
                    <input type="text" id="secret-key" name="secret-key" value="">
                </div>
                <div class="affililabs-plugin-marketplace-edit__config__field">
                    <label for="affiliate-id"><?php affl_print(esc_html__('Affiliate ID', 'affililabs')); ?></label>
                    <input type="text" id="marketplace-affiliate-id" name="affiliate-id" value="<?php affl_print(esc_attr($marketplace_details['affiliate_id'] ?? '')); ?>">
                </div>
                <div class="affililabs-plugin-marketplace-edit__config__status-field">
                    <span class="affililabs-plugin-marketplace-edit__config__status-label"><?php affl_print(esc_html__('Status', 'affililabs')); ?></span>
                    <div class="affililabs-plugin-marketplace-edit__config__status">
                        <span class="affililabs-plugin-marketplace-edit__config__status-circle <?php affl_print(esc_attr($status_mode_class)); ?>"></span>
                        <div class="affililabs-plugin-marketplace-edit__config__status-text"><?php affl_print($status_mode_text); ?></div>
                    </div>
                </div>
                <button class="affililabs-plugin__button affililabs-plugin__marketplace-edit-save-button" data-save-tab="connection"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
            </div>
            <div class="affililabs-plugin-marketplace-edit__config__tab-content" data-tab-content="nerd">
                <div class="affililabs-plugin-marketplace-edit__config__field">
                    <label for="tags"><?php affl_print(esc_html__('Tags', 'affililabs')); ?></label>
                    <input type="text" id="tags" name="tags" value="">
                </div>
                <div class="affililabs-plugin-marketplace-edit__config__field">
                  <label for="marketplace-category"><?php affl_print(esc_html__('Category', 'affililabs')); ?></label>
                  <select id="marketplace-category" name="marketplace-category">
                    <option value="">-- Select Category --</option>
                    <?php
                    $categories = get_terms(array(
                      'taxonomy'   => AFFILILABS_TAXONOMY_MARKETPLACE_CATEGORY,
                      'hide_empty' => false,
                    ));
                    foreach ($categories as $category) {
                      affl_print('<option value="' . esc_attr($category->slug) . '" ' . selected($marketplace_details['category'], $category->slug, false) . '>' . esc_html($category->name) . '</option>');
                    }
                    ?>
                  </select>
                </div>
                <div class="affililabs-plugin-marketplace-edit__config__field">
                    <label for="custom-field-1"><?php affl_print(esc_html__('Custom Field 1', 'affililabs')); ?></label>
                    <input type="text" id="custom-field-1" name="custom-field-1" value="<?php affl_print(esc_attr(get_post_meta($marketplace_details['id'], 'custom_field_1', true))); ?>">
                </div>
                <button type="button" class="affililabs-plugin__button" id="add-new-field"><?php affl_print(esc_html__('Add New Field', 'affililabs')); ?></button>
            </div>
        </section>
    </main>
</div>
