jQuery(document).ready(function($) {

  const {
      file_upload_button_title,
      file_upload_button_text,
      save_success_title,
      save_success,
      save_error_title,
      save_error,
      save_error_unknown,
      save_error_server_connection_title,
      save_error_server_connection_message
  } = affililabs_marketplace_edit.i18n;
  
  const { nonce } = affililabs_marketplace_edit;

  // Switch Tabs
  $('.affililabs-plugin-marketplace-edit__config__tab').on('click', function(tab) {
    $('.affililabs-plugin-marketplace-edit__config__tab')
    .removeClass('affililabs-plugin-marketplace-edit__config__tab--active');
    $(tab.target).addClass('affililabs-plugin-marketplace-edit__config__tab--active');
    
    $('.affililabs-plugin-marketplace-edit__config__tab-content')
    .removeClass('affililabs-plugin-marketplace-edit__config__tab-content--active');
    $(`.affililabs-plugin-marketplace-edit__config__tab-content[data-tab-content="${
      $(tab.target).data('tab')}"]`)
      .addClass('affililabs-plugin-marketplace-edit__config__tab-content--active');
    });

  let file_frame;
  $('#upload-shop-logo-button').on('click', function(e) {
      e.preventDefault();

      if (file_frame) {
          file_frame.open();
          return;
      }

      file_frame = wp.media({
          title: file_upload_button_title,
          button: {
              text: file_upload_button_text
          },
          multiple: false
      });

      file_frame.on('select', function(){
          var attachment = file_frame.state().get('selection').first().toJSON();
          $('#shop-logo').val(attachment.url);
          $('#shop-logo-preview').attr('src', attachment.url).show();
          $('#shop-logo-preview').data('attachment_id', attachment.id);
      });

      file_frame.open();
  });

  let index_field = 1;
  jQuery('#add-new-field').on('click', function() {
      let new_field_id = ++index_field;
      let new_field_html = `
          <div class="affililabs-plugin-marketplace-edit__config__field">
              <label for="custom-field-${new_field_id}">Custom Field ${new_field_id}</label>
              <input type="text" id="custom-field-${new_field_id}" name="custom-field-${new_field_id}" value="">
          </div>
      `;
      jQuery('.affililabs-plugin-marketplace-edit__config__tab-content--active .affililabs-plugin-marketplace-edit__config__field:last-of-type').after(new_field_html);
  });

  $('.affililabs-plugin__marketplace-edit-save-button').on('click', function() {
      let marketplace_data = {};
      marketplace_data.id = $('#marketplace-id').val().trim();
      marketplace_data.name = $('#marketplace-name').val().trim();
      marketplace_data.logo = $('#shop-logo').val().trim(); // @TODO: Check if it can be  safely Removed
      marketplace_data.image_id = $('#shop-logo-preview').data('attachment_id');
      marketplace_data.api_key = $('#marketplace-api-key').val().trim();
      marketplace_data.affiliate_id = $('#marketplace-affiliate-id').val().trim();
      marketplace_data.category = $('#marketplace-category').val().trim();

      let data = {
          action: 'affililabs_save_marketplace',
          marketplace_data: JSON.stringify(marketplace_data),
          nonce: nonce,
      };

      $.ajax({
        url: ajaxurl,
        type: 'POST',
        data: data,
        beforeSend: function() {
            if (window.affililabs_spinner) {
                window.affililabs_spinner.show('Saving marketplace...');
            }
        },
        success: function(response) {
            if (response.data.status === 'ok') {
                if (!marketplace_data.id) {
                    $('#marketplace-id').val(response.data.marketplace_id);

                    const new_url = new URL(window.location.href);
                    new_url.searchParams.set('marketplace_id', response.data.marketplace_id);
                    window.history.pushState({}, '', new_url);
                }
                window.affililabs_modal.success(
                save_success_title,
                save_success
            );
            } else {
                console.error('[Response.data.status.error] There was an error saving marketplace:', response);
                    window.affililabs_modal.error(
                        save_error_title,
                        save_error + ": " + (response.data ? response.data.message : save_error_unknown)
                    );
            }
        },
        error: function(xhr, status, error) {
            console.error('[Response.error] There was an error saving marketplace:', xhr, status, error);
            window.affililabs_modal.error(
                save_error_server_connection_title,
                save_error_server_connection_message
            );
            console.error("[Response.error] AJAX Error:", error);
        },
        complete: function() {
            if (window.affililabs_spinner) {
                window.affililabs_spinner.hide();
            }
        }
    });
  });
});
