<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_SERVICE_LOG_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);

$log_page = new AFFLLogPage();
$log_page->load_scripts();
$log_page->render();

class AFFLLogPage {
    public function load_scripts() {
        wp_enqueue_style('affililabs-log', AFFILILABS_LOG_PAGE_CSS_URL, array(), AFFILILABS_VERSION);
        wp_enqueue_script('affililabs-log', AFFILILABS_LOG_PAGE_JS_URL, array('jquery'), AFFILILABS_VERSION, true);

        $i18n = array(
            'copied' => __('Copied!', 'affililabs'),
            'failed_to_copy' => __('Failed to copy!', 'affililabs')
        );

        wp_localize_script('affililabs-log', 'affililabs_log_i18n', $i18n);
    }

    public function render() {
        $sidebar = new AffiliLabs_Sidebar();
        $sidebar->load_scripts();
        $navbar = new AffiliLabs_Navbar();
        $navbar->load_scripts();
        $button = new AffiliLabs_Button();
        $video_frame = new AffiliLabs_VideoFrame();
        $log_service = new AFFLLogService();
        $error_logs = $log_service->get_logs('error.log');
        $debug_logs = $log_service->get_logs('debug.log');
        $general_logs = $log_service->get_general_log();
        ?>
        <div class="affililabs-plugin-logs-page">
            <?php $sidebar->render('logs'); ?>
            <main class="affililabs-plugin-logs-page__main">
                <?php $navbar->render(); ?>
                <header class="affililabs-plugin-logs-page__header">
                    <h1><?php affl_print(esc_html__('Logs', 'affililabs')); ?></h1>
                    <?php $button->render(__('See your stats', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs')), AFFILILABS_ASSETS_PULSE_WHITE_SVG); ?>
                </header>
                <section class="affililabs-plugin-logs-page__intro">
                    <div class="affililabs-plugin-logs-page__intro__text">
                        <p><b><?php affl_print(esc_html__("Let's get started!", 'affililabs')); ?></b></p>
                        <p class="affililabs-plugin-logs-page__intro__description"><?php affl_print(esc_html__('Easiest way to automate your repeating tasks. We bring together your favorite products and tools into one place, so you can finish more work in less time.', 'affililabs')); ?></p>
                        <?php $button->render(__('See all Products', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs-products')), AFFILILABS_ASSETS_LETTER_P_SVG); ?>
                    </div>
                    <div class="affililabs-plugin-logs-page__intro__video">
                        <?php $video_frame->render(''); ?>
                    </div>
                </section>
                <section class="affililabs-plugin-logs-page__config">
                    <div class="affililabs-plugin-logs-page__log-columns-container">
                        <div>
                            <h2>
                                <?php affl_print(esc_html__('Error Logs', 'affililabs')); ?>
                                <span class="affililabs-plugin-logs-page__copy-icon" data-target-id="error-log-content">
                                    <img src="<?php affl_print(AFFILILABS_ASSETS_COPY_SVG); ?>" alt="<?php affl_print(esc_attr__('Copy', 'affililabs')); ?>">
                                </span>
                                <span class="affililabs-plugin-logs-page__copy-feedback" id="error-log-feedback"></span>
                            </h2>
                            <div class="log-container">
                                <pre id="error-log-content"><?php affl_print(esc_html($error_logs)); ?></pre>
                            </div>
                        </div>

                        <div>
                            <h2>
                                <?php affl_print(esc_html__('Debug Logs', 'affililabs')); ?>
                                <span class="affililabs-plugin-logs-page__copy-icon" data-target-id="debug-log-content">
                                    <img src="<?php affl_print(AFFILILABS_ASSETS_COPY_SVG); ?>" alt="<?php affl_print(esc_attr__('Copy', 'affililabs')); ?>">
                                </span>
                                <span class="affililabs-plugin-logs-page__copy-feedback" id="debug-log-feedback"></span>
                            </h2>
                            <div class="log-container">
                                <pre id="debug-log-content"><?php affl_print(esc_html($debug_logs)); ?></pre>
                            </div>
                        </div>
                    </div>

                    <hr class="affililabs-plugin-logs-page__log-separator">
                    
                    <div>
                        <h2>
                            <?php affl_print(esc_html__('General WordPress/PHP Logs', 'affililabs')); ?>
                            <span class="affililabs-plugin-logs-page__copy-icon" data-target-id="general-log-content">
                                <img src="<?php affl_print(AFFILILABS_ASSETS_COPY_SVG); ?>" alt="<?php affl_print(esc_attr__('Copy', 'affililabs')); ?>">
                            </span>
                            <span class="affililabs-plugin-logs-page__copy-feedback" id="general-log-feedback"></span>
                        </h2>
                        <div class="log-container">
                            <pre id="general-log-content"><?php affl_print(esc_html($general_logs)); ?></pre>
                        </div>
                    </div>
                </section>
            </main>
        </div>
        <?php
    }
}
