jQuery(document).ready(function($) {
    function scroll_log_containers_to_bottom() {
        var log_containers = $('.log-container');
        log_containers.each(function(_index, element) {
            element.scrollTop = element.scrollHeight;
        });
    }

    scroll_log_containers_to_bottom();

    $('.affililabs-plugin-logs-page__copy-icon').on('click', function() {
        var target_id = $(this).data('target-id');
        var log_content = $('#' + target_id).text();
        var feedback_element = $('#' + target_id.replace('-content', '-feedback'));

        navigator.clipboard.writeText(log_content).then(function() {
            feedback_element.text(affililabs_log_i18n.copied);
            setTimeout(function() {
                feedback_element.text('');
            }, 2000);
        }, function(err) {
            console.error('Could not copy text: ', err);
            feedback_element.text(affililabs_log_i18n.failed_to_copy);
            setTimeout(function() {
                feedback_element.text('');
            }, 2000);
        });
    });
});
