<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);
$lists_args = array(
    'post_type' => AFFILILABS_CPT_COMPARISON_TABLE,
    'posts_per_page' => -1,
    'post_status' => 'publish',
);
$lists_query = new WP_Query($lists_args);
$lists = $lists_query->posts;

$sidebar = new AffiliLabs_Sidebar();
$sidebar->load_scripts();
$navbar = new AffiliLabs_Navbar();
$navbar->load_scripts();
$button = new AffiliLabs_Button();
$modal = new AffiliLabs_Modal();
$modal->load_scripts();
$modal->init();
$spinner = new AffiliLabs_Spinner();
$spinner->load_scripts();
$spinner->init();
$video_frame = new AffiliLabs_VideoFrame();
$video_frame->load_scripts();
$video_frame->init();

wp_enqueue_style('affililabs-lists', AFFILILABS_LISTS_CSS_URL, array(), AFFILILABS_VERSION);
wp_enqueue_script('affililabs-lists', AFFILILABS_LISTS_JS_URL, array('jquery'), AFFILILABS_VERSION, true);
wp_localize_script(
    'affililabs-lists',
    'affililabs_lists_data',
    array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('affl_admin_nonce'),
        'i18n' => array(
            'delete_confirm_title' => esc_html__('Delete Confirmation', 'affililabs'),
            'delete_confirm' => esc_html__('Are you sure you want to delete this list?', 'affililabs'),
            'delete_confirm_button_confirm' => esc_html__('Delete', 'affililabs'),
            'delete_confirm_button_cancel' => esc_html__('Cancel', 'affililabs'),
            'delete_success_title' => esc_html__('Success', 'affililabs'),
            'delete_success_message' => esc_html__('The list was successfully deleted.', 'affililabs'),
            'delete_error_title' => esc_html__('Error', 'affililabs'),
            'delete_error_message' => esc_html__('Error deleting list.', 'affililabs'),
            'deleting_list_spinner' => esc_html__('Deleting list...', 'affililabs'),
            'ai_suggest_title' => esc_html__('AI List Suggestions', 'affililabs'),
            'ai_suggest_loading' => esc_html__('Generating suggestions...', 'affililabs'),
            'ai_suggest_error' => esc_html__('Could not get suggestions. Please check your API key and try again.', 'affililabs'),
            'ai_suggest_no_suggestions' => esc_html__('No suggestions found based on your current products.', 'affililabs'),
            'ai_suggest_accept' => esc_html__('Accept', 'affililabs'),
            'ai_suggest_saving' => esc_html__('Saving...', 'affililabs'),
            'ai_suggest_save_success' => esc_html__('Suggested list created successfully!', 'affililabs'),
            'ai_suggest_save_error' => esc_html__('Error creating list from suggestion.', 'affililabs'),
            'status_active' => esc_html__('Active', 'affililabs'),
            'status_inactive' => esc_html__('Inactive', 'affililabs'),
            'products_label' => esc_html__('Products:', 'affililabs'),
            'status_label' => esc_html__('Status:', 'affililabs'),
            'edit_button' => esc_html__('Edit', 'affililabs'),
            'delete_button' => esc_html__('Delete', 'affililabs'),
            'ai_suggest_save_success_added' => esc_html__('Suggested list created successfully and added to the page.', 'affililabs'),
            'ai_suggest_update_success' => esc_html__('List updated successfully.', 'affililabs'),
        ),
        'assets' => array(
            'ai_icon' => AFFILILABS_ASSETS_STARS_SVG,
            'check_icon' => AFFILILABS_ASSETS_CHECK_FILLED_SVG,
            'checklist_icon' => AFFILILABS_ASSETS_CHECKLIST_SVG,
            'trash_icon' => AFFILILABS_ASSETS_TRASH_SVG,
        )
    )
);

?>

<div class="affililabs-plugin">
    <?php $sidebar->render('lists'); ?>
    <main class="affililabs-plugin__main">
        <?php $navbar->render(); ?>
        <header class="affililabs-plugin__header">
            <h1><?php affl_print(esc_html__('Lists', 'affililabs')); ?></h1>
            <div class="affililabs-plugin__header-actions">
                <?php $button->render(__('Add New List', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-list-edit'), 'affl_admin_nonce', 'nonce'))); ?>
            </div>
        </header>
        <section class="affililabs-plugin__intro">
            <div class="affililabs-plugin__intro__text">
                <div>
                  <p><b><?php affl_print(esc_html__("Manage Your Lists", 'affililabs')); ?></b></p>
                  <p class="affililabs-plugin__intro__description"><?php affl_print(esc_html__('Create and manage your product lists. Use the AI assistant to get suggestions for new lists based on your existing products.', 'affililabs')); ?></p>
                </div>
                <?php $button->render(__('Add New List', 'affililabs') . ' +', esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-list-edit'), 'affl_admin_nonce', 'nonce'))); ?>
            </div>
            <div class="affililabs-plugin__intro__video">
                <?php $video_frame->render(''); ?>
            </div>
        </section>

        <section class="affililabs-plugin-lists__ai-suggest">
            <span class="affililabs-plugin-lists__ai-suggest__button-wrapper affililabs-tooltip" aria-label="<?php affl_print(esc_attr(__('Suggest lists with AI', 'affililabs'))); ?>">
                <img id="ai-suggest-lists-button" class="affililabs-plugin-lists__ai-suggest__button" src="<?php affl_print(AFFILILABS_ASSETS_STARS_SVG); ?>" alt="<?php affl_print(esc_attr(__('AI Suggest', 'affililabs'))); ?>" style="width: 32px;" />
            </span>
        </section>

        <section id="ai-suggestions-container" class="affililabs-plugin__ai-suggestions" style="display: none;">
            <h2><?php affl_print(esc_html(__('AI List Suggestions', 'affililabs'))); ?></h2>
            <div id="ai-suggestions-content">
                <p class="ai-loading-message"><?php affl_print(esc_html(__('Generating suggestions...', 'affililabs'))); ?></p>
                </div>
            <button id="close-ai-suggestions" class="affililabs-plugin__button affililabs-plugin__button--secondary"><?php affl_print(esc_html(__('Close Suggestions', 'affililabs'))); ?></button>
        </section>


        <section class="affililabs-plugin__list">
            <?php ?>
            <div class="affililabs-plugin__card-container">
                <?php
                if (empty($lists)) : ?>
                     <div class="affililabs-plugin__no-results" style="text-align: center; padding: 30px;">
                         <p><?php affl_print(esc_html__('No lists found.', 'affililabs')); ?></p>
                     </div>
                <?php else:
                    foreach ($lists as $post):
                        $list_products = get_post_meta($post->ID, AFFILILABS_META_KEY_COMPARISON_TABLE_PRODUCTS, true);
                        $product_count = is_array($list_products) ? count($list_products) : 0;
                        $status = $post->post_status === 'publish' ? esc_html__('Active', 'affililabs') : esc_html__('Inactive', 'affililabs');
                        $shortcode = "[affl_table id=" . esc_attr($post->ID) . "]";
                        ?>
                        <div class="affililabs-plugin__card" data-list-id="<?php affl_print(esc_attr($post->ID)); ?>">
                            <div class="affililabs-plugin__card__image-container">
                                <img src="<?php affl_print(AFFILILABS_ASSETS_CHECKLIST_SVG); ?>" alt="checklist-icon" class="affililabs-plugin__card__image affililabs-plugin__card__image--icon">
                            </div>
                            <div class="affililabs-plugin__card__content">
                                <div class="affililabs-plugin__card__title-container">
                                    <strong class="affililabs-plugin__card__title"><?php affl_print(esc_html($post->post_title)); ?></strong>
                                </div>
                                <p><strong><?php affl_print(esc_html__('Products:', 'affililabs')); ?></strong> <?php affl_print($product_count); ?></p>
                                <p><?php affl_print(esc_html($post->post_content)); ?></p>
                            </div>
                            <div class="affililabs-plugin__card__footer">
                                <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-list-edit&list_id=' . $post->ID), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin__edit-btn"><?php affl_print(esc_html__('Edit', 'affililabs')); ?></a>
                                <img src="<?php affl_print(AFFILILABS_ASSETS_TRASH_SVG); ?>" alt="trash-icon" class="affililabs-plugin__trash-icon affililabs-plugin__delete-btn" data-list-id="<?php affl_print(esc_attr($post->ID)); ?>"  data-list-name="<?php affl_print(esc_attr($post->post_title)); ?>"/>
                            </div>
                        </div>
                    <?php endforeach;
                endif; ?>
            </div>
             <?php if (!empty($lists)) : ?>
                <div class="affililabs-plugin__no-results" style="display: none; text-align: center; padding: 30px;">
                    <p><?php affl_print(esc_html__('No lists found.', 'affililabs')); ?></p>
                </div>
             <?php endif; ?>
        </section>
    </main>
</div>
