jQuery(document).ready(function ($) {
  const {
      delete_confirm_title,
      delete_confirm,
      delete_confirm_button_confirm,
      delete_confirm_button_cancel,
      delete_success_title,
      delete_success_message,
      deleting_list_spinner,
      delete_error_title,
      delete_error_message,
      ai_suggest_title,
      ai_suggest_loading,
      ai_suggest_error,
      ai_suggest_no_suggestions,
      ai_suggest_accept,
      ai_suggest_saving,
      ai_suggest_save_success,
      ai_suggest_save_error,
      status_active = 'Active',
      status_inactive = 'Inactive',
      products_label = 'Products:',
      status_label = 'Status:',
      edit_button = 'Edit',
      delete_button = 'Delete',
      ai_suggest_save_success_added = 'Suggested list created successfully and added to the page.',
      ai_suggest_update_success = 'List updated successfully.'
  } = window.affililabs_lists_data.i18n;

  const nonce = window.affililabs_lists_data.nonce;
  const ajax_url = window.ajaxurl || window.affililabs_lists_data.ajax_url;
  const assets = window.affililabs_lists_data.assets;
  $('.affililabs-plugin__list').on("click", ".affililabs-plugin__delete-btn", function (e) {
    e.preventDefault();

    const list_id = $(this).data("list-id");
    const list_name = $(this).data("list-name");
    const $card = $(this).closest(".affililabs-plugin__card");

    window.affililabs_modal.confirm(
      delete_confirm_title,
      delete_confirm + ' "' + list_name + '"',
      function() {
        delete_list(list_id, $card);
      },
      {
        buttons: {
          confirm: delete_confirm_button_confirm,
          cancel: delete_confirm_button_cancel
        }
      }
    );
  });

  function delete_list(list_id, $card) {
    $.ajax({
      url: ajax_url,
      type: "POST",
      data: {
        action: "affililabs_delete_comparison_table",
        comparison_table_id: list_id,
        nonce: nonce
      },
      beforeSend: function() {
        if (window.affililabs_spinner) {
          window.affililabs_spinner.show(deleting_list_spinner);
        }
      },
      success: function (response) {
        if (response.success && response.data.status === "ok") {
          $card.fadeOut("fast", function() {
            $(this).remove();
            if ($('.affililabs-plugin__card-container').children().length === 0) {
                $('.affililabs-plugin__no-results').show();
            }
          });

          window.affililabs_modal.notice(
            delete_success_title,
            delete_success_message
          );
        } else {
          console.error("[Response Error] Error deleting list:", response.data);
          window.affililabs_modal.error(
            delete_error_title,
            response.data?.message || delete_error_message
          );
        }
      },
      error: function (xhr, status, error) {
        console.error("[AJAX Error] Error deleting list:", xhr, status, error);

        window.affililabs_modal.error(
          delete_error_title,
          delete_error_message + ": " + (xhr.responseJSON ? xhr.responseJSON.message : error)
        );
      },
      complete: function() {
        if (window.affililabs_spinner) {
          window.affililabs_spinner.hide();
        }
      }
    });
  }

  function create_list_card_html(list_data) {
    const status_text = list_data.status === 'publish' ? status_active : status_inactive;

    const escaped_title = $('<textarea />').html(list_data.title).text();

    return `<div class="affililabs-plugin__card" data-list-id="${list_data.id}">
               <div class="affililabs-plugin__card__image-container">
                 <img src="${assets.checklist_icon}" alt="checklist-icon" class="affililabs-plugin__card__image affililabs-plugin__card__image--icon">
               </div>
               <div class="affililabs-plugin__card__content">
                 <div class="affililabs-plugin__card__title-container">
                   <strong class="affililabs-plugin__card__title">${escaped_title}</strong>
                 </div>
                 <p><strong>${products_label}</strong> ${list_data.product_count}</p>
                 <p>${list_data.list_description || ''}</p>
               </div>
               <div class="affililabs-plugin__card__footer">
                 <a href="${list_data.edit_url}" class="affililabs-plugin__edit-btn">${edit_button}</a>
                 <img src="${assets.trash_icon}" alt="${delete_button}" class="affililabs-plugin__trash-icon affililabs-plugin__delete-btn" data-list-id="${list_data.id}"  data-list-name="${escaped_title}" title="${delete_button}"/>
               </div>
             </div>`;
  }

  const $ai_suggestions_container = $('#ai-suggestions-container');
  const $ai_suggestions_content = $('#ai-suggestions-content');
  const $ai_loading_message = $ai_suggestions_content.find('.ai-loading-message');

  $('#ai-suggest-lists-button').on('click', function(e) {
    e.preventDefault();
    $ai_suggestions_container.show();
    $ai_suggestions_content.empty();
    $ai_loading_message.show();
    $.ajax({
      url: ajax_url,
      type: 'POST',
      data: {
        action: 'affililabs_suggest_lists', 
        nonce: nonce
      },
      beforeSend: function() {
         if (window.affililabs_spinner) {
           window.affililabs_spinner.show(ai_suggest_loading);
         }
      },
      success: function(response) {
        $ai_loading_message.hide();
        if (response.success && response.data.status === 'ok' && response.data.lists_response) {
          const suggestions = response.data.lists_response;
          const product_id_to_name = response.data.product_id_to_name;
          if (suggestions.length > 0) {
            let suggestions_html = '';
             $.each(suggestions, function(index, suggestion) {
               const encoded_suggestion = btoa(JSON.stringify(suggestion));
               suggestions_html += `<div class="affililabs-plugin__ai-suggestion-item">
                 <div class="affililabs-plugin__ai-suggestion-item__content">
                   <strong class="affililabs-plugin__ai-suggestion-item__title">${suggestion.name || 'Suggested List'}</strong>
                   <span class="affililabs-plugin__ai-suggestion-item__products">Products: ${suggestion.product_ids && suggestion.product_ids.length > 0 ? suggestion.product_ids.map(id => product_id_to_name[id] || `Product ${id}`).join(', ') : 'No products suggested.'}</span>
                 </div>
                 <div class="affililabs-plugin__ai-suggestion-item__actions">
                   <span class="affililabs-tooltip" aria-label="${ai_suggest_accept}"><img src="${assets.check_icon}" alt="${ai_suggest_accept}" class="affililabs-plugin__check-icon accept-suggestion" data-suggestion="${encoded_suggestion}" title="${ai_suggest_accept}"/></span>
                 </div>
               </div>`;
             });
             $ai_suggestions_content.append(suggestions_html);
           } else {
             $ai_suggestions_content.append(`<p>${ai_suggest_no_suggestions}</p>`);
           }
         } else {
           console.error('Error getting AI suggestions:', response.data?.message);
           $ai_suggestions_content.append(`<p>${ai_suggest_error}</p>`);
         }
       },
       error: function(xhr, status, error) {
         $ai_loading_message.hide();
         console.error('AJAX error getting AI suggestions:', error);
         $ai_suggestions_content.append(`<p>${ai_suggest_error}</p>`);
       },
        complete: function() {
         if (window.affililabs_spinner) {
           window.affililabs_spinner.hide();
         }
       }
     });
   });
   $ai_suggestions_content.on('click', '.accept-suggestion', function(e) {
     e.preventDefault();
     const $button_icon = $(this);

     if ($button_icon.data('processing')) {
         return;
     }
     $button_icon.data('processing', true);
     $button_icon.css('opacity', 0.5);

     const encoded_suggestion = $button_icon.data('suggestion');
     let suggestion_data = {};
     try {
         const decoded_suggestion = atob(encoded_suggestion);
         suggestion_data = JSON.parse(decoded_suggestion);
     } catch (e) {
         console.error('Error decoding or parsing suggestion data:', e);
         window.affililabs_modal.error(
             null,
             ai_suggest_error
         );
         $button_icon.removeData('processing').css('opacity', 1);
         return;
     }

     const new_list_data = {
       title: suggestion_data.name || 'Suggested List',
       list_description: suggestion_data.description || '',
       product_ids: suggestion_data.product_ids || [],
       criteria_ids: [],
       applied_template_id: null,
       tier_best_price: null,
       tier_best_quality: null,
       tier_best_cost_benefit: null,
     };

     if (suggestion_data.id > 0) {
         new_list_data.id = suggestion_data.id;
     }

     $.ajax({
       url: ajax_url,
       type: 'POST',
       data: {
         action: 'affililabs_save_comparison_table',
         comparison_table_data: JSON.stringify(new_list_data),
         nonce: nonce
       },
       beforeSend: function() {
          if (window.affililabs_spinner) {
            window.affililabs_spinner.show(ai_suggest_saving);
          }
       },
       success: function(response) {
         console.log('AJAX success response:', response);

         if (response.success && response.data.status === 'ok' && response.data.list_data) {
             const list_data = response.data.list_data;
             const is_new_list = response.data.status_code === 201;
             if (is_new_list) {
                 const $no_results_message = $('.affililabs-plugin__no-results');
                 if ($no_results_message.is(':visible')) {
                     $no_results_message.remove();
                 }
                 const new_list_card_html = create_list_card_html(list_data);
                 $('.affililabs-plugin__card-container').prepend(new_list_card_html);
             } else {
                 const $existing_card = $(`.affililabs-plugin__card[data-list-id="${list_data.id}"]`);
                 if ($existing_card.length) {
                     const updated_list_card_html = create_list_card_html(list_data);
                     $existing_card.replaceWith(updated_list_card_html);
                 } else {
                     console.warn('Existing card not found for update:', list_data.id);
                 }
             }

              window.affililabs_modal.success(
                  ai_suggest_save_success,
                 is_new_list ? ai_suggest_save_success_added : ai_suggest_update_success
             );

             $button_icon.closest('.affililabs-plugin__ai-suggestion-item').remove();

         } else {
             console.error('Error saving suggested list:', response.data);
             window.affililabs_modal.error(
                 null,
                 response.data?.message || ai_suggest_save_error || 'An unknown error occurred.'
             );
             $button_icon.removeData('processing').css('opacity', 1);
         }
       },
       error: function(xhr, status, error) {
         console.error('AJAX error saving suggested list:', xhr, status, error);
         window.affililabs_modal.error(
           null,
           ai_suggest_save_error || 'Failed to connect to the server.'
         );
          $button_icon.removeData('processing').css('opacity', 1);
       },
        complete: function() {
         if (window.affililabs_spinner) {
           window.affililabs_spinner.hide();
         }
       }
     });
   });
   $('#close-ai-suggestions').on('click', function(e) {
     e.preventDefault();
     $ai_suggestions_container.hide();
   });
 
 });
