<?php

if (!defined('ABSPATH')) {
    exit;
}

if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'affililabs'));
}

affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_CPT_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_BUTTON_COMPONENT_FILE);
affl_import(AFFILILABS_COMPARISON_TABLE_SERVICE_FILE);
affl_import(AFFILILABS_SERVICE_PRODUCT_FILE);
affl_import(AFFILILABS_SERVICE_CRITERIA_FILE);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);

// Nonce verification
if (!isset($_GET['nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['nonce'])), 'affl_admin_nonce')) {
    wp_die(esc_html__('Security check failed.', 'affililabs'));
}
$list_id = isset($_GET['list_id']) ? intval($_GET['list_id']) : null;
$list_edit = new AFFLListEdit();
$list_edit->load_scripts($list_id);
$list_edit->render($list_id);
$modal = new AffiliLabs_Modal();
$modal->load_scripts();
$modal->init();
$spinner = new AffiliLabs_Spinner();
$spinner->load_scripts();
$spinner->init();

class AFFLListEdit {
    public function load_scripts($list_id = null) {
        wp_enqueue_style('affililabs-list-edit', AFFILILABS_LIST_EDIT_CSS_URL, array(), AFFILILABS_VERSION);
        wp_enqueue_script('affililabs-list-edit', AFFILILABS_LIST_EDIT_JS_URL, array('jquery'), AFFILILABS_VERSION, true);

        wp_localize_script('affililabs-list-edit', 'affililabs_list_edit', array(
            'nonce' => wp_create_nonce('affl_admin_nonce'),
            'list_id' => $list_id,
            'ajax_url' => admin_url('admin-ajax.php'),
            'i18n' => array(
                'list_name' => __('List Name', 'affililabs'),
                'products' => __('Products', 'affililabs'),
                'remove' => __('Remove', 'affililabs'),
                'select_product' => __('Select a product', 'affililabs'),
                'save_success_title' => __('Success', 'affililabs'),
                'save_success' => __('List saved successfully', 'affililabs'),
                'save_error_title' => __('Error', 'affililabs'),
                'save_error' => __('Error saving list', 'affililabs'),
                'save_error_unknown' => __('Unknown error', 'affililabs'),
                'save_error_server_connection_title' => __('Error', 'affililabs'),
                'save_error_server_connection_message' => __('Failed to connect to the server. Please try again later.', 'affililabs'),
                'import_category_error_no_id' => __('Please select a category', 'affililabs'),
                'import_tag_error_no_id' => __('Please select a tag', 'affililabs'),
                'import_category_error_no_products' => __('No products found in the selected category', 'affililabs'),
                'import_tag_error_no_products' => __('No products found in the selected tag', 'affililabs'),
                'import_category_error_no_products_title' => __('Error', 'affililabs'),
                'import_tag_error_no_products_title' => __('Error', 'affililabs'),
                'import_success_title' => __('Success', 'affililabs'),
                'import_success_products_imported' => __('Products imported successfully', 'affililabs'),
                'import_success_products_imported_post_message' => __("Don't forget to save your changes!", 'affililabs'),
                'import_success_products_imported_title' => __('Success', 'affililabs'),
                'import_error_title' => __('Error', 'affililabs'),
                'import_error_unknown' => __('Unknown error', 'affililabs'),
                'import_error_server_connection_title' => __('Error', 'affililabs'),
                'import_error_server_connection_message' => __('Failed to connect to the server. Please try again later.', 'affililabs'),
                'select_criteria' => __('Select Criteria', 'affililabs'),
                'selected_criteria_fields' => __('Selected Criteria Fields Preview', 'affililabs'),
                'no_criteria_selected' => __('No criteria selected.', 'affililabs'),
                'error_fetching_criteria_fields' => __('Error fetching fields for the selected criterion.', 'affililabs'),
                'apply_template' => __('Apply Template', 'affililabs'),
                'select_template' => __('Select a template', 'affililabs'),
                'no_template' => __('None', 'affililabs'),
                'ai_suggest_criteria_title' => esc_html__('AI Criteria Suggestions', 'affililabs'),
                'ai_suggest_criteria_loading' => esc_html__('Generating criteria suggestions...', 'affililabs'),
                'ai_suggest_criteria_error' => esc_html__('Could not get criteria suggestions. Please check your API key and try again.', 'affililabs'),
                'ai_suggest_criteria_no_suggestions' => esc_html__('No criteria suggestions found based on your selected products.', 'affililabs'),
                'ai_suggest_criteria_accept' => esc_html__('Accept', 'affililabs'),
                'ai_suggest_criteria_saving' => esc_html__('Saving suggested criterion...', 'affililabs'),
                'ai_suggest_criteria_save_success' => esc_html__('Suggested criterion saved successfully!', 'affililabs'),
                'ai_suggest_criteria_save_error' => esc_html__('Error saving suggested criterion.', 'affililabs'),
                'no_fields_defined' => esc_html__('No fields defined for this criterion.', 'affililabs'),
                'ai_suggest_criteria_save_list_first' => esc_html__('Please save the list first before requesting AI criteria suggestions.', 'affililabs'),
                'ai_suggest_criteria_category_label' => esc_html__('Category', 'affililabs'),
                'ai_suggest_criteria_fields_label' => esc_html__('Fields', 'affililabs'),
                'ai_suggest_criteria_replacing_label' => esc_html__('Replacing existing criteria', 'affililabs'),
            ),
        ));

        $products_data = AFFLProductService::get_all('any');
        $categories = get_terms(array(
            'taxonomy' => AFFILILABS_TAXONOMY_PRODUCT_CATEGORY,
            'hide_empty' => false,
        ));

        $criteria_data = [];
        if (class_exists('AFFLCriteriaService')) {
            $criteria_data = AFFLCriteriaService::get_all();
        } else {
             AFFL_LoggerService::log('AFFLCriteriaService not found in AFFLListEdit::load_scripts', 'ERROR');
        }

        $templates_data = get_posts(array(
            'post_type' => AFFILILABS_CPT_TEMPLATE,
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'meta_query' => array(
                array(
                    'key' => AFFILILABS_META_KEY_TEMPLATE_TYPE,
                    'value' => 'comparison_table',
                    'compare' => '=',
                ),
            ),
        ));
        $formatted_templates = array_map(function($post) {
            return ['id' => $post->ID, 'title' => $post->post_title];
        }, $templates_data);


        wp_localize_script(
            'affililabs-list-edit',
            'affl_list_edit_data',
            array(
                'products' => $products_data,
                'categories' => $categories,
                'criteria' => $criteria_data,
                'templates' => $formatted_templates,
            )
        );
    }

    public function render($list_id=null) {
        $list_details = array();

        if ($list_id) {
            try {
                $list_details = AFFLComparisonTableService::get_table_data($list_id);
            } catch (Exception $e) {
                AFFL_LoggerService::log("Error fetching list data for ID " . esc_html($list_id) . ": " . esc_html($e->getMessage()), 'ERROR');
                $list_id = null;
            }
        }

        if (empty($list_details)) {
            $list_details = array(
                'id' => null,
                'title' => '',
                'list_description' => '',
                'products' => [],
                'criteria_ids' => [],
                'linked_criteria_details' => [],
                'applied_template_id' => null,
                'tiers' => array(
                    'best_price' => null,
                    'best_quality' => null,
                    'best_cost_benefit' => null,
                ),
            );
        }


        $sidebar = new AffiliLabs_Sidebar();
        $sidebar->load_scripts();
        $navbar = new AffiliLabs_Navbar();
        $navbar->load_scripts();
        $button = new AffiliLabs_Button();
        $video_frame = new AffiliLabs_VideoFrame();
        $video_frame->load_scripts();
        $video_frame->init();

        ?>
        <div class="affililabs-plugin">
            <?php $sidebar->render('lists'); ?>
            <main class="affililabs-plugin__main">
                <?php $navbar->render(); ?>
                <header class="affililabs-plugin__header">
                    <h1><?php affl_print($list_id ? esc_html__('Edit List', 'affililabs') : esc_html__('Add New List', 'affililabs')); ?></h1>
                    <?php $button->render(__('See your stats', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs')), AFFILILABS_ASSETS_PULSE_WHITE_SVG); ?>
                </header>
                <section class="affililabs-plugin__intro">
                    <div class="affililabs-plugin__intro__text">
                        <p><b><?php affl_print(esc_html__("Let's get started!", 'affililabs')); ?></b></p>
                        <p class="affililabs-plugin__intro__description"><?php affl_print(esc_html__('Create powerful lists to showcase products side by side. Help your visitors make informed purchasing decisions with easy-to-read comparison data.', 'affililabs')); ?></p>
                        <?php $button->render(__('See All Lists', 'affililabs'), esc_url(admin_url('admin.php?page=affililabs-lists')), AFFILILABS_ASSETS_COPY_SVG); ?>
                    </div>
                    <div class="affililabs-plugin__intro__video">
                        <?php $video_frame->render(''); ?>
                    </div>
                </section>
                <section class="affililabs-plugin__config">
                    <ul class="affililabs-plugin__config__tabs">
                        <li class="affililabs-plugin__config__tab affililabs-plugin__config__tab--active" data-tab="basic"><?php affl_print(esc_html__('BASICS', 'affililabs')); ?></li>
                        <li class="affililabs-plugin__config__tab" data-tab="products"><?php affl_print(esc_html__('PRODUCTS', 'affililabs')); ?></li>
                        <li class="affililabs-plugin__config__tab" data-tab="criteria"><?php affl_print(esc_html__('CRITERIA', 'affililabs')); ?></li>
                        <li class="affililabs-plugin__config__tab" data-tab="template"><?php affl_print(esc_html__('TEMPLATE', 'affililabs')); ?></li>
                        <li class="affililabs-plugin__config__tab" data-tab="tiers"><?php affl_print(esc_html__('TIERS', 'affililabs')); ?></li>
                    </ul>

                    <div class="affililabs-plugin__config__tab-content affililabs-plugin__config__tab-content--active" data-tab-content="basic">
                        <h2><?php affl_print(esc_html__('Basic Information', 'affililabs')); ?></h2>
                        <input type="hidden" id="list-id" name="list_id" value="<?php affl_print(esc_attr($list_details['id'] ?? '')); ?>">
                        <div class="affililabs-plugin__config__field">
                            <label for="list-title"><?php affl_print(esc_html__('List Name', 'affililabs')); ?></label>
                            <input type="text" id="list-title" name="list_title" value="<?php affl_print(esc_attr($list_details['title'] ?? '')); ?>" required>
                        </div>
                        <div class="affililabs-plugin__config__field">
                            <label for="list-description"><?php affl_print(esc_html__('List Description', 'affililabs')); ?></label>
                            <textarea id="list-description" name="list_description" rows="4"><?php affl_print(esc_textarea($list_details['list_description'] ?? '')); ?></textarea>
                        </div>
                        <button class="affililabs-plugin__button affililabs-plugin__list-save-button" data-save-tab="basic"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                    </div>

                    <div class="affililabs-plugin__config__tab-content" data-tab-content="products">
                        <h2><?php affl_print(esc_html__('Products Configuration', 'affililabs')); ?></h2>

                        <div class="affililabs-plugin__config__field">
                            <h3><?php affl_print(esc_html__('Import Products', 'affililabs')); ?></h3>
                        </div>

                        <div class="affililabs-plugin-list-edit__import-tools">
                            <div class="affililabs-plugin-list-edit__import-section">
                                <h4><?php affl_print(esc_html__('Import from Category', 'affililabs')); ?></h4>
                                <select id="import-from-category" class="affililabs-plugin__select affl-w-100">
                                    <option value=""><?php affl_print(esc_html__('Select a category', 'affililabs')); ?></option>
                                    <?php
                                    $categories = get_terms(array(
                                        'taxonomy' => AFFILILABS_TAXONOMY_PRODUCT_CATEGORY,
                                        'hide_empty' => false,
                                    ));
                                    foreach ($categories as $category) {
                                        affl_print('<option value="' . esc_attr($category->term_id) . '">' . esc_html($category->name) . '</option>');
                                    }
                                    ?>
                                </select>
                                <button type="button" id="import-category-button" class="affililabs-plugin__button affililabs-plugin__button--secondary affililabs-plugin-list-edit__import-button"><?php affl_print(esc_html__('Import', 'affililabs')); ?></button>
                            </div>

                            <div class="affililabs-plugin-list-edit__import-section">
                                <h4><?php affl_print(esc_html__('Import from Tags', 'affililabs')); ?></h4>
                                <select id="import-from-tag" class="affililabs-plugin__select affl-w-100">
                                    <option value=""><?php affl_print(esc_html__('Select a tag', 'affililabs')); ?></option>
                                    <?php
                                    //@TODO: potential for performance improvements here
                                    $args = array(
                                        'post_type' => AFFILILABS_CPT_PRODUCT,
                                        'post_status' => 'publish',
                                        'posts_per_page' => -1
                                    );


                                    $products_posts = get_posts($args);

                                    $tags = array();

                                    foreach ($products_posts as $product_post) {
                                        $product_tags = wp_get_post_tags($product_post->ID);
                                        foreach ($product_tags as $tag) {
                                            $tags[$tag->term_id] = $tag->name;
                                        }
                                    }

                                    foreach ($tags as $tag_id => $tag_name) {
                                        affl_print('<option value="' . esc_attr($tag_id) . '">' . esc_html($tag_name) . '</option>');
                                    }
                                    ?>
                                </select>
                                <button type="button" id="import-tag-button" class="affililabs-plugin__button affililabs-plugin__button--secondary affililabs-plugin-list-edit__import-button"><?php affl_print(esc_html__('Import', 'affililabs')); ?></button>
                            </div>
                        </div>

                        <div class="affililabs-plugin__config__field">
                            <h3><?php affl_print(esc_html__('Selected Products', 'affililabs')); ?></h3>
                        </div>

                        <div class="affililabs-plugin__filters">
                            <div class="affililabs-plugin__search-container">
                                <input id="list-product-search" type="text" class="affililabs-plugin__search" placeholder="<?php affl_print(esc_html__('Search selected products...', 'affililabs')); ?>">
                            </div>
                            <div class="affililabs-plugin__dropdown-filters">
                                <div class="affililabs-plugin__filter-group">
                                      <label for="list-product-sort"><?php affl_print(esc_html__('Sort by:', 'affililabs')); ?></label>
                                      <select id="list-product-sort" class="affililabs-plugin__filter-select">
                                          <option value="default"><?php affl_print(esc_html__('Default Order', 'affililabs')); ?></option>
                                          <option value="name-asc"><?php affl_print(esc_html__('Name (A-Z)', 'affililabs')); ?></option>
                                          <option value="name-desc"><?php affl_print(esc_html__('Name (Z-A)', 'affililabs')); ?></option>
                                          <option value="price-asc"><?php affl_print(esc_html__('Price (Low to High)', 'affililabs')); ?></option>
                                          <option value="price-desc"><?php affl_print(esc_html__('Price (High to Low)', 'affililabs')); ?></option>
                                          <option value="rating-desc"><?php affl_print(esc_html__('Rating (High to Low)', 'affililabs')); ?></option>
                                          <option value="rating-asc"><?php affl_print(esc_html__('Rating (Low to High)', 'affililabs')); ?></option>
                                      </select>
                                  </div>
                                  <div class="affililabs-plugin__filter-group">
                                      <label for="list-product-filter"><?php affl_print(esc_html__('Filter by:', 'affililabs')); ?></label>
                                      <select id="list-product-filter" class="affililabs-plugin__filter-select">
                                          <option value=""><?php affl_print(esc_html__('All Products', 'affililabs')); ?></option>
                                          <?php
                                          $categories = get_terms(array(
                                              'taxonomy' => AFFILILABS_TAXONOMY_PRODUCT_CATEGORY,
                                              'hide_empty' => false,
                                          ));
                                          if (!empty($categories)): ?>
                                              <optgroup label="<?php affl_print(esc_html__('Categories', 'affililabs')); ?>">
                                                  <?php foreach ($categories as $category): ?>
                                                      <option value="category-<?php affl_print(esc_attr($category->term_id)); ?>"><?php affl_print(esc_html($category->name)); ?></option>
                                                  <?php endforeach; ?>
                                              </optgroup>
                                          <?php endif; ?>
                                          <?php
                                          $marketplaces_args = array(
                                              'post_type' => AFFILILABS_CPT_MARKETPLACE,
                                              'posts_per_page' => -1,
                                          );
                                          $marketplaces_query = new WP_Query($marketplaces_args);
                                          $marketplaces = $marketplaces_query->posts;
                                          if (!empty($marketplaces)): ?>
                                              <optgroup label="<?php affl_print(esc_html__('Marketplaces', 'affililabs')); ?>">
                                                  <?php foreach ($marketplaces as $marketplace): ?>
                                                      <option value="marketplace-<?php affl_print(esc_attr($marketplace->ID)); ?>"><?php affl_print(esc_html($marketplace->post_title)); ?></option>
                                                  <?php endforeach; ?>
                                              </optgroup>
                                          <?php endif; ?>
                                          <optgroup label="<?php affl_print(esc_html__('Ratings', 'affililabs')); ?>">
                                              <option value="rating-5"><?php affl_print(esc_html__('5 Stars Only', 'affililabs')); ?></option>
                                              <option value="rating-4"><?php affl_print(esc_html__('4+ Stars', 'affililabs')); ?></option>
                                              <option value="rating-3"><?php affl_print(esc_html__('3+ Stars', 'affililabs')); ?></option>
                                              <option value="rating-2"><?php affl_print(esc_html__('2+ Stars', 'affililabs')); ?></option>
                                              <option value="rating-1"><?php affl_print(esc_html__('1+ Stars', 'affililabs')); ?></option>
                                              <option value="rating-0.1"><?php affl_print(esc_html__('Any Rating', 'affililabs')); ?></option>
                                          </optgroup>
                                      </select>
                                  </div>
                            </div>
                        </div>

                        <div id="list-selected-products" class="affililabs-plugin__card-container">
                                 <?php
                                 $selected_products = $list_details['products'] ?? [];
                                 $products = get_posts(array(
                                     'post_type' => AFFILILABS_CPT_PRODUCT,
                                     'posts_per_page' => -1,
                                     'post_status' => 'any'
                                 ));

                                 $selected_product_ids = array();
                                 if (is_array($selected_products) && !empty($selected_products)) {
                                     $selected_product_ids = array_map(function($product) {
                                         return $product['id'];
                                     }, $selected_products);
                                 }
   
                                 $selected_products_list = [];
                                 $unselected_products_list = [];
   
                                 foreach ($products as $product) {
                                     if (in_array($product->ID, $selected_product_ids)) {
                                         $selected_products_list[] = $product;
                                     } else {
                                         $unselected_products_list[] = $product;
                                     }
                                 }
   
                                 $ordered_products = array_merge($selected_products_list, $unselected_products_list);
   
                                 foreach ($ordered_products as $product):
                                     $checked = in_array($product->ID, $selected_product_ids) ? 'checked' : '';
   
                                     $post = get_post($product);
                                     $product_rating = get_post_meta($post->ID, AFFILILABS_META_KEY_RATING, true);
                                     $product_price = get_post_meta($post->ID, AFFILILABS_META_KEY_PRICE, true);
                                     $price_currency = get_post_meta($post->ID, AFFILILABS_META_KEY_PRICE_CURRENCY, true) ?? '$';
                                     $marketplace_id = get_post_meta($post->ID, AFFILILABS_META_KEY_MARKETPLACE, true);
                                     $marketplace_name = '';
                                     if (!empty($marketplace_id)) {
                                         $marketplace_post = get_post($marketplace_id);
                                         if ($marketplace_post) {
                                             $marketplace_name = $marketplace_post->post_title;
                                         }
                                     }
                                     $category_terms = wp_get_post_terms($post->ID, AFFILILABS_TAXONOMY_PRODUCT_CATEGORY);
                                     $category_ids = array();
                                     $category_name = '';
                                     if (!is_wp_error($category_terms) && !empty($category_terms)) {
                                         foreach ($category_terms as $term) {
                                             $category_ids[] = (string)$term->term_id;
                                         }
                                         $category_name = $category_terms[0]->name;
                                     }
                                     $category_ids_string = implode(',', $category_ids);
                                     $image_url = get_the_post_thumbnail_url($post->ID) ?? AFFILILABS_DEFAULT_PRODUCT_IMAGE;
   
                                     $rating_html = '';
                                     if (!empty($product_rating)) {
                                         $rating_html = AFFLProductService::get_rating_stars_html((float)$product_rating);
                                     }
   
                                     $escaped_product_name = esc_attr($post->post_title);
                                     $escaped_product_price = esc_attr($product_price);
                                     $escaped_product_rating = esc_attr($product_rating);
                                     $escaped_marketplace_id = esc_attr($marketplace_id);
                                     $escaped_category_ids_string = esc_attr($category_ids_string);
                                     $escaped_image_url = esc_url($image_url);
                                     $escaped_marketplace_name = esc_html($marketplace_name);
                                     $escaped_category_name = esc_html($category_name);
                                     $escaped_price_currency = esc_html($price_currency);
                                     $escaped_product_price_html = esc_html($product_price);
                                     $escaped_rating_html = $rating_html;
   
                                     ?>
                                     <div class="affililabs-plugin__card" <?php // .affililabs-plugin__card ?>
                                          data-product-id="<?php affl_print(esc_attr($post->ID)); ?>"
                                          data-product-name="<?php affl_print($escaped_product_name); ?>"
                                          data-product-price="<?php affl_print($escaped_product_price); ?>"
                                          data-rating="<?php affl_print($escaped_product_rating); ?>"
                                          data-marketplace-id="<?php affl_print($escaped_marketplace_id); ?>"
                                          data-category-ids="<?php affl_print($escaped_category_ids_string); ?>">
                                          <div  class="affililabs-plugin-criteria-edit__config__field-card" style="border: none; padding: 0; margin-bottom: 10px;">
                                               <input type="checkbox" class="affililabs-plugin-list-edit__config__products-checkbox" id="product-<?php affl_print(esc_attr($product->ID)); ?>" name="list_products[]" value="<?php affl_print(esc_attr($product->ID)); ?>" <?php affl_print($checked); ?> />
                                               <label for="product-<?php affl_print(esc_attr($product->ID)); ?>" style="font-weight: normal;"><?php affl_print(esc_html__('Select', 'affililabs')); ?></label>
                                          </div>
                                          <div class="affililabs-plugin__card__image-container">
                                              <img src="<?php affl_print($escaped_image_url); ?>" alt="<?php affl_print($escaped_product_name); ?>" class="affililabs-plugin__card__image">
                                          </div>
                                          <div class="affililabs-plugin__card__content">
                                              <div class="affililabs-plugin__card__title-container">
                                                  <strong class="affililabs-plugin__card__title"><?php affl_print(esc_html($post->post_title)); ?></strong>
                                                  <?php if (!empty($marketplace_name)): ?>
                                                      <span class="affililabs-plugin__card__marketplace"><?php affl_print($escaped_marketplace_name); ?></span>
                                                  <?php endif; ?>
                                              </div>
                                              <p class="affililabs-plugin__card__price">
                                                  <?php affl_print($escaped_price_currency); ?><?php affl_print($escaped_product_price_html); ?>
                                              </p>
                                              <?php if (!empty($category_name)): ?>
                                                  <div class="affililabs-plugin__card__category-container">
                                                      <strong><?php affl_print(esc_html__('Category:', 'affililabs')); ?></strong>
                                                      <span class="affililabs-plugin__card__category"><?php affl_print($escaped_category_name); ?></span>
                                                  </div>
                                              <?php endif; ?>
                                              <?php if (!empty($rating_html)): ?>
                                                  <div class="affililabs-plugin__card__rating">
                                                      <?php affl_print($escaped_rating_html); ?>
                                                  </div>
                                              <?php endif; ?>
                                          </div>
                                      </div>
                                      <?php
                                  endforeach;
                                  ?>
                              </div>
                        <button class="affililabs-plugin__button affililabs-plugin__list-save-button" data-save-tab="products"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                        </div>

                     <div class="affililabs-plugin__config__tab-content" data-tab-content="criteria">
                         <h2><?php affl_print(esc_html__('Criteria Configuration', 'affililabs')); ?></h2>
                         <div class="affililabs-plugin-lists__ai-suggest">
                             <span class="affililabs-plugin-lists__ai-suggest__text"><?php affl_print(esc_html__('Suggest criteria with AI', 'affililabs') . ': '); ?></span>
                             <span class="affililabs-plugin-lists__ai-suggest__button-wrapper affililabs-tooltip" aria-label="<?php affl_print(esc_attr(__('Suggest new criteria or replace current with AI', 'affililabs'))); ?>">
                                 <img id="ai-suggest-criteria-button" class="affililabs-plugin-lists__ai-suggest__button" src="<?php affl_print(AFFILILABS_ASSETS_STARS_SVG); ?>" alt="<?php affl_print(esc_attr(__('AI Suggest Criteria', 'affililabs'))); ?>" style="width: 32px;" />
                             </span>
                         </div>

                         <div id="ai-criteria-suggestions-container" class="affililabs-plugin__ai-suggestions" style="display: none;">
                             <h2><?php affl_print(esc_html(__('AI Criteria Suggestions', 'affililabs'))); ?></h2>
                             <div id="ai-criteria-suggestions-content">
                                 <p class="ai-loading-message"><?php affl_print(esc_html(__('Generating suggestions...', 'affililabs'))); ?></p>
                             </div>
                             <button id="close-ai-criteria-suggestions" class="affililabs-plugin__button affililabs-plugin__button--primary"><?php affl_print(esc_html(__('Close Suggestions', 'affililabs'))); ?></button>
                         </div>

                         <div class="affililabs-plugin__config__field">
                             <h3><?php affl_print(esc_html__('Select Criteria', 'affililabs')); ?></h3>
                             <div id="list-criteria-selection" class="affililabs-plugin-criteria-edit__config__card">
                                  <?php
                                  $selected_criteria_ids = $list_details['criteria_ids'] ?? [];
                                  $list_product_ids = array_column($list_details['products'] ?? [], 'id');

                                  $product_category_ids = [];
                                  if (!empty($list_product_ids)) {
                                      foreach ($list_product_ids as $product_id) {
                                          $terms = wp_get_post_terms($product_id, AFFILILABS_TAXONOMY_PRODUCT_CATEGORY, ['fields' => 'ids']);
                                          if (!is_wp_error($terms) && !empty($terms)) {
                                              $product_category_ids = array_merge($product_category_ids, $terms);
                                          }
                                      }
                                      $product_category_ids = array_unique($product_category_ids);
                                  }

                                  $all_criteria = get_posts(array(
                                      'post_type' => AFFILILABS_CPT_CRITERION,
                                      'posts_per_page' => -1,
                                      'post_status' => 'publish'
                                  ));

                                  $priority_criteria = [];
                                  $other_criteria = [];

                                  foreach ($all_criteria as $criterion) {
                                      $linked_categories = get_post_meta($criterion->ID, AFFILILABS_META_KEY_LINKED_CATEGORIES, true);
                                      $linked_categories = is_array($linked_categories) ? $linked_categories : [];

                                      $is_priority = false;
                                      foreach ($linked_categories as $linked_cat_id) {
                                          if (in_array($linked_cat_id, $product_category_ids)) {
                                              $is_priority = true;
                                              break;
                                          }
                                      }

                                      if ($is_priority) {
                                          $priority_criteria[] = $criterion;
                                      } else {
                                          $other_criteria[] = $criterion;
                                      }
                                  }

                                  usort($priority_criteria, function($a, $b) {
                                      return strcmp($a->post_title, $b->post_title);
                                  });

                                  usort($other_criteria, function($a, $b) {
                                      return strcmp($a->post_title, $b->post_title);
                                  });

                                  $ordered_criteria = array_merge($priority_criteria, $other_criteria);

                                  if (empty($ordered_criteria)) {
                                      affl_print('<p>' . esc_html__('No criteria found. Please create some first.', 'affililabs') . '</p>');
                                  } else {
                                      foreach ($ordered_criteria as $criterion) {
                                          $checked = in_array($criterion->ID, $selected_criteria_ids) ? 'checked' : '';
                                          ?>
                                          <div class="affililabs-plugin-criteria-edit__config__field-card">
                                              <input type="checkbox" class="affililabs-plugin-list-edit__config__criteria-checkbox" id="criterion-<?php affl_print(esc_attr($criterion->ID)); ?>" name="list_criteria_ids[]" value="<?php affl_print(esc_attr($criterion->ID)); ?>" <?php affl_print($checked); ?> />
                                              <label for="criterion-<?php affl_print(esc_attr($criterion->ID)); ?>"><?php affl_print(esc_html($criterion->post_title)); ?></label>
                                          </div>
                                          <?php
                                      }
                                  }
                                  ?>
                             </div>
                         </div>
                          <div class="affililabs-plugin__config__field">
                             <h3><?php affl_print(esc_html__('Selected Criteria Fields Preview', 'affililabs')); ?></h3>
                             <div id="selected-criteria-fields-preview" class="affililabs-plugin-list-edit__criteria-preview">
                                 <p class="loading-message" style="display: none;"><?php affl_print(esc_html(__('Loading fields...', 'affililabs'))); ?></p>
                                 <p class="no-selection-message"><?php affl_print(esc_html(__('No criteria selected.', 'affililabs'))); ?></p>
                             </div>
                         </div>
                         <button class="affililabs-plugin__button affililabs-plugin__list-save-button" data-save-tab="criteria"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                     </div>

                    <div class="affililabs-plugin__config__tab-content" data-tab-content="template">
                         <h2><?php affl_print(esc_html__('Template Configuration', 'affililabs')); ?></h2>
                         <div class="affililabs-plugin__config__field">
                             <label for="list-template-select"><?php affl_print(esc_html__('Apply Template', 'affililabs')); ?></label>
                             <select id="list-template-select" name="applied_template_id" class="affililabs-plugin__select">
                                 <option value=""><?php affl_print(esc_html__('None', 'affililabs')); ?></option>
                                 <?php
                                 $templates = get_posts(array(
                                     'post_type' => AFFILILABS_CPT_TEMPLATE,
                                     'posts_per_page' => -1,
                                     'post_status' => 'publish',
                                     'meta_query' => array(
                                         array(
                                             'key' => AFFILILABS_META_KEY_TEMPLATE_TYPE,
                                             'value' => 'comparison_table',
                                             'compare' => '=',
                                         ),
                                     ),
                                 ));
                                 $current_template_id = $list_details['applied_template_id'] ?? null;
                                 foreach ($templates as $template) {
                                     $selected = selected($current_template_id, $template->ID, false);
                                     affl_print('<option value="' . esc_attr($template->ID) . '" ' . $selected . '>' . esc_html($template->post_title) . '</option>');
                                 }
                                 ?>
                             </select>
                         </div>
                          <button class="affililabs-plugin__button affililabs-plugin__list-save-button" data-save-tab="template"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                     </div>

                     <div class="affililabs-plugin__config__tab-content" data-tab-content="tiers">
                         <h2><?php affl_print(esc_html__('Tiers Configuration', 'affililabs')); ?></h2>
                         <p><?php affl_print(esc_html__('Set tier badges to highlight the best products in your list.', 'affililabs')); ?></p>

                         <div class="affililabs-plugin__config__field">
                             <label for="tier-best-price"><?php affl_print(esc_html__('Best Price', 'affililabs')); ?></label>
                             <select id="tier-best-price" name="tier_best_price" class="affililabs-plugin__select">
                                 <option value=""><?php affl_print(esc_html__('Select a product', 'affililabs')); ?></option>
                                 <?php
                                 $selected_products = $list_details['products'] ?? [];
                                 $best_price_id = $list_details['tiers']['best_price'] ?? null;

                                 foreach ($selected_products as $product) {
                                     $selected = ($best_price_id == $product['id']) ? 'selected' : '';
                                     affl_print('<option value="' . esc_attr($product['id']) . '" ' . $selected . '>' . esc_html($product['name']) . '</option>');
                                 }
                                 ?>
                             </select>
                         </div>

                         <div class="affililabs-plugin__config__field">
                             <label for="tier-best-quality"><?php affl_print(esc_html__('Best Quality', 'affililabs')); ?></label>
                             <select id="tier-best-quality" name="tier_best_quality" class="affililabs-plugin__select">
                                 <option value=""><?php affl_print(esc_html__('Select a product', 'affililabs')); ?></option>
                                 <?php
                                 $best_quality_id = $list_details['tiers']['best_quality'] ?? null;

                                 foreach ($selected_products as $product) {
                                     $selected = ($best_quality_id == $product['id']) ? 'selected' : '';
                                     affl_print('<option value="' . esc_attr($product['id']) . '" ' . $selected . '>' . esc_html($product['name']) . '</option>');
                                 }
                                 ?>
                             </select>
                         </div>

                         <div class="affililabs-plugin__config__field">
                             <label for="tier-best-cost-benefit"><?php affl_print(esc_html__('Best Cost-Benefit', 'affililabs')); ?></label>
                             <select id="tier-best-cost-benefit" name="tier_best_cost_benefit" class="affililabs-plugin__select">
                                 <option value=""><?php affl_print(esc_html__('Select a product', 'affililabs')); ?></option>
                                 <?php
                                 $selected_products = $list_details['products'] ?? [];
                                 $best_cost_benefit_id = $list_details['tiers']['best_cost_benefit'] ?? null;

                                 foreach ($selected_products as $product) {
                                     $selected = ($best_cost_benefit_id == $product['id']) ? 'selected' : '';
                                     affl_print('<option value="' . esc_attr($product['id']) . '" ' . $selected . '>' . esc_html($product['name']) . '</option>');
                                 }
                                 ?>
                             </select>
                         </div>

                         <button class="affililabs-plugin__button affililabs-plugin__list-save-button" data-save-tab="tiers"><?php affl_print(esc_html__('Save Settings', 'affililabs')); ?></button>
                     </div>
                 </section>
             </main>
         </div>
         <?php
     }
 }
?>
