jQuery(document).ready(function ($) {
    const {
        save_success_title,
        save_error_title,
        save_error_unknown,
        save_success,
        save_error,
        import_category_error_no_id_title,
        import_category_error_no_id,
        import_tag_error_no_id_title,
        import_tag_error_no_id,
        import_success_title,
        import_success_products_imported,
        import_success_products_imported_post_message,
        import_error_title,
        import_error_unknown,
        import_error_server_connection_message,
        select_product,
        select_criteria,
        selected_criteria_fields,
        no_criteria_selected,
        error_fetching_criteria_fields,
        ai_suggest_criteria_title,
        ai_suggest_criteria_loading,
        ai_suggest_criteria_error,
        ai_suggest_criteria_no_suggestions,
        ai_suggest_criteria_accept,
        ai_suggest_criteria_saving,
        ai_suggest_criteria_save_success,
        ai_suggest_criteria_save_error,
        no_fields_defined,
        ai_suggest_criteria_save_list_first,
        ai_suggest_criteria_category_label,
        ai_suggest_criteria_fields_label,
        ai_suggest_criteria_replacing_label
    } = affililabs_list_edit.i18n;

    const nonce = affililabs_list_edit.nonce;
    const ajax_url = window.ajaxurl || affililabs_list_edit.ajax_url;

    let is_ai_suggest_in_progress = false;
    let current_accept_button = null;

    $('.affililabs-plugin__config__tab').on('click', function () {
        const tab_id = $(this).data('tab');

        $('.affililabs-plugin__config__tab').removeClass('affililabs-plugin__config__tab--active');
        $(this).addClass('affililabs-plugin__config__tab--active');

        $('.affililabs-plugin__config__tab-content').removeClass('affililabs-plugin__config__tab-content--active');
        $(`.affililabs-plugin__config__tab-content[data-tab-content="${tab_id}"]`).addClass('affililabs-plugin__config__tab-content--active');
    });

    const $ai_criteria_suggest_button = $('#ai-suggest-criteria-button');
    const $ai_criteria_suggestions_container = $('#ai-criteria-suggestions-container');
    const $ai_criteria_suggestions_content = $('#ai-criteria-suggestions-content');
    const $close_ai_criteria_suggestions_button = $('#close-ai-criteria-suggestions');

    $ai_criteria_suggest_button.on('click', function () {
        if (is_ai_suggest_in_progress) {
            return;
        }

        const list_id = $('#list-id').val();
        const selected_product_ids = [];
        $('input[name="list_products[]"]:checked').each(function () {
            selected_product_ids.push($(this).val());
        });

        is_ai_suggest_in_progress = true;
        $ai_criteria_suggest_button.prop('disabled', true);

        if (!list_id) {
            is_ai_suggest_in_progress = false;
            $ai_criteria_suggest_button.prop('disabled', false);
            window.affililabs_modal.error(
                save_error_title,
                ai_suggest_criteria_save_list_first
            );
            return;
        }

        if (selected_product_ids.length === 0) {
            is_ai_suggest_in_progress = false;
            $ai_criteria_suggest_button.prop('disabled', false);
            window.affililabs_modal.notice(
                ai_suggest_criteria_title,
                ai_suggest_criteria_no_suggestions
            );
            return;
        }

        $ai_criteria_suggestions_container.show();
        $ai_criteria_suggestions_content.html(`<p class="ai-loading-message">${ai_suggest_criteria_loading}</p>`);
        if (window.affililabs_spinner) {
            window.affililabs_spinner.show(ai_suggest_criteria_loading);
        }

        $.ajax({
            url: ajax_url,
            type: 'POST',
            data: {
                action: 'affililabs_ai_suggest_criteria',
                list_id: list_id,
                product_ids: selected_product_ids,
                nonce: nonce
            },
            success: function (response) {
                if (response.success && response.data && response.data.suggestions && response.data.status === 'ok') {
                    render_ai_criteria_suggestions(response.data.suggestions);
                } else {
                    console.error('[Response.data.status.error] Error fetching AI criteria suggestions:', response.data?.message);
                    window.affililabs_modal.error(
                        ai_suggest_criteria_title,
                        response.data?.message || ai_suggest_criteria_error
                    );
                    $ai_criteria_suggestions_content.html(''); // Clear content on error
                }
            },
            error: function (xhr, status, error) {
                console.error('[Response.data.error] AJAX error fetching AI criteria suggestions:', error);
                window.affililabs_modal.error(
                    ai_suggest_criteria_title,
                    ai_suggest_criteria_error
                );
                $ai_criteria_suggestions_content.html(''); // Clear content on error
            },
            complete: function () {
                is_ai_suggest_in_progress = false;
                $ai_criteria_suggest_button.prop('disabled', false);
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.hide();
                }
            }
        });
    });

    $close_ai_criteria_suggestions_button.on('click', function () {
        $ai_criteria_suggestions_container.hide();
        $ai_criteria_suggestions_content.empty();
    });

    function render_ai_criteria_suggestions(suggestions) {
        $ai_criteria_suggestions_content.empty();

        if (suggestions.length === 0) {
            $ai_criteria_suggestions_content.html(`<p>${ai_suggest_criteria_no_suggestions}</p>`);
            return;
        }

        let suggestions_html = '<div class="affililabs-plugin__card-container">';
        $.each(suggestions, function (index, suggestion) {
            let fields_list_html = '';
            if (suggestion.fields && suggestion.fields.length > 0) {
                fields_list_html = '<ul>';
                $.each(suggestion.fields, function (field_index, field) {
                    let unit_text = '';
                    if (field.unit) {
                        unit_text = ` (${field.unit})`;
                    }
                    let field_name = field.name || 'Unnamed Field';
                    let field_type = field.type || 'text';
                    let type_class = '';
                    switch (field_type) {
                        case 'number':
                            type_class = 'ai-field-type--number';
                            break;
                        case 'text':
                            type_class = 'ai-field-type--text';
                            break;
                        case 'boolean':
                            type_class = 'ai-field-type--boolean';
                            break;
                        default:
                            type_class = '';
                    }
                    fields_list_html += `<li class="${type_class}">${field_name} (${field_type}${unit_text})</li>`;
                });
                fields_list_html += '</ul>';
            } else {
                fields_list_html = `<p>${no_fields_defined}</p>`;
            }

            suggestions_html += `
                <div class="affililabs-plugin__card ai-suggestion-card${suggestion.is_existing_criterion ? ' ai-suggestion-card--existing' : ''}" data-suggestion-id="${suggestion.id}" data-suggestion-index="${index}">
                    <div class="affililabs-plugin__card__content">
                        <strong class="affililabs-plugin__card__title">${suggestion.criteria_name}</strong>
                        ${suggestion.is_existing_criterion && suggestion.existing_criterion_title ? `<p class="ai-replacing-text">${ai_suggest_criteria_replacing_label} <strong>${suggestion.existing_criterion_title}</strong></p>` : ''}
                        <p><strong>${ai_suggest_criteria_category_label}: ${suggestion.category_name}</strong></p>
                        <p><strong>${ai_suggest_criteria_fields_label}:</strong></p>
                        ${fields_list_html}
                    </div>
                    <div class="affililabs-plugin__card__footer">
                        <button class="affililabs-plugin__button affililabs-plugin__button--secondary ai-accept-criteria-suggestion-button" data-suggestion-index="${index}">
                            ${ai_suggest_criteria_accept}
                        </button>
                    </div>
                </div>
            `;
        });
        suggestions_html += '</div>';
        $ai_criteria_suggestions_content.html(suggestions_html);

        $('.ai-accept-criteria-suggestion-button').on('click', function () {
            current_accept_button = $(this);
            current_accept_button.prop('disabled', true);

            const index = current_accept_button.data('suggestion-index');
            const accepted_suggestion = { ...suggestions[index], index: index };
            save_ai_suggested_criterion(accepted_suggestion);
        });
    }

    function save_ai_suggested_criterion(suggested_criterion) {
        const list_id = $('#list-id').val();
        if (!list_id) {
            if (current_accept_button) {
                current_accept_button.prop('disabled', false);
                current_accept_button = null;
            }
            window.affililabs_modal.error(
                save_error_title,
                ai_suggest_criteria_save_list_first
            );
            return;
        }

        if (window.affililabs_spinner) {
            window.affililabs_spinner.show(ai_suggest_criteria_saving);
        }

        $.ajax({
            url: ajax_url,
            type: 'POST',
            data: {
                action: 'affililabs_save_ai_suggested_criteria',
                list_id: list_id,
                suggested_criterion: JSON.stringify(suggested_criterion),
                nonce: nonce
            },
            success: function (response) {
                if (response.success && response.data && response.data.status === 'ok') {
                    window.affililabs_modal.success(
                        ai_suggest_criteria_title,
                        ai_suggest_criteria_save_success
                    );
                    const new_criterion_id = response.data.criterion_id;
                    console.log('Received new_criterion_id from AJAX response:', new_criterion_id);
                    const new_criterion_name = suggested_criterion.criteria_name;

                    const $existing_checkbox = $(`#list-criteria-selection input[type="checkbox"][value="${new_criterion_id}"]`);

                    if ($existing_checkbox.length > 0) {
                        const was_checked = $existing_checkbox.prop('checked');
                        $existing_checkbox.next('label').text(new_criterion_name);
                        $existing_checkbox.prop('checked', was_checked);
                    } else {
                        const new_criterion_html = `
                             <div class="affililabs-plugin-criteria-edit__config__field-card">
                                 <input type="checkbox" class="affililabs-plugin-list-edit__config__criteria-checkbox" id="criterion-${new_criterion_id}" name="list_criteria_ids[]" value="${new_criterion_id}" />
                                 <label for="criterion-${new_criterion_id}">${new_criterion_name}</label>
                             </div>
                         `;
                        $('#list-criteria-selection').append(new_criterion_html);
                    }

                    $criteria_preview_container.find(`.criterion-preview-group[data-criterion-id="${new_criterion_id}"]`).remove();
                    if ($(`#list-criteria-selection input[type="checkbox"][value="${new_criterion_id}"]`).is(':checked')) {
                        display_criterion_fields(new_criterion_id, new_criterion_name);
                    }

                    const $card_to_remove = $ai_criteria_suggestions_content.find(`.ai-suggestion-card[data-suggestion-id="${suggested_criterion.id}"][data-suggestion-index="${suggested_criterion.index}"]`);
                    console.log('Attempting to remove card with ID:', suggested_criterion.id, 'and Index:', suggested_criterion.index);
                    console.log('Selected card element for removal:', $card_to_remove);
                    $card_to_remove.remove();

                    if ($ai_criteria_suggestions_content.find('.ai-suggestion-card').length === 0) {
                        $ai_criteria_suggestions_content.html(`<p>${ai_suggest_criteria_no_suggestions}</p>`);
                    }

                } else {
                    console.error('[Response.data.status.error] Error saving AI suggested criterion:', response.data?.message);
                    window.affililabs_modal.error(
                        ai_suggest_criteria_title,
                        response.data?.message || ai_suggest_criteria_save_error
                    );
                }
            },
            error: function (xhr, status, error) {
                console.error('[Response.data.error] AJAX error saving AI suggested criterion:', error);
                window.affililabs_modal.error(
                    ai_suggest_criteria_title,
                    ai_suggest_criteria_save_error
                );
            },
            complete: function () {
                is_ai_suggest_in_progress = false;
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.hide();
                }
                if (current_accept_button) {
                    current_accept_button.prop('disabled', false);
                    current_accept_button = null;
                }
            }
        });
    }

    const $criteria_preview_container = $('#selected-criteria-fields-preview');
    const $loading_message = $criteria_preview_container.find('.loading-message');
    const $no_selection_message = $criteria_preview_container.find('.no-selection-message');
    let active_criteria_ajax_requests = {};

    function display_criterion_fields(criterion_id, criterion_name) {
        if (active_criteria_ajax_requests[criterion_id]) {
            return;
        }
        $loading_message.show();
        $no_selection_message.hide();
        active_criteria_ajax_requests[criterion_id] = true;

        $.ajax({
            url: ajax_url,
            type: 'POST',
            data: {
                action: 'affililabs_get_criterion_fields',
                criterion_id: criterion_id,
                nonce: nonce
            },
            success: function (response) {
                if (response.success && response.data && response.data.fields) {
                    let criterion_fields_html = `<div class="criterion-preview-group" data-criterion-id="${criterion_id}"><h4>${criterion_name}</h4><ul>`;
                    if (response.data.fields.length > 0) {
                        $.each(response.data.fields, function (index, field) {
                            const unit_text = field.unit ? ` (${field.unit})` : '';
                            criterion_fields_html += `<li>${field.name || 'Unnamed Field'} (${field.type || 'text'}${unit_text})</li>`;
                        });
                    } else {
                        criterion_fields_html += `<li>${affililabs_list_edit.i18n.no_fields_defined || 'No fields defined for this criterion.'}</li>`;
                    }
                    criterion_fields_html += '</ul></div>';
                    $criteria_preview_container.append(criterion_fields_html);
                } else {
                    console.error('Error fetching fields:', response.data?.message);
                    $criteria_preview_container.append(`<div class="criterion-preview-group criterion-preview-error" data-criterion-id="${criterion_id}"><h4>${criterion_name}</h4><p>${error_fetching_criteria_fields}</p></div>`);
                }
            },
            error: function (xhr, status, error) {
                console.error('AJAX error fetching fields:', error);
                $criteria_preview_container.append(`<div class="criterion-preview-group criterion-preview-error" data-criterion-id="${criterion_id}"><h4>${criterion_name}</h4><p>${error_fetching_criteria_fields}</p></div>`);
            },
            complete: function () {
                delete active_criteria_ajax_requests[criterion_id];
                if (Object.keys(active_criteria_ajax_requests).length === 0) {
                    $loading_message.hide();
                }
                if ($criteria_preview_container.find('.criterion-preview-group').length === 0) {
                    $no_selection_message.show();
                }
            }
        });
    }

    // Event listener for criteria checkboxes
    $('#list-criteria-selection').on('change', '.affililabs-plugin-list-edit__config__criteria-checkbox', function () {
        const criterion_id = $(this).val();
        const criterion_name = $(this).next('label').text();
        const is_checked = $(this).is(':checked');

        $no_selection_message.hide();

        if (is_checked) {
            if ($criteria_preview_container.find(`.criterion-preview-group[data-criterion-id="${criterion_id}"]`).length === 0) {
                display_criterion_fields(criterion_id, criterion_name);
            }
        } else {
            $criteria_preview_container.find(`.criterion-preview-group[data-criterion-id="${criterion_id}"]`).remove();
            if ($criteria_preview_container.find('.criterion-preview-group').length === 0) {
                $no_selection_message.show();
            }
        }
    });
    $('#list-selected-products').on('click', '.affililabs-plugin__card', function (e) {
        if ($(e.target).is('input[type="checkbox"]') || $(e.target).is('label')) {
            return;
        }

        const $checkbox = $(this).find('.affililabs-plugin-list-edit__config__products-checkbox');
        $checkbox.prop('checked', !$checkbox.prop('checked')).trigger('change');
    });

    $('.affililabs-plugin-list-edit__config__criteria-checkbox:checked').each(function () {
        const criterion_id = $(this).val();
        const criterion_name = $(this).next('label').text();
        display_criterion_fields(criterion_id, criterion_name);
    });


    $('.affililabs-plugin__list-save-button').on('click', function (e) {
        e.preventDefault();

        const $button = $(this);
        const original_button_text = $button.text();
        const tab_type = $button.data('save-tab');
        const list_id = $('#list-id').val();

        let form_data = {
            id: list_id,
            nonce: nonce
        };

        form_data.title = $('#list-title').val().trim();
        form_data.list_description = $('#list-description').val().trim();

        const selected_products = [];
        $('input[name="list_products[]"]:checked').each(function () {
            selected_products.push($(this).val());
        });
        form_data.product_ids = selected_products;

        const selected_criteria = [];
        $('input[name="list_criteria_ids[]"]:checked').each(function () {
            selected_criteria.push($(this).val());
        });
        form_data.criteria_ids = selected_criteria;

        form_data.applied_template_id = $('#list-template-select').val();

        form_data.tier_best_price = $('#tier-best-price').val();
        form_data.tier_best_quality = $('#tier-best-quality').val();
        form_data.tier_best_cost_benefit = $('#tier-best-cost-benefit').val();

        console.log("Data to save:", form_data);

        $.ajax({
            url: ajax_url,
            type: 'POST',
            data: {
                action: 'affililabs_save_comparison_table',
                comparison_table_data: JSON.stringify(form_data),
                nonce: nonce
            },
            beforeSend: function () {
                $button.prop('disabled', true).text('Saving...');
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.show('Saving list...');
                }
            },
            success: function (response) {
                if (response.success && response.data.status === 'ok') {
                    if (!list_id && response.data.comparison_table_id) {
                        const new_list_id = response.data.comparison_table_id;
                        $('#list-id').val(new_list_id);

                        const new_url = new URL(window.location.href);
                        new_url.searchParams.set('list_id', new_list_id);
                        window.history.pushState({ path: new_url.href }, '', new_url.href);
                    }
                    window.affililabs_modal.success(
                        save_success_title,
                        save_success
                    );
                } else {
                    console.error('[Response Error] Error saving list:', response.data);
                    window.affililabs_modal.error(
                        save_error_title,
                        response.data?.message || save_error
                    );
                }
            },
            error: function (xhr, status, error) {
                console.error('[AJAX Error] Error saving list:', error);
                window.affililabs_modal.error(
                    save_error_title,
                    save_error_unknown
                );
            },
            complete: function () {
                $button.prop('disabled', false).text(original_button_text);
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.hide();
                }
            }
        });
    });

    // Import products functionality
    $('#import-category-button').on('click', function () {
        const category_id = $('#import-from-category').val();
        if (!category_id) {
            const title = affililabs_list_edit.i18n.import_category_error_no_id_title || import_error_title;
            window.affililabs_modal.error(
                title,
                import_category_error_no_id
            );
            return;
        }
        import_products('category', category_id);
    });

    $('#import-tag-button').on('click', function () {
        const tag_id = $('#import-from-tag').val();
        if (!tag_id) {
            const title = affililabs_list_edit.i18n.import_tag_error_no_id_title || import_error_title;
            window.affililabs_modal.error(
                title,
                import_tag_error_no_id
            );
            return;
        }
        import_products('tag', tag_id);
    });

    function import_products(import_type, import_id) {
        $.ajax({
            url: ajax_url,
            type: 'POST',
            data: {
                action: 'affililabs_import_products',
                import_type: import_type,
                import_id: import_id,
                nonce: nonce
            },
            beforeSend: function () {
                const $button = import_type === 'category' ? $('#import-category-button') : $('#import-tag-button');
                $button.prop('disabled', true).text('Importing...');
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.show('Importing products...');
                }
            },
            success: function (response) {
                if (response.success && response.data.status === 'ok' && response.data.product_ids) {
                    $.each(response.data.product_ids, function (index, product_id) {
                        $(`input[name="list_products[]"][value="${product_id}"]`).prop('checked', true);
                    });
                    $('input[name="list_products[]"]').trigger('change');
                    window.affililabs_modal.success(
                        import_success_title,
                        import_success_products_imported + ' ' + import_success_products_imported_post_message
                    );
                } else {
                    console.error('[Response Error] Error importing products:', response.data?.message);
                    let error_title = import_error_title;
                    if (import_type === 'category' && affililabs_list_edit.i18n.import_category_error_no_products_title) {
                        error_title = affililabs_list_edit.i18n.import_category_error_no_products_title;
                    } else if (import_type === 'tag' && affililabs_list_edit.i18n.import_tag_error_no_products_title) {
                        error_title = affililabs_list_edit.i18n.import_tag_error_no_products_title;
                    }
                    window.affililabs_modal.error(
                        error_title,
                        response.data?.message || import_error_unknown
                    );
                }
            },
            error: function (xhr, status, error) {
                console.error('[AJAX Error] Error importing products:', error);
                window.affililabs_modal.error(
                    import_error_title,
                    import_error_server_connection_message
                );
            },
            complete: function () {
                const $button = import_type === 'category' ? $('#import-category-button') : $('#import-tag-button');
                $button.prop('disabled', false).text('Import');
                if (window.affililabs_spinner) {
                    window.affililabs_spinner.hide();
                }
            }
        });
    }

    const $list_product_search = $('#list-product-search');
    const $list_product_sort = $('#list-product-sort');
    const $list_product_filter = $('#list-product-filter');
    const $list_selected_products_container = $('#list-selected-products');
    let $list_product_cards = $list_selected_products_container.find('.affililabs-plugin__card');

    function filter_list_products() {
        const search_term = $list_product_search.val().toLowerCase();
        const filter_value = $list_product_filter.val();
        let visible_count = 0;
        let visible_card_elements = [];

        $list_product_cards.each(function () {
            const $card = $(this);
            const product_id = $card.data('product-id');
            const product_name = $card.data('product-name')?.toLowerCase() || '';
            const marketplace_id = $card.data('marketplace-id') || '';
            const category_ids_attr = $card.data('category-ids') || '';
            const category_ids = category_ids_attr ?
                String(category_ids_attr).split(',').filter(id => id.trim() !== '') : [];
            const product_rating = parseFloat($card.data("rating")) || 0;

            let matches_search = true;
            let matches_filter = true;

            const category_name = $card.find('.affililabs-plugin__card__category').text().toLowerCase();
            const marketplace_name = $card.find('.affililabs-plugin__card__marketplace').text().toLowerCase();
            const product_price = parseFloat($card.data("product-price")) || 0;

            if (search_term) {
                matches_search = product_name.includes(search_term) ||
                    category_name.includes(search_term) ||
                    marketplace_name.includes(search_term) ||
                    product_price.toString().includes(search_term);
            }


            if (filter_value) {
                if (filter_value.startsWith('category-')) {
                    const category_id = filter_value.replace('category-', '');
                    matches_filter = category_ids.some(id => String(id).trim() === String(category_id).trim());
                } else if (filter_value.startsWith('marketplace-')) {
                    const filter_marketplace_id = filter_value.replace('marketplace-', '');
                    matches_filter = String(marketplace_id) === String(filter_marketplace_id);
                } else if (filter_value.startsWith("rating-")) {
                    const min_rating = parseFloat(filter_value.replace("rating-", ""));
                    const product_rating = parseFloat($card.data("rating")) || 0;
                    if (filter_value === "rating-5") {
                        matches_filter = product_rating === 5;
                    } else {
                        matches_filter = product_rating >= min_rating;
                    }
                } else {
                    matches_filter = true;
                }
            }

            const is_visible = matches_search && matches_filter;
            const display_before_toggle = $card.css('display');
            $card.toggle(is_visible);
            const display_after_toggle = $card.css('display');


            if (is_visible) {
                visible_count++;
                visible_card_elements.push($card[0]);
            }
        });

        sort_list_products(visible_card_elements);
    }

    function sort_list_products(visible_card_elements_array) {
        const sort_value = $list_product_sort.val();
        let cards;

        if (visible_card_elements_array && visible_card_elements_array.length > 0) {
            cards = visible_card_elements_array;
        } else {
            const $visible_cards_from_dom = $list_product_cards.filter(':visible');
            cards = $visible_cards_from_dom.get();
        }

        if (!cards) {
            console.error("Sort Error: cards array is undefined or null.");
            return;
        }

        if (sort_value === 'default') {
        } else if (sort_value === 'name-asc') {
            cards.sort(function (a, b) {
                const $a = $(a);
                const $b = $(b);
                return ($a.data('product-name') || '').localeCompare($b.data('product-name') || '');
            });
        } else if (sort_value === 'name-desc') {
            cards.sort(function (a, b) {
                const $a = $(a);
                const $b = $(b);
                return ($b.data('product-name') || '').localeCompare($a.data('product-name') || '');
            });
        } else if (sort_value === 'price-asc') {
            cards.sort(function (a, b) {
                const $a = $(a);
                const $b = $(b);
                const price_a = parseFloat($a.data('product-price')) || 0;
                const price_b = parseFloat($b.data('product-price')) || 0;
                return price_a - price_b;
            });
        } else if (sort_value === 'price-desc') {
            cards.sort(function (a, b) {
                const $a = $(a);
                const $b = $(b);
                const price_a = parseFloat($a.data('product-price')) || 0;
                const price_b = parseFloat($b.data('product-price')) || 0;
                return price_b - price_a;
            });
        } else if (sort_value === 'rating-desc') {
            cards.sort(function (a, b) {
                const $a = $(a);
                const $b = $(b);
                const rating_a = parseFloat($a.data("rating")) || 0;
                const rating_b = parseFloat($b.data("rating")) || 0;
                return rating_b - rating_a;
            });
        } else if (sort_value === 'rating-asc') {
            cards.sort(function (a, b) {
                const $a = $(a);
                const $b = $(b);
                const rating_a = parseFloat($a.data("rating")) || 0;
                const rating_b = parseFloat($b.data("rating")) || 0;
                return rating_a - rating_b;
            });
        }

        const selected_cards = cards.filter(card => $(card).find('.affililabs-plugin-list-edit__config__products-checkbox').is(':checked'));
        const unselected_cards = cards.filter(card => !$(card).find('.affililabs-plugin-list-edit__config__products-checkbox').is(':checked'));

        $list_selected_products_container.empty();
        $.each(selected_cards, function (index, card) {
            $list_selected_products_container.append(card);
        });
        $.each(unselected_cards, function (index, card) {
            $list_selected_products_container.append(card);
        });
    }

    $list_product_search.on('input', filter_list_products);
    $list_product_sort.on('change', sort_list_products);
    $list_product_filter.on('change', filter_list_products);

    $('#list-selected-products').on('change', '.affililabs-plugin-list-edit__config__products-checkbox', function () {
        $list_product_cards = $list_selected_products_container.find('.affililabs-plugin__card');
        filter_list_products();
        update_tier_options();
    });

    $('input[name="list_products[]"]').on('change', function () {
        update_tier_options();
    });

    update_tier_options();

    function update_tier_options() {
        const selected_products = [];

        $('input[name="list_products[]"]:checked').each(function () {
            const product_id = $(this).val();
            const $product_card = $(`#list-selected-products .affililabs-plugin__card[data-product-id="${product_id}"]`);
            let product_name = select_product;
            if ($product_card.length > 0) {
                product_name = $product_card.data('product-name') || select_product;
            } else {
                console.warn(`Product card not found for ID: ${product_id} when updating tier options.`);
            }

            if (product_id) {
                selected_products.push({
                    id: product_id,
                    name: product_name
                });
            }
        });

        const best_price_val = $('#tier-best-price').val();
        const best_quality_val = $('#tier-best-quality').val();
        const best_cost_benefit_val = $('#tier-best-cost-benefit').val();

        $('#tier-best-price, #tier-best-quality, #tier-best-cost-benefit').empty()
            .append($('<option></option>').val("").text(select_product));

        $.each(selected_products, function (index, product) {
            $('#tier-best-price').append(
                $('<option></option>').val(product.id).text(product.name)
            );
            $('#tier-best-quality').append(
                $('<option></option>').val(product.id).text(product.name)
            );
            $('#tier-best-cost-benefit').append(
                $('<option></option>').val(product.id).text(product.name)
            );
        });

        $('#tier-best-price').val(best_price_val);
        $('#tier-best-quality').val(best_quality_val);
        $('#tier-best-cost-benefit').val(best_cost_benefit_val);
    }
});
