<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
affl_import(AFFILILABS_PLUGIN_CONSTANTS_PATH);
affl_import(AFFILILABS_SIDEBAR_COMPONENT_FILE);
affl_import(AFFILILABS_NAVBAR_COMPONENT_FILE);
affl_import(AFFILILABS_SERVICE_MARKETPLACES);
affl_import(AFFILILABS_MODAL_COMPONENT_FILE);
affl_import(AFFILILABS_SPINNER_COMPONENT_FILE);
affl_import(AFFILILABS_VIDEO_FRAME_COMPONENT_FILE);

$sidebar = new AffiliLabs_Sidebar();
$sidebar->load_scripts();
$navbar = new AffiliLabs_Navbar();
$navbar->load_scripts();
$modal = new AffiliLabs_Modal();
$modal->load_scripts();
$modal->init();
$spinner = new AffiliLabs_Spinner();
$spinner->load_scripts();
$spinner->init();
$video_frame = new AffiliLabs_VideoFrame();
$video_frame->load_scripts();
$video_frame->init();
wp_enqueue_style('affililabs-dashboard', AFFILILABS_DASHBOARD_CSS_URL, array(), AFFILILABS_VERSION);
wp_enqueue_script('affililabs-dashboard', AFFILILABS_DASHBOARD_JS_URL, array('jquery'), AFFILILABS_VERSION, true);

wp_localize_script(
    'affililabs-dashboard',
    'affililabs_dashboard',
    array(
        'nonce' => wp_create_nonce('affl_admin_nonce'),
        'admin_url' => admin_url(),
        'i18n' => array(
            'connected_text' => esc_html__('Connected', 'affililabs'),
            'create_connect_text' => esc_html__('Create & Connect', 'affililabs'),
            'save_success_title' => esc_html__('Success', 'affililabs'),
            'save_success' => esc_html__('Marketplace connected successfully!', 'affililabs'),
            'save_error_title' => esc_html__('Error', 'affililabs'),
            'save_error' => esc_html__('Failed to connect marketplace.', 'affililabs'),
            'save_error_unknown' => esc_html__('An unknown error occurred.', 'affililabs'),
            'connecting_marketplace_text' => esc_html__('Connecting marketplace...', 'affililabs'),
        ),
    )
);

$name = ucfirst(esc_html(wp_get_current_user()->display_name ?? wp_get_current_user()->user_nicename)) ?? esc_html__('Visitor', 'affililabs');

$amount_of_products = count((new WP_Query(array(
    'post_type' => AFFILILABS_CPT_PRODUCT,
    'post_status' => 'any',
    'posts_per_page' => -1
)))->posts);

$amount_of_product_lists = count((new WP_Query(array(
    'post_type' => AFFILILABS_CPT_COMPARISON_TABLE,
    'post_status' => 'any',
    'posts_per_page' => -1
)))->posts);

$amount_of_criteria = count((new WP_Query(array(
    'post_type' => AFFILILABS_CPT_CRITERION,
    'post_status' => 'any',
    'posts_per_page' => -1
)))->posts);

$amount_of_templates = count((new WP_Query(array(
    'post_type' => AFFILILABS_CPT_TEMPLATE,
    'post_status' => 'any',
    'posts_per_page' => -1
)))->posts);

$amount_of_categories = count(get_categories(array(
    'taxonomy' => AFFILILABS_TAXONOMY_PRODUCT_CATEGORY,
    'hide_empty' => false
)));

$amount_of_marketplaces = count(get_posts(array(
    'post_type' => AFFILILABS_CPT_MARKETPLACE,
    'post_status' => 'any',
    'posts_per_page' => -1
)));
?>

<div class="affililabs-plugin-dashboard">
    <?php $sidebar->render('dashboard'); ?>
    <main class="affililabs-plugin-dashboard__main">
        <?php $navbar->render(); ?>
        <header class="affililabs-plugin-dashboard__header">
            <h1>
                <?php
                affl_print(
                    esc_html__('Welcome', 'affililabs')
                    . ', '
                    . $name
                    . '!'
                );
                ?>
            </h1>
            <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-product-edit'), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin__button"><?php affl_print(esc_html__('New Product', 'affililabs')); ?> +</a>
        </header>
        <section class="affililabs-plugin-dashboard__stats">
            <div class="affililabs-plugin-dashboard__stat">
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <span><?php affl_print(esc_html__('Published Products', 'affililabs')); ?></span>
                    <span><?php affl_print(esc_html($amount_of_products)); ?></span>
                </div>
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                  <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-product-edit'), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__button-padding">+</a>
                  <a class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__stats-button__eye-padding affililabs-tooltip" href="<?php affl_print(esc_url(admin_url('admin.php?page=affililabs-products'))); ?>" aria-label="<?php affl_print(esc_attr__('View all Products', 'affililabs')); ?>">
                      <img class="affililabs-plugin-dashboard__stats-button__eye" src="<?php affl_print(AFFILILABS_ASSETS_EYE_LIGHT_SVG); ?>" />
                  </a>
                </div>
            </div>
            <div class="affililabs-plugin-dashboard__stat">
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <span><?php affl_print(esc_html__('Criteria', 'affililabs')); ?></span>
                    <span><?php affl_print(esc_html($amount_of_criteria)); ?></span>
                </div>
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-criteria-edit'), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__button-padding">+</a>
                    <a class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__stats-button__eye-padding affililabs-tooltip" href="<?php affl_print(esc_url(admin_url('admin.php?page=affililabs-criteria'))); ?>" aria-label="<?php affl_print(esc_attr__('View all Criteria', 'affililabs')); ?>">
                        <img class="affililabs-plugin-dashboard__stats-button__eye" src="<?php affl_print(AFFILILABS_ASSETS_EYE_LIGHT_SVG); ?>" />
                    </a>
                </div>
            </div>
            <div class="affililabs-plugin-dashboard__stat">
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <span><?php affl_print(esc_html__('Created Lists', 'affililabs')); ?></span>
                    <span><?php affl_print(esc_html($amount_of_product_lists)); ?></span>
                </div>
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-list-edit'), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__button-padding">+</a>
                    <a class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__stats-button__eye-padding affililabs-tooltip" href="<?php affl_print(esc_url(admin_url('admin.php?page=affililabs-lists'))); ?>" aria-label="<?php affl_print(esc_attr__('View all Product Lists', 'affililabs')); ?>">
                        <img class="affililabs-plugin-dashboard__stats-button__eye" src="<?php affl_print(AFFILILABS_ASSETS_EYE_LIGHT_SVG); ?>" />
                    </a>
                </div>
            </div>
            <div class="affililabs-plugin-dashboard__stat">
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <span><?php affl_print(esc_html__('Product Categories', 'affililabs')); ?></span>
                    <span><?php affl_print(esc_html($amount_of_categories)); ?></span>
                </div>
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-product-category-edit'), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__button-padding">+</a>
                    <a class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__stats-button__eye-padding affililabs-tooltip" href="<?php affl_print(esc_url(admin_url('admin.php?page=affililabs-product-categories'))); ?>" aria-label="<?php affl_print(esc_attr__('View all Product Categories', 'affililabs')); ?>">
                        <img class="affililabs-plugin-dashboard__stats-button__eye" src="<?php affl_print(AFFILILABS_ASSETS_EYE_LIGHT_SVG); ?>" />
                    </a>
                </div>
            </div>
            <div class="affililabs-plugin-dashboard__stat">
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <span><?php affl_print(esc_html__('Templates', 'affililabs')); ?></span>
                    <span><?php affl_print(esc_html($amount_of_templates)); ?></span>
                </div>
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-template-editor&type=comparison_table'), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__button-padding">+</a>
                    <a class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__stats-button__eye-padding affililabs-tooltip" href="<?php affl_print(esc_url(admin_url('admin.php?page=affililabs-templates'))); ?>" aria-label="<?php affl_print(esc_attr__('View all Templates', 'affililabs')); ?>">
                        <img class="affililabs-plugin-dashboard__stats-button__eye" src="<?php affl_print(AFFILILABS_ASSETS_EYE_LIGHT_SVG); ?>" />
                    </a>

                </div>
            </div>
            <div class="affililabs-plugin-dashboard__stat">
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <span id="affililabs-plugin-dashboard__marketplaces__span"><?php affl_print(esc_html__('Marketplaces created', 'affililabs')); ?></span>
                    <span id="affililabs-plugin-dashboard__marketplaces__counter"><?php affl_print(esc_html($amount_of_marketplaces)); ?></span>
                </div>
                <div class="affililabs-plugin-dashboard__stat__wrapper">
                    <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-marketplace-edit'), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__button-padding">+</a>
                    <a class="affililabs-plugin-dashboard__stats-button affililabs-plugin-dashboard__stats-button__eye-padding affililabs-tooltip" href="<?php affl_print(esc_url(admin_url('admin.php?page=affililabs-marketplaces'))); ?>" aria-label="<?php affl_print(esc_attr__('View all Marketplaces', 'affililabs')); ?>">
                        <img class="affililabs-plugin-dashboard__stats-button__eye" src="<?php affl_print(AFFILILABS_ASSETS_EYE_LIGHT_SVG); ?>" />
                    </a>
                </div>
            </div>
        </section>
        <section class="affililabs-plugin-dashboard__integration_section">
            <div class="affililabs-plugin-dashboard__intro">
                <div class="affililabs-plugin-dashboard__intro__main">
                    <div>
                        <p><b><?php affl_print(esc_html__("Let's get started!", 'affililabs')); ?></b></p>
                        <p class="affililabs-plugin-dashboard__intro__description"><?php affl_print(esc_html__('Easiest way to automate your repeating tasks. We bring together your favorite Marketplaces and tools into one place, so you can finish more work in less time.', 'affililabs')); ?></p>
                    </div>
                    <a href="<?php affl_print(esc_url(wp_nonce_url(admin_url('admin.php?page=affililabs-product-edit'), 'affl_admin_nonce', 'nonce'))); ?>" class="affililabs-plugin__button"><?php affl_print(esc_html__('New Product', 'affililabs')); ?> +</a>
                </div>
                <div class="affililabs-plugin-dashboard__video">
                        <?php $video_frame->render(''); ?>
                </div>
            </div>
            <div class="affililabs-plugin-dashboard__integrations">
                <h2><?php affl_print(esc_html__('Marketplace Integrations', 'affililabs')); ?></h2>
                <hr class="affililabs-plugin-dashboard__separator" />
                <div class="affililabs-plugin-dashboard__integration">
                    <div class="affililabs-plugin-dashboard__integration-logo">
                        <img src="<?php affl_print(AFFILILABS_DIGISTORE24_LOGO); ?>" />
                        <span>Digistore24</span>
                    </div>
                    <?php
                    $is_digistore_connected = AFFLMarketplaceService::is_marketplace_connected('digistore');
                    $digistore_button_text = $is_digistore_connected ? esc_html__('Connected', 'affililabs') : esc_html__('Create & Connect', 'affililabs');
                    $digistore_button_attributes = '';
                    $digistore_marketplace_id = get_option(AFFILILABS_DIGISTORE_MARKETPLACE_ID);

                    if ($is_digistore_connected && $digistore_marketplace_id > 0) {
                        $edit_url = wp_nonce_url(admin_url('admin.php?page=affililabs-marketplace-edit&marketplace_id=' . $digistore_marketplace_id), 'affl_admin_nonce', 'nonce');
                        $digistore_button_attributes .= ' data-edit-url="' . esc_url($edit_url) . '"';
                    } else {
                        $digistore_button_attributes .= ' disabled';
                    }
                    ?>
                    <button id="digistore_connect_button" data-marketplace-type="digistore" data-is-connected="<?php affl_print( $is_digistore_connected ? 'true' : 'false' ); ?>" <?php affl_print($digistore_button_attributes); ?>><?php affl_print($digistore_button_text); ?></button>
                </div>
                <div class="affililabs-plugin-dashboard__integration">
                    <div class="affililabs-plugin-dashboard__integration-logo">
                        <img src="<?php affl_print(AFFILILABS_ELOPAGE_LOGO); ?>" />
                        <span>Elopage</span>
                    </div>
                    <button id="elopage_connect_button" disabled><?php affl_print(esc_html__('Under Development', 'affililabs')); ?></button>
                </div>
            </div>
        </section>
    </main>
</div>
